/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.info;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.outer_planes.jso.ExtensionNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.info.TimeQuery;

public class TimeQueryNode
extends ExtensionNode
implements TimeQuery {
    public static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    public static final NSI NSI_UTC = new NSI("utc", "jabber:iq:time");
    public static final NSI NSI_TZ = new NSI("tz", "jabber:iq:time");
    public static final NSI NSI_DISPLAY = new NSI("display", "jabber:iq:time");

    public TimeQueryNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    public TimeQueryNode(StreamElement parent, TimeQueryNode base) {
        super(parent, base);
    }

    public Date getTime() {
        StreamElement elem = this.getFirstElement(NSI_UTC);
        String utc = elem != null ? elem.normalizeTrimText() : "";
        Date time = null;
        try {
            time = UTC_FORMAT.parse(utc);
        }
        catch (ParseException pe) {
            // empty catch block
        }
        return time;
    }

    public void setTime(Date time) {
        StreamElement elem = this.getFirstElement(NSI_UTC);
        if (elem != null) {
            elem.detach();
        }
        if (time != null) {
            String utc = UTC_FORMAT.format(time);
            this.addElement(NSI_UTC).addText(utc);
        }
    }

    public String getTimezone() {
        StreamElement elem = this.getFirstElement(NSI_TZ);
        String tz = elem != null ? elem.normalizeTrimText() : "";
        return tz;
    }

    public void setTimezone(String tz) {
        StreamElement elem = this.getFirstElement(NSI_TZ);
        if (elem != null) {
            elem.detach();
        }
        if (Utilities.isValidString(tz)) {
            this.addElement(NSI_TZ).addText(tz);
        }
    }

    public String getDisplay() {
        StreamElement elem = this.getFirstElement(NSI_DISPLAY);
        String display = elem != null ? elem.normalizeTrimText() : "";
        return display;
    }

    public void setDisplay(String display) {
        StreamElement elem = this.getFirstElement(NSI_DISPLAY);
        if (elem != null) {
            elem.detach();
        }
        if (Utilities.isValidString(display)) {
            this.addElement(NSI_DISPLAY).addText(display);
        }
    }

    public StreamObject copy(StreamElement parent) {
        return new TimeQueryNode(parent, this);
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT-00:00"));
    }
}

