/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.x.core;

import net.outer_planes.jso.ExtensionNode;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JIDFormatException;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.util.stringprep.ResourceprepProfile;
import org.jabberstudio.jso.x.core.BindQuery;

public class BindQueryNode
extends ExtensionNode
implements BindQuery {
    public static final NSI ELEMNAME_RESOURCE = new NSI("resource", "urn:ietf:params:xml:ns:xmpp-bind");
    public static final NSI ELEMNAME_JID = new NSI("jid", "urn:ietf:params:xml:ns:xmpp-bind");

    public BindQueryNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected BindQueryNode(StreamElement parent, BindQueryNode base) {
        super(parent, base);
    }

    public String getResource() {
        StreamElement elem = this.getFirstElement(ELEMNAME_RESOURCE);
        return elem != null ? elem.normalizeTrimText() : "";
    }

    public void setResource(String res) throws IllegalArgumentException {
        StreamElement elem = this.getFirstElement(ELEMNAME_RESOURCE);
        if (Utilities.isValidString(res)) {
            res = ResourceprepProfile.getInstance().prepare(res);
            if (elem == null) {
                elem = this.addElement(ELEMNAME_RESOURCE);
            }
            elem.clearText();
            elem.addText(res);
        } else if (elem != null) {
            elem.detach();
        }
    }

    public JID getJID() {
        StreamElement elem = this.getFirstElement(ELEMNAME_JID);
        JID jid = null;
        try {
            if (elem != null) {
                jid = this.getDataFactory().createJID(elem.normalizeTrimText());
            }
        }
        catch (JIDFormatException jIDFormatException) {
            // empty catch block
        }
        return jid;
    }

    public void setJID(JID jid) {
        StreamElement elem = this.getFirstElement(ELEMNAME_JID);
        if (jid != null) {
            if (elem == null) {
                elem = this.addElement(ELEMNAME_JID);
            }
            elem.clearText();
            elem.addText(jid.toString());
        } else if (elem != null) {
            elem.detach();
        }
    }

    public StreamObject copy(StreamElement parent) {
        return new BindQueryNode(parent, this);
    }
}

