/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.util;

import java.text.ParseException;
import java.util.Date;
import org.jabberstudio.jso.format.DateTimeProfileFormat;
import org.jabberstudio.jso.util.Utilities;

public class DateTimeProfileWrapper {
    private DateTimeProfileFormat _Format;
    private Date _Wrapped;
    private String _Spec;

    public DateTimeProfileWrapper(DateTimeProfileFormat fmt, Date date) throws IllegalArgumentException {
        if (fmt == null) {
            throw new IllegalArgumentException("Format cannot be null");
        }
        if (date == null) {
            throw new IllegalArgumentException("Date cannot be null");
        }
        this._Wrapped = date;
        this._Spec = fmt.format(date);
    }

    public DateTimeProfileWrapper(DateTimeProfileFormat fmt, String spec) throws IllegalArgumentException {
        if (fmt == null) {
            throw new IllegalArgumentException("Format cannot be null");
        }
        if (!Utilities.isValidString(spec)) {
            throw new IllegalArgumentException("Specification cannot be null");
        }
        try {
            this._Wrapped = fmt.parse(spec);
        }
        catch (ParseException pe) {
            throw new IllegalArgumentException("specification does not match profile");
        }
        this._Spec = spec;
    }

    public final Date toDate() {
        return this._Wrapped;
    }

    public final String toString() {
        return this._Spec;
    }

    public static DateTimeProfileWrapper create(int profile, Date date) throws IllegalArgumentException {
        return new DateTimeProfileWrapper(DateTimeProfileFormat.getInstance(profile), date);
    }

    public static DateTimeProfileWrapper create(int profile, String spec) throws IllegalArgumentException {
        return new DateTimeProfileWrapper(DateTimeProfileFormat.getInstance(profile), spec);
    }
}

