/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl.mechanisms;

import java.io.UnsupportedEncodingException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MD5MessageCodec {
    private static final String _token = "[^\"()<>@,;:\\<>/\\[\\]?=\\{\\} \t]+";
    private static final Pattern _pattern = Pattern.compile("([^\"()<>@,;:\\<>/\\[\\]?=\\{\\} \t]+)=(?:([^\"()<>@,;:\\<>/\\[\\]?=\\{\\} \t]+)|(?:\"([^\"]+)(?:\")))");

    public static Properties decode(byte[] b64) {
        String challenge;
        Properties props = new Properties();
        if (b64 == null || b64.length == 0) {
            return props;
        }
        try {
            challenge = new String(b64, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 is not a supported encoding");
        }
        Matcher m = _pattern.matcher(challenge);
        while (m.find()) {
            String name = m.group(1);
            String val = m.group(2);
            String string = val = val != null ? val : m.group(3);
            if (name == null || val == null) continue;
            props.setProperty(name, val);
        }
        return props;
    }

    public static byte[] encode(Properties props) {
        StringBuffer buffer = new StringBuffer();
        byte[] b64 = null;
        if (props == null) {
            props = new Properties();
        }
        buffer = MD5MessageCodec.appendParameter(buffer, props, "charset", false);
        buffer = MD5MessageCodec.appendParameter(buffer, props, "username", true);
        buffer = MD5MessageCodec.appendParameter(buffer, props, "realm", true);
        buffer = MD5MessageCodec.appendParameter(buffer, props, "nonce", true);
        buffer = MD5MessageCodec.appendParameter(buffer, props, "cnonce", true);
        buffer = MD5MessageCodec.appendParameter(buffer, props, "nc", false);
        buffer = MD5MessageCodec.appendParameter(buffer, props, "qop", false);
        buffer = MD5MessageCodec.appendParameter(buffer, props, "digest-uri", true);
        buffer = MD5MessageCodec.appendParameter(buffer, props, "response", false);
        try {
            b64 = buffer.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        return b64;
    }

    private static final StringBuffer appendParameter(StringBuffer buffer, Properties props, String key, boolean quoted) {
        if (buffer == null) {
            buffer = new StringBuffer();
        }
        if (key == null) {
            return buffer;
        }
        String value = props.getProperty(key);
        if (value == null) {
            value = "";
        }
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append(key).append("=");
        if (quoted) {
            buffer.append("\"");
        }
        buffer.append(value);
        if (quoted) {
            buffer.append("\"");
        }
        return buffer;
    }
}

