/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl;

import net.outer_planes.jso.sasl.AbstractMechanism;
import org.jabberstudio.jso.sasl.SASLAuthPacket;
import org.jabberstudio.jso.sasl.SASLFailedException;
import org.jabberstudio.jso.sasl.SASLFailurePacket;
import org.jabberstudio.jso.sasl.SASLMechanism;
import org.jabberstudio.jso.sasl.SASLPacket;
import org.jabberstudio.jso.sasl.SASLServerInfo;
import org.jabberstudio.jso.util.Utilities;

public abstract class ServerMechanism
extends AbstractMechanism {
    public ServerMechanism(SASLServerInfo si) {
        super(si.getDataFactory(), si.getServer(), si.getCallbackHandler(), si.getProperties());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SASLPacket evaluate(SASLPacket input) throws IllegalArgumentException, IllegalStateException, SASLFailedException {
        SASLMechanism.Status current = this.getCurrentStatus();
        SASLPacket.Action act = input != null ? input.getAction() : null;
        SASLPacket output = null;
        if (current == READY) {
            if (act == SASLPacket.AUTHENTICATE) {
                return this.evaluateAuth((SASLAuthPacket)input);
            }
            if (act == SASLPacket.RESPONSE) {
                return this.evaluateResponse(input);
            }
            if (act != SASLPacket.ABORT) throw this.completeFailure("temporary-auth-failure");
            throw this.completeFailure("aborted");
        }
        if (current != AUTHENTICATING) throw new IllegalStateException("mechanism is not in a compatible state");
        if (act == SASLPacket.RESPONSE) {
            return this.evaluateResponse(input);
        }
        if (act != SASLPacket.ABORT) throw this.completeFailure("temporary-auth-failure");
        throw this.completeFailure("aborted");
    }

    protected SASLPacket evaluateAuth(SASLAuthPacket auth) throws IllegalStateException, SASLFailedException {
        if (!Utilities.equateStrings(this.getMechanismName(), auth.getMechanismName())) {
            throw this.completeFailure("invalid-mechanism");
        }
        SASLPacket resp = (SASLPacket)this.getDataFactory().createPacketNode(SASLPacket.NAME_RESPONSE, SASLPacket.class);
        return resp;
    }

    protected abstract SASLPacket evaluateResponse(SASLPacket var1) throws IllegalStateException, SASLFailedException;

    protected void completeSuccess(SASLPacket success) {
        this.setCurrentStatus(SUCCEEDED);
    }

    protected SASLFailedException completeFailure(String cond) {
        SASLFailurePacket failed = (SASLFailurePacket)this.getDataFactory().createPacketNode(SASLFailurePacket.NAME, SASLFailurePacket.class);
        this.setCurrentStatus(FAILED);
        failed.setCondition(cond);
        return new SASLFailedException(failed);
    }
}

