/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.sasl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.outer_planes.jso.ElementNode;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.sasl.SASLMechanismsFeature;
import org.jabberstudio.jso.util.Utilities;

public class SASLFeatureNode
extends ElementNode
implements SASLMechanismsFeature {
    public static final NSI ELEM_MECHANISM = new NSI("mechanism", "urn:ietf:params:xml:ns:xmpp-sasl");
    public static final Map NAMESPACES = Collections.singletonMap("sasl", "urn:ietf:params:xml:ns:xmpp-sasl");

    public SASLFeatureNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    protected SASLFeatureNode(StreamElement parent, SASLFeatureNode base) {
        super(parent, base);
    }

    public List getMechanismNames() {
        Iterator itr = this.listElements(ELEM_MECHANISM).iterator();
        ArrayList<String> mechs = new ArrayList<String>();
        while (itr.hasNext()) {
            StreamElement elem = (StreamElement)itr.next();
            String name = elem.normalizeTrimText();
            if (!Utilities.isValidString(name)) continue;
            mechs.add(name);
        }
        return mechs;
    }

    public void setMechanismNames(List names) {
        Iterator itr = (names != null ? names : Collections.EMPTY_LIST).iterator();
        this.clearMechanismNames();
        while (itr.hasNext()) {
            Object val = itr.next();
            String name = val != null ? val.toString() : null;
            if (!Utilities.isValidString(name)) continue;
            this.addElement(ELEM_MECHANISM).addText(name);
        }
    }

    public void addMechanismName(String name) throws IllegalArgumentException {
        if (!Utilities.isValidString(name)) {
            throw new IllegalArgumentException("name cannot be null or \"\"");
        }
        if (!this.getMechanismNames().contains(name)) {
            this.addElement(ELEM_MECHANISM).addText(name);
        }
    }

    public void removeMechanismName(String name) throws IllegalArgumentException {
        boolean removed = false;
        if (!Utilities.isValidString(name)) {
            throw new IllegalArgumentException("name cannot be null or \"\"");
        }
        Iterator itr = this.selectAll("sasl:mechanism", NAMESPACES).iterator();
        while (!removed && itr.hasNext()) {
            StreamElement elem = (StreamElement)itr.next();
            if (!Utilities.equateStrings(name, elem.normalizeTrimText())) continue;
            elem.detach();
            removed = true;
        }
    }

    public void clearMechanismNames() {
        this.clearElements(ELEM_MECHANISM);
    }

    public StreamObject copy(StreamElement parent) {
        return new SASLFeatureNode(parent, this);
    }
}

