/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.ixp;

import com.jclark.xml.tok.Encoding;
import com.jclark.xml.tok.StringConversionCache;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.outer_planes.jso.ixp.InvalidXMLException;
import net.outer_planes.jso.ixp.IxpException;
import net.outer_planes.jso.ixp.IxpParseState;
import net.outer_planes.jso.ixp.NamespaceManager;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.util.Utilities;

public class Context {
    private StreamElement _Elem;
    private NamespaceManager _Namespaces = new NamespaceManager(null, null);
    private List _States = new LinkedList();
    private int _Depth = 0;
    private boolean _EOD;
    private Encoding _Enc;
    private StringConversionCache _SCC;
    private boolean _InCData;
    private StringBuffer _Text = new StringBuffer();

    public Context(StreamElement e) {
        this._Elem = e;
    }

    public StreamElement getContextElement() {
        return this._Elem;
    }

    public Encoding getEncoding() {
        return this._Enc;
    }

    public StringConversionCache getStringConverter() {
        return this._SCC;
    }

    public void configureEncoding(Encoding enc) {
        this._Enc = enc;
        this._SCC = new StringConversionCache(enc);
    }

    public boolean isInCData() {
        return this._InCData;
    }

    public boolean hasStates() {
        return !this._States.isEmpty();
    }

    public StreamParseState popState() {
        return !this._States.isEmpty() ? this._States.remove(0) : null;
    }

    public void pushState(StreamParseState sps) {
        this._States.add(sps);
    }

    public NamespaceManager getNamespaces() {
        return this._Namespaces;
    }

    public NamespaceManager popNamespaces() throws IxpException {
        NamespaceManager nsm = this.getNamespaces();
        if (nsm.getParent() == null) {
            throw new IxpException("unexpected end-of-document encountered");
        }
        this._Namespaces = nsm.getParent();
        return nsm;
    }

    public NamespaceManager pushNamespaces(Map nss) {
        NamespaceManager nsm = this.getNamespaces();
        this._Namespaces = new NamespaceManager(nsm, nss);
        return this.getNamespaces();
    }

    public int getElementDepth() {
        return this._Depth;
    }

    protected int incrementElementDepth() {
        return ++this._Depth;
    }

    protected int decrementElementDepth() {
        return --this._Depth;
    }

    public void startElement(NSI name, Map nss, Map attrs) throws IxpException {
        if (this.isEOD()) {
            throw new InvalidXMLException("cannot start new element after document end");
        }
        this.pushTextState();
        IxpParseState state = new IxpParseState(this.getContextElement(), this.getNamespaces(), StreamParseState.ELEMENT_START);
        state.setName(name);
        state.setAttributes(attrs);
        this.pushState(state);
        this.incrementElementDepth();
    }

    public void endElement(NSI name) throws IxpException {
        NamespaceManager nsm = this.popNamespaces();
        if (this.isEOD()) {
            throw new InvalidXMLException("unexpected document end");
        }
        this.pushTextState();
        IxpParseState state = new IxpParseState(this.getContextElement(), nsm, StreamParseState.ELEMENT_END);
        state.setName(name);
        this.pushState(state);
        if (this.decrementElementDepth() == 0) {
            this.setEOD(true);
        }
    }

    public void startCDATA() throws IxpException {
        this._InCData = true;
    }

    public void endCDATA() throws IxpException {
        this._InCData = false;
        this.pushTextState();
    }

    public void characters(String chars) throws IxpException {
        char last = chars.charAt(chars.length() - 1);
        this._Text.append(chars);
        if (last == '\n' || last == '\r') {
            this.pushTextState();
        }
    }

    public boolean isEOD() {
        return this._EOD;
    }

    public void setEOD(boolean eod) {
        this._EOD = eod;
    }

    private void pushTextState() {
        String txt = this._Text.toString();
        if (Utilities.isValidString(txt)) {
            this._Text.setLength(0);
            IxpParseState state = new IxpParseState(this.getContextElement(), this.getNamespaces(), StreamParseState.TEXT);
            state.setText(txt);
            this.pushState(state);
        }
    }

    private Logger obtainLogger() {
        return Logger.getLogger(this.getClass());
    }
}

