/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.ixp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.jabberstudio.jso.io.StreamSource;

public class Buffer {
    private static final int BUFFER_SIZE = 8192;
    private StreamSource _Src;
    private byte[] _Data;
    private int _End;
    private boolean _EOF;

    public Buffer(StreamSource src) {
        this._Src = src;
        this._Data = new byte[0];
    }

    public StreamSource getSource() {
        return this._Src;
    }

    public byte[] getData() {
        return this._Data;
    }

    public int getLength() {
        return this._End;
    }

    public boolean isEOF() {
        return this._EOF;
    }

    public void eat(int amt) {
        int length = this._End - amt;
        if (length > 0) {
            System.arraycopy(this._Data, amt, this._Data, 0, length);
        }
        this._End = length;
    }

    public void reset() {
        this.eat(this.getLength());
    }

    public void fill() throws IOException {
        byte[] temp = new byte[8192];
        if (!this.isEOF()) {
            int length = this.getSource().read(temp, 0, temp.length);
            if (length == -1) {
                this._EOF = true;
            } else {
                this.append(temp, 0, length);
            }
        }
    }

    private void append(byte[] data, int offset, int length) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        if (this._End > 0) {
            bout.write(this._Data, 0, this._End);
        }
        bout.write(data, offset, length);
        this._Data = bout.toByteArray();
        this._End = this._Data.length;
    }
}

