/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso.io;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import net.outer_planes.jso.io.XMLParseState;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNamespace;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.XMLImporter;
import org.jabberstudio.jso.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class XMLReader
implements XMLImporter {
    private StreamElement _Ctx;
    private StreamElement _Out;
    private List _States = new LinkedList();

    public XMLReader() {
    }

    public XMLReader(StreamElement ctx) throws IllegalArgumentException {
        this.setContext(ctx);
    }

    public StreamElement getContext() {
        return this._Ctx;
    }

    private void setContext(StreamElement ctx) throws IllegalArgumentException {
        if (ctx == null) {
            throw new IllegalArgumentException("context StreamElement cannot be null");
        }
        this._Ctx = ctx;
    }

    public void configure(StreamElement ctx) throws IllegalArgumentException, IllegalStateException, RuntimeException {
        if (this._Ctx != null) {
            throw new IllegalStateException("Importer has already been initialized");
        }
        this._Ctx = ctx;
    }

    public StreamElement read(String in) throws RuntimeException {
        StreamElement out = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(new StringReader(in)), (DefaultHandler)new SAXHandler());
            out = this.getOutput();
        }
        catch (IOException ioe) {
            throw new RuntimeException("unknown I/O exception occured", ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException("could not create or configure parser", pce);
        }
        catch (SAXParseException saxpe) {
            throw new RuntimeException("could not parse input", saxpe);
        }
        catch (SAXException saxe) {
            throw new RuntimeException("unknown SAX exception occured", saxe);
        }
        return out;
    }

    public StreamElement execute(Object in) throws RuntimeException {
        return this.read(in != null ? in.toString() : "");
    }

    protected StreamBuilder setupBuilder(XMLParseState current, StreamBuilder b) {
        if (b == null) {
            StreamElement ctx = this.getContext();
            NSI name = current.getName();
            b = name.equals(ctx.getNSI()) ? ctx.createBuilder() : ctx.getDataFactory().createElementBuilder(name, null);
        }
        return b;
    }

    protected StreamElement getOutput() {
        return this._Out;
    }

    protected void setOutput(StreamElement out) {
        this._Out = out;
    }

    protected StreamElement getCurrentElement() {
        StreamElement current = this.getOutput();
        return current == null ? this.getContext() : current;
    }

    protected BuildPlace topPlace() {
        return !this._States.isEmpty() ? this._States.get(0) : null;
    }

    protected void pushPlace(BuildPlace bp) {
        this._States.add(0, bp);
    }

    protected BuildPlace popPlace() {
        return !this._States.isEmpty() ? this._States.remove(0) : null;
    }

    protected class SAXHandler
    extends DefaultHandler {
        private NamespaceSupport _Nss = new NamespaceSupport();

        protected SAXHandler() {
        }

        protected String getPrefix(String qn) {
            String prefix = "";
            int pos = qn.indexOf(58);
            if (pos != -1) {
                prefix = qn.substring(0, pos);
            }
            return prefix;
        }

        public void startDocument() {
            StreamElement ctx = XMLReader.this.getContext();
            Iterator itr = ctx.getDeclaredNamespaces().iterator();
            while (itr.hasNext()) {
                StreamNamespace ns = (StreamNamespace)itr.next();
                this._Nss.declarePrefix(ns.getPrefix(), ns.getURI());
            }
            this._Nss.pushContext();
        }

        public void startElement(String uri, String ln, String qn, Attributes atts) throws SAXException {
            StreamBuilder.Status stat;
            BuildPlace bp = XMLReader.this.topPlace();
            TreeMap<String, String> nss = new TreeMap<String, String>();
            TreeMap<NSI, String> attrs = new TreeMap<NSI, String>(NSI.STRICT_COMPARATOR);
            XMLParseState parent = bp != null ? bp.parseState : null;
            String prefix = this.getPrefix(qn);
            if (!Utilities.isValidString(uri)) {
                uri = this._Nss.getURI(prefix);
            }
            if (!Utilities.isValidString(uri)) {
                uri = XMLReader.this.getCurrentElement().getNamespaceURI(prefix);
            }
            if (!Utilities.isValidString(uri)) {
                uri = null;
            }
            NSI name = new NSI(ln, uri);
            Enumeration<String> itr = this._Nss.getDeclaredPrefixes();
            while (itr.hasMoreElements()) {
                String nsPrefix = itr.nextElement();
                String nsURI = this._Nss.getURI(nsPrefix);
                nss.put(nsPrefix, nsURI);
            }
            for (int idx = 0; idx < atts.getLength(); ++idx) {
                String attrLN = atts.getLocalName(idx);
                String attrURI = atts.getURI(idx);
                String attrVal = atts.getValue(idx);
                NSI attrName = new NSI(attrLN, attrURI);
                attrs.put(attrName, attrVal);
            }
            XMLParseState current = XMLParseState.createForElementStart(XMLReader.this.getContext(), parent, name, nss, attrs);
            this._Nss.pushContext();
            StreamBuilder builder = XMLReader.this.setupBuilder(current, bp != null ? bp.builder : null);
            while ((stat = builder.processElementStart(current)) == StreamBuilder.EXTENDED_DATA) {
                builder = builder.buildExtendedData();
            }
            XMLReader.this.pushPlace(new BuildPlace(current, builder));
        }

        public void endElement(String uri, String ln, String qn) throws SAXException {
            BuildPlace currBP = XMLReader.this.popPlace();
            BuildPlace prevBP = XMLReader.this.topPlace();
            if (currBP != null) {
                NSI name = currBP.parseState.getName();
                StreamBuilder builder = currBP.builder;
                XMLParseState previous = prevBP != null ? prevBP.parseState : null;
                XMLParseState current = XMLParseState.createForElementEnd(XMLReader.this.getContext(), previous, name);
                StreamBuilder.Status stat = builder.processElementEnd(current);
                if (stat == StreamBuilder.COMPLETE) {
                    StreamElement currElem = (StreamElement)builder.getNode();
                    if (prevBP != null) {
                        prevBP.builder.addExtendedData(currElem);
                    }
                    XMLReader.this.setOutput(currElem);
                }
                this._Nss.popContext();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            BuildPlace currBP = XMLReader.this.topPlace();
            if (currBP != null) {
                String txt = new String(ch, start, length);
                StreamBuilder builder = currBP.builder;
                XMLParseState previous = currBP.parseState;
                XMLParseState current = XMLParseState.createForText(XMLReader.this.getContext(), previous, txt);
                StreamBuilder.Status stat = builder.processText(current);
            }
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this._Nss.declarePrefix(prefix, uri);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
        }
    }

    protected class BuildPlace {
        public final StreamBuilder builder;
        public final XMLParseState parseState;

        public BuildPlace(XMLParseState ps, StreamBuilder builder) {
            this.parseState = ps;
            this.builder = builder;
        }
    }
}

