/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.outer_planes.jso.ElementBuilder;
import net.outer_planes.jso.ElementNode;
import net.outer_planes.jso.TextNode;
import org.jabberstudio.jso.ErrorCondition;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamObject;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.io.StreamParseState;
import org.jabberstudio.jso.util.Utilities;
import org.jaxen.JaxenException;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class PacketErrorNode
extends ElementNode
implements PacketError {
    public static final NSI NAME = new NSI("error", null);
    public static final NSI ELEMNAME_TEXT = new NSI("text", "urn:ietf:params:xml:ns:xmpp-stanzas");
    private static final NSI ATTRNAME_TYPE = new NSI("type", null);
    private static final NSI ATTRNAME_CODE = new NSI("code", null);
    private static final Map DEFINED_CONDITIONS;
    private XPath _AppCondPath;

    public PacketErrorNode(StreamDataFactory sdf) {
        super(sdf, NAME);
    }

    public PacketErrorNode(StreamDataFactory sdf, int code, String text) {
        this(sdf);
        this.setCode(code);
        this.add(new TextNode(this, sdf, text));
    }

    public PacketErrorNode(StreamElement parent, PacketErrorNode cp) {
        super(parent, cp);
    }

    protected XPath getApplicationConditionXPath() {
        if (this._AppCondPath == null) {
            try {
                this._AppCondPath = this.getDataFactory().createXPath("*[namespace-uri()!='" + this.getNamespaceURI() + "' and namespace-uri()!='" + "urn:ietf:params:xml:ns:xmpp-stanzas" + "']");
            }
            catch (SAXPathException sAXPathException) {
                // empty catch block
            }
        }
        return this._AppCondPath;
    }

    public StreamBuilder createBuilder() {
        return new ElementBuilder(this){

            protected StreamElement createElementNode(StreamParseState s) {
                StreamElement ctx = s.getContext();
                NSI.Comparator cmpr = NSI.NS_LOOSE_COMPARATOR;
                NSI name = s.getName();
                String uri = name.getNamespaceURI();
                String ln = name.getLocalName();
                StreamDataFactory sdf = ctx.getDataFactory();
                StreamElement elem = Utilities.equateStrings("urn:ietf:params:xml:ns:xmpp-stanzas", uri) && Utilities.equateStrings("text", ln) ? sdf.createElementNode(name) : sdf.createElementNode(name, class$org$jabberstudio$jso$ErrorCondition == null ? (class$org$jabberstudio$jso$ErrorCondition = PacketErrorNode.class$("org.jabberstudio.jso.ErrorCondition")) : class$org$jabberstudio$jso$ErrorCondition);
                return elem;
            }
        };
    }

    public List listConditions() {
        return this.listElements(ErrorCondition.class);
    }

    public String getDefinedCondition() {
        StreamElement condition = this.getFirstElement(null, "urn:ietf:params:xml:ns:xmpp-stanzas", ErrorCondition.class);
        return condition != null ? condition.getLocalName() : "";
    }

    public void setDefinedCondition(String name) {
        Iterator itr = this.listElements(null, "urn:ietf:params:xml:ns:xmpp-stanzas", ErrorCondition.class).iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
        if (Utilities.isValidString(name)) {
            NSI nsi = (NSI)DEFINED_CONDITIONS.get(name);
            if (nsi == null) {
                throw new IllegalArgumentException("\"" + nsi + "\" is not a defined condition");
            }
            this.addElement(nsi, ErrorCondition.class);
        }
    }

    public NSI getApplicationCondition() {
        NSI name = null;
        try {
            StreamElement elem = (StreamElement)this.getApplicationConditionXPath().selectSingleNode((Object)this);
            if (elem != null) {
                name = elem.getNSI();
            }
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        return name;
    }

    public void setApplicationCondition(NSI name) throws IllegalArgumentException {
        if (name != null) {
            if (!Utilities.isValidString(name.getLocalName())) {
                throw new IllegalArgumentException("localname cannot be null or \"\"");
            }
            if (Utilities.equateStrings(name.getNamespaceURI(), this.getNSI().getNamespaceURI())) {
                throw new IllegalArgumentException("namespace URI cannot be in stanza namespace");
            }
            if (Utilities.equateStrings(name.getNamespaceURI(), "urn:ietf:params:xml:ns:xmpp-stanzas")) {
                throw new IllegalArgumentException("namespace URI cannot be in stanza-conditions namespace");
            }
        }
        try {
            Iterator itr = this.getApplicationConditionXPath().selectNodes((Object)this).iterator();
            while (itr.hasNext()) {
                ((StreamElement)itr.next()).detach();
            }
        }
        catch (JaxenException jaxenException) {
            // empty catch block
        }
        if (name != null) {
            this.addElement(name, ErrorCondition.class);
        }
    }

    public PacketError.Type getType() {
        Object val = this.getAttributeObject(ATTRNAME_TYPE);
        PacketError.Type type = null;
        if (val instanceof PacketError.Type) {
            type = (PacketError.Type)val;
        } else if (val != null) {
            String temp = val.toString();
            if (Utilities.equateStrings(CANCEL.toString(), temp)) {
                type = CANCEL;
            } else if (Utilities.equateStrings(CONTINUE.toString(), temp)) {
                type = CONTINUE;
            } else if (Utilities.equateStrings(MODIFY.toString(), temp)) {
                type = MODIFY;
            } else if (Utilities.equateStrings(AUTH.toString(), temp)) {
                type = AUTH;
            } else if (Utilities.equateStrings(WAIT.toString(), temp)) {
                type = WAIT;
            }
            if (type != null) {
                this.setAttributeObject(ATTRNAME_TYPE, (Object)type);
            }
        }
        return type;
    }

    public void setType(PacketError.Type type) {
        this.setAttributeObject(ATTRNAME_TYPE, (Object)type);
    }

    public int getCode() {
        Object val = this.getAttributeObject(ATTRNAME_CODE);
        int code = val instanceof Integer ? (Integer)val : 0;
        return code;
    }

    public void setCode(int code) {
        if (code < 0) {
            throw new IllegalArgumentException("Code cannot be less than 0");
        }
        this.setAttributeObject(ATTRNAME_CODE, (Object)new Integer(code));
    }

    public String getText() {
        StreamElement text = this.getFirstElement(ELEMNAME_TEXT);
        return text != null ? text.normalizeTrimText() : "";
    }

    public void setText(String txt) {
        Iterator itr = this.listElements(ELEMNAME_TEXT).iterator();
        while (itr.hasNext()) {
            ((StreamElement)itr.next()).detach();
        }
        if (txt != null) {
            this.addElement(ELEMNAME_TEXT).addText(txt);
        }
    }

    public boolean equals(Object obj) {
        boolean result;
        try {
            result = this.compareTo(obj) == 0;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public int compareTo(Object obj) {
        PacketError cmp = (PacketError)obj;
        int result = 0;
        if (obj == null) {
            throw new NullPointerException();
        }
        PacketError.Type type1 = this.getType();
        PacketError.Type type2 = cmp.getType();
        if (type1 == null) {
            type1 = PacketError.CANCEL;
        }
        if (type2 == null) {
            type2 = PacketError.CANCEL;
        }
        if ((result = type1.compareTo(type2)) == 0) {
            String temp1 = this.getDefinedCondition();
            String temp2 = cmp.getDefinedCondition();
            if (!Utilities.isValidString(temp1)) {
                temp1 = "undefined-condition";
            }
            if (!Utilities.isValidString(temp2)) {
                temp2 = "undefined-condition";
            }
            result = temp1.compareTo(temp2);
        }
        return result;
    }

    public StreamObject copy(StreamElement p) {
        return new PacketErrorNode(p, this);
    }

    static {
        TreeMap<String, NSI> temp = new TreeMap<String, NSI>();
        NSI name = new NSI("bad-request", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("conflict", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("feature-not-implemented", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("forbidden", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("gone", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("internal-server-error", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("item-not-found", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("jid-malformed", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("not-acceptable", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("not-allowed", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("not-authorized", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("payment-required", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("recipient-unavailable", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("redirect", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("registration-required", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("remote-server-not-found", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("remote-server-timeout", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("resource-constraint", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("service-unavailable", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("subscription-required", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("undefined-condition", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        name = new NSI("unexpected-request", "urn:ietf:params:xml:ns:xmpp-stanzas");
        temp.put(name.getLocalName(), name);
        DEFINED_CONDITIONS = Collections.unmodifiableMap(temp);
    }
}

