/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.outer_planes.jso.TextNode;
import net.outer_planes.jso.xpath.JSOXPath;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamElementFactory;
import org.jabberstudio.jso.StreamError;
import org.jabberstudio.jso.StreamText;
import org.jabberstudio.jso.io.StreamBuilder;
import org.jabberstudio.jso.util.Utilities;
import org.jaxen.XPath;
import org.saxpath.SAXPathException;

public class DataFactory
implements StreamDataFactory {
    private String _DefaultNS;
    private DataFactory _baseDataFactory = null;
    private Map _Registered;
    private Map _NamespaceMappings;

    public DataFactory() {
        this((String)null);
    }

    public DataFactory(String ns) {
        this.setDefaultNamespace(ns);
    }

    public DataFactory(DataFactory base) {
        this(base.getDefaultNamespace(), base);
    }

    public DataFactory(String ns, DataFactory base) {
        this._baseDataFactory = base;
        this.setDefaultNamespace(ns);
    }

    public String getDefaultNamespace() {
        return this._DefaultNS;
    }

    private void setDefaultNamespace(String ns) {
        this._DefaultNS = ns == null ? "" : ns;
    }

    public Map getNamespaceMappings() {
        Map baseMap = null;
        if (this._baseDataFactory != null) {
            baseMap = this._baseDataFactory.getNamespaceMappings();
        }
        if (baseMap == null && this._NamespaceMappings == null) {
            return new TreeMap();
        }
        if (baseMap != null && this._NamespaceMappings == null) {
            return baseMap;
        }
        if (baseMap == null && this._NamespaceMappings != null) {
            return new TreeMap(this._NamespaceMappings);
        }
        baseMap.putAll(this._NamespaceMappings);
        return baseMap;
    }

    public void setNamespaceMappings(Map nss) {
        if (nss == null) {
            nss = Collections.EMPTY_MAP;
        }
        if (this._NamespaceMappings != null) {
            this._NamespaceMappings.clear();
        }
        Iterator itr = nss.keySet().iterator();
        while (itr.hasNext()) {
            Object key = itr.next();
            Object value = nss.get(key);
            String prefix = key == null ? null : key.toString();
            String uri = value == null ? null : value.toString();
            this.putNamespaceMapping(prefix, uri);
        }
    }

    public void putNamespaceMapping(String prefix, String uri) {
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if (this._NamespaceMappings == null) {
            this._NamespaceMappings = new TreeMap();
        }
        this._NamespaceMappings.put(prefix, uri);
    }

    public void removeNamespaceMapping(String prefix) {
        if (this._NamespaceMappings != null) {
            if (prefix == null) {
                prefix = "";
            }
            this._NamespaceMappings.remove(prefix);
        }
    }

    public XPath createXPath(String expr) throws SAXPathException {
        return this.createXPath(expr, null);
    }

    public XPath createXPath(String expr, Map nss) throws SAXPathException {
        Map mappings = this.getNamespaceMappings();
        if (nss == null) {
            nss = Collections.EMPTY_MAP;
        }
        mappings.putAll(nss);
        JSOXPath xpath = new JSOXPath(expr);
        Utilities.setupNamespaces((XPath)xpath, mappings);
        return xpath;
    }

    public NSI createNSI(String name, String uri) throws IllegalArgumentException {
        return new NSI(name, uri);
    }

    public StreamElement createElement(String name) throws IllegalArgumentException {
        if (!Utilities.isValidString(name)) {
            throw new IllegalArgumentException("Element local name cannot be null or \"\"");
        }
        return this.createElement(this.createNSI(name, null));
    }

    public StreamElement createElement(String name, String uri) throws IllegalArgumentException {
        if (!Utilities.isValidString(name)) {
            throw new IllegalArgumentException("Element local name cannot be null or \"\"");
        }
        return this.createElement(this.createNSI(name, uri));
    }

    public StreamElement createElement(NSI name) throws IllegalArgumentException {
        return this.createElementNode(name, null);
    }

    public StreamText createText(String txt) {
        return new TextNode(this, txt);
    }

    public JID createJID(Object spec) throws IllegalArgumentException {
        return new JID(spec);
    }

    public JID createJID(String node, String domain, String resource) throws IllegalArgumentException {
        return new JID(node, domain, resource);
    }

    protected StreamElementFactory getElementFactory(NSI name, Class iface) {
        StreamElementFactory matched = null;
        if (name == null) {
            name = new NSI(null, null);
        }
        boolean hasLN = Utilities.isValidString(name.getLocalName());
        boolean hasNS = Utilities.isValidString(name.getNamespaceURI());
        if (hasNS) {
            matched = this.locateElementFactory(name, iface);
        }
        if (matched == null && hasNS) {
            matched = this.locateElementFactory(new NSI(null, name.getNamespaceURI()), iface);
        }
        if (matched == null && hasLN) {
            matched = this.locateElementFactory(new NSI(name.getLocalName(), null), iface);
        }
        if (matched == null) {
            matched = this.locateElementFactory(new NSI(null, null), iface);
        }
        return matched;
    }

    private final StreamElementFactory locateElementFactory(NSI name, Class iface) {
        List possibles = null;
        StreamElementFactory matched = null;
        if (this._Registered != null && (possibles = (List)this._Registered.get(name)) != null) {
            Iterator itr = possibles.iterator();
            while (matched == null && itr.hasNext()) {
                StreamElementFactory test = (StreamElementFactory)itr.next();
                matched = test.isSupportedElement(name, iface) ? test : null;
            }
        }
        if (matched == null && this._baseDataFactory != null) {
            matched = this._baseDataFactory.locateElementFactory(name, iface);
        }
        return matched;
    }

    public void registerElementFactory(StreamElementFactory sef) {
        if (sef != null) {
            Iterator itr = sef.getSupportedElements().iterator();
            while (itr.hasNext()) {
                this.registerElementFactoryDirect((NSI)itr.next(), sef);
            }
        }
    }

    public void registerElementFactory(NSI name, StreamElementFactory sef) {
        if (name != null && sef != null && sef.isSupportedElement(name, null)) {
            this.registerElementFactoryDirect(name, sef);
        }
    }

    protected void registerElementFactoryDirect(NSI name, StreamElementFactory sef) {
        ArrayList<StreamElementFactory> factories;
        if (this._Registered == null) {
            this._Registered = new TreeMap(NSI.STRICT_COMPARATOR);
        }
        if ((factories = (ArrayList<StreamElementFactory>)this._Registered.get(name)) == null) {
            factories = new ArrayList<StreamElementFactory>();
            this._Registered.put(name, factories);
        }
        factories.add(0, sef);
    }

    public void unregisterElementFactory(StreamElementFactory sef) {
        if (sef != null) {
            Iterator itr = sef.getSupportedElements().iterator();
            while (itr.hasNext()) {
                this.unregisterElementFactoryDirect((NSI)itr.next(), sef);
            }
        }
    }

    public void unregisterElementFactory(NSI name, StreamElementFactory sef) {
        if (name != null && sef != null && sef.isSupportedElement(name, null)) {
            this.unregisterElementFactoryDirect(name, sef);
        }
    }

    protected void unregisterElementFactoryDirect(NSI name, StreamElementFactory sef) {
        List factories;
        if (this._Registered != null && (factories = (List)this._Registered.get(name)) != null) {
            factories.remove(sef);
            if (factories.isEmpty()) {
                this._Registered.remove(name);
            }
        }
    }

    public Set getSupportedElements() {
        Set set = null;
        Set baseSet = null;
        if (this._Registered != null) {
            set = this._Registered.keySet();
        }
        if (this._baseDataFactory != null) {
            baseSet = this._baseDataFactory.getSupportedElements();
        }
        if (baseSet == null && set == null) {
            return Collections.EMPTY_SET;
        }
        if (baseSet != null && set == null) {
            return baseSet;
        }
        if (baseSet == null && set != null) {
            return Collections.unmodifiableSet(set);
        }
        TreeSet temp = new TreeSet();
        temp.addAll(set);
        temp.addAll(baseSet);
        return temp;
    }

    public boolean isSupportedElement(NSI name, Class iface) {
        return this.getElementFactory(name, iface) != null;
    }

    public StreamBuilder createElementBuilder(NSI name) throws IllegalArgumentException {
        return this.createElementBuilder(name, null);
    }

    public StreamBuilder createElementBuilder(NSI name, Class iface) throws IllegalArgumentException {
        StreamElementFactory factory = this.getElementFactory(name, iface);
        if (factory == null) {
            throw new IllegalArgumentException("No StreamElementFactory for the given NSI and interface");
        }
        return factory.createElementBuilder(name, iface, this);
    }

    public StreamElement createElementNode(NSI name) throws IllegalArgumentException {
        return this.createElementNode(name, null);
    }

    public StreamElement createElementNode(NSI name, Class iface) throws IllegalArgumentException {
        StreamElementFactory factory = this.getElementFactory(name, iface);
        if (factory == null) {
            throw new IllegalArgumentException("No StreamElementFactory for the given NSI and interface");
        }
        return factory.createElementNode(name, iface, this);
    }

    public StreamError createStreamError(String cond) throws IllegalArgumentException {
        if (!Utilities.isValidString(cond)) {
            cond = "undefined-condition";
        }
        StreamError err = (StreamError)this.createElementNode(this.createNSI("error", "http://etherx.jabber.org/streams"), StreamError.class);
        err.setDefinedCondition(cond);
        return err;
    }

    public PacketError createPacketError(PacketError.Type type, String cond) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (!Utilities.isValidString(cond)) {
            cond = "undefined-condition";
        }
        PacketError err = (PacketError)this.createElementNode(this.createNSI("error", null), PacketError.class);
        err.setType(type);
        err.setDefinedCondition(cond);
        return err;
    }

    public PacketError createError(int code) throws IllegalArgumentException {
        return this.createError(code, null);
    }

    public PacketError createError(int code, String msg) throws IllegalArgumentException {
        PacketError err = (PacketError)this.createElementNode(new NSI("error", null), PacketError.class);
        err.setCode(code);
        err.setText(msg);
        return err;
    }

    public Packet createPacketNode(NSI name) throws IllegalArgumentException {
        return (Packet)this.createElementNode(name, Packet.class);
    }

    public Packet createPacketNode(NSI name, Class iface) throws IllegalArgumentException {
        if (iface == null) {
            iface = Packet.class;
        }
        if (!Packet.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException("Interface " + iface.getName() + " is not derived from Packet");
        }
        return (Packet)this.createElementNode(name, iface);
    }

    public StreamBuilder createPacketBuilder(NSI name) throws IllegalArgumentException {
        return this.createElementBuilder(name, Packet.class);
    }

    public StreamBuilder createPacketBuilder(NSI name, Class iface) throws IllegalArgumentException {
        if (iface == null) {
            iface = Packet.class;
        }
        if (!Packet.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException("Interface " + iface.getName() + " is not derived from Packet");
        }
        return this.createElementBuilder(name, iface);
    }

    public Extension createExtensionNode(NSI name) throws IllegalArgumentException {
        return (Extension)this.createElementNode(name, Extension.class);
    }

    public Extension createExtensionNode(NSI name, Class iface) throws IllegalArgumentException {
        if (iface == null) {
            iface = Extension.class;
        }
        if (!Extension.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException("Interface " + iface.getName() + " is not derived from Extension");
        }
        return (Extension)this.createElementNode(name, iface);
    }

    public StreamBuilder createExtensionBuilder(NSI name) throws IllegalArgumentException {
        return this.createElementBuilder(name, Extension.class);
    }

    public StreamBuilder createExtensionBuilder(NSI name, Class iface) throws IllegalArgumentException {
        if (iface == null) {
            iface = Extension.class;
        }
        if (!Extension.class.isAssignableFrom(iface)) {
            throw new IllegalArgumentException("Interface " + iface.getName() + " is not derived from Extension");
        }
        return this.createElementBuilder(name, iface);
    }

    public Object clone() {
        return new DataFactory(this);
    }
}

