/*
 * Decompiled with CFR 0.152.
 */
package net.outer_planes.jso;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.outer_planes.jso.AbstractElement;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamElementFactory;
import org.jabberstudio.jso.io.StreamBuilder;

public abstract class AbstractElementFactory
implements StreamElementFactory {
    private NSI.Comparator _Cmpr;
    private Map _Supported;

    public AbstractElementFactory(NSI.Comparator cmpr) throws IllegalArgumentException {
        if (cmpr == null) {
            cmpr = NSI.STRICT_COMPARATOR;
        }
        this._Cmpr = cmpr;
        this._Supported = new TreeMap(cmpr);
        this.registerSupportedElements();
    }

    protected NSI.Comparator getComparator() {
        return this._Cmpr;
    }

    protected abstract void registerSupportedElements() throws IllegalArgumentException;

    protected NSI adjustNSI(NSI name) throws IllegalArgumentException {
        return name;
    }

    public Set getSupportedElements() {
        return Collections.unmodifiableSet(this._Supported.keySet());
    }

    protected AbstractElement getSupportedElement(NSI name, Class iface) {
        AbstractElement elem = (AbstractElement)this._Supported.get(name = this.adjustNSI(name == null ? new NSI(null, null) : name));
        if (elem != null && iface != null && !iface.isInstance(elem)) {
            elem = null;
        }
        return elem;
    }

    protected void putSupportedElement(AbstractElement elem) {
        if (elem != null) {
            this.putSupportedElement(elem.getNSI(), elem);
        }
    }

    protected void putSupportedElement(NSI name, StreamElement elem) {
        if (name != null && elem != null) {
            this._Supported.put(name, elem);
        }
    }

    protected void removeSupportedElement(NSI name) {
        if (name != null) {
            this._Supported.remove(name);
        }
    }

    public boolean isSupportedElement(NSI name, Class iface) {
        AbstractElement elem = this.getSupportedElement(name, iface);
        return elem != null;
    }

    public StreamElement createElementNode(NSI name, Class iface, StreamDataFactory sdf) throws IllegalArgumentException, IllegalStateException {
        return this.createElementBase(name, iface, sdf);
    }

    public StreamBuilder createElementBuilder(NSI name, Class iface, StreamDataFactory sdf) throws IllegalArgumentException, IllegalStateException {
        return this.createElementBase(name, iface, sdf).createBuilder();
    }

    protected StreamElement createElementBase(NSI name, Class iface, StreamDataFactory sdf) throws IllegalArgumentException, IllegalStateException {
        if (name == null) {
            throw new IllegalArgumentException("NSI cannot be null");
        }
        AbstractElement elem = this.getSupportedElement(name, iface);
        if (elem == null) {
            throw new IllegalStateException("NSI is not supported");
        }
        elem = (AbstractElement)elem.copy();
        elem.reset(name);
        elem.setDataFactory(sdf);
        return elem;
    }
}

