/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.ApplicationInfo;
import com.sun.im.service.AuthenticationException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.ConferenceService;
import com.sun.im.service.ConflictException;
import com.sun.im.service.MessagePart;
import com.sun.im.service.NewsService;
import com.sun.im.service.NotificationService;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGateway;
import com.sun.im.service.PersonalStoreFolder;
import com.sun.im.service.PersonalStoreService;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceService;
import com.sun.im.service.PrivacyItem;
import com.sun.im.service.PrivacyList;
import com.sun.im.service.RegistrationListener;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.StreamingService;
import com.sun.im.service.TimeoutException;
import com.sun.im.service.util.BufferedByteChannel;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.util.Worker;
import com.sun.im.service.xmpp.JIDUtil;
import com.sun.im.service.xmpp.StreamSourceCreator;
import com.sun.im.service.xmpp.XMPPConference;
import com.sun.im.service.xmpp.XMPPConferenceService;
import com.sun.im.service.xmpp.XMPPConferenceSession;
import com.sun.im.service.xmpp.XMPPContentStream;
import com.sun.im.service.xmpp.XMPPMessage;
import com.sun.im.service.xmpp.XMPPMessagePart;
import com.sun.im.service.xmpp.XMPPNewsChannel;
import com.sun.im.service.xmpp.XMPPNewsService;
import com.sun.im.service.xmpp.XMPPNewsSession;
import com.sun.im.service.xmpp.XMPPNotificationService;
import com.sun.im.service.xmpp.XMPPNotificationSession;
import com.sun.im.service.xmpp.XMPPPersonalGateway;
import com.sun.im.service.xmpp.XMPPPersonalStoreService;
import com.sun.im.service.xmpp.XMPPPersonalStoreSession;
import com.sun.im.service.xmpp.XMPPPresenceService;
import com.sun.im.service.xmpp.XMPPPresenceSession;
import com.sun.im.service.xmpp.XMPPPrincipal;
import com.sun.im.service.xmpp.XMPPPrivacyItem;
import com.sun.im.service.xmpp.XMPPPrivacyList;
import com.sun.im.service.xmpp.XMPPRegistrationListenerWrapper;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import com.sun.im.service.xmpp.XMPPStreamingService;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import net.outer_planes.jso.x.core.PrivacyListNode;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JIDFormatException;
import org.jabberstudio.jso.JSOImplementation;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.PacketRouter;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamError;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.event.MonitorEvent;
import org.jabberstudio.jso.event.MonitorListener;
import org.jabberstudio.jso.event.PacketDispatcher;
import org.jabberstudio.jso.event.PacketEvent;
import org.jabberstudio.jso.event.PacketListener;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.util.ByteCodec;
import org.jabberstudio.jso.util.IdentityGenerator;
import org.jabberstudio.jso.util.PacketMonitor;
import org.jabberstudio.jso.util.Utilities;
import org.jabberstudio.jso.x.core.AuthQuery;
import org.jabberstudio.jso.x.core.PrivacyQuery;
import org.jabberstudio.jso.x.core.RegisterQuery;
import org.jabberstudio.jso.x.core.RosterQuery;
import org.jabberstudio.jso.x.disco.DiscoIdentity;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoItem;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;
import org.jabberstudio.jso.x.muc.MUCUserQuery;

public class XMPPSession
implements CollaborationSession {
    static Logger xmpplogger;
    private List _sessionListeners = Collections.synchronizedList(new ArrayList());
    private Map _regisListeners = new HashMap();
    Stream _connection;
    XMPPPrincipal _client;
    JID _server;
    private String _sessionID;
    private String _loginName;
    private boolean uidHasDomain = false;
    private IdentityGenerator _idGen = new IdentityGenerator();
    private TreeMap _namespaces = new TreeMap();
    private XMPPSessionProvider _provider;
    private XMPPPersonalStoreService _personalStoreService;
    private XMPPPresenceService _presenceService;
    private XMPPNewsService _newsService;
    private XMPPConferenceService _conferenceService;
    private XMPPNotificationService _notificationService;
    private XMPPStreamingService _streamingService;
    private StreamSource _css;
    private Object _selectionKey;
    private String _providerSessionIdentifier;
    private HashSet _remoteServices = new HashSet();
    String keyValue;
    boolean ampSupported = false;
    boolean ampCondDeliverSupported = false;
    boolean ampCondExpireAtSupported = false;
    boolean ampCondMatchResourceSupported = false;
    boolean ampActionDropSupported = false;
    boolean ampActionErrorSupported = false;
    boolean ampActionNotifySupported = false;
    boolean ampActionAlertSupported = false;
    public static long REQUEST_TIMEOUT;
    public static long SHORT_REQUEST_TIMEOUT;
    public static int IBB_MESSAGE_SIZE;
    public static int NUM_WORKER_THREAD;
    private boolean _logout = false;
    static JSOImplementation _jso;
    static StreamDataFactory _sdf;
    public static final NSI IQ_NAME;
    public static final NSI MESSAGE_NAME;
    public static final NSI PRESENCE_NAME;
    public static final NSI STORAGE_NAME;
    public static final NSI STORAGE_BOOKMARK_NAME;
    public static final String PRIVATE_NAMESPACE = "jabber:iq:private";
    public static final String IBB_NAMESPACE = "http://jabber.org/protocol/ibb";
    public static final NSI IBB_OPEN;
    public static final NSI IBB_CLOSE;
    public static final NSI IBB_DATA;
    public static final ByteCodec.Base64Codec BASE64;
    public static final String SUN_PRIVATE_NAMESPACE = "sun:xmpp:properties";
    public static final NSI SUN_PRIVATE_NAME;
    public static final NSI SUN_PRIVATE_SUNMSGR_NAME;
    public static final NSI SUN_PRIVATE_POLICY_NAME;
    public static final NSI SEARCH_QUERY_NAME;
    public static final NSI SUN_ATTACH_NAME;
    public static final String DEFAULT_CLIENT_CATEGORY = "client";
    public static final String DEFAULT_CLIENT_TYPE = "pc";
    public static final String DEFAULT_CLIENT_NAME = "SJSClient";
    public static final NSI SUN_PRIVATE_LDAPGROUP_NAME;
    public static final String AMP_NAMESPACE = "http://jabber.org/protocol/amp";
    public static final String AMP_ACTION_DROP_NAMESPACE = "http://jabber.org/protocol/amp?action=drop";
    public static final String AMP_ACTION_ERROR_NAMESPACE = "http://jabber.org/protocol/amp?action=error";
    public static final String AMP_ACTION_NOTIFY_NAMESPACE = "http://jabber.org/protocol/amp?action=notify";
    public static final String AMP_ACTION_ALERT_NAMESPACE = "http://jabber.org/protocol/amp?action=drop";
    public static final String AMP_COND_EXPIREAT_NAMESPACE = "http://jabber.org/protocol/amp?condition=expire-at";
    public static final String AMP_COND_DELIVER_NAMESPACE = "http://jabber.org/protocol/amp?condition=deliver";
    public static final String AMP_COND_MATCHRES_NAMESPACE = "http://jabber.org/protocol/amp?condition=match-resource";
    private boolean privacyListsListed = false;
    private Hashtable _ibbMessages = new Hashtable();
    private StreamSourceCreator _streamSrcCreator;
    private List _sendAndWatchIDs = new LinkedList();
    private List _discoveredServices = new LinkedList();
    protected String _activePrivacyList = null;
    protected String _defaultPrivacyList = null;
    JID _mucService = null;
    JID _pubsubService = null;
    JID _judService = null;
    Map _gateways = new Hashtable();
    private boolean _loadingServices = false;
    private Object _jabberServiceLock = new Object();
    private Object _loadingServiceLock = new Object();
    private Worker _worker = new Worker(NUM_WORKER_THREAD);
    private static byte[] keepAliveBuffer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$jabberstudio$jso$Message;

    protected XMPPSession() {
    }

    public XMPPSession(XMPPSessionProvider fac, String serviceUrl, StreamSourceCreator streamSrcCreator) throws CollaborationException {
        this.init(fac, serviceUrl, null, null, -1, null, streamSrcCreator);
        this.connect(serviceUrl);
        this.setupListeners();
        try {
            this.registerChannelWithProvider();
        }
        catch (IOException ioe) {
            throw new CollaborationException(ioe);
        }
    }

    public XMPPSession(XMPPSessionProvider fac, String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener listener, StreamSourceCreator streamSrcCreator) throws CollaborationException {
        this.init(fac, serviceUrl, loginName, password, loginType, listener, streamSrcCreator);
        this.setupListeners();
        this.connect(serviceUrl);
        try {
            this.registerChannelWithProvider();
            if (loginName != null) {
                this.authenticate(password);
            }
            this.start();
        }
        catch (CollaborationException ce) {
            this.logout();
            throw ce;
        }
        catch (Exception e) {
            this.logout();
            throw new CollaborationException(e);
        }
    }

    CollaborationSessionListener getSessionListener() {
        return (CollaborationSessionListener)this._sessionListeners.get(0);
    }

    private void init(XMPPSessionProvider fac, String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener listener, StreamSourceCreator streamSrcCreator) throws CollaborationException {
        this._provider = fac;
        this._sessionListeners.add(0, listener);
        this._connection = _jso.createStream(this.getStreamNameSpace());
        this._streamSrcCreator = streamSrcCreator;
        if (loginName != null) {
            this._loginName = this.getLoginName(loginName, serviceUrl);
        }
    }

    private void connect(String serviceUrl) throws CollaborationException {
        String domain = serviceUrl;
        int port = 5222;
        int startIndex = serviceUrl.indexOf(":");
        if (startIndex != -1) {
            domain = serviceUrl.substring(0, startIndex);
            port = Integer.parseInt(serviceUrl.substring(startIndex + 1));
        }
        if (!Utilities.isValidString((String)domain)) {
            domain = this._client.getDomainName();
        }
        this._server = _sdf.createJID((Object)domain);
        if (Utilities.isValidString((String)this._server.getNode()) || Utilities.isValidString((String)this._server.getResource())) {
            throw new IllegalArgumentException("Host JID cannot include a node or resource");
        }
        try {
            this._css = this._streamSrcCreator.createStreamSource(this._server.getDomain(), port);
            this._connection.connect(this._css);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new CollaborationException(ioe);
        }
        catch (StreamException se) {
            se.printStackTrace();
            throw new CollaborationException(se);
        }
        catch (CollaborationException e) {
            throw e;
        }
        catch (Exception se) {
            se.printStackTrace();
            throw new CollaborationException(se);
        }
        XMPPSessionProvider.debug("Connected");
        this._connection.getOutboundContext().setTo(this._server);
        this.open();
    }

    protected void open() throws CollaborationException {
        try {
            this._connection.open(15000L);
        }
        catch (StreamException se) {
            se.printStackTrace();
            throw new CollaborationException(se);
        }
        XMPPSessionProvider.debug("Opened");
        this._server = this._connection.getInboundContext().getFrom();
        this.setClientJID();
        XMPPSessionProvider.debug("FROM == " + this._server);
        this._sessionID = this._connection.getInboundContext().getID();
        XMPPSessionProvider.debug("ID ==   " + this._sessionID);
    }

    protected String getLoginName(String loginName, String serviceUrl) throws AuthenticationException {
        String fqLoginName = null;
        String resource = null;
        int index = loginName.indexOf("/");
        if (index > 0) {
            resource = loginName.substring(index + 1);
            loginName = loginName.substring(0, index);
        } else {
            resource = Long.toString(System.currentTimeMillis());
        }
        if (StringUtility.getDomainFromAddress(loginName, null) == null) {
            int startIndex = serviceUrl.indexOf(":");
            String domain = null;
            domain = startIndex != -1 ? serviceUrl.substring(0, startIndex) : serviceUrl;
            fqLoginName = loginName + "@" + domain;
        } else {
            this.uidHasDomain = true;
            fqLoginName = loginName;
        }
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError();
        }
        fqLoginName = fqLoginName + "/" + resource;
        this.setClientJID(fqLoginName);
        return loginName;
    }

    protected String getLoginName() {
        return this._loginName;
    }

    protected String getStreamNameSpace() {
        return "jabber:client";
    }

    protected void setClientJID() throws AuthenticationException {
        if (!this.uidHasDomain && this._client != null) {
            try {
                JID jid = new JID(this._client.getJID().getNode(), this._server.getDomain(), this._client.getJID().getResource());
                this._client.setJID(jid);
            }
            catch (JIDFormatException jfe) {
                throw new AuthenticationException(jfe.toString());
            }
        }
    }

    protected void setClientJID(String fqLoginName) throws AuthenticationException {
        try {
            if (this._client == null) {
                this._client = new XMPPPrincipal(fqLoginName);
            } else {
                JID jid = new JID(fqLoginName);
                this._client.setJID(jid);
            }
        }
        catch (JIDFormatException jfe) {
            throw new AuthenticationException(jfe.toString());
        }
    }

    void starttls() throws Exception {
    }

    protected void authenticate(String password) throws AuthenticationException {
        AuthQuery.Method method;
        InfoQuery iqAuth = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iqAuth.setTo(this._server);
        iqAuth.setType((Packet.Type)InfoQuery.GET);
        iqAuth.setID(this.nextID("auth"));
        AuthQuery auth = (AuthQuery)_sdf.createExtensionNode(AuthQuery.NAME, AuthQuery.class);
        if (auth == null) {
            XMPPSessionProvider.debug("Auth is null");
            throw new AuthenticationException("Unable to create auth packet");
        }
        if (this._client == null) {
            XMPPSessionProvider.debug("_client is null");
            throw new AuthenticationException("User info not present");
        }
        String uid = StringUtility.removeResource(this._loginName);
        auth.setUsername(uid);
        iqAuth.add((StreamNode)auth);
        try {
            iqAuth = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._connection, (Packet)iqAuth, (long)REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
            throw new AuthenticationException(se.toString());
        }
        if (iqAuth == null) {
            throw new AuthenticationException("No reply from server");
        }
        if (iqAuth.getType() == InfoQuery.ERROR && iqAuth.getError().getType() == PacketError.AUTH) {
            throw new AuthenticationException(iqAuth.getError().getText());
        }
        auth = (AuthQuery)iqAuth.listExtensions("jabber:iq:auth").get(0);
        auth.setUsername(uid);
        auth.setResource(this._client.getJID().getResource());
        if (AuthQuery.DIGEST.isSupported(auth)) {
            method = AuthQuery.DIGEST;
            Map params = method.setupAuthParams(auth);
            params.put("sessionid", this._sessionID);
            params.put("password", password);
            method.setupAuth(auth, params);
            XMPPSessionProvider.info("Authenticating using " + method);
        } else if (AuthQuery.PLAIN.isSupported(auth)) {
            method = AuthQuery.PLAIN;
            Map params = method.setupAuthParams(auth);
            params.put("password", password);
            method.setupAuth(auth, params);
            XMPPSessionProvider.info("Authenticating using " + method);
        }
        iqAuth.setTo(this._server);
        iqAuth.setType((Packet.Type)InfoQuery.SET);
        iqAuth.setID(this.nextID("auth"));
        try {
            iqAuth = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._connection, (Packet)iqAuth, (long)REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
            throw new AuthenticationException(se.toString());
        }
        if (iqAuth == null) {
            throw new AuthenticationException("No reply from server");
        }
        if (iqAuth.getType() == InfoQuery.ERROR && iqAuth.getError().getType() == PacketError.AUTH) {
            throw new AuthenticationException(iqAuth.getError().getText());
        }
        this._server = new JID(this._client.getDomainName());
    }

    void start() throws CollaborationException, IOException {
        XMPPSessionProvider.debug("XMPPSession: start()");
    }

    public void registerChannelWithProvider() throws IOException {
        ByteChannel channel = this._streamSrcCreator.getBufferedChannel();
        SocketChannel socketChannel = this._streamSrcCreator.getSocketChannel();
        Runnable packetReader = new Runnable(){

            public void run() {
                try {
                    XMPPSession.this._connection.process();
                }
                catch (StreamException se) {
                    se.printStackTrace();
                }
            }
        };
        this._selectionKey = channel instanceof BufferedByteChannel ? this._provider.register(socketChannel, packetReader, (BufferedByteChannel)channel) : this._provider.register(socketChannel, packetReader);
    }

    public Map getNameSpaces() {
        return this._namespaces;
    }

    private void setupListeners() {
        StatusListenerClass statusListener = new StatusListenerClass();
        PacketListenerClass watcher = new PacketListenerClass();
        this._connection.addPacketListener(PacketEvent.RECEIVED, (PacketListener)watcher);
        if (xmpplogger.isDebugEnabled()) {
            this._connection.addPacketListener((PacketListener)new DebugPacketListenerClass());
        }
        this._connection.addStreamStatusListener((StreamStatusListener)statusListener);
    }

    public String nextID(String key) {
        return this._idGen.generate(key);
    }

    public InfoQuery createIBBInfoQuery(JID to, String sid, boolean open) {
        Extension extn;
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iq.setType((Packet.Type)InfoQuery.SET);
        iq.setID(this.nextID("ibb"));
        iq.setTo(to);
        iq.setFrom(this._client.getJID());
        if (open) {
            extn = _sdf.createExtensionNode(IBB_OPEN);
            extn.setAttributeValue("block-size", Integer.toString(IBB_MESSAGE_SIZE));
        } else {
            extn = _sdf.createExtensionNode(IBB_CLOSE);
        }
        extn.setAttributeValue("sid", sid);
        iq.add((StreamNode)extn);
        return iq;
    }

    public void sendAllMessageParts(XMPPMessage msg) throws CollaborationException {
        Message xmppMessage = (Message)msg.getXMPPMessage();
        MessagePart[] parts = msg.getParts();
        if (parts.length == 1) {
            try {
                xmppMessage.add((StreamNode)this.getPropertiesExtension(msg.getHeaders()));
                this._connection.send((Packet)xmppMessage);
            }
            catch (StreamException se) {
                XMPPSessionProvider.error(se.toString(), se);
                throw new CollaborationException(se.toString());
            }
            return;
        }
        String[] sid_list = new String[parts.length - 1];
        for (int i = 1; i < parts.length; ++i) {
            String sid = this.nextID("sid");
            InfoQuery iq = this.createIBBInfoQuery(xmppMessage.getTo(), sid, true);
            try {
                iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._connection, (Packet)iq, (long)REQUEST_TIMEOUT);
            }
            catch (StreamException se) {
                XMPPSessionProvider.error(se.toString(), se);
            }
            if (iq == null || iq.getType() != InfoQuery.RESULT) {
                throw new CollaborationException("Failed to open IBB Stream");
            }
            try {
                Extension data = _sdf.createExtensionNode(IBB_DATA);
                data.setAttributeValue("sid", sid);
                int seqId = 0;
                Message newMsg = (Message)_sdf.createPacketNode(MESSAGE_NAME, class$org$jabberstudio$jso$Message == null ? XMPPSession.class$("org.jabberstudio.jso.Message") : class$org$jabberstudio$jso$Message);
                newMsg.setFrom(xmppMessage.getFrom());
                newMsg.setTo(xmppMessage.getTo());
                newMsg.setID(this.nextID("message"));
                String contents = parts[i].getContent();
                newMsg.addExtension(this.getPropertiesExtension(((XMPPMessagePart)parts[i]).getHeaders()));
                int packets = contents.length() / IBB_MESSAGE_SIZE + 1;
                newMsg.add((StreamNode)data);
                int end = 0;
                for (int k = 0; k < packets; ++k) {
                    data.setAttributeValue("seq", Integer.toString(seqId++));
                    end = end + IBB_MESSAGE_SIZE <= contents.length() ? end + IBB_MESSAGE_SIZE : contents.length();
                    data.clearText();
                    data.addText(contents.substring(k * IBB_MESSAGE_SIZE, end));
                    this._connection.send((Packet)newMsg);
                }
                sid_list[i - 1] = sid;
                iq = this.createIBBInfoQuery(xmppMessage.getTo(), sid, false);
                iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._connection, (Packet)iq, (long)REQUEST_TIMEOUT);
                continue;
            }
            catch (StreamException se) {
                XMPPSessionProvider.error(se.toString(), se);
            }
        }
        StringBuffer buf = new StringBuffer(sid_list[0]);
        for (int n = 1; n < sid_list.length; ++n) {
            buf.append("," + sid_list[n]);
        }
        StreamElement attachElem = _sdf.createElementNode(SUN_ATTACH_NAME);
        attachElem.addText(buf.toString());
        xmppMessage.add((StreamNode)attachElem);
        xmppMessage.add((StreamNode)this.getPropertiesExtension(msg.getHeaders()));
        try {
            this._connection.send((Packet)xmppMessage);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
        }
    }

    private Extension getPropertiesExtension(Hashtable contents) {
        if (contents == null || contents.size() == 0) {
            return null;
        }
        Extension x = _sdf.createExtensionNode(SUN_PRIVATE_NAME);
        Enumeration enumeration = contents.keys();
        while (enumeration.hasMoreElements()) {
            String header = (String)enumeration.nextElement();
            String value = (String)contents.get(header);
            StreamElement propElem = _sdf.createElementNode(_sdf.createNSI("property", null));
            propElem.setAttributeValue("name", header);
            propElem.addElement("value").addText(value);
            x.add((StreamNode)propElem);
        }
        return x;
    }

    public CollaborationSession accessService(String str) throws CollaborationException {
        XMPPSessionProvider.debug(str);
        if (str.equals("pstore")) {
            if (this._personalStoreService == null) {
                this._personalStoreService = new XMPPPersonalStoreSession(this);
                this._personalStoreService.initialize(null);
            }
            if (!(this._personalStoreService instanceof XMPPPersonalStoreSession)) {
                throw new CollaborationException("Either accessService(CollaborationSessionFactory.PERSONALSTORE) or getPersonalStoreService() should be used. Both cannot be used interchangeably");
            }
            return (XMPPPersonalStoreSession)this._personalStoreService;
        }
        if (str.equals("presence")) {
            if (this._presenceService == null) {
                XMPPPresenceSession presenceSession = new XMPPPresenceSession(this);
                CollaborationSessionListener listener = this.getSessionListener();
                if (listener != null) {
                    presenceSession.setSessionListener(listener);
                }
                this._presenceService = presenceSession;
            }
            if (!(this._presenceService instanceof XMPPPresenceSession)) {
                throw new CollaborationException("Either accessService(CollaborationSessionFactory.PRESENCE) or getPresenceService() should be used. Both cannot be used interchangeably");
            }
            return (XMPPPresenceSession)this._presenceService;
        }
        if (str.equals("news")) {
            if (this._newsService == null) {
                XMPPNewsSession newsSession = new XMPPNewsSession(this);
                CollaborationSessionListener listener = this.getSessionListener();
                if (listener != null) {
                    newsSession.setSessionListener(listener);
                }
                this._newsService = newsSession;
            }
            if (!(this._newsService instanceof XMPPNewsSession)) {
                throw new CollaborationException("Either accessService(CollaborationSessionFactory.NEWS) or getNewsService() should be used. Both cannot be used interchangeably");
            }
            return (XMPPNewsSession)this._newsService;
        }
        if (str.equals("conference")) {
            if (this._conferenceService == null) {
                XMPPConferenceSession conferenceSession = new XMPPConferenceSession(this);
                CollaborationSessionListener listener = this.getSessionListener();
                if (listener != null) {
                    conferenceSession.setSessionListener(listener);
                }
                this._conferenceService = conferenceSession;
            }
            if (!(this._conferenceService instanceof XMPPConferenceSession)) {
                throw new CollaborationException("Either accessService(CollaborationSessionFactory.CONFERENCE) or getConferenceService() should be used. Both cannot be used interchangeably");
            }
            return (XMPPConferenceSession)this._conferenceService;
        }
        if (str.equals("notification")) {
            if (this._notificationService == null) {
                XMPPNotificationSession notificationSession = new XMPPNotificationSession(this);
                CollaborationSessionListener listener = this.getSessionListener();
                if (listener != null) {
                    notificationSession.setSessionListener(listener);
                }
                this._notificationService = notificationSession;
            }
            if (!(this._notificationService instanceof XMPPNotificationSession)) {
                throw new CollaborationException("Either accessService(CollaborationSessionFactory.NOTIFICATION) or getNotificationService() should be used. Both cannot be used interchangeably");
            }
            return (XMPPNotificationSession)this._notificationService;
        }
        return this;
    }

    public CollaborationPrincipal createPrincipal(String uid) throws CollaborationException {
        String fquid = StringUtility.appendDomainToAddress(uid, this._server.getDomain());
        return new XMPPPrincipal(new JID(fquid));
    }

    public CollaborationPrincipal createPrincipal(String uid, String displayName) throws CollaborationException {
        String fquid = StringUtility.appendDomainToAddress(uid, this._server.getDomain());
        return new XMPPPrincipal(new JID(fquid), displayName);
    }

    public static String getItemValue(StreamElement node, String name) {
        String value = null;
        Iterator i = node.listElements(name).iterator();
        if (i.hasNext()) {
            value = ((StreamElement)i.next()).normalizeTrimText();
        }
        return value;
    }

    protected void loadJabberServices() throws CollaborationException {
        DiscoItemsQuery dq = this.sendItemsQuery(this._server, null);
        Iterator itr = dq.listItems().iterator();
        PacketMonitor monitor = new PacketMonitor();
        monitor.setRouter((PacketRouter)this._connection);
        monitor.setDispatcher((PacketDispatcher)this._connection);
        monitor.setTimeout(REQUEST_TIMEOUT);
        while (itr.hasNext()) {
            Object diq = null;
            DiscoItem item = (DiscoItem)itr.next();
            if (item.getJID().equals(this.getCurrentUserJID()) || this._discoveredServices.contains(item.getJID())) continue;
            InfoQuery iq = this.createDiscoInfoQuery(item.getJID(), null);
            try {
                monitor.send((Packet)iq, (MonitorListener)new ServiceDiscovery(this, item));
            }
            catch (IllegalStateException e) {}
        }
    }

    protected DiscoItemsQuery sendItemsQuery(JID server, String node) throws CollaborationException {
        String errorCond;
        PacketError error;
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iq.setType((Packet.Type)InfoQuery.GET);
        iq.setFrom(this._client.getJID());
        iq.setTo(server);
        iq.setID(this.nextID("item"));
        DiscoItemsQuery dq = (DiscoItemsQuery)_sdf.createElementNode(DiscoItemsQuery.NAME);
        if (node != null) {
            dq.setNode(node);
        }
        iq.add((StreamNode)dq);
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._connection, (Packet)iq, (long)SHORT_REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
            throw new CollaborationException("Connection Error");
        }
        if (iq == null) {
            throw new TimeoutException("Request timed out");
        }
        if (iq.getType() == InfoQuery.RESULT) {
            return (DiscoItemsQuery)iq.listExtensions("http://jabber.org/protocol/disco#items").get(0);
        }
        if (iq.getType() == InfoQuery.ERROR && (error = iq.getError()) != null && (errorCond = error.getDefinedCondition()) != null && (errorCond.equals("feature-not-implemented") || errorCond.equals("service-unavailable"))) {
            throw new ServiceUnavailableException(error.getText());
        }
        throw new CollaborationException("Some error has occurred in getting the discovery information : " + iq.toString());
    }

    private InfoQuery createDiscoInfoQuery(JID server, String node) {
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iq.setType((Packet.Type)InfoQuery.GET);
        iq.setFrom(this._client.getJID());
        iq.setTo(server);
        iq.setID(this.nextID("info"));
        DiscoInfoQuery dq = (DiscoInfoQuery)_sdf.createElementNode(DiscoInfoQuery.NAME);
        if (node != null) {
            dq.setNode(node);
        }
        iq.add((StreamNode)dq);
        return iq;
    }

    protected DiscoInfoQuery sendInfoQuery(JID server, String node) throws CollaborationException {
        String errorCond;
        PacketError error;
        InfoQuery iq = this.createDiscoInfoQuery(server, node);
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._connection, (Packet)iq, (long)SHORT_REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
            throw new IllegalStateException("Could not authenticate to server!");
        }
        if (iq == null) {
            throw new TimeoutException("Request timed out");
        }
        if (iq.getType() == InfoQuery.RESULT) {
            return (DiscoInfoQuery)iq.listExtensions("http://jabber.org/protocol/disco#info").get(0);
        }
        if (iq.getType() == InfoQuery.ERROR && (error = iq.getError()) != null && (errorCond = error.getDefinedCondition()) != null && (errorCond.equals("feature-not-implemented") || errorCond.equals("service-unavailable"))) {
            throw new ServiceUnavailableException(error.getText());
        }
        throw new CollaborationException("Some error has occurred in getting the discovery information : " + iq.toString());
    }

    private DiscoInfoQuery sendInfoQuery(JID server) throws CollaborationException {
        return this.sendInfoQuery(server, null);
    }

    public CollaborationPrincipal getPrincipal() throws CollaborationException {
        return this._client;
    }

    public void logout() {
        try {
            this._logout = true;
            this._connection.close();
            this._provider.cancel(this._selectionKey);
            this._connection.disconnect();
        }
        catch (Exception e) {
            XMPPSessionProvider.error(e.toString(), e);
        }
        this._provider.cleanupSession(this);
    }

    public void setSessionListener(CollaborationSessionListener listener) {
        this._sessionListeners.remove(0);
        this._sessionListeners.add(0, listener);
    }

    private Presence processPresence(org.jabberstudio.jso.Presence p) throws CollaborationException {
        if (p.getType() != null && p.getType().equals((Object)org.jabberstudio.jso.Presence.ERROR)) {
            XMPPSessionProvider.error("Recieved a presence packet of type error");
            return null;
        }
        Iterator itr = p.listElements().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof MUCUserQuery)) continue;
            XMPPConference c = this._conferenceService.getConference(p.getFrom().toBareJID().toString());
            if (c != null) {
                c.userStatusChange(p);
            }
            return null;
        }
        XMPPSessionProvider.debug("Calling process presence in presence session");
        if (this._presenceService != null) {
            return this._presenceService.processPresence(p);
        }
        return null;
    }

    public Stream getConnection() {
        return this._connection;
    }

    public StreamDataFactory getDataFactory() {
        return _sdf;
    }

    private XMPPContentStream getContentStream(String sid) {
        XMPPContentStream cs = null;
        if (this._streamingService != null) {
            cs = this._streamingService.getContentStream(sid);
        }
        return cs;
    }

    private void processInfoQuery(Packet packet) {
        try {
            if (this._streamingService != null && this._streamingService.isStreamingPacket(packet)) {
                this._streamingService.processSIPackets((InfoQuery)packet);
                return;
            }
            List elements = packet.listElements("open", IBB_NAMESPACE);
            if (elements.size() > 0) {
                StreamElement ibb = (StreamElement)elements.get(0);
                String sid = ibb.getAttributeValue("sid");
                if (sid == null) {
                    return;
                }
                XMPPContentStream cs = this.getContentStream(sid);
                if (cs != null) {
                    cs.process(packet);
                    return;
                }
                this._ibbMessages.put(sid, new ArrayList());
                Packet p = _sdf.createPacketNode(packet.getNSI());
                p.setID(packet.getID());
                p.setType((Packet.Type)InfoQuery.RESULT);
                p.setFrom(this._client.getJID());
                JID from = packet.getFrom();
                if (this._conferenceService.getConference(from.toBareJID().toString()) != null) {
                    p.setTo(from.toBareJID());
                } else {
                    p.setTo(from);
                }
                this._connection.send(p);
                return;
            }
            elements = packet.listElements("close", IBB_NAMESPACE);
            if (elements.size() > 0) {
                StreamElement ibb = (StreamElement)elements.get(0);
                String sid = ibb.getAttributeValue("sid");
                if (sid == null) {
                    return;
                }
                XMPPContentStream cs = this.getContentStream(sid);
                if (cs != null) {
                    cs.process(packet);
                    return;
                }
                ArrayList list = (ArrayList)this._ibbMessages.get(sid);
                if (list == null || list.size() == 0) {
                    return;
                }
                Packet p = _sdf.createPacketNode(packet.getNSI());
                p.setID(packet.getID());
                p.setType((Packet.Type)InfoQuery.RESULT);
                p.setFrom(this._client.getJID());
                JID from = packet.getFrom();
                if (this._conferenceService.getConference(from.toBareJID().toString()) != null) {
                    p.setTo(from.toBareJID());
                } else {
                    p.setTo(from);
                }
                this._connection.send(p);
                return;
            }
            List rqList = packet.listExtensions("jabber:iq:roster");
            if (rqList.size() > 0) {
                if (packet.getType() == InfoQuery.RESULT) {
                    this._personalStoreService.processAsyncRosterQuery((RosterQuery)rqList.get(0));
                } else if (packet.getType() == InfoQuery.SET) {
                    this._personalStoreService.processRosterQuery((RosterQuery)rqList.get(0));
                }
                return;
            }
            List pqList = packet.listExtensions(PRIVATE_NAMESPACE);
            if (pqList.size() > 0) {
                List gList;
                List sList = ((StreamElement)pqList.get(0)).listElements(STORAGE_NAME);
                if (sList.size() > 0) {
                    if (packet.getType() == InfoQuery.RESULT) {
                        this._personalStoreService.processAsyncBookmarkQuery((StreamElement)sList.get(0));
                    } else if (packet.getType() == InfoQuery.SET) {
                        this._personalStoreService.processBookmarkQuery((StreamElement)sList.get(0));
                    }
                }
                if ((gList = ((StreamElement)pqList.get(0)).listElements(SUN_PRIVATE_LDAPGROUP_NAME)).size() > 0) {
                    if (packet.getType() == InfoQuery.RESULT) {
                        this._personalStoreService.processAsyncLDAPGroupQuery((StreamElement)gList.get(0));
                    } else if (packet.getType() == InfoQuery.SET) {
                        this._personalStoreService.processLDAPGroupQuery((StreamElement)gList.get(0));
                    }
                }
                return;
            }
            if (packet.getExtension("http://jabber.org/protocol/disco#info") != null) {
                this.processDiscoInfoRequest(packet);
                return;
            }
            if (packet.getExtension("http://jabber.org/protocol/disco#items") != null) {
                this.processDiscoItemsRequest(packet);
                return;
            }
            if (packet.getExtension("jabber:iq:register") != null) {
                new Thread(new RegisterNotifier((InfoQuery)packet)).start();
                return;
            }
            if (this._regisListeners.containsKey(packet.getID())) {
                new Thread(new RegisterNotifier((InfoQuery)packet)).start();
                return;
            }
            XMPPContentStream cs = this.getContentStream(packet.getID());
            if (cs != null) {
                cs.process(packet);
                return;
            }
            List oobList = packet.listExtensions("jabber:iq:oob");
            if (oobList.size() > 0 && this._streamingService != null && packet.getType() == InfoQuery.SET) {
                this._streamingService.processSIPackets((InfoQuery)packet);
                return;
            }
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
        }
        catch (CollaborationException ce) {
            XMPPSessionProvider.error(ce.toString(), ce);
        }
    }

    protected void processMessage(Packet packet) {
        List elements = packet.listElements("data", IBB_NAMESPACE);
        if (elements.size() > 0) {
            StreamElement ibb = (StreamElement)elements.get(0);
            String sid = ibb.getAttributeValue("sid");
            if (sid != null) {
                XMPPContentStream cs = this.getContentStream(sid);
                if (cs != null) {
                    cs.process(packet);
                    return;
                }
                ArrayList list = (ArrayList)this._ibbMessages.get(sid);
                if (list == null) {
                    return;
                }
                list.add(packet);
                this._ibbMessages.put(sid, list);
            }
            return;
        }
        Message in = (Message)packet;
        try {
            XMPPSessionProvider.debug("Incoming message type: " + in.getType());
            if (in.getType() == Packet.ERROR) {
                XMPPSessionProvider.error("Error message received: " + in.toString());
            } else if (Message.GROUPCHAT.equals((Object)in.getType())) {
                if (this._conferenceService != null) {
                    this._conferenceService.processGroupChat(in);
                } else {
                    XMPPSessionProvider.warning("[PacketTransferred] : chat message received as conference service is not initialized - packet is ignored.");
                }
            } else if (this._conferenceService != null && this._conferenceService.getConference(in.getFrom().toBareJID().toString()) != null) {
                XMPPSessionProvider.debug("[PacketTransferred] : processing groupchat message");
                this._conferenceService.processGroupChat(in);
            } else if (Message.CHAT.equals((Object)in.getType())) {
                XMPPSessionProvider.debug("[PacketTransferred] : processing chat message");
                if (this._conferenceService != null) {
                    this._conferenceService.processChat(in);
                } else {
                    XMPPSessionProvider.warning("[PacketTransferred] : chat message received as conference service is not initialized - packet is ignored.");
                }
            } else if (in.getExtension("http://jabber.org/protocol/muc#user") != null) {
                XMPPSessionProvider.debug("[PacketTransferred] : processing invite message");
                if (this._conferenceService != null) {
                    this._conferenceService.processInvite(in);
                } else {
                    XMPPSessionProvider.warning("[PacketTransferred] : chat message received as conference service is not initialized - packet is ignored.");
                }
            } else if (in.getExtension("http://jabber.org/protocol/pubsub#event") != null) {
                if (this._newsService != null) {
                    this._newsService.processNewsMessage(in);
                } else {
                    XMPPSessionProvider.warning("[PacketTransferred] pubsub packet received as news service is not initialized - packet is ignored.");
                }
            } else if (this._notificationService != null) {
                this._notificationService.processNormalMessage(in);
            } else {
                XMPPSessionProvider.warning("[PacketTransferred] normal messsage packet received as notification service is not initialized - packet is ignored.");
            }
        }
        catch (CollaborationException ce) {
            XMPPSessionProvider.error(ce.toString(), ce);
        }
    }

    protected XMPPMessage assembleMessages(XMPPMessage m) throws CollaborationException {
        Message in = (Message)m.getXMPPMessage();
        m.setHeaders(this.getPropertiesFromPacket((Packet)in));
        StreamElement attachElem = in.getFirstElement(SUN_ATTACH_NAME);
        if (attachElem == null) {
            return m;
        }
        String sid_list = attachElem.normalizeTrimText();
        StringTokenizer st = new StringTokenizer(sid_list, ",");
        while (st.hasMoreTokens()) {
            String sid = st.nextToken();
            ArrayList list = (ArrayList)this._ibbMessages.get(sid);
            if (list == null || list.size() == 0) continue;
            XMPPMessagePart part = new XMPPMessagePart();
            part.setHeaders(this.getPropertiesFromPacket((Packet)list.get(0)));
            StringBuffer contents = new StringBuffer();
            for (int i = 0; i < list.size(); ++i) {
                in = (Message)list.get(i);
                List elements = in.listElements("data", IBB_NAMESPACE);
                if (elements.size() == 0) continue;
                contents.append(((StreamElement)elements.get(0)).normalizeText());
            }
            part.setContent(contents.toString());
            m.addPart(part);
            this._ibbMessages.remove(sid);
        }
        return m;
    }

    private Hashtable getPropertiesFromPacket(Packet in) {
        Extension x = in.getExtension(SUN_PRIVATE_NAMESPACE);
        if (x == null) {
            return null;
        }
        Hashtable<String, String> contents = new Hashtable<String, String>();
        Iterator itr = x.listElements("property").iterator();
        while (itr.hasNext()) {
            StreamElement propElem = (StreamElement)itr.next();
            String name = propElem.getAttributeValue("name");
            StreamElement valueElem = propElem.getFirstElement("value");
            if (valueElem == null) continue;
            contents.put(name, valueElem.normalizeTrimText());
        }
        return contents;
    }

    private void processRegisterQuery(InfoQuery iq) throws CollaborationException {
        RegisterQuery registerQuery;
        XMPPRegistrationListenerWrapper regisListenerWrapper = (XMPPRegistrationListenerWrapper)this._regisListeners.get(iq.getID());
        JID server = iq.getFrom();
        String serverStr = this._server.toString();
        RegistrationListener regisListener = null;
        if (regisListenerWrapper == null) {
            throw new CollaborationException("registration response out of sync");
        }
        regisListener = regisListenerWrapper.getRegisListener();
        XMPPRegistrationListenerWrapper.RequestType reqType = regisListenerWrapper.getRequestType();
        if (server != null) {
            serverStr = server.toString();
        }
        if ((registerQuery = (RegisterQuery)iq.getExtension("jabber:iq:register")) != null) {
            this.processRegisterResponse(iq, registerQuery, regisListenerWrapper, serverStr);
        } else {
            this.processRegisSuccessFailure(iq, regisListenerWrapper, serverStr);
        }
    }

    private String getRegistrationErrorCondition(String condition) {
        if ("conflict".equals(condition)) {
            return "already_registered";
        }
        if ("not-authorized".equals(condition) || "forbidden".equals(condition)) {
            return "not_authorized";
        }
        if ("not-acceptable".equals(condition) || "bad-request".equals(condition)) {
            return "missing_data";
        }
        if ("registration-required".equals(condition)) {
            return "not_registered";
        }
        if ("feature-not-implemented".equals(condition) || "unexpected-request".equals(condition) || "not-allowed".equals(condition)) {
            return "service_unavailable";
        }
        return "unknown_error_condition";
    }

    public static String access2Affiliation(int access) {
        String affiliation = null;
        switch (access) {
            case 1: {
                affiliation = "outcast";
                break;
            }
            case 2: {
                affiliation = "none";
                break;
            }
            case 4: {
                affiliation = "publisher";
                break;
            }
            case 30: {
                affiliation = "owner";
                break;
            }
            default: {
                affiliation = "none";
            }
        }
        return affiliation;
    }

    public static int affiliation2Access(String affiliation) {
        int access = 0;
        int defaultAccess = 1;
        if (affiliation == null) {
            access = defaultAccess;
        } else if (affiliation.equals("outcast")) {
            access = 1;
        } else if (affiliation.equals("publisher")) {
            access = 4;
        } else if (affiliation.equals("owner")) {
            access = 30;
        } else if (affiliation.equals("none")) {
            access = 2;
        }
        return access;
    }

    public void addConference(XMPPConference c) {
        this._conferenceService.addConference(c);
    }

    public void removeConference(String str) {
        this._conferenceService.removeConference(str);
    }

    public void register(String serviceURL, XMPPRegistrationListenerWrapper listener) throws CollaborationException {
        this.getRegistrationFields(new JID(serviceURL), listener);
    }

    public void changePassword(String password, RegistrationListener listener) throws CollaborationException {
        XMPPRegistrationListenerWrapper regisListenerWrapper = new XMPPRegistrationListenerWrapper(listener);
        regisListenerWrapper.setRequestType(XMPPRegistrationListenerWrapper.USER_PASSWD_CHANGE);
        InfoQuery iqQuery = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iqQuery.setTo(this._server);
        iqQuery.setType((Packet.Type)InfoQuery.SET);
        iqQuery.setID(this.nextID("register"));
        XMPPRegistrationListenerWrapper regisListener = new XMPPRegistrationListenerWrapper(listener);
        this._regisListeners.put(iqQuery.getID(), regisListenerWrapper);
        RegisterQuery rQuery = (RegisterQuery)_sdf.createExtensionNode(RegisterQuery.NAME, RegisterQuery.class);
        rQuery.setUsername(this.getPrincipal().getName());
        rQuery.setPassword(password);
        iqQuery.addExtension((Extension)rQuery);
        try {
            this._connection.send((Packet)iqQuery);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.getMessage());
        }
    }

    void getRegistrationFields(JID recipient, XMPPRegistrationListenerWrapper listener) throws CollaborationException {
        InfoQuery iqQuery = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iqQuery.setTo(recipient);
        iqQuery.setType((Packet.Type)InfoQuery.GET);
        iqQuery.setID(this.nextID("register"));
        this._regisListeners.put(iqQuery.getID(), listener);
        RegisterQuery rQuery = (RegisterQuery)_sdf.createExtensionNode(_sdf.createNSI("query", "jabber:iq:register"), RegisterQuery.class);
        if (rQuery == null) {
            // empty if block
        }
        iqQuery.addExtension((Extension)rQuery);
        try {
            this._connection.send((Packet)iqQuery);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.getMessage());
        }
    }

    void sendRegistration(JID jid, Map values, String ID) throws CollaborationException {
        XMPPRegistrationListenerWrapper regisListener = (XMPPRegistrationListenerWrapper)this._regisListeners.get(ID);
        InfoQuery iqQuery = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iqQuery.setTo(jid);
        iqQuery.setType((Packet.Type)InfoQuery.SET);
        iqQuery.setID(this.nextID("register"));
        this._regisListeners.remove(ID);
        this._regisListeners.put(iqQuery.getID(), regisListener);
        RegisterQuery rQuery = (RegisterQuery)_sdf.createExtensionNode(RegisterQuery.NAME, RegisterQuery.class);
        if (this.keyValue != null) {
            values.put("key", this.keyValue);
        }
        Iterator i = values.keySet().iterator();
        while (i.hasNext()) {
            String fieldName = (String)i.next();
            rQuery.setField(fieldName, (String)values.get(fieldName));
        }
        iqQuery.addExtension((Extension)rQuery);
        try {
            this._connection.send((Packet)iqQuery);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.getMessage());
        }
        finally {
            this.keyValue = null;
        }
    }

    public void unregister(RegistrationListener listener) throws CollaborationException {
        XMPPRegistrationListenerWrapper regisListenerWrapper = new XMPPRegistrationListenerWrapper(listener);
        regisListenerWrapper.setRequestType(XMPPRegistrationListenerWrapper.USER_UNREGISTRATION);
        this.unregister(this._server, regisListenerWrapper);
    }

    void unregister(JID recipient, XMPPRegistrationListenerWrapper regisListener) throws CollaborationException {
        InfoQuery iqQuery = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iqQuery.setTo(recipient);
        iqQuery.setType((Packet.Type)InfoQuery.SET);
        iqQuery.setID(this.nextID("unregister"));
        this._regisListeners.put(iqQuery.getID(), regisListener);
        RegisterQuery rQuery = (RegisterQuery)_sdf.createExtensionNode(RegisterQuery.NAME, RegisterQuery.class);
        rQuery.setRemove(true);
        iqQuery.addExtension((Extension)rQuery);
        try {
            this._connection.send((Packet)iqQuery);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.getMessage());
        }
    }

    protected XMPPConference getConference(String id) {
        return this._conferenceService.getConference(id);
    }

    private void postGatewayRegistration(String senderServer) throws CollaborationException {
        this._presenceService.subscribe(senderServer);
        PersonalGateway gw = this._personalStoreService.getGatewayEntry(senderServer);
        PersonalStoreFolder folder = (PersonalStoreFolder)this._personalStoreService.getEntry("abook", "");
        if (folder == null) {
            folder = (PersonalStoreFolder)this._personalStoreService.createEntry("abook", "");
            folder.save();
        }
        if (gw != null) {
            gw.addToFolder(folder);
            gw.save();
        }
    }

    private void postGatewayUnregistration(String gatewayJID) throws CollaborationException {
        Iterator i = this._personalStoreService.getEntries("contact").iterator();
        while (i.hasNext()) {
            PersonalContact pc = (PersonalContact)i.next();
            String domain = pc.getPrincipal().getDomainName();
            if (domain == null || !domain.equalsIgnoreCase(gatewayJID)) continue;
            pc.remove();
        }
    }

    public PrivacyList getPrivacyList(String name) throws CollaborationException {
        PrivacyQuery pq = this.getPrivacyQueryResult(name);
        if (pq == null) {
            return null;
        }
        org.jabberstudio.jso.x.core.PrivacyList xmppPL = pq.getPrivacyList(name);
        if (xmppPL == null) {
            return null;
        }
        XMPPPrivacyList list = new XMPPPrivacyList(name);
        Iterator itr = xmppPL.listElements().iterator();
        while (itr.hasNext()) {
            this.addPrivacyItemToList(list, (org.jabberstudio.jso.x.core.PrivacyItem)itr.next());
        }
        return list;
    }

    private void addPrivacyItemToList(PrivacyList list, org.jabberstudio.jso.x.core.PrivacyItem xmppItem) throws CollaborationException {
        XMPPPrivacyItem item = new XMPPPrivacyItem();
        if (xmppItem.getAction().equals((Object)org.jabberstudio.jso.x.core.PrivacyItem.ALLOW)) {
            item.setAccess(1);
        } else {
            item.setAccess(2);
        }
        String subject = null;
        if (xmppItem.getType() == org.jabberstudio.jso.x.core.PrivacyItem.SUBSCRIPTION) {
            item.setType("subscription");
            subject = xmppItem.getValue();
        } else if (xmppItem.getType() == org.jabberstudio.jso.x.core.PrivacyItem.GROUP) {
            item.setType("group");
            subject = xmppItem.getValue();
        } else if (xmppItem.getType() == org.jabberstudio.jso.x.core.PrivacyItem.JID) {
            item.setType("jid");
            subject = JIDUtil.decodedJID(xmppItem.getValue());
        }
        item.setSubject(subject);
        boolean resourcePresent = false;
        if (xmppItem.isAppliedToPresenceIn()) {
            resourcePresent = true;
            item.setResource(1);
            list.addPrivacyItem(item);
        }
        if (xmppItem.isAppliedToPresenceOut()) {
            resourcePresent = true;
            item.setResource(2);
            list.addPrivacyItem(item);
        }
        if (xmppItem.isAppliedToMessage()) {
            resourcePresent = true;
            item.setResource(4);
            list.addPrivacyItem(item);
        }
        if (xmppItem.isAppliedToIQ()) {
            resourcePresent = true;
            item.setResource(8);
            list.addPrivacyItem(item);
        }
        if (!resourcePresent) {
            list.addPrivacyItem(item);
        }
    }

    public void addPrivacyList(PrivacyList lst) throws CollaborationException {
        org.jabberstudio.jso.x.core.PrivacyList list = (org.jabberstudio.jso.x.core.PrivacyList)_sdf.createElementNode(org.jabberstudio.jso.x.core.PrivacyList.NAME, org.jabberstudio.jso.x.core.PrivacyList.class);
        ((PrivacyListNode)list).setName(lst.getName());
        int order = 0;
        Collection c = lst.getPrivacyItems();
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            PrivacyItem pi = (PrivacyItem)itr.next();
            org.jabberstudio.jso.x.core.PrivacyItem item = null;
            if (pi.getAccess() == 1) {
                item = list.addItem(org.jabberstudio.jso.x.core.PrivacyItem.ALLOW, order);
            } else if (pi.getAccess() == 2) {
                item = list.addItem(org.jabberstudio.jso.x.core.PrivacyItem.DENY, order);
            }
            String subject = null;
            if ("subscription".equals(pi.getType())) {
                item.setType(org.jabberstudio.jso.x.core.PrivacyItem.SUBSCRIPTION);
                subject = pi.getSubject();
            } else if ("group".equals(pi.getType())) {
                item.setType(org.jabberstudio.jso.x.core.PrivacyItem.GROUP);
                subject = pi.getSubject();
            } else if ("jid".equals(pi.getType())) {
                item.setType(org.jabberstudio.jso.x.core.PrivacyItem.JID);
                subject = JIDUtil.encodedJID(pi.getSubject()).toString();
            }
            item.setValue(subject);
            this.setItemResource(pi, item);
            ++order;
        }
        this.setPrivacyQuery(list, null, null);
    }

    public List listPrivacyLists() throws CollaborationException {
        PrivacyQuery pq = this.getPrivacyQueryResult(null);
        this.privacyListsListed = true;
        this._activePrivacyList = pq.getActive();
        this._defaultPrivacyList = pq.getDefault();
        List l = pq.listPrivacyLists();
        ArrayList<String> ret = new ArrayList<String>();
        Iterator i = l.iterator();
        while (i.hasNext()) {
            org.jabberstudio.jso.x.core.PrivacyList pl = (org.jabberstudio.jso.x.core.PrivacyList)i.next();
            String name = pl.getName();
            ret.add(name);
        }
        return ret;
    }

    public void removePrivacyList(String name) throws CollaborationException {
        if (name.equals(this._defaultPrivacyList)) {
            this._defaultPrivacyList = null;
        }
        if (name.equals(this._activePrivacyList)) {
            this._activePrivacyList = null;
        }
        PrivacyListNode list = new PrivacyListNode(_sdf);
        list.setName(name);
        this.setPrivacyQuery((org.jabberstudio.jso.x.core.PrivacyList)list, null, null);
    }

    protected PrivacyQuery getPrivacyQueryResult(String listName) throws CollaborationException {
        PacketError error;
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iq.setType((Packet.Type)InfoQuery.GET);
        iq.setID(this.nextID("privacy"));
        PrivacyQuery node = (PrivacyQuery)_sdf.createExtensionNode(PrivacyQuery.NAME, PrivacyQuery.class);
        if (listName != null) {
            node.addPrivacyList(listName);
        }
        iq.add((StreamNode)node);
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._connection, (Packet)iq, (long)REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            se.printStackTrace();
        }
        if (iq == null) {
            throw new TimeoutException("Timeout while getting the privacy list from server!");
        }
        if (iq.getType() == InfoQuery.RESULT) {
            return (PrivacyQuery)iq.listExtensions("jabber:iq:privacy").get(0);
        }
        if (iq.getType() == InfoQuery.ERROR && (error = iq.getError()) != null && "item-not-found".equals(error.getDefinedCondition())) {
            return null;
        }
        throw new CollaborationException("Could not get the privacy list from server!");
    }

    private void setPrivacyQuery(org.jabberstudio.jso.x.core.PrivacyList list, String active, String def) {
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        PrivacyQuery node = (PrivacyQuery)_sdf.createExtensionNode(PrivacyQuery.NAME, PrivacyQuery.class);
        if (list != null) {
            node.add((StreamNode)list);
            node.addPrivacyList(list.getName());
        }
        this.sendPrivacyQuery(iq, node);
    }

    private void sendPrivacyQuery(InfoQuery iq, PrivacyQuery node) {
        iq.addExtension((Extension)node);
        iq.setType((Packet.Type)InfoQuery.SET);
        iq.setFrom(this._client.getJID());
        iq.setID(this.nextID("privacy"));
        try {
            this._connection.send((Packet)iq);
        }
        catch (StreamException se) {
            se.printStackTrace();
        }
    }

    public PrivacyList createPrivacyList(String name) throws CollaborationException {
        return new XMPPPrivacyList(name);
    }

    public String getDefaultPrivacyListName() throws CollaborationException {
        if (this._defaultPrivacyList == null) {
            this._defaultPrivacyList = this.getPrivacyQueryResult(null).getDefault();
        }
        return this._defaultPrivacyList;
    }

    public void setDefaultPrivacyListName(String name) throws CollaborationException {
        this._defaultPrivacyList = name;
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        PrivacyQuery node = (PrivacyQuery)_sdf.createExtensionNode(PrivacyQuery.NAME, PrivacyQuery.class);
        if (name == null) {
            node.addElement("default");
        } else {
            node.setDefault(name);
        }
        this.sendPrivacyQuery(iq, node);
    }

    public String getActivePrivacyListName() throws CollaborationException {
        if (this._activePrivacyList == null && !this.privacyListsListed) {
            this._activePrivacyList = this.getPrivacyQueryResult(null).getActive();
        }
        return this._activePrivacyList;
    }

    public void setActivePrivacyListName(String name) throws CollaborationException {
        this._activePrivacyList = name;
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        PrivacyQuery node = (PrivacyQuery)_sdf.createExtensionNode(PrivacyQuery.NAME, PrivacyQuery.class);
        if (name == null) {
            node.addElement("active");
        } else {
            node.setActive(name);
        }
        this.sendPrivacyQuery(iq, node);
    }

    private void setItemResource(PrivacyItem pi, org.jabberstudio.jso.x.core.PrivacyItem item) {
        switch (pi.getResource()) {
            case 1: {
                item.setAppliedToPresenceIn(true);
                break;
            }
            case 2: {
                item.setAppliedToPresenceOut(true);
                break;
            }
            case 4: {
                item.setAppliedToMessage(true);
            }
        }
    }

    String getProviderSessionIdentifier() {
        return this._providerSessionIdentifier;
    }

    void setProviderSessionIdentifier(String sessionIdentifier) {
        this._providerSessionIdentifier = sessionIdentifier;
    }

    void addSendAndWatchID(String id) {
        this._sendAndWatchIDs.add(id);
    }

    boolean removeSendAndWatchID(String id) {
        return this._sendAndWatchIDs.remove(id);
    }

    void cancelSubscription(String uid) throws CollaborationException {
        if (this._presenceService != null) {
            this._presenceService.cancel(uid);
        }
    }

    public NotificationService getNotificationService() throws CollaborationException {
        if (this._notificationService == null) {
            this._notificationService = new XMPPNotificationService(this);
        }
        return this._notificationService;
    }

    public ConferenceService getConferenceService() throws CollaborationException {
        if (this._conferenceService == null) {
            this._conferenceService = new XMPPConferenceService(this);
        }
        return this._conferenceService;
    }

    public NewsService getNewsService() throws CollaborationException {
        if (this._newsService == null) {
            this._newsService = new XMPPNewsService(this);
        }
        return this._newsService;
    }

    public PersonalStoreService getPersonalStoreService() throws CollaborationException {
        if (this._personalStoreService == null) {
            this._personalStoreService = new XMPPPersonalStoreService(this);
        }
        return this._personalStoreService;
    }

    public PresenceService getPresenceService() throws CollaborationException {
        if (this._presenceService == null) {
            this._presenceService = new XMPPPresenceService(this);
        }
        return this._presenceService;
    }

    public StreamingService getStreamingService() throws CollaborationException {
        if (this._streamingService == null) {
            this._streamingService = new XMPPStreamingService(this);
        }
        return this._streamingService;
    }

    public Collection listNewsChannels(String domain) throws CollaborationException {
        return this._newsService.listNewsChannels();
    }

    protected void addNewsChannel(XMPPNewsChannel nc) {
        if (this._newsService != null) {
            this._newsService.addNewsChannel(nc);
        }
    }

    protected void removeNewsChannel(XMPPNewsChannel nc) {
        if (this._newsService != null) {
            this._newsService.removeNewsChannel(nc);
        }
    }

    public boolean isCurrentUser(JID jid) {
        if (jid == null) {
            return false;
        }
        return this._client.getJID().toBareJID().equals(jid.toBareJID());
    }

    public JID getCurrentUserJID() {
        if (this._client != null) {
            return this._client.getJID();
        }
        return null;
    }

    private void processDiscoInfoRequest(Packet packet) throws CollaborationException {
        if (InfoQuery.RESULT.equals((Object)packet.getType()) || InfoQuery.ERROR.equals((Object)packet.getType()) || InfoQuery.SET.equals((Object)packet.getType())) {
            return;
        }
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iq.setTo(packet.getFrom());
        iq.setType((Packet.Type)InfoQuery.RESULT);
        iq.setID(packet.getID());
        DiscoInfoQuery disco = (DiscoInfoQuery)_sdf.createExtensionNode(DiscoInfoQuery.NAME, DiscoInfoQuery.class);
        try {
            if (InfoQuery.GET.equals((Object)packet.getType())) {
                ApplicationInfo appinfo = this._provider.getApplicationInfo();
                String category = DEFAULT_CLIENT_CATEGORY;
                String type = DEFAULT_CLIENT_TYPE;
                String name = DEFAULT_CLIENT_NAME;
                if (appinfo != null) {
                    if (appinfo.getCategory() != null) {
                        category = appinfo.getCategory();
                    }
                    if (appinfo.getType() != null) {
                        type = appinfo.getType();
                    }
                    if (appinfo.getName() != null) {
                        name = appinfo.getName();
                    }
                }
                disco.addIdentity(category, type, name);
            }
            this.addFeatures(disco);
            iq.add((StreamNode)disco);
            this._connection.send((Packet)iq);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.toString());
        }
    }

    private void processDiscoItemsRequest(Packet packet) throws CollaborationException {
        if (InfoQuery.RESULT.equals((Object)packet.getType()) || InfoQuery.ERROR.equals((Object)packet.getType()) || InfoQuery.SET.equals((Object)packet.getType())) {
            return;
        }
        InfoQuery iq = (InfoQuery)_sdf.createPacketNode(IQ_NAME, InfoQuery.class);
        iq.setFrom(packet.getTo());
        iq.setTo(packet.getFrom());
        iq.setType((Packet.Type)InfoQuery.RESULT);
        iq.setID(packet.getID());
        try {
            DiscoItemsQuery disco = (DiscoItemsQuery)_sdf.createExtensionNode(DiscoItemsQuery.NAME, DiscoItemsQuery.class);
            iq.add((StreamNode)disco);
            this._connection.send((Packet)iq);
        }
        catch (StreamException se) {
            throw new CollaborationException(se.toString());
        }
    }

    public boolean isGatewayEntry(JID jid) {
        try {
            if (jid != null && this._personalStoreService != null && this._personalStoreService.isGatewayEntry(jid.toBareJID())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void notifyStreamError(StreamError error) {
        if (this.getSessionListener() != null) {
            this._provider.cancel(this._selectionKey);
            this._provider.cleanupSession(this);
            CollaborationException e = error != null && error.getFirstElement("conflict") != null ? new ConflictException("Duplicate Connection detected") : new CollaborationException("Server Disconnected");
            this.fireCollaborationSessionListener(e);
        } else {
            Iterator itr = this._regisListeners.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                XMPPRegistrationListenerWrapper listener = (XMPPRegistrationListenerWrapper)entry.getValue();
                if (listener == null) continue;
                String condition = "service_unavailable";
                if (error != null && error.getFirstElement(null, "not-authorized") != null) {
                    condition = "not_authorized";
                }
                listener.getRegisListener().registrationFailed(condition, "Stream error", null);
                this._regisListeners.remove(entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendKeepAlive() {
        Stream stream = this._connection;
        synchronized (stream) {
            try {
                this._css.write(keepAliveBuffer, 0, 2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected boolean _initFeaturesSupported() {
        String feature;
        Iterator i;
        boolean sFailed = false;
        DiscoInfoQuery diq = null;
        try {
            diq = this.sendInfoQuery(this._server);
        }
        catch (CollaborationException ce) {
            XMPPSessionProvider.debug(null, ce);
            sFailed = true;
        }
        if (diq != null) {
            i = diq.getFeatures().iterator();
            while (i.hasNext()) {
                feature = (String)i.next();
                if (!AMP_NAMESPACE.equals(feature)) continue;
                this.ampSupported = true;
            }
        }
        if (this.ampSupported) {
            try {
                diq = this.sendInfoQuery(this._server, AMP_NAMESPACE);
            }
            catch (CollaborationException ce) {
                XMPPSessionProvider.debug(null, ce);
                sFailed = true;
            }
            i = diq.getFeatures().iterator();
            while (i.hasNext()) {
                feature = (String)i.next();
                if (AMP_COND_DELIVER_NAMESPACE.equals(feature)) {
                    this.ampCondDeliverSupported = true;
                    continue;
                }
                if (AMP_COND_EXPIREAT_NAMESPACE.equals(feature)) {
                    this.ampCondExpireAtSupported = true;
                    continue;
                }
                if (AMP_COND_MATCHRES_NAMESPACE.equals(feature)) {
                    this.ampCondMatchResourceSupported = true;
                    continue;
                }
                if ("http://jabber.org/protocol/amp?action=drop".equals(feature)) {
                    this.ampActionDropSupported = true;
                    continue;
                }
                if ("http://jabber.org/protocol/amp?action=drop".equals(feature)) {
                    this.ampActionAlertSupported = true;
                    continue;
                }
                if (AMP_ACTION_NOTIFY_NAMESPACE.equals(feature)) {
                    this.ampActionNotifySupported = true;
                    continue;
                }
                if (!AMP_ACTION_ERROR_NAMESPACE.equals(feature)) continue;
                this.ampActionErrorSupported = true;
            }
        }
        return sFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForServiceInitialization(Object service) {
        Object object;
        try {
            if (!this._loadingServices) {
                object = this._loadingServiceLock;
                synchronized (object) {
                    if (!this._loadingServices) {
                        this._loadingServices = true;
                        this.loadJabberServices();
                    }
                }
            }
            object = service;
            synchronized (object) {
                long waitTime = SHORT_REQUEST_TIMEOUT;
                long start = System.currentTimeMillis();
                while (!this.isServiceInitialized(service)) {
                    try {
                        service.wait(waitTime);
                    }
                    catch (InterruptedException ie) {
                        XMPPSessionProvider.debug(ie.toString(), ie);
                    }
                    if (this.isServiceInitialized(service)) continue;
                    long end = System.currentTimeMillis();
                    int slept = (int)(end - start);
                    if ((long)slept >= waitTime) break;
                    waitTime -= (long)slept;
                    start = end;
                }
            }
        }
        catch (Exception e) {
            XMPPSessionProvider.debug(e.toString(), e);
        }
        object = this._loadingServiceLock;
        synchronized (object) {
            this._loadingServices = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServiceInitialized(Object service) {
        Object object = this._jabberServiceLock;
        synchronized (object) {
            if (service instanceof ConferenceService) {
                return this._mucService != null;
            }
            if (service instanceof NewsService) {
                return this._pubsubService != null;
            }
            if (service instanceof PersonalStoreService) {
                return this._judService != null;
            }
            return false;
        }
    }

    private void addFeatures(DiscoInfoQuery disco) {
        disco.addFeature("http://jabber.org/protocol/si");
        disco.addFeature("http://jabber.org/protocol/si/profile/file-transfer");
    }

    private void processRegisterResponse(InfoQuery iq, RegisterQuery registerQuery, XMPPRegistrationListenerWrapper regisListenerWrapper, String serverStr) throws CollaborationException {
        RegistrationListener regisListener = regisListenerWrapper.getRegisListener();
        XMPPRegistrationListenerWrapper.RequestType reqType = regisListenerWrapper.getRequestType();
        if (iq.getType() == InfoQuery.RESULT && registerQuery != null) {
            if (registerQuery.isRegistered() && XMPPRegistrationListenerWrapper.USER_REGISTRATION.equals(reqType)) {
                regisListener.registered(serverStr);
                return;
            }
            this.keyValue = registerQuery.getKey();
            registerQuery.clearKey();
            Set fields = registerQuery.getFieldNames();
            HashMap<String, String> fieldValuePairs = new HashMap<String, String>();
            Iterator iter = fields.iterator();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                fieldValuePairs.put(fieldName, registerQuery.getField(fieldName));
            }
            boolean filled = regisListener.fillRegistrationInformation(fieldValuePairs, serverStr);
            if (!filled) {
                if (XMPPRegistrationListenerWrapper.USER_REGISTRATION.equals(reqType)) {
                    this.logout();
                }
                return;
            }
            String userName = (String)fieldValuePairs.get("username");
            String password = (String)fieldValuePairs.get("password");
            if (userName == null || userName.equals("") || password == null || password.equals("")) {
                regisListener.registrationFailed("missing_data", "Empty username or password is not allowed", serverStr);
                if (XMPPRegistrationListenerWrapper.USER_REGISTRATION.equals(reqType)) {
                    this.logout();
                }
                return;
            }
            if (iq.getFrom() != null) {
                this.sendRegistration(iq.getFrom(), fieldValuePairs, iq.getID());
            } else {
                this.sendRegistration(this._server, fieldValuePairs, iq.getID());
            }
        }
    }

    private void processRegisSuccessFailure(InfoQuery iq, XMPPRegistrationListenerWrapper regisListenerWrapper, String serverStr) throws CollaborationException {
        RegistrationListener regisListener = regisListenerWrapper.getRegisListener();
        XMPPRegistrationListenerWrapper.RequestType reqType = null;
        reqType = regisListenerWrapper.getRequestType();
        if (iq.getType() == InfoQuery.RESULT) {
            if (XMPPRegistrationListenerWrapper.GATEWAY_REGISTRATION.equals(reqType)) {
                this.postGatewayRegistration(serverStr);
                regisListener.registered(serverStr);
            } else if (XMPPRegistrationListenerWrapper.USER_REGISTRATION.equals(reqType)) {
                regisListener.registered(serverStr);
                this.logout();
            } else if (XMPPRegistrationListenerWrapper.USER_PASSWD_CHANGE.equals(reqType)) {
                regisListener.registrationUpdated(serverStr);
            } else if (XMPPRegistrationListenerWrapper.GATEWAY_UNREGISTRATION.equals(reqType)) {
                this.postGatewayUnregistration(serverStr);
                regisListener.unregistered(serverStr);
            } else if (XMPPRegistrationListenerWrapper.USER_UNREGISTRATION.equals(reqType)) {
                regisListener.unregistered(serverStr);
            }
            this._regisListeners.remove(iq.getID());
        } else if (iq.getType() == InfoQuery.ERROR) {
            XMPPSessionProvider.debug("Error in registration");
            PacketError pe = iq.getError();
            if (pe != null) {
                if (XMPPRegistrationListenerWrapper.USER_PASSWD_CHANGE.equals(reqType)) {
                    regisListener.registrationUpdateFailed(pe.getDefinedCondition(), pe.getText(), serverStr);
                } else if (XMPPRegistrationListenerWrapper.GATEWAY_UNREGISTRATION.equals(reqType) || XMPPRegistrationListenerWrapper.USER_UNREGISTRATION.equals(reqType)) {
                    regisListener.unregistrationFailed(this.getRegistrationErrorCondition(pe.getDefinedCondition()), pe.getText(), serverStr);
                } else if (XMPPRegistrationListenerWrapper.GATEWAY_REGISTRATION.equals(reqType) || XMPPRegistrationListenerWrapper.USER_REGISTRATION.equals(reqType)) {
                    regisListener.registrationFailed(this.getRegistrationErrorCondition(pe.getDefinedCondition()), pe.getText(), serverStr);
                }
            } else {
                XMPPSessionProvider.debug("Packet error is null");
            }
            this._regisListeners.remove(iq.getID());
            if (XMPPRegistrationListenerWrapper.USER_REGISTRATION.equals(reqType)) {
                this.logout();
            }
            return;
        }
    }

    public int addWorkerRunnable(Runnable r) {
        return this._worker.addRunnable(r);
    }

    private void fireCollaborationSessionListener(CollaborationException e) {
        this.addWorkerRunnable(new CollaborationSessionNotifier(e));
    }

    public void addSessionListener(CollaborationSessionListener listener) {
        if (!this._sessionListeners.contains(listener)) {
            this._sessionListeners.add(listener);
        }
    }

    public void removeSessionListener(CollaborationSessionListener listener) {
        this._sessionListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JID getMUCService() {
        Object object = this._jabberServiceLock;
        synchronized (object) {
            return this._mucService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JID getPubSubService() {
        Object object = this._jabberServiceLock;
        synchronized (object) {
            return this._pubsubService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JID getJUDService() {
        Object object = this._jabberServiceLock;
        synchronized (object) {
            return this._judService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getGateways() {
        Object object = this._jabberServiceLock;
        synchronized (object) {
            return this._gateways;
        }
    }

    static {
        $assertionsDisabled = !XMPPSession.class.desiredAssertionStatus();
        xmpplogger = LogManager.getLogger((String)"com.sun.im.service.xmpp.traffic");
        REQUEST_TIMEOUT = 50000L;
        SHORT_REQUEST_TIMEOUT = 5000L;
        IBB_MESSAGE_SIZE = 4096;
        NUM_WORKER_THREAD = 2;
        _jso = JSOImplementation.getInstance();
        _sdf = _jso.getDataFactory();
        IQ_NAME = new NSI("iq", null);
        MESSAGE_NAME = new NSI("message", null);
        PRESENCE_NAME = new NSI("presence", null);
        STORAGE_NAME = new NSI("storage", null);
        STORAGE_BOOKMARK_NAME = new NSI("storage", "storage:bookmarks");
        IBB_OPEN = _sdf.createNSI("open", IBB_NAMESPACE);
        IBB_CLOSE = _sdf.createNSI("close", IBB_NAMESPACE);
        IBB_DATA = _sdf.createNSI("data", IBB_NAMESPACE);
        BASE64 = new ByteCodec.Base64Codec();
        SUN_PRIVATE_NAME = new NSI("x", SUN_PRIVATE_NAMESPACE);
        SUN_PRIVATE_SUNMSGR_NAME = new NSI("sunmsgr", SUN_PRIVATE_NAMESPACE);
        SUN_PRIVATE_POLICY_NAME = new NSI("sunmsgrpolicy", SUN_PRIVATE_NAMESPACE);
        SEARCH_QUERY_NAME = new NSI("query", "jabber:iq:search");
        SUN_ATTACH_NAME = new NSI("attach", "sun:xmpp:attach");
        SUN_PRIVATE_LDAPGROUP_NAME = new NSI("sunldapgrp", "sun:xmpp:ldapgroups");
        keepAliveBuffer = new byte[]{32, 32};
    }

    private class CollaborationSessionNotifier
    implements Runnable {
        CollaborationException ce;

        CollaborationSessionNotifier(CollaborationException ce) {
            this.ce = ce;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = XMPPSession.this._sessionListeners;
            synchronized (list) {
                Iterator itr = XMPPSession.this._sessionListeners.iterator();
                while (itr.hasNext()) {
                    try {
                        CollaborationSessionListener l = (CollaborationSessionListener)itr.next();
                        if (l == null) continue;
                        l.onError(this.ce);
                    }
                    catch (Exception e) {
                        XMPPSessionProvider.error(e.toString(), e);
                    }
                }
            }
        }
    }

    private class DiscoRunnable
    implements Runnable {
        JID _to;

        DiscoRunnable(JID to) {
            this._to = to;
        }

        public void run() {
            try {
                DiscoItemsQuery dq = XMPPSession.this.sendItemsQuery(this._to, null);
                Iterator itr = dq.listItems().iterator();
                XMPPSessionProvider.debug("Loading Jabber services for " + this._to);
                while (itr.hasNext()) {
                    DiscoItem item = (DiscoItem)itr.next();
                    DiscoInfoQuery diq = null;
                    try {
                        diq = XMPPSession.this.sendInfoQuery(item.getJID());
                    }
                    catch (CollaborationException ce) {
                        XMPPSessionProvider.debug(null, ce);
                        continue;
                    }
                    Iterator iter = diq.listIdentities().iterator();
                    while (iter.hasNext()) {
                        DiscoIdentity discoIdentity = (DiscoIdentity)iter.next();
                        String category = discoIdentity.getCategory();
                        if ("conference".equals(category)) {
                            XMPPSessionProvider.debug("adding remote conference service " + item.getJID());
                            XMPPSession.this._conferenceService.addRemoteService(item.getJID());
                            continue;
                        }
                        if ("pubsub".equals(category)) {
                            XMPPSession.this._newsService.addRemoteService(item.getJID());
                            continue;
                        }
                        if (!"directory".equals(category)) continue;
                        XMPPSession.this._personalStoreService.addRemoteService(item.getJID());
                    }
                }
                XMPPSession.this._remoteServices.add(this._to);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class ServiceDiscovery
    implements MonitorListener {
        DiscoItem item;
        XMPPSession session;

        public ServiceDiscovery(XMPPSession s, DiscoItem di) {
            this.item = di;
            this.session = s;
        }

        public void monitorFailed(MonitorEvent evt) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void monitorFound(MonitorEvent evt) {
            try {
                Packet packet = evt.getActualPacket();
                if (packet.getType() == Packet.ERROR) {
                    return;
                }
                DiscoInfoQuery diq = (DiscoInfoQuery)packet.listExtensions("http://jabber.org/protocol/disco#info").get(0);
                Iterator iter = diq.listIdentities().iterator();
                while (iter.hasNext()) {
                    block41: {
                        Object object;
                        DiscoIdentity discoIdentity = (DiscoIdentity)iter.next();
                        String category = discoIdentity.getCategory();
                        if ("gateway".equals(category)) {
                            XMPPPersonalGateway pse = new XMPPPersonalGateway(this.session, discoIdentity.getName(), this.item.getJID().toString(), discoIdentity.getType());
                            try {
                                Object i = diq.getFeatures().iterator();
                                while (i.hasNext()) {
                                    pse.addSupportedFeature((String)i.next());
                                }
                                i = XMPPSession.this._jabberServiceLock;
                                synchronized (i) {
                                    XMPPSession.this._gateways.put(this.item.getJID().toString(), pse);
                                    break block41;
                                }
                            }
                            catch (CollaborationException e) {
                                XMPPSessionProvider.error(e.toString(), e);
                                continue;
                            }
                        }
                        if ("conference".equals(category)) {
                            object = XMPPSession.this._jabberServiceLock;
                            synchronized (object) {
                                XMPPSession.this._mucService = this.item.getJID();
                            }
                            if (XMPPSession.this._conferenceService != null) {
                                object = XMPPSession.this._conferenceService;
                                synchronized (object) {
                                    XMPPSession.this._conferenceService.notifyAll();
                                }
                            }
                        } else if ("pubsub".equals(category)) {
                            object = XMPPSession.this._jabberServiceLock;
                            synchronized (object) {
                                XMPPSession.this._pubsubService = this.item.getJID();
                            }
                            if (XMPPSession.this._newsService != null) {
                                object = XMPPSession.this._newsService;
                                synchronized (object) {
                                    XMPPSession.this._newsService.notifyAll();
                                }
                            }
                        } else if ("directory".equals(category)) {
                            object = XMPPSession.this._jabberServiceLock;
                            synchronized (object) {
                                XMPPSession.this._judService = this.item.getJID();
                            }
                            if (XMPPSession.this._personalStoreService != null) {
                                object = XMPPSession.this._personalStoreService;
                                synchronized (object) {
                                    XMPPSession.this._personalStoreService.notifyAll();
                                }
                            }
                        } else if ("service".equals(category)) {
                            if (!XMPPSession.this._remoteServices.contains(this.item.getJID())) {
                                new Thread(new DiscoRunnable(this.item.getJID())).start();
                            }
                        } else {
                            XMPPSessionProvider.debug("Category " + category + " is not known");
                        }
                    }
                    XMPPSession.this._discoveredServices.add(this.item.getJID());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void monitorTimeout(MonitorEvent evt) {
        }
    }

    class RegisterNotifier
    implements Runnable {
        private InfoQuery _iqPacket;

        public RegisterNotifier(InfoQuery iq) {
            this._iqPacket = iq;
        }

        public void run() {
            try {
                XMPPSession.this.processRegisterQuery(this._iqPacket);
            }
            catch (CollaborationException ce) {
                ce.printStackTrace();
            }
        }
    }

    class StatusListenerClass
    implements StreamStatusListener {
        StatusListenerClass() {
        }

        public void statusChanged(StreamStatusEvent evt) {
            if (evt.getNextStatus() == Stream.DISCONNECTED) {
                xmpplogger.info((Object)"disconnected");
                if (!XMPPSession.this._logout && !evt.isExceptional()) {
                    XMPPSession.this.notifyStreamError(null);
                }
            }
            if (evt.getNextStatus() == Stream.CLOSED) {
                xmpplogger.info((Object)"closed");
            }
            if (evt.getNextStatus() == Stream.CONNECTED) {
                xmpplogger.info((Object)"connected");
            }
            if (evt.getNextStatus() == Stream.OPENED) {
                xmpplogger.info((Object)"opened");
            }
        }
    }

    class PacketListenerClass
    implements PacketListener {
        PacketListenerClass() {
        }

        public void packetTransferred(PacketEvent evt) {
            Packet packet = evt.getData();
            if (XMPPSession.this.removeSendAndWatchID(packet.getID())) {
                return;
            }
            if (packet instanceof Message) {
                XMPPSession.this.processMessage(packet);
            } else if (!(packet instanceof PrivacyQuery)) {
                if (packet instanceof InfoQuery) {
                    XMPPSession.this.processInfoQuery(packet);
                } else if (packet instanceof org.jabberstudio.jso.Presence) {
                    try {
                        XMPPSession.this.processPresence((org.jabberstudio.jso.Presence)packet);
                    }
                    catch (CollaborationException e) {
                        XMPPSessionProvider.error(e.toString(), e);
                    }
                    catch (Exception e) {
                        XMPPSessionProvider.error(e.toString(), e);
                    }
                } else if (packet instanceof StreamError && !XMPPSession.this._logout) {
                    XMPPSession.this.notifyStreamError((StreamError)packet);
                } else {
                    XMPPSessionProvider.debug("UnSupported XMPP XML Stanza");
                }
            }
        }
    }

    class DebugPacketListenerClass
    implements PacketListener {
        DebugPacketListenerClass() {
        }

        public void packetTransferred(PacketEvent evt) {
            try {
                Packet packet = evt.getData();
                if (evt.getType() == PacketEvent.RECEIVED) {
                    xmpplogger.debug((Object)("[" + XMPPSession.this.getCurrentUserJID() + "]" + " Received a packet: " + packet.toString()));
                } else {
                    if (evt.getType() == PacketEvent.SENT) {
                        if (!(packet instanceof InfoQuery) || !packet.getType().equals((Object)InfoQuery.SET) || packet.getExtension("jabber:iq:auth") == null && packet.getExtension("jabber:iq:register") == null) {
                            xmpplogger.debug((Object)("[" + XMPPSession.this.getCurrentUserJID() + "]" + " Sent a packet: " + packet.toString()));
                        }
                        return;
                    }
                    xmpplogger.debug((Object)("packet: " + packet.toString()));
                }
            }
            catch (Exception e) {
                XMPPSessionProvider.error(e.toString(), e);
            }
        }
    }
}

