/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreFolder;
import com.sun.im.service.xmpp.JIDUtil;
import com.sun.im.service.xmpp.XMPPPersonalContact;
import com.sun.im.service.xmpp.XMPPPersonalGateway;
import com.sun.im.service.xmpp.XMPPPersonalGroup;
import com.sun.im.service.xmpp.XMPPPersonalStoreEntry;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPWatcher;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class XMPPPersonalFolder
extends XMPPPersonalStoreEntry
implements PersonalStoreFolder {
    Vector _contactEntries = new Vector();
    Vector _groupEntries = new Vector();
    Vector _gatewayEntries = new Vector();
    Vector _watcherEntries = new Vector();

    public XMPPPersonalFolder(XMPPSession s, String name) {
        super(s, name, "abook", null);
    }

    public Collection getEntries() throws CollaborationException {
        Vector _entries = new Vector();
        _entries.addAll(this._contactEntries);
        _entries.addAll(this._groupEntries);
        _entries.addAll(this._gatewayEntries);
        _entries.addAll(this._watcherEntries);
        return _entries;
    }

    public Collection getEntries(String type) throws CollaborationException {
        if (type.equals("contact")) {
            return this._contactEntries;
        }
        if (type.equals("group")) {
            return this._groupEntries;
        }
        if (type.equals("gateway")) {
            return this._gatewayEntries;
        }
        if (type.equals("watcher")) {
            return this._watcherEntries;
        }
        return null;
    }

    public PersonalStoreEntry getEntry(String jid) throws CollaborationException {
        PersonalStoreEntry pse;
        Vector _entries = this._contactEntries;
        Enumeration e = _entries.elements();
        while (e.hasMoreElements()) {
            pse = (PersonalStoreEntry)e.nextElement();
            if (!pse.getEntryId().equals(jid)) continue;
            return pse;
        }
        _entries = this._gatewayEntries;
        e = _entries.elements();
        while (e.hasMoreElements()) {
            pse = (PersonalStoreEntry)e.nextElement();
            if (!pse.getEntryId().equals(jid)) continue;
            return pse;
        }
        _entries = this._groupEntries;
        jid = JIDUtil.encodedJID(jid).toString();
        e = _entries.elements();
        while (e.hasMoreElements()) {
            pse = (PersonalStoreEntry)e.nextElement();
            if (!pse.getEntryId().equals(jid)) continue;
            return pse;
        }
        return null;
    }

    public boolean hasEntry(String jid) {
        PersonalStoreEntry entry = null;
        try {
            entry = this.getEntry(jid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry != null;
    }

    protected void addEntry(XMPPPersonalContact entry) {
        if (!this._contactEntries.contains(entry)) {
            this._contactEntries.addElement(entry);
        }
    }

    protected void addEntry(XMPPPersonalGroup entry) {
        if (!this._groupEntries.contains(entry)) {
            this._groupEntries.addElement(entry);
        }
    }

    protected void addEntry(XMPPPersonalGateway entry) {
        if (!this._gatewayEntries.contains(entry)) {
            this._gatewayEntries.addElement(entry);
        }
    }

    protected void addEntry(XMPPWatcher entry) {
        if (!this._watcherEntries.contains(entry)) {
            this._watcherEntries.addElement(entry);
        }
    }

    protected void removeEntry(XMPPPersonalContact entry) {
        this._contactEntries.remove(entry);
    }

    protected void removeEntry(XMPPPersonalGroup entry) {
        this._groupEntries.remove(entry);
    }

    protected void removeEntry(XMPPPersonalGateway entry) {
        this._gatewayEntries.remove(entry);
    }

    protected void removeEntry(XMPPWatcher entry) {
        this._watcherEntries.remove(entry);
    }

    public void rename(String name) {
        this._personalStoreService.renameFolder(this, name);
    }

    public int size() {
        return this._contactEntries.size() + this._groupEntries.size() + this._gatewayEntries.size();
    }
}

