/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.util.HostPort;
import com.sun.im.service.util.Http;
import com.sun.im.service.xmpp.StreamingMethod;
import com.sun.im.service.xmpp.XMPPContentStream;
import com.sun.im.service.xmpp.XMPPSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.info.OutOfBandExtension;

public class XMPPOOBStream
implements StreamingMethod {
    private XMPPSession _session;
    private XMPPContentStream _cs;
    private boolean abort = false;
    private HostPort hp;

    public XMPPOOBStream(XMPPSession session, XMPPContentStream cs) {
        this._session = session;
        this._cs = cs;
    }

    public void abort() {
        this.abort = true;
    }

    public void process(Packet packet) {
        try {
            if (packet instanceof InfoQuery) {
                List list;
                if (packet.getType() == InfoQuery.RESULT) {
                    this._cs.notifyClosed(0, "");
                    if (this.hp != null) {
                        Http.stopServ(this.hp);
                    }
                } else if (packet.getType() == Packet.ERROR) {
                    this._cs.notifyClosed(2, "error");
                    if (this.hp != null) {
                        Http.stopServ(this.hp);
                    }
                } else if (packet.getType() == InfoQuery.SET && (list = packet.listExtensions("jabber:iq:oob")).size() != 0) {
                    OutOfBandExtension oob = (OutOfBandExtension)list.get(0);
                    URL url = oob.getURL();
                    InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
                    iq.setFrom(this._session.getCurrentUserJID());
                    iq.setTo(packet.getFrom());
                    iq.setID(packet.getID());
                    try {
                        if (this.abort) {
                            return;
                        }
                        InputStream is = url.openStream();
                        this._cs.notifyStarted();
                        byte[] b = new byte[1024];
                        int len = 0;
                        while ((len = is.read(b)) != -1) {
                            if (this.abort) {
                                return;
                            }
                            this._cs.write(b, len);
                        }
                        iq.setType((Packet.Type)InfoQuery.RESULT);
                        if (this.abort) {
                            return;
                        }
                        this._session.getConnection().send((Packet)iq);
                        this._cs.notifyClosed(0, "");
                    }
                    catch (IOException io) {
                        io.printStackTrace();
                        iq.setType(InfoQuery.ERROR);
                        this._session.getConnection().send((Packet)iq);
                        this._cs.notifyClosed(2, io.toString());
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void start(JID to, String sid, InputStream is) {
        try {
            StreamDataFactory sdf = this._session.getDataFactory();
            InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
            OutOfBandExtension oob = (OutOfBandExtension)sdf.createExtensionNode(OutOfBandExtension.IQ_NAME);
            File f = this._cs.getFile();
            this.hp = new HostPort(InetAddress.getLocalHost().getHostAddress(), 0);
            Http.startServ(f.getAbsolutePath(), this.hp);
            URL url = new URL("http", this.hp.getHostName(), this.hp.getPort(), "/" + f.getName());
            oob.setURL(url);
            iq.add((StreamNode)oob);
            iq.setType((Packet.Type)InfoQuery.SET);
            iq.setFrom(this._session.getCurrentUserJID());
            iq.setTo(to);
            iq.setID(sid);
            if (this.abort) {
                return;
            }
            this._session.getConnection().send((Packet)iq);
            this._cs.notifyStarted();
        }
        catch (Exception e) {
            e.printStackTrace();
            this._cs.notifyClosed(3, e.toString());
        }
    }
}

