/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.Message;
import com.sun.im.service.MessageStatusListener;
import com.sun.im.service.NotificationService;
import com.sun.im.service.NotificationServiceListener;
import com.sun.im.service.Poll;
import com.sun.im.service.xmpp.XMPPMessage;
import com.sun.im.service.xmpp.XMPPPrincipal;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.message_event.MessageEventExtension;

public class XMPPNotificationService
implements NotificationService {
    private List _notificationServiceListeners = Collections.synchronizedList(new ArrayList());
    XMPPSession __session;
    private HashMap _messageStatusListeners = new HashMap();
    private HashMap _messageReplyListeners = new HashMap();

    public XMPPNotificationService(XMPPSession session) {
        this.__session = session;
    }

    public static int getApiStatus(MessageEventExtension evtNode) {
        NSI n = evtNode.getNSI();
        if (evtNode.hasMessageEvent(MessageEventExtension.OFFLINE)) {
            return 2;
        }
        if (evtNode.hasMessageEvent(MessageEventExtension.DELIVERED)) {
            return 1;
        }
        if (evtNode.hasMessageEvent(MessageEventExtension.DISPLAYED)) {
            return 7;
        }
        if (evtNode.hasMessageEvent(MessageEventExtension.COMPOSING)) {
            return 8;
        }
        return 9;
    }

    protected void processNormalMessage(org.jabberstudio.jso.Message in) {
        try {
            String threadId;
            MessageStatusListener msl;
            XMPPSessionProvider.debug("regular message or response ");
            MessageEventExtension xNode = (MessageEventExtension)in.getExtension("jabber:x:event");
            if (xNode != null && xNode.hasMessageID()) {
                MessageStatusListener msl2 = (MessageStatusListener)this._messageStatusListeners.get(xNode.getMessageID());
                if (msl2 != null) {
                    msl2.onReceipt(in.getFrom().toString(), XMPPNotificationService.getApiStatus(xNode));
                }
                if (!in.hasBody()) {
                    return;
                }
            }
            if ((msl = (MessageStatusListener)this._messageReplyListeners.get(threadId = in.getThread())) != null) {
                msl.onReply(this.__session.assembleMessages(new XMPPMessage(this.__session, (Packet)in)));
            } else {
                XMPPSessionProvider.debug("msl is null thread " + threadId);
                this._fireNotificationServiceListener(this.__session.assembleMessages(new XMPPMessage(this.__session, (Packet)in)));
            }
        }
        catch (CollaborationException ce) {
            XMPPSessionProvider.error(ce.toString(), ce);
        }
        catch (Exception e) {
            XMPPSessionProvider.error(e.toString(), e);
        }
    }

    public void initialize(NotificationServiceListener listener) throws CollaborationException {
        this.addNotificationServiceListener(listener);
    }

    public void sendMessage(Message message, MessageStatusListener listener) throws CollaborationException {
        org.jabberstudio.jso.Message m = (org.jabberstudio.jso.Message)((XMPPMessage)message).getXMPPMessage();
        String[] recipients = message.getRecipients();
        String messageId = message.getMessageId();
        if (listener != null) {
            if (message.getContentType() != null && message.getContentType().equalsIgnoreCase("application/x-iim-poll")) {
                String content = message.getContent();
                m.setBody(null);
                Poll p = null;
                try {
                    p = new Poll(content);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new CollaborationException(e.toString());
                }
                m.add((StreamNode)p.getXDataForm());
            }
            MessageEventExtension msgEvtExt = (MessageEventExtension)this.__session.getDataFactory().createExtensionNode(MessageEventExtension.NAME);
            msgEvtExt.addEvent(MessageEventExtension.OFFLINE);
            msgEvtExt.addEvent(MessageEventExtension.DELIVERED);
            msgEvtExt.addEvent(MessageEventExtension.DISPLAYED);
            m.add((StreamNode)msgEvtExt);
        }
        for (int i = 0; i < recipients.length; ++i) {
            m.setTo(new JID(recipients[i]));
            String threadId = this.__session.nextID("thread");
            threadId = m.getFrom() + threadId;
            String mid = this.__session.nextID("message");
            m.setThread(threadId);
            m.setID(mid);
            if (listener != null) {
                this._messageStatusListeners.put(mid, listener);
                this._messageReplyListeners.put(threadId, listener);
            }
            this.__session.sendAllMessageParts((XMPPMessage)message);
        }
    }

    public Message createMessage(String destination) throws CollaborationException {
        JID recipient = this.__session.getDataFactory().createJID((Object)destination);
        return new XMPPMessage(this.__session, recipient, ((XMPPPrincipal)this.__session.getPrincipal()).getJID());
    }

    public Message createMessage() throws CollaborationException {
        return new XMPPMessage(this.__session, ((XMPPPrincipal)this.__session.getPrincipal()).getJID());
    }

    private String getMessageListenerKey(String key, String rcpt) {
        return key + ";" + rcpt;
    }

    private void _fireNotificationServiceListener(Message m) {
        this.__session.addWorkerRunnable(new NotificationServiceNotifier(m));
    }

    public void addNotificationServiceListener(NotificationServiceListener listener) {
        if (!this._notificationServiceListeners.contains(listener)) {
            this._notificationServiceListeners.add(listener);
        }
    }

    public void removeNotificationServiceListener(NotificationServiceListener listener) {
        this._notificationServiceListeners.remove(listener);
    }

    private class NotificationServiceNotifier
    implements Runnable {
        Message message;

        NotificationServiceNotifier(Message m) {
            this.message = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = XMPPNotificationService.this._notificationServiceListeners;
            synchronized (list) {
                Iterator itr = XMPPNotificationService.this._notificationServiceListeners.iterator();
                while (itr.hasNext()) {
                    try {
                        NotificationServiceListener l = (NotificationServiceListener)itr.next();
                        if (l == null) continue;
                        l.onMessage(this.message);
                    }
                    catch (Exception e) {
                        XMPPSessionProvider.error(e.toString(), e);
                    }
                }
            }
        }
    }
}

