/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.MessagePart;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import org.jabberstudio.jso.util.ByteCodec;

public class XMPPMessagePart
implements MessagePart {
    Hashtable _contents = new Hashtable();
    Hashtable _headers = new Hashtable();
    String _body = null;
    ByteCodec.Base64Codec base64 = new ByteCodec.Base64Codec();

    public void clearContent() throws CollaborationException {
        this._body = null;
        this._contents = new Hashtable();
    }

    public String getContent() throws CollaborationException {
        return this._body;
    }

    public String getContent(String contentType) throws CollaborationException {
        return (String)this._contents.get(contentType);
    }

    public String getContentEncoding() {
        return (String)this._headers.get("content-encoding");
    }

    public String getContentID() {
        return null;
    }

    public String getContentName() {
        return (String)this._headers.get("content-name");
    }

    public String getContentType() {
        return (String)this._headers.get("content-type");
    }

    public InputStream getInputStream() throws CollaborationException {
        if (this._body != null) {
            return new ByteArrayInputStream(this._body.getBytes());
        }
        return null;
    }

    public byte[] getBytes(String encoding) throws CollaborationException {
        if (this._body != null) {
            return this.base64.decode(this._body);
        }
        return null;
    }

    public int getSize() throws CollaborationException {
        return this._body.length();
    }

    public void setContent(String str) throws CollaborationException {
        this._body = str;
    }

    public void setContent(InputStream is, String enc) throws CollaborationException {
        try {
            if (enc != null) {
                this._headers.put("content-encoding", enc);
            }
            StringBuffer buf = new StringBuffer();
            byte[] b = new byte[1023];
            while (is.available() > 0) {
                int len = is.read(b, 0, b.length);
                buf.append(this.base64.encode(b, 0, len));
            }
            this.setContent(buf.toString());
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    public void setContent(byte[] b, String enc) throws CollaborationException {
        this.setContent(this.base64.encode(b));
        if (enc != null) {
            this._headers.put("content-encoding", enc);
        }
    }

    public void setContentName(String str) throws CollaborationException {
        this._headers.put("content-name", str);
    }

    public void setContent(String content, String contentType) throws CollaborationException {
        this._contents.put(contentType, content);
        this.setContentType(contentType);
    }

    public void setContentType(String str) throws CollaborationException {
        this._headers.put("content-type", str);
    }

    protected Hashtable getContents() {
        return this._contents;
    }

    protected void setHeaders(Hashtable ht) {
        this._headers = ht;
    }

    protected Hashtable getHeaders() {
        return this._headers;
    }
}

