/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.ContentStream;
import com.sun.im.service.ContentStreamListener;
import com.sun.im.service.ReceiverStreamingProfile;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.StreamingMethod;
import com.sun.im.service.xmpp.XMPPIBBStream;
import com.sun.im.service.xmpp.XMPPOOBStream;
import com.sun.im.service.xmpp.XMPPReceiverFileStreamingProfile;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import com.sun.im.service.xmpp.XMPPStreamingService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.PacketError;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.x.info.OutOfBandExtension;
import org.jabberstudio.jso.x.si.SIProfile;
import org.jabberstudio.jso.x.si.SIQuery;
import org.jabberstudio.jso.x.sift.FileTransferProfile;

public class XMPPContentStream
implements ContentStream {
    private String[] _methods = new String[0];
    private File _file;
    private ContentStreamListener _listener;
    private XMPPSession _session;
    private XMPPReceiverFileStreamingProfile _profile;
    private long _transferredBytes = 0L;
    private InfoQuery _iq;
    private String _sid;
    private JID _to;
    private StreamingMethod _stream;
    private boolean _closed = false;
    private long _lastUpdateTime = -1L;
    private boolean _isOOBOnlyStream = false;
    public static final NSI INVALID_STREAM = new NSI("no-valid-streams", "http://jabber.org/protocol/si");
    public static final NSI BAD_PROFILE = new NSI("bad-profile", "http://jabber.org/protocol/si");
    public static long TIMEOUT = 120000L;

    public XMPPContentStream(XMPPSession session, ContentStreamListener listener) {
        this._session = session;
        this._listener = listener;
    }

    public XMPPContentStream(XMPPSession session, InfoQuery iq) throws CollaborationException {
        this._session = session;
        this._iq = iq;
        List elements = iq.listElements(SIQuery.NAME);
        if (elements.size() > 0) {
            SIQuery si = (SIQuery)elements.get(0);
            SIProfile profile = si.getProfile();
            if (!(profile instanceof FileTransferProfile)) {
                XMPPSessionProvider.error("Unknown profile for stream initiation");
                this.reject("no-valid-streams");
                throw new CollaborationException("Unknown profile for stream initiation");
            }
            this._sid = si.getID();
            List list = si.listSupportedStreamMethods();
            this._methods = new String[list.size()];
            int i = 0;
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                this._methods[i++] = (String)itr.next();
            }
        } else if (iq.listElements(OutOfBandExtension.IQ_NAME).size() > 0) {
            this._sid = iq.getID();
            this._methods = new String[]{"jabber:iq:oob"};
            this._isOOBOnlyStream = true;
        }
    }

    public void reject(String reason) throws CollaborationException {
        if (this._iq == null) {
            throw new IllegalStateException("Cannot reject streams opened by you");
        }
        InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME);
        if (!this._isOOBOnlyStream) {
            PacketError error;
            if ("no-valid-streams".equals(reason)) {
                error = this._session.getDataFactory().createPacketError(PacketError.CANCEL, "bad-request");
                StreamElement element = this._session.getDataFactory().createElementNode(INVALID_STREAM);
                error.add((StreamNode)element);
            } else if ("bad-profile".equals(reason)) {
                error = this._session.getDataFactory().createPacketError(PacketError.CANCEL, "bad-request");
                StreamElement element = this._session.getDataFactory().createElementNode(BAD_PROFILE);
                error.add((StreamNode)element);
            } else {
                error = this._session.getDataFactory().createPacketError(PacketError.CANCEL, "forbidden");
                error.setText(reason);
            }
            iq.add((StreamNode)error);
        }
        iq.setID(this._iq.getID());
        iq.setFrom(this._session.getCurrentUserJID());
        iq.setTo(this._iq.getFrom());
        iq.setType(InfoQuery.ERROR);
        try {
            this._session.getConnection().send((Packet)iq);
        }
        catch (StreamException se) {
            this.notifyClosed(2, se.toString());
        }
        ((XMPPStreamingService)this._session.getStreamingService()).removeContentStream(this._sid);
    }

    public void accept(String preferredMethod, ReceiverStreamingProfile profile, ContentStreamListener listener) throws CollaborationException {
        if (!(profile instanceof XMPPReceiverFileStreamingProfile)) {
            this.reject("bad-profile");
            throw new CollaborationException("Profile Not Implemented");
        }
        this._profile = (XMPPReceiverFileStreamingProfile)profile;
        this._listener = listener;
        if (this._iq == null) {
            throw new IllegalStateException("Cannot accept streams opened by you");
        }
        if (!StringUtility.contains(this._methods, preferredMethod)) {
            throw new IllegalArgumentException("preferredMethod should be one of the supported methods");
        }
        if (this._isOOBOnlyStream) {
            this._stream = new XMPPOOBStream(this._session, this);
            this._stream.process((Packet)this._iq);
        } else {
            InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME);
            SIQuery si = (SIQuery)this._session.getDataFactory().createElementNode(SIQuery.NAME);
            si.setPreferredStreamMethod(preferredMethod);
            iq.add((StreamNode)si);
            iq.setID(this._iq.getID());
            iq.setTo(this._iq.getFrom());
            iq.setType((Packet.Type)InfoQuery.RESULT);
            try {
                this._session.getConnection().send((Packet)iq);
            }
            catch (StreamException se) {
                this.notifyClosed(2, se.toString());
            }
            if ("http://jabber.org/protocol/ibb".equals(preferredMethod)) {
                this._stream = new XMPPIBBStream(this._session, this);
            } else if ("jabber:iq:oob".equals(preferredMethod)) {
                this._stream = new XMPPOOBStream(this._session, this);
            }
        }
        this._lastUpdateTime = System.currentTimeMillis();
    }

    public void abort() throws CollaborationException {
        if (this._closed) {
            throw new IllegalStateException("Cannot abort already closed streams");
        }
        if (this._stream != null) {
            this._stream.abort();
        }
        this.notifyClosed(3, "Stream aborted");
    }

    public void timeout() {
        if (this._stream != null) {
            this._stream.abort();
        }
        this.notifyClosed(3, "Stream Timeout");
    }

    public String[] getSupportedMethods() {
        return this._methods;
    }

    public long getTransferredBytes() {
        return this._transferredBytes;
    }

    public void notifyStarted() {
        if (this._listener != null) {
            this._listener.started();
        }
    }

    public void notifyClosed(int status, String reason) {
        if (this._profile != null) {
            this._profile.close();
        }
        if (this._listener != null) {
            this._listener.closed(status, reason);
        }
        try {
            ((XMPPStreamingService)this._session.getStreamingService()).removeContentStream(this._sid);
        }
        catch (CollaborationException e) {
            XMPPSessionProvider.error(e.toString(), e);
        }
        this._closed = true;
    }

    public void setSessionID(String id) {
        this._sid = id;
    }

    public void setTo(JID to) {
        this._to = to;
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    public void start(String method) {
        if ("http://jabber.org/protocol/ibb".equals(method)) {
            this._stream = new XMPPIBBStream(this._session, this);
            try {
                this._stream.start(this._to, this._sid, new FileInputStream(this._file));
            }
            catch (FileNotFoundException fnfe) {
                fnfe.printStackTrace();
            }
        } else if ("jabber:iq:oob".equals(method)) {
            this._stream = new XMPPOOBStream(this._session, this);
            this._stream.start(this._to, this._sid, null);
        }
    }

    public void process(Packet packet) {
        if (this._stream != null) {
            this._stream.process(packet);
        }
    }

    public void write(byte[] b, int len) {
        this._lastUpdateTime = System.currentTimeMillis();
        this._profile.write(b, len);
        this.incrementTransferredBytes(len);
    }

    public void incrementTransferredBytes(int i) {
        this._transferredBytes += (long)i;
    }

    public boolean isTimedOut() {
        if (this._lastUpdateTime == -1L) {
            return false;
        }
        return System.currentTimeMillis() - this._lastUpdateTime > TIMEOUT;
    }
}

