/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.ConferenceService;
import com.sun.im.service.ConferenceServiceListener;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.JIDUtil;
import com.sun.im.service.xmpp.XMPPConference;
import com.sun.im.service.xmpp.XMPPMessage;
import com.sun.im.service.xmpp.XMPPNotificationSession;
import com.sun.im.service.xmpp.XMPPPersonalStoreService;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.x.message_event.MessageEventExtension;
import org.jabberstudio.jso.x.muc.Decline;
import org.jabberstudio.jso.x.muc.Invite;
import org.jabberstudio.jso.x.muc.MUCUserQuery;

public class XMPPConferenceService
implements ConferenceService {
    private List _conferenceServiceListeners = Collections.synchronizedList(new ArrayList());
    XMPPSession __session;
    private HashSet _remoteServices = new HashSet();
    private Hashtable _conferences = new Hashtable();

    public XMPPConferenceService(XMPPSession session) {
        this.__session = session;
    }

    protected void processInvite(Message in) throws CollaborationException {
        MUCUserQuery user = (MUCUserQuery)in.getExtension("http://jabber.org/protocol/muc#user");
        XMPPSessionProvider.debug("[" + this.__session.getCurrentUserJID() + "] processInvite: " + user);
        if (user != null) {
            Iterator itr = user.listElements().iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                XMPPConference c = (XMPPConference)this._conferences.get(in.getFrom().toString());
                if (c == null) {
                    c = (XMPPConference)this._conferences.remove(in.getFrom().getNode());
                    if (c == null) {
                        c = new XMPPConference(this.__session, in.getFrom().getNode(), in.getFrom());
                    } else {
                        c.setNode(in.getFrom());
                    }
                    this._conferences.put(in.getFrom().toString(), c);
                }
                if (c.isPresentInRoom() && (o instanceof Invite || o instanceof Decline)) {
                    XMPPSessionProvider.debug("[" + this.__session.getCurrentUserJID() + "] Received a invite reply");
                    c.handleInviteReply(in);
                    continue;
                }
                if (!(o instanceof Invite)) continue;
                Invite invite = (Invite)o;
                XMPPMessage m = this.__session.assembleMessages(new XMPPMessage(this.__session, (Packet)in));
                m.setAssociatedConferenceJID(in.getFrom().toBareJID());
                try {
                    m.setOriginator(invite.getFrom().toString());
                    m.setContent(invite.getReason());
                }
                catch (CollaborationException e) {
                    e.printStackTrace();
                }
                c.setGroupChat(true);
                this._fireConferenceServiceListener(c, m);
                return;
            }
        }
    }

    protected void processGroupChat(Message in) throws CollaborationException {
        MessageEventExtension xNode;
        if (in.getExtension("http://jabber.org/protocol/muc#user") != null && in.getType() == null) {
            this.processInvite(in);
            return;
        }
        String id = in.getFrom().toBareJID().toString();
        XMPPConference c = (XMPPConference)this._conferences.get(id);
        if (in.hasBody()) {
            c.messageAdded(this.__session.assembleMessages(new XMPPMessage(this.__session, (Packet)in)));
        }
        if ((xNode = (MessageEventExtension)in.getExtension("jabber:x:event")) != null && xNode.hasMessageID()) {
            c.userStatusChange(c.getParticipant(in.getFrom().getResource()).toString(), XMPPNotificationSession.getApiStatus(xNode));
        }
        c.processChatStates(in);
    }

    protected void processChat(Message in) throws CollaborationException {
        String thread = this.getConversationThread(in);
        XMPPConference c = (XMPPConference)this._conferences.get(thread);
        XMPPMessage message = this.__session.assembleMessages(new XMPPMessage(this.__session, (Packet)in));
        StreamElement element = in.getFirstElement(XMPPConference.NSI_GONE);
        if (element != null) {
            if (c == null) {
                return;
            }
            c.userStatusChange(message.getOriginator(), 11);
            return;
        }
        if (c == null && !in.hasBody()) {
            return;
        }
        if (c == null) {
            c = new XMPPConference(this.__session, thread, null);
            this._conferences.put(thread, c);
            XMPPMessage m = this.__session.assembleMessages(new XMPPMessage(this.__session, (Packet)in));
            c.addParticipant(in.getFrom());
            c.addParticipant(in.getTo());
            m.setOriginator(StringUtility.removeResource(m.getOriginator()));
            this._fireConferenceServiceListener(c, m);
        } else if (in.hasBody()) {
            c.messageAdded(message);
        }
        MessageEventExtension xNode = (MessageEventExtension)in.getExtension("jabber:x:event");
        if (xNode != null && xNode.hasMessageID()) {
            c.userStatusChange(in.getFrom().toString(), XMPPNotificationSession.getApiStatus(xNode));
        }
        c.processChatStates(in);
    }

    protected JID getService() throws CollaborationException {
        JID _confService = this.__session.getMUCService();
        if (_confService == null) {
            this.__session.waitForServiceInitialization(this);
            _confService = this.__session.getMUCService();
        }
        if (_confService == null) {
            throw new ServiceUnavailableException("[" + this.__session.getCurrentUserJID() + "] Conference service is not initialized");
        }
        return _confService;
    }

    void addRemoteService(JID jid) {
        this._remoteServices.add(jid);
    }

    Set getRemoteServices() {
        return this._remoteServices;
    }

    public void addConference(XMPPConference c) {
        this._conferences.put(JIDUtil.encodedJID(c.getDestination()).toString(), c);
    }

    public void removeConference(String str) {
        if (str == null) {
            return;
        }
        this._conferences.remove(str);
    }

    public XMPPConference getConference(String str) {
        return (XMPPConference)this._conferences.get(str);
    }

    private void _fireConferenceServiceListener(Conference c, InviteMessage m) {
        this.__session.addWorkerRunnable(new InviteNotifier(c, m));
    }

    public void addConferenceServiceListener(ConferenceServiceListener listener) {
        if (!this._conferenceServiceListeners.contains(listener)) {
            this._conferenceServiceListeners.add(listener);
        }
    }

    public void removeConferenceServiceListener(ConferenceServiceListener listener) {
        this._conferenceServiceListeners.remove(listener);
    }

    public Conference getPublicConference(String str) throws CollaborationException {
        String id = StringUtility.appendDomainToAddress(str, this.getService().toString());
        Conference c = (Conference)this._conferences.get(id);
        XMPPPersonalStoreService pss = (XMPPPersonalStoreService)this.__session.getPersonalStoreService();
        Conference[] a = pss.searchConference(0, id);
        if (a != null && a.length == 1) {
            if (c != null) {
                return c;
            }
            return a[0];
        }
        if (c != null) {
            this._conferences.remove(id);
        }
        return null;
    }

    public Conference joinPublicConference(String conf, ConferenceListener listener) throws CollaborationException {
        String id = StringUtility.appendDomainToAddress(conf, this.getService().toString());
        Conference c = this.getPublicConference(id);
        if (c == null) {
            throw new CollaborationException("[" + this.__session.getCurrentUserJID() + "] Conference room not found");
        }
        c.join(listener);
        return c;
    }

    public Conference setupConference(ConferenceListener conferenceListener, int access) throws CollaborationException {
        XMPPConference c = new XMPPConference(this.__session, conferenceListener, access);
        this._conferences.put(c.getName(), c);
        return c;
    }

    public Conference setupPublicConference(String str, ConferenceListener conferenceListener, int param) throws CollaborationException {
        XMPPConference c = new XMPPConference(this.__session, str, conferenceListener, param);
        this._conferences.put(c.getNode().toString(), c);
        return c;
    }

    public void initialize(ConferenceServiceListener listener) throws CollaborationException {
        this.addConferenceServiceListener(listener);
    }

    public String getConversationThread(Message in) throws CollaborationException {
        String thread = in.getThread();
        if (thread == null || thread.equals("")) {
            thread = in.getFrom().getNode();
            String confName = null;
            XMPPConference conf = null;
            String sender = StringUtility.removeResource(in.getFrom().toString());
            Enumeration enumeration = this._conferences.keys();
            while (enumeration.hasMoreElements()) {
                confName = (String)enumeration.nextElement();
                conf = (XMPPConference)this._conferences.get(confName);
                if (!conf.isOne2OnePrivateChat() || !conf.isParticipant(sender)) continue;
                return conf.getName();
            }
        }
        return thread;
    }

    class InviteNotifier
    implements Runnable {
        Conference c;
        InviteMessage m;

        InviteNotifier(Conference conference, InviteMessage message) {
            this.m = message;
            this.c = conference;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = XMPPConferenceService.this._conferenceServiceListeners;
            synchronized (list) {
                Iterator itr = XMPPConferenceService.this._conferenceServiceListeners.iterator();
                while (itr.hasNext()) {
                    try {
                        ConferenceServiceListener l = (ConferenceServiceListener)itr.next();
                        if (l == null) continue;
                        l.onInvite(this.c, this.m);
                    }
                    catch (Exception e) {
                        XMPPSessionProvider.error(e.toString(), e);
                    }
                }
            }
        }
    }
}

