/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceEventHelper;
import com.sun.im.service.ConferenceEventListener;
import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.InviteMessageStatusListener;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.TimeoutException;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.JIDUtil;
import com.sun.im.service.xmpp.XMPPConferenceService;
import com.sun.im.service.xmpp.XMPPMessage;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.util.PacketMonitor;
import org.jabberstudio.jso.x.disco.DiscoInfoQuery;
import org.jabberstudio.jso.x.disco.DiscoItem;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;
import org.jabberstudio.jso.x.muc.Affiliation;
import org.jabberstudio.jso.x.muc.Decline;
import org.jabberstudio.jso.x.muc.Destroy;
import org.jabberstudio.jso.x.muc.Invite;
import org.jabberstudio.jso.x.muc.MUCItem;
import org.jabberstudio.jso.x.muc.MUCOwnerQuery;
import org.jabberstudio.jso.x.muc.MUCQuery;
import org.jabberstudio.jso.x.muc.MUCRole;
import org.jabberstudio.jso.x.muc.MUCUserQuery;
import org.jabberstudio.jso.x.xdata.XDataField;
import org.jabberstudio.jso.x.xdata.XDataForm;

public class XMPPConference
implements Conference {
    protected JID _node;
    protected String _name;
    protected XMPPSession _session;
    private ConferenceListener _listener;
    private int _access;
    private static final int _initialChatMsgCacheSize = 10;
    private ArrayList _initialChatMessages = new ArrayList(10);
    boolean _joined = false;
    boolean isPrivate = false;
    Hashtable inviteListeners = new Hashtable();
    Hashtable _participants = new Hashtable();
    int currentUserPrivilege = -1;
    Affiliation.Type currentUserAffiliation = null;
    String _recipient = null;
    boolean isGroupChat = false;
    String _thread = null;
    boolean isJEP0085Supported = false;
    boolean isFirstMessage = true;
    String moderator = null;
    public static final String CHATSTATE_NAMESPACE = "http://jabber.org/protocol/chatstates";
    public static final NSI NSI_ACTIVE = new NSI("active", "http://jabber.org/protocol/chatstates");
    public static final NSI NSI_INACTIVE = new NSI("inactive", "http://jabber.org/protocol/chatstates");
    public static final NSI NSI_COMPOSING = new NSI("composing", "http://jabber.org/protocol/chatstates");
    public static final NSI NSI_PAUSE = new NSI("pause", "http://jabber.org/protocol/chatstates");
    public static final NSI NSI_GONE = new NSI("gone", "http://jabber.org/protocol/chatstates");
    public static final String MODERATION_SUBMIT = "submit";
    public static final String MODERATION_ACCEPTED = "accepted";
    public static final String MODERATION_PENDING = "pending";
    public static final String MODERATION_MODIFIED = "modified";
    public static final String MODERATION_REJECTED = "rejected";
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_FROM = "from";
    public static final String MODERATION_NAMESPACE = "sun:xmpp:moderation";
    public static final NSI NSI_START = new NSI("start", "sun:xmpp:moderation");
    public static final NSI NSI_STOP = new NSI("stop", "sun:xmpp:moderation");
    public static final NSI NSI_MESSAGE = new NSI("x", "sun:xmpp:moderation");
    public static final NSI NSI_ACTION = new NSI("action", null);
    public static final NSI NSI_REASON = new NSI("reason", null);
    public static final NSI NSI_ORIGINATOR = new NSI("originator", null);

    public XMPPConference() {
    }

    public XMPPConference(XMPPSession session, ConferenceListener listener, int access) throws CollaborationException {
        this._session = session;
        this._listener = listener;
        this._name = this.makeConferenceName();
        this.addParticipant(this._session.getCurrentUserJID());
        JID service = this.getService();
        this._node = service != null ? JIDUtil.encodedJID(StringUtility.appendDomainToAddress(this._name, service.toString())) : new JID(JIDUtil.encodedString(this._name));
        this._access = access;
        this.userStatusChange(this._session.getCurrentUserJID().toBareJID().toString(), 12);
        this.isPrivate = true;
    }

    public XMPPConference(XMPPSession session, String destination, ConferenceListener listener, int access) throws CollaborationException {
        this._session = session;
        this._listener = listener;
        this.createNewRoom(destination);
        try {
            this.setDefaultPrivilege(access);
        }
        catch (CollaborationException ce) {
            this.leave();
            throw ce;
        }
        this._access = access;
        this.isGroupChat = true;
        if (this._listener == null) {
            this.leave();
        }
    }

    public XMPPConference(XMPPSession session) {
        this._session = session;
    }

    public XMPPConference(XMPPSession session, String name, JID jid) throws CollaborationException {
        this._session = session;
        this._name = name;
        this._node = jid;
        if (this._node == null) {
            JID service = this.getService();
            this._node = service != null ? JIDUtil.encodedJID(StringUtility.appendDomainToAddress(this._name, service.toString())) : new JID(JIDUtil.encodedString(this._name));
            this.isPrivate = true;
        } else {
            this.isGroupChat = true;
        }
    }

    private String makeConferenceName() {
        return "." + Long.toString(new Date().getTime()) + Long.toString(Math.round(Math.random() * 10000.0));
    }

    private void createNewRoom(String destination) throws CollaborationException {
        JID service = this.getService();
        if (service == null) {
            throw new ServiceUnavailableException();
        }
        this._node = JIDUtil.encodedJID(StringUtility.appendDomainToAddress(destination, service.toString()));
        this._session.addConference(this);
        this._join();
    }

    public void addMessage(Message message) throws CollaborationException {
        XMPPSessionProvider.debug("_recipient is " + this._recipient);
        org.jabberstudio.jso.Message m = (org.jabberstudio.jso.Message)((XMPPMessage)message).getXMPPMessage();
        if (this.isFirstMessage) {
            StreamElement activeElement = this._session.getDataFactory().createElementNode(NSI_ACTIVE);
            m.add((StreamNode)activeElement);
            this.isFirstMessage = false;
        }
        if (!this.isGroupChat) {
            if (this._recipient != null) {
                m.setType((Packet.Type)org.jabberstudio.jso.Message.CHAT);
                m.setThread(this._name);
                m.setTo(new JID(this._recipient));
                this._session.sendAllMessageParts((XMPPMessage)message);
            }
            m.setTo(m.getFrom());
            this.messageAdded((XMPPMessage)message);
            return;
        }
        m.setType((Packet.Type)org.jabberstudio.jso.Message.GROUPCHAT);
        m.setTo(this._node);
        m.setThread(null);
        this._session.sendAllMessageParts((XMPPMessage)message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws CollaborationException {
        XMPPConference xMPPConference = this;
        synchronized (xMPPConference) {
            if (this._joined) {
                this._listener = null;
                this._joined = false;
            }
        }
        InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(this._session.getDataFactory().createNSI("iq", this._session.getConnection().getDefaultNamespace()), InfoQuery.class);
        StreamDataFactory sdf = this._session.getDataFactory();
        MUCOwnerQuery owner = (MUCOwnerQuery)sdf.createElementNode(MUCOwnerQuery.NAME, MUCOwnerQuery.class);
        Destroy destroy = (Destroy)sdf.createElementNode(new NSI("destroy", "http://jabber.org/protocol/muc#owner"));
        owner.add((StreamNode)destroy);
        iq.addExtension((Extension)owner);
        iq.setType((Packet.Type)InfoQuery.SET);
        iq.setFrom(this._session.getCurrentUserJID());
        iq.setTo(this._node);
        iq.setID(this._session.nextID("destroy"));
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq, (long)XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            se.printStackTrace();
        }
        if (iq == null || iq.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Cannot close the room!");
        }
    }

    public InviteMessage createInviteMessage() throws CollaborationException {
        XMPPMessage m = new XMPPMessage(this._session, this._session.getCurrentUserJID());
        return m;
    }

    public Message createMessage() throws CollaborationException {
        XMPPMessage m;
        if (!this.isGroupChat) {
            if (this._recipient == null) {
                XMPPSessionProvider.warning("Recipient is null. Invite a user to room");
            }
            m = new XMPPMessage(this._session, this._recipient != null ? new JID(this._recipient) : null, this._session.getCurrentUserJID());
            m.getXMPPMessage().setType((Packet.Type)org.jabberstudio.jso.Message.CHAT);
            ((org.jabberstudio.jso.Message)m.getXMPPMessage()).setThread(this._name);
        } else {
            m = new XMPPMessage(this._session, this._node, this._session.getCurrentUserJID());
            m.getXMPPMessage().setType((Packet.Type)org.jabberstudio.jso.Message.GROUPCHAT);
        }
        return m;
    }

    public int getDefaultPrivilege() throws CollaborationException {
        InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iq.setType((Packet.Type)InfoQuery.GET);
        iq.setTo(this._node);
        iq.setFrom(this._session.getCurrentUserJID());
        iq.setID(this._session.nextID("room"));
        StreamDataFactory sdf = this._session.getDataFactory();
        MUCOwnerQuery owner = (MUCOwnerQuery)sdf.createElementNode(MUCOwnerQuery.NAME, MUCOwnerQuery.class);
        iq.add((StreamNode)owner);
        try {
            InfoQuery response = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq, (long)XMPPSession.SHORT_REQUEST_TIMEOUT);
            if (response == null || response.getType() == Packet.ERROR) {
                throw new CollaborationException("Cannot get the privilege");
            }
            this.currentUserPrivilege = 30;
            iq = response;
            Iterator q = iq.listElements(MUCOwnerQuery.NAME).iterator();
            while (q.hasNext()) {
                Iterator f = ((StreamElement)q.next()).listElements(XDataForm.NAME).iterator();
                if (!f.hasNext()) continue;
                XDataForm x = (XDataForm)f.next();
                x.setType(XDataForm.SUBMIT);
                XDataField mem = x.getField("muc#roomconfig_membersonly");
                if (mem != null && mem.getValue().equals("1")) {
                    return 1;
                }
                XDataField mod = x.getField("muc#roomconfig_moderatedroom");
                if (mod != null && mod.getValue().equals("1")) {
                    return 2;
                }
                return 4;
            }
        }
        catch (StreamException e) {
            e.printStackTrace();
        }
        return 1;
    }

    public String getName() {
        return this._name;
    }

    public String getDestination() {
        return JIDUtil.decodedJID(this._node);
    }

    public JID getNode() {
        return this._node;
    }

    public int getPrivilege() throws CollaborationException {
        XMPPSessionProvider.debug("Current user privilege " + this.currentUserPrivilege);
        if (this.currentUserPrivilege == -1) {
            int n = this.getDefaultPrivilege();
        }
        if (this.currentUserPrivilege != -1) {
            return this.currentUserPrivilege;
        }
        throw new CollaborationException("Cannot get the privilege");
    }

    public int getPrivilege(String str) throws CollaborationException {
        Map map = this.listPrivileges();
        Integer i = (Integer)map.get(str);
        if (i != null) {
            return i;
        }
        return this.getDefaultPrivilege();
    }

    public void setPrivileges(Map m) throws CollaborationException {
        InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        StreamDataFactory sdf = this._session.getDataFactory();
        MUCOwnerQuery admin = (MUCOwnerQuery)sdf.createElementNode(MUCOwnerQuery.NAME, MUCOwnerQuery.class);
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String uid = (String)i.next();
            MUCItem item = (MUCItem)sdf.createElementNode(new NSI("item", "http://jabber.org/protocol/muc#owner"), class$org$jabberstudio$jso$x$muc$MUCItem == null ? XMPPConference.class$("org.jabberstudio.jso.x.muc.MUCItem") : class$org$jabberstudio$jso$x$muc$MUCItem);
            item.setJID(new JID(uid));
            item.setAffiliation(this.getAffiliation((Integer)m.get(uid)));
            if (item.getAffiliation() == Affiliation.NONE) {
                item.setRole(MUCRole.VISITOR);
            }
            admin.add((StreamNode)item);
        }
        iq.addExtension((Extension)admin);
        iq.setType((Packet.Type)InfoQuery.SET);
        iq.setFrom(this._session.getCurrentUserJID());
        iq.setTo(this._node);
        iq.setID(this._session.nextID("affiliation"));
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq);
        }
        catch (StreamException se) {
            se.printStackTrace();
        }
        if (iq == null || iq.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Cannot set the list");
        }
    }

    public Map listPrivileges() throws CollaborationException {
        Map users = new Hashtable();
        users = this.addUserstoList(users, this.getUserPrivileges(Affiliation.ADMIN), this.getAccess(Affiliation.ADMIN));
        users = this.addUserstoList(users, this.getUserPrivileges(Affiliation.MEMBER), this.getAccess(Affiliation.MEMBER));
        users = this.addUserstoList(users, this.getUserPrivileges(Affiliation.NONE), this.getAccess(Affiliation.NONE));
        users = this.addUserstoList(users, this.getUserPrivileges(Affiliation.OUTCAST), this.getAccess(Affiliation.OUTCAST));
        users = this.addUserstoList(users, this.getUserPrivileges(Affiliation.OWNER), this.getAccess(Affiliation.OWNER));
        return users;
    }

    private Map addUserstoList(Map m, List l, int access) {
        Iterator i = l.iterator();
        while (i.hasNext()) {
            m.put(i.next(), new Integer(access));
        }
        return m;
    }

    private List getUserPrivileges(Affiliation.Type type) throws CollaborationException {
        ArrayList<String> ret = new ArrayList<String>();
        InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        StreamDataFactory sdf = this._session.getDataFactory();
        MUCOwnerQuery admin = (MUCOwnerQuery)sdf.createElementNode(MUCOwnerQuery.NAME, MUCOwnerQuery.class);
        MUCItem item = (MUCItem)sdf.createElementNode(new NSI("item", "http://jabber.org/protocol/muc#owner"), MUCItem.class);
        if (type != null) {
            item.setAffiliation(type);
        }
        admin.add((StreamNode)item);
        iq.addExtension((Extension)admin);
        iq.setType((Packet.Type)InfoQuery.GET);
        iq.setFrom(this._session.getCurrentUserJID());
        iq.setTo(this._node);
        iq.setID(this._session.nextID("affiliation"));
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq);
        }
        catch (StreamException se) {
            se.printStackTrace();
        }
        if (iq == null || iq.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Cannot get the list");
        }
        admin = (MUCOwnerQuery)iq.listExtensions("http://jabber.org/protocol/muc#owner").get(0);
        Iterator itr = admin.listElements().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof MUCItem)) continue;
            ret.add(((MUCItem)o).getJID().toString());
        }
        return ret;
    }

    private int getAccess(Affiliation.Type type) {
        if (type == null) {
            return -1;
        }
        if (type == Affiliation.ADMIN || type == Affiliation.OWNER) {
            return 30;
        }
        if (type == Affiliation.MEMBER) {
            return 4;
        }
        if (type == Affiliation.NONE) {
            return 2;
        }
        return 1;
    }

    private Affiliation.Type getAffiliation(int access) {
        switch (access) {
            case 30: {
                return Affiliation.OWNER;
            }
            case 4: 
            case 14: {
                return Affiliation.MEMBER;
            }
            case 2: {
                return Affiliation.NONE;
            }
        }
        return Affiliation.OUTCAST;
    }

    public String getProperty(String str) {
        return null;
    }

    public boolean isPublic() {
        if (!this.isGroupChat) {
            return !this.isPrivate;
        }
        InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iq.setType((Packet.Type)InfoQuery.GET);
        iq.setTo(this._node);
        iq.setFrom(this._session.getCurrentUserJID());
        iq.setID(this._session.nextID("room"));
        StreamDataFactory sdf = this._session.getDataFactory();
        DiscoInfoQuery disco = (DiscoInfoQuery)sdf.createElementNode(DiscoInfoQuery.NAME);
        iq.add((StreamNode)disco);
        try {
            InfoQuery response = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq, (long)XMPPSession.SHORT_REQUEST_TIMEOUT);
            if (response == null || response.getType() == Packet.ERROR) {
                return !this.isPrivate;
            }
            disco = (DiscoInfoQuery)response.listExtensions("http://jabber.org/protocol/disco#info").get(0);
            Iterator i = disco.getFeatures().iterator();
            while (i.hasNext()) {
                if (!"muc_persistent".equals(i.next())) continue;
                this.isPrivate = false;
                return !this.isPrivate;
            }
            this.isPrivate = true;
        }
        catch (StreamException e) {
            e.printStackTrace();
        }
        return !this.isPrivate;
    }

    public void invite(int param, Message message, InviteMessageStatusListener inviteListener) throws CollaborationException {
        org.jabberstudio.jso.Message m = (org.jabberstudio.jso.Message)((XMPPMessage)message).getXMPPMessage();
        String[] rcpt = message.getRecipients();
        if (!this.isGroupChat && this._participants.size() == 1 && rcpt.length == 1) {
            m.setFrom(this._session.getCurrentUserJID());
            m.setTo(new JID(rcpt[0]));
            m.setID(null);
            m.setType((Packet.Type)org.jabberstudio.jso.Message.CHAT);
            m.setThread(this._name);
            StreamElement activeElement = this._session.getDataFactory().createElementNode(NSI_ACTIVE);
            m.add((StreamNode)activeElement);
            this._session.sendAllMessageParts((XMPPMessage)message);
            this.inviteListeners.put(rcpt[0], inviteListener);
            this._participants.put(rcpt[0], new JID(rcpt[0]));
            this._recipient = rcpt[0];
            return;
        }
        MessagePart[] parts = message.getParts();
        String content = null;
        if (parts != null) {
            content = parts[0].getContent();
        }
        StreamDataFactory sdf = this._session.getDataFactory();
        MUCUserQuery user = (MUCUserQuery)sdf.createElementNode(MUCUserQuery.NAME, MUCUserQuery.class);
        Invite invite = (Invite)sdf.createElementNode(Invite.NAME, Invite.class);
        user.add((StreamNode)invite);
        m.add((StreamNode)user);
        m.setTo(this._node);
        m.setFrom(null);
        m.setID(null);
        m.setType(null);
        m.setBody(null);
        m.setThread(null);
        if (!this.isGroupChat && (this._participants.size() == 2 || this._participants.size() < 2 && rcpt.length > 1)) {
            this.createNewRoom(this._name);
            this._join();
            if (this._recipient != null) {
                invite.setTo(new JID(this._recipient));
                invite.setContinue();
                this._session.sendAllMessageParts((XMPPMessage)message);
            }
            this._recipient = null;
            invite.removeContinue();
        }
        invite.setReason(content);
        for (int i = 0; i < rcpt.length; ++i) {
            invite.setTo(new JID(rcpt[i]));
            this._session.sendAllMessageParts((XMPPMessage)message);
            this.inviteListeners.put(rcpt[i], inviteListener);
        }
    }

    public void handleInviteReply(org.jabberstudio.jso.Message m) {
        XMPPSessionProvider.debug("Handle Invite");
        MUCUserQuery user = (MUCUserQuery)m.getExtension("http://jabber.org/protocol/muc#user");
        String rcpt = null;
        if (user == null) {
            return;
        }
        Iterator itr = user.listElements().iterator();
        while (itr.hasNext()) {
            InviteMessageStatusListener inviteListener;
            Object o = itr.next();
            if (o instanceof Decline) {
                rcpt = ((Decline)o).getFrom().toString();
                inviteListener = (InviteMessageStatusListener)this.inviteListeners.get(rcpt);
                if (inviteListener != null) {
                    XMPPSessionProvider.debug("invite listener not null- decline");
                    inviteListener.onRsvp(rcpt, false);
                    this.inviteListeners.remove(rcpt);
                } else {
                    XMPPSessionProvider.debug("invite listener null- decline");
                }
                return;
            }
            if (!(o instanceof Invite)) continue;
            rcpt = ((Invite)o).getFrom().toString();
            if (((Invite)o).hasContinue()) {
                try {
                    this._join();
                }
                catch (CollaborationException e) {
                    e.printStackTrace();
                }
                this._recipient = null;
                return;
            }
            inviteListener = (InviteMessageStatusListener)this.inviteListeners.get(rcpt);
            if (inviteListener != null) {
                XMPPSessionProvider.debug("invite listener not null- invite");
                inviteListener.onRsvp(rcpt, true);
                this.inviteListeners.remove(rcpt);
                continue;
            }
            XMPPSessionProvider.debug("invite listener null- invite");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(ConferenceListener conferenceListener) throws CollaborationException {
        this._session.addConference(this);
        if (this.isGroupChat || this._participants.size() > 2) {
            this._listener = conferenceListener;
            this._join();
        } else if (!this.isGroupChat && this._listener == null && this._recipient != null) {
            ArrayList arrayList = this._initialChatMessages;
            synchronized (arrayList) {
                if (this._initialChatMessages.size() > 0) {
                    Iterator i = this._initialChatMessages.iterator();
                    while (i.hasNext()) {
                        Message msg = (Message)i.next();
                        conferenceListener.onMessageAdded(msg);
                    }
                }
                this._initialChatMessages.clear();
                this._listener = conferenceListener;
            }
            XMPPSessionProvider.debug("Sending join notification " + this._recipient);
            this.userStatusChange(this._recipient, 12);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave() {
        try {
            if (this.isGroupChat) {
                StreamDataFactory sdf = this._session.getDataFactory();
                Presence p = (Presence)sdf.createPacketNode(XMPPSession.PRESENCE_NAME, Presence.class);
                String nick = this._session.getCurrentUserJID().getNode();
                p.setTo(new JID(this._node.getNode(), this._node.getDomain(), nick));
                p.setFrom(this._session.getCurrentUserJID());
                p.setType((Packet.Type)Presence.UNAVAILABLE);
                if (this.moderator != null && this._session.isCurrentUser((JID)this._participants.get(this.moderator))) {
                    p.add((StreamNode)sdf.createElementNode(NSI_STOP));
                    this.moderator = null;
                }
                this._session.getConnection().send((Packet)p);
                XMPPConference xMPPConference = this;
                synchronized (xMPPConference) {
                    if (this._joined) {
                        this._listener = null;
                        this._joined = false;
                    }
                }
                this._session.removeConference(this._node.toString());
            } else {
                if (this.isJEP0085Supported) {
                    this._listener = null;
                    StreamElement element = this._session.getDataFactory().createElementNode(NSI_GONE);
                    this.sendStatusMessage(element);
                }
                this._session.removeConference(this._name);
            }
            this._participants.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDefaultPrivilege(int access) throws CollaborationException {
        InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iq.setType((Packet.Type)InfoQuery.GET);
        iq.setTo(this._node);
        iq.setFrom(this._session.getCurrentUserJID());
        iq.setID(this._session.nextID("room"));
        StreamDataFactory sdf = this._session.getDataFactory();
        MUCOwnerQuery owner = (MUCOwnerQuery)sdf.createElementNode(MUCOwnerQuery.NAME, MUCOwnerQuery.class);
        iq.add((StreamNode)owner);
        try {
            InfoQuery response;
            iq = response = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq);
            Iterator q = iq.listElements(MUCOwnerQuery.NAME).iterator();
            block8: while (q.hasNext()) {
                Iterator f = ((StreamElement)q.next()).listElements(XDataForm.NAME).iterator();
                while (f.hasNext()) {
                    XDataForm x = (XDataForm)f.next();
                    x.setType(XDataForm.SUBMIT);
                    XDataField persist = x.getField("muc#roomconfig_persistentroom");
                    if (persist == null) continue;
                    XDataField mem = null;
                    XDataField mod = null;
                    persist.setValue("1");
                    switch (access) {
                        case 2: 
                        case 14: {
                            mod = x.getField("muc#roomconfig_moderatedroom");
                            if (mod == null) {
                                mod = x.getField("muc#owner_moderatedroom");
                            }
                            if (mod != null) {
                                mod.setValue("1");
                            }
                            if ((mem = x.getField("muc#roomconfig_membersonly")) == null) {
                                mem = x.getField("muc#owner_membersonly");
                            }
                            if (mem == null) break;
                            mem.setValue("0");
                            break;
                        }
                        case 4: {
                            mem = x.getField("muc#roomconfig_membersonly");
                            if (mem == null) {
                                mem = x.getField("muc#owner_membersonly");
                            }
                            if (mem != null) {
                                mem.setValue("0");
                            }
                            if ((mod = x.getField("muc#roomconfig_moderatedroom")) == null) {
                                mod = x.getField("muc#owner_moderatedroom");
                            }
                            if (mod == null) break;
                            mod.setValue("0");
                            break;
                        }
                        case 30: {
                            break;
                        }
                        case 1: {
                            mem = x.getField("muc#roomconfig_membersonly");
                            if (mem == null) {
                                mem = x.getField("muc#owner_membersonly");
                            }
                            if (mem != null) {
                                mem.setValue("1");
                            }
                            if ((mod = x.getField("muc#roomconfig_moderatedroom")) == null) {
                                mod = x.getField("muc#owner_moderatedroom");
                            }
                            if (mod == null) break;
                            mod.setValue("0");
                        }
                    }
                    iq.setType((Packet.Type)InfoQuery.SET);
                    iq.setID(this._session.nextID("room"));
                    iq.setFrom(this._session.getCurrentUserJID());
                    iq.setTo(this._node);
                    response = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq, (long)XMPPSession.REQUEST_TIMEOUT);
                    if (response == null) {
                        throw new TimeoutException("Timeout while changing the default privilege");
                    }
                    if (response.getType() == InfoQuery.RESULT) continue block8;
                    throw new CollaborationException("Cannot set the default privilege");
                }
            }
        }
        catch (StreamException e) {
            e.printStackTrace();
        }
    }

    public void setPrivilege(String uid, int param) throws CollaborationException {
        Map m = this.listPrivileges();
        m.put(uid, new Integer(param));
        this.setPrivileges(m);
    }

    public void setProperty(String str, String str1) throws CollaborationException {
    }

    public boolean hasPrivilege(int accessLevel) throws CollaborationException {
        if (this.currentUserPrivilege == -1) {
            try {
                this.getDefaultPrivilege();
            }
            catch (CollaborationException ce) {
                XMPPSessionProvider.error("Cannot get the default privlege");
                return false;
            }
        }
        switch (accessLevel) {
            case 30: {
                switch (this.currentUserPrivilege) {
                    case 30: {
                        return true;
                    }
                }
                return false;
            }
            case 4: 
            case 14: {
                switch (this.currentUserPrivilege) {
                    case 4: 
                    case 14: 
                    case 30: {
                        return true;
                    }
                }
                return false;
            }
            case 2: {
                switch (this.currentUserPrivilege) {
                    case 2: 
                    case 4: 
                    case 14: 
                    case 30: {
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void moderate(boolean start) throws CollaborationException {
        if (!this.isPublic()) {
            throw new CollaborationException("Moderation is supported only for public conferences");
        }
        if (start && this.moderator != null) {
            throw new CollaborationException("Only one moderator is allowed per room");
        }
        if (!start) {
            if (this.moderator == null) {
                throw new CollaborationException("No one is moderating the room");
            }
            if (!this._session.isCurrentUser((JID)this._participants.get(this.moderator))) {
                throw new CollaborationException("Unauthorized to stop moderation");
            }
        }
        try {
            StreamDataFactory sdf = this._session.getDataFactory();
            Presence p = (Presence)sdf.createPacketNode(XMPPSession.PRESENCE_NAME, Presence.class);
            p.setTo(this._node);
            p.setFrom(this._session.getCurrentUserJID());
            if (start) {
                p.add((StreamNode)sdf.createElementNode(NSI_START));
            } else {
                p.add((StreamNode)sdf.createElementNode(NSI_STOP));
            }
            this._session.getConnection().send((Packet)p);
        }
        catch (StreamException e) {
            XMPPSessionProvider.error(e.toString(), e);
            throw new CollaborationException("Error while moderating the room");
        }
    }

    protected synchronized void _join() throws CollaborationException {
        if (this._joined) {
            XMPPSessionProvider.debug("Already present in the room");
            return;
        }
        try {
            StreamDataFactory sdf = this._session.getDataFactory();
            Presence p = (Presence)sdf.createPacketNode(XMPPSession.PRESENCE_NAME, Presence.class);
            String nick = this._session.getCurrentUserJID().getNode();
            p.setTo(new JID(this._node.getNode(), this._node.getDomain(), nick));
            p.setFrom(this._session.getCurrentUserJID());
            MUCQuery mucQuery = (MUCQuery)sdf.createElementNode(MUCQuery.NAME, MUCQuery.class);
            p.add((StreamNode)mucQuery);
            p = (Presence)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)p, (long)XMPPSession.REQUEST_TIMEOUT);
            if (p == null || p.getType() == Presence.ERROR) {
                throw new CollaborationException("Cannot join the room");
            }
            this._joined = true;
            this.isGroupChat = true;
        }
        catch (StreamException e) {
            e.printStackTrace();
            throw new CollaborationException("Cannot create the room");
        }
    }

    public void userStatusChange(Presence p) {
        JID jid = null;
        MUCUserQuery user = (MUCUserQuery)p.getExtension("http://jabber.org/protocol/muc#user");
        Iterator itr = user.listElements().iterator();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof MUCItem)) continue;
            MUCItem item = (MUCItem)o;
            jid = item.getJID();
            if (this._session.isCurrentUser(jid)) {
                MUCRole.Type role = item.getRole();
                this.currentUserPrivilege = role == MUCRole.MODERATOR ? 30 : (role == MUCRole.PARTICIPANT ? 4 : (role == MUCRole.VISITOR ? 2 : 1));
                this.currentUserAffiliation = item.getAffiliation();
                XMPPSessionProvider.debug("Current user privilege " + this.currentUserPrivilege);
            }
            if (this._listener == null || jid == null) continue;
            ConferenceEventTuple cet = new ConferenceEventTuple(jid.toString());
            if (p.getType() == null) {
                cet.status = Integer.toString(12);
                String nick = this.getNickFromJID(jid);
                if (nick != null) {
                    this._participants.remove(nick);
                    this._participants.put(p.getFrom().getResource(), jid);
                } else {
                    this._participants.put(p.getFrom().getResource(), jid);
                    this.isFirstMessage = true;
                    this.fireEventListener(cet);
                }
            } else if (p.getType().equals((Object)Presence.UNAVAILABLE)) {
                cet.status = Integer.toString(11);
                this._participants.remove(p.getFrom().getResource());
                this.fireEventListener(cet);
            }
            if (p.getFirstElement(NSI_START) != null) {
                if (p.getType() == Packet.ERROR) {
                    return;
                }
                cet.status = Integer.toString(32);
                this.moderator = p.getFrom().getResource();
                this.fireEventListener(cet);
                continue;
            }
            if (p.getFirstElement(NSI_STOP) == null) continue;
            if (p.getType() == Packet.ERROR) {
                return;
            }
            cet.status = Integer.toString(33);
            this.moderator = null;
            this.fireEventListener(cet);
        }
    }

    public void userStatusChange(String jid, int status) {
        if (!this.isGroupChat && status == 11) {
            String rcpt = StringUtility.removeResource(jid);
            if (jid.equals(this._recipient)) {
                this._participants.remove(jid);
                this._recipient = null;
            } else if (rcpt.equals(this._recipient)) {
                this._participants.remove(rcpt);
                this._recipient = null;
            }
            InviteMessageStatusListener inviteListener = (InviteMessageStatusListener)this.inviteListeners.get(rcpt);
            if (inviteListener != null) {
                XMPPSessionProvider.debug("Invite listener not null - " + rcpt);
                inviteListener.onRsvp(rcpt, false);
                this.inviteListeners.remove(rcpt);
                return;
            }
            this.isJEP0085Supported = false;
        }
        if (this._listener == null) {
            return;
        }
        ConferenceEventTuple cet = new ConferenceEventTuple(jid);
        cet.status = status == 8 ? Integer.toString(9) : (status == 9 ? Integer.toString(10) : Integer.toString(status));
        this.fireEventListener(cet);
    }

    private void fireEventListener(ConferenceEventTuple cet) {
        if (this._listener instanceof ConferenceEventListener) {
            ((ConferenceEventListener)((Object)this._listener)).onEvent(cet);
        } else {
            ConferenceEventHelper ceh = new ConferenceEventHelper();
            ceh.addTuple(cet);
            this._listener.onEvent(ceh.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageAdded(XMPPMessage m) {
        if (this.isGroupChat) {
            if (this._listener != null) {
                org.jabberstudio.jso.Message msg = (org.jabberstudio.jso.Message)m.getXMPPMessage();
                String nick = msg.getFrom().getResource();
                JID jid = (JID)this._participants.get(nick);
                String uid = jid == null ? nick : jid.toString();
                try {
                    m.setOriginator(uid);
                }
                catch (CollaborationException e) {
                    e.printStackTrace();
                }
                StreamElement element = msg.getFirstElement(NSI_MESSAGE);
                if (element != null) {
                    if (org.jabberstudio.jso.Message.GROUPCHAT.equals((Object)msg.getType())) {
                        StreamElement orig = element.getFirstElement(NSI_ORIGINATOR);
                        String from = orig.getAttributeValue(ATTR_FROM);
                        try {
                            m.setOriginator(from);
                        }
                        catch (CollaborationException e) {
                            e.printStackTrace();
                        }
                        this._listener.onModeratedMessageAdded(m);
                    } else {
                        String reason;
                        StreamElement action = element.getFirstElement(NSI_ACTION);
                        String type = action.getAttributeValue(ATTR_TYPE);
                        StreamElement reasonElem = action.getFirstElement(NSI_REASON);
                        String string = reason = reasonElem == null ? null : reasonElem.normalizeTrimText();
                        if (MODERATION_SUBMIT.equals(type)) {
                            this._listener.onModeratedMessageStatus(m, 32, reason);
                        } else if (MODERATION_ACCEPTED.equals(type)) {
                            this._listener.onModeratedMessageStatus(m, 36, reason);
                        } else if (MODERATION_MODIFIED.equals(type)) {
                            this._listener.onModeratedMessageStatus(m, 38, reason);
                        } else if (MODERATION_REJECTED.equals(type)) {
                            this._listener.onModeratedMessageStatus(m, 40, reason);
                        } else if (MODERATION_PENDING.equals(type)) {
                            this._listener.onModeratedMessageStatus(m, 34, reason);
                        }
                    }
                } else {
                    this._listener.onMessageAdded(m);
                }
            } else {
                XMPPSessionProvider.debug("listener is null");
            }
        } else {
            ArrayList arrayList = this._initialChatMessages;
            synchronized (arrayList) {
                if (this._listener == null) {
                    if (this._initialChatMessages.size() < 10) {
                        this._initialChatMessages.add(m);
                    }
                } else {
                    this._listener.onMessageAdded(m);
                }
            }
        }
    }

    public void addParticipant(JID jid) {
        if (!this._session.isCurrentUser(jid) && this._participants.size() < 2) {
            this._recipient = jid.toString();
            XMPPSessionProvider.debug("_recipient = " + this._recipient);
        }
        XMPPSessionProvider.debug("Adding participant = " + jid.toString());
        this._participants.put(jid.toString(), jid);
    }

    public JID getParticipant(String jid) {
        return (JID)this._participants.get(jid);
    }

    public void setGroupChat(boolean b) {
        this.isGroupChat = b;
    }

    /*
     * WARNING - void declaration
     */
    public boolean sendStatus(int msgStatus) throws CollaborationException {
        void var2_3;
        if (!this.isJEP0085Supported) {
            return false;
        }
        StreamDataFactory sdf = this._session.getDataFactory();
        switch (msgStatus) {
            case 8: {
                StreamElement element = sdf.createElementNode(NSI_COMPOSING);
                break;
            }
            case 9: {
                StreamElement element = sdf.createElementNode(NSI_PAUSE);
                break;
            }
            default: {
                return false;
            }
        }
        return this.sendStatusMessage((StreamElement)var2_3);
    }

    public boolean sendStatusMessage(StreamElement element) throws CollaborationException {
        Stream connection = this._session.getConnection();
        StreamDataFactory sdf = this._session.getDataFactory();
        org.jabberstudio.jso.Message msg = (org.jabberstudio.jso.Message)sdf.createPacketNode(XMPPSession.MESSAGE_NAME, org.jabberstudio.jso.Message.class);
        msg.setFrom(this._session.getCurrentUserJID());
        msg.add((StreamNode)element);
        if (!this.isGroupChat) {
            if (this._recipient != null) {
                msg.setTo(new JID(this._recipient));
            }
            msg.setType((Packet.Type)org.jabberstudio.jso.Message.CHAT);
            msg.setThread(this._name);
        } else {
            msg.setTo(this._node);
            msg.setType((Packet.Type)org.jabberstudio.jso.Message.GROUPCHAT);
        }
        try {
            if (msg.getTo() != null) {
                connection.send((Packet)msg);
            }
            if (!this.isGroupChat) {
                msg.setTo(msg.getFrom());
                this._session.processMessage((Packet)msg);
            }
        }
        catch (StreamException se) {
            throw new CollaborationException(se);
        }
        return true;
    }

    public void processChatStates(org.jabberstudio.jso.Message in) throws CollaborationException {
        if (!this.isJEP0085Supported) {
            StreamElement activeElement = in.getFirstElement(NSI_ACTIVE);
            if (activeElement != null && !in.getFrom().equals(this._session.getCurrentUserJID())) {
                this.isJEP0085Supported = true;
                String rcpt = StringUtility.removeResource(in.getFrom().toString());
                InviteMessageStatusListener inviteListener = (InviteMessageStatusListener)this.inviteListeners.get(rcpt);
                if (in.getType() == org.jabberstudio.jso.Message.CHAT && inviteListener != null) {
                    XMPPSessionProvider.debug("Invite listener not null - " + rcpt);
                    inviteListener.onRsvp(rcpt, true);
                    this.inviteListeners.remove(rcpt);
                    this.userStatusChange(rcpt, 12);
                }
            }
        } else {
            String uid = in.getType() == org.jabberstudio.jso.Message.GROUPCHAT ? this.getParticipant(in.getFrom().getResource()).toString() : in.getFrom().toString();
            StreamElement element = in.getFirstElement(NSI_COMPOSING);
            if (element != null) {
                this.userStatusChange(uid, 8);
            }
            if ((element = in.getFirstElement(NSI_PAUSE)) != null) {
                this.userStatusChange(uid, 9);
            }
            if ((element = in.getFirstElement(NSI_INACTIVE)) != null) {
                this.isJEP0085Supported = false;
            }
        }
    }

    public void addModeratedMessage(Message msg, int status, String reason) throws CollaborationException {
        String nick;
        if (!this.isPublic()) {
            throw new CollaborationException("Moderation is supported only for public conferences");
        }
        if (this.moderator == null) {
            throw new CollaborationException("No moderator for this room");
        }
        XMPPMessage message = ((XMPPMessage)msg).copy();
        org.jabberstudio.jso.Message m = (org.jabberstudio.jso.Message)message.getXMPPMessage();
        StreamElement element = m.getFirstElement(NSI_MESSAGE);
        if (element == null) {
            element = this._session.getDataFactory().createElementNode(NSI_MESSAGE);
            m.add((StreamNode)element);
        }
        if (status == 32) {
            if (this.currentUserPrivilege != 2) {
                throw new CollaborationException("Users with LISTEN privilege can post to moderator");
            }
            nick = this.moderator;
        } else {
            if (!this._session.isCurrentUser((JID)this._participants.get(this.moderator))) {
                throw new CollaborationException("Not Authorized");
            }
            nick = this.getNickFromJID(m.getFrom());
            m.setFrom(this._session.getCurrentUserJID());
            StreamElement action = element.getFirstElement(NSI_ACTION);
            if (action == null) {
                action = this._session.getDataFactory().createElementNode(NSI_ACTION);
                element.add((StreamNode)action);
            }
            switch (status) {
                case 36: {
                    action.setAttributeValue(ATTR_TYPE, MODERATION_ACCEPTED);
                    break;
                }
                case 38: {
                    action.setAttributeValue(ATTR_TYPE, MODERATION_MODIFIED);
                    break;
                }
                case 40: {
                    action.setAttributeValue(ATTR_TYPE, MODERATION_REJECTED);
                    break;
                }
                case 34: {
                    action.setAttributeValue(ATTR_TYPE, MODERATION_PENDING);
                    break;
                }
                default: {
                    throw new CollaborationException("Illegal status " + status);
                }
            }
            StreamElement reasonElem = action.getFirstElement(NSI_REASON);
            if (reasonElem == null) {
                reasonElem = this._session.getDataFactory().createElementNode(NSI_REASON);
                action.add((StreamNode)reasonElem);
            }
            reasonElem.clearText();
            reasonElem.addText(reason);
        }
        m.setTo(new JID(this._node.getNode(), this._node.getDomain(), nick));
        m.setType((Packet.Type)org.jabberstudio.jso.Message.CHAT);
        m.setThread(null);
        this._session.sendAllMessageParts(message);
    }

    public Collection getParticipants() throws CollaborationException {
        ArrayList<String> list = new ArrayList<String>();
        InfoQuery iq = (InfoQuery)this._session.getDataFactory().createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        iq.setType((Packet.Type)InfoQuery.GET);
        iq.setTo(this._node);
        iq.setFrom(this._session.getCurrentUserJID());
        iq.setID(this._session.nextID("room"));
        StreamDataFactory sdf = this._session.getDataFactory();
        DiscoItemsQuery disco = (DiscoItemsQuery)sdf.createElementNode(DiscoItemsQuery.NAME, DiscoItemsQuery.class);
        iq.add((StreamNode)disco);
        try {
            InfoQuery response = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq, (long)XMPPSession.SHORT_REQUEST_TIMEOUT);
            if (response == null || response.getType() == Packet.ERROR) {
                throw new CollaborationException("Cannot get the participants list");
            }
            disco = (DiscoItemsQuery)response.listExtensions("http://jabber.org/protocol/disco#items").get(0);
            Iterator itr = disco.listItems().iterator();
            while (itr.hasNext()) {
                DiscoItem item = (DiscoItem)itr.next();
                JID jid = item.getJID();
                if (jid == null) continue;
                list.add(jid.toString());
            }
        }
        catch (StreamException e) {
            e.printStackTrace();
        }
        return list;
    }

    private String getNickFromJID(JID jid) {
        Enumeration enumeration = this._participants.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            JID value = (JID)this._participants.get(key);
            if (!jid.equals(value) && !jid.equals(value.toBareJID())) continue;
            return key;
        }
        return null;
    }

    private JID getService() {
        try {
            XMPPConferenceService s = (XMPPConferenceService)this._session.getConferenceService();
            return s.getService();
        }
        catch (CollaborationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isPresentInRoom() {
        if (this._recipient != null) {
            return true;
        }
        return this.isGroupChat && this._joined;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void sendChatInviteReply(Message message, boolean invite) throws CollaborationException {
        if (invite) {
            this.userStatusChange(this._session.getCurrentUserJID().toBareJID().toString(), 12);
        }
        if (!this.isJEP0085Supported) {
            return;
        }
        XMPPMessage m = (XMPPMessage)message;
        if (m == null) {
            m = new XMPPMessage(this._session, this._recipient != null ? new JID(this._recipient) : null, this._session.getCurrentUserJID());
        }
        org.jabberstudio.jso.Message xmppMsg = (org.jabberstudio.jso.Message)m.getXMPPMessage();
        if (invite) {
            if (!this.isFirstMessage) return;
            StreamElement activeElement = this._session.getDataFactory().createElementNode(NSI_ACTIVE);
            xmppMsg.add((StreamNode)activeElement);
            this.isFirstMessage = false;
        } else {
            this._listener = null;
            StreamElement goneElement = this._session.getDataFactory().createElementNode(NSI_GONE);
            xmppMsg.add((StreamNode)goneElement);
            this._session.removeConference(this._name);
        }
        xmppMsg.setType((Packet.Type)org.jabberstudio.jso.Message.CHAT);
        xmppMsg.setThread(this._name);
        this._session.sendAllMessageParts(m);
    }

    public boolean isParticipant(String jid) {
        return this._participants.containsKey(jid);
    }

    public boolean isOne2OnePrivateChat() {
        return !this.isGroupChat && !this.isPublic();
    }

    public void setNode(JID node) {
        this._node = node;
    }
}

