/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.AuthenticationException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.xmpp.StreamSourceCreator;
import com.sun.im.service.xmpp.XMPPComponentSessionProvider;
import com.sun.im.service.xmpp.XMPPSession;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamContext;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.util.DigestHash;

public class XMPPComponentSession
extends XMPPSession {
    public static final NSI HANDSHAKE = new NSI("handshake", null);

    public XMPPComponentSession() {
    }

    public XMPPComponentSession(XMPPComponentSessionProvider fac, String serviceUrl, StreamSourceCreator streamSrcCreator) throws CollaborationException {
        super(fac, serviceUrl, streamSrcCreator);
    }

    public XMPPComponentSession(XMPPComponentSessionProvider fac, String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener listener, StreamSourceCreator streamSrcCreator) throws CollaborationException {
        super(fac, serviceUrl, loginName, password, loginType, listener, streamSrcCreator);
    }

    protected String getLoginName(String loginName, String serviceUrl) throws AuthenticationException {
        this.setClientJID(loginName);
        return loginName;
    }

    protected String getStreamNameSpace() {
        return "jabber:component:accept";
    }

    protected void setClientJID() {
    }

    protected void authenticate(String password) throws AuthenticationException {
        StreamDataFactory sdf = this.getDataFactory();
        Stream connection = this.getConnection();
        Packet handShake = sdf.createPacketNode(HANDSHAKE);
        StreamContext ctx = connection.getInboundContext();
        System.out.println("Ctx ID " + ctx.getID() + " password " + password);
        String secret = DigestHash.SHA1.hash(ctx.getID() + password);
        handShake.addText(secret);
        try {
            connection.send(handShake);
        }
        catch (StreamException se) {
            throw new AuthenticationException(se.toString());
        }
    }

    protected void open() throws CollaborationException {
        Stream connection = this.getConnection();
        connection.getOutboundContext().setTo(new JID(this.getLoginName()));
        System.out.println(connection.getOutboundContext().getTo());
        super.open();
    }
}

