/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.AccessRule;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.XMPPSession;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;

public class XMPPAccessRule
implements AccessRule {
    LinkedList _principals = new LinkedList();
    LinkedList _excepts = new LinkedList();
    boolean _grant;
    XMPPSession _session;
    HashMap _allPrincipals = new HashMap();

    public XMPPAccessRule(XMPPSession session) {
        this._session = session;
    }

    public void addExceptPrincipal(String uid) throws CollaborationException {
        String localUid = StringUtility.getLocalPartFromAddress(uid);
        CollaborationPrincipal p = (CollaborationPrincipal)this._allPrincipals.get(localUid);
        if (p == null) {
            p = this._session.createPrincipal(localUid);
            this._allPrincipals.put(localUid, p);
        }
        this.addExceptPrincipal(p);
    }

    public void addPrincipal(String uid) throws CollaborationException {
        String localUid = StringUtility.getLocalPartFromAddress(uid);
        CollaborationPrincipal p = (CollaborationPrincipal)this._allPrincipals.get(localUid);
        if (p == null) {
            p = this._session.createPrincipal(localUid);
            this._allPrincipals.put(localUid, p);
        }
        this.addPrincipal(p);
    }

    public String getDomain() {
        return null;
    }

    public String getExceptDomain() {
        return null;
    }

    public Collection getExceptPrincipals() {
        return this._excepts;
    }

    public Collection getPrincipals() {
        return this._principals;
    }

    public String getResourceURL() {
        return null;
    }

    public boolean grant() {
        return this._grant;
    }

    public void removeExceptPrincipal(String uid) throws CollaborationException {
        CollaborationPrincipal p = (CollaborationPrincipal)this._allPrincipals.get(uid);
        if (p == null) {
            p = this._session.createPrincipal(uid);
            this._allPrincipals.put(uid, p);
        }
        this._excepts.remove(p);
        this._allPrincipals.remove(uid);
    }

    public void removeExceptPrincipal(CollaborationPrincipal p) throws CollaborationException {
        this._excepts.remove(p);
    }

    public void removePrincipal(String uid) throws CollaborationException {
        CollaborationPrincipal p = (CollaborationPrincipal)this._allPrincipals.get(uid);
        if (p == null) {
            p = this._session.createPrincipal(uid);
            this._allPrincipals.put(uid, p);
        }
        this._principals.remove(p);
        this._allPrincipals.remove(uid);
    }

    public void removePrincipal(CollaborationPrincipal p) throws CollaborationException {
        this._principals.remove(p);
    }

    public void addPrincipal(CollaborationPrincipal p) throws CollaborationException {
        if (!this._principals.contains(p)) {
            this._principals.add(p);
        }
    }

    public void removeAllPrincipals() throws CollaborationException {
        this._principals.clear();
    }

    public void setGrant(boolean param) {
        this._grant = param;
    }

    public void addExceptPrincipal(CollaborationPrincipal principal) throws CollaborationException {
        if (!this._excepts.contains(principal)) {
            this._excepts.add(principal);
        }
    }

    public void removeAllExceptPrincipals() throws CollaborationException {
        this._excepts.clear();
    }
}

