/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import com.sun.im.service.util.StringUtility;
import com.sun.im.service.util.XMLProcessingException;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLUtil {
    private static DocumentBuilderFactory _fac = DocumentBuilderFactory.newInstance();
    private static final String basicIndent = " ";

    private XMLUtil() {
    }

    public static Document parse(InputStream in) throws XMLProcessingException, IOException {
        try {
            DocumentBuilder builder = _fac.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (SAXException se) {
            throw new XMLProcessingException("Error while parsing the stream : " + se.toString());
        }
        catch (ParserConfigurationException pce) {
            throw new XMLProcessingException("Error while parsing the stream : " + pce.toString());
        }
    }

    protected static Document parse(InputSource in) throws XMLProcessingException, IOException {
        try {
            DocumentBuilder builder = _fac.newDocumentBuilder();
            return builder.parse(in);
        }
        catch (SAXException se) {
            throw new XMLProcessingException("Error while parsing the stream : " + se.toString());
        }
        catch (ParserConfigurationException pce) {
            throw new XMLProcessingException("Error while parsing the stream : " + pce.toString());
        }
    }

    public static Document parse(String in) throws XMLProcessingException {
        try {
            StringReader strReader = new StringReader(in);
            strReader.ready();
            InputSource inputSrc = new InputSource(strReader);
            return XMLUtil.parse(inputSrc);
        }
        catch (IOException ioe) {
            throw new XMLProcessingException("Error while parsing the stream : " + ioe.toString());
        }
    }

    public static void appendElementTag(StringBuffer buf, String namespace, String tagName, boolean endTag, boolean closeTag) {
        if (endTag) {
            buf.append("</");
        } else {
            buf.append("<");
        }
        buf.append(namespace);
        buf.append(tagName);
        if (endTag || closeTag) {
            buf.append(">");
        }
    }

    public static String getElementText(Element e) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 3) continue;
            return n.getNodeValue();
        }
        return null;
    }

    public static String getNamespacePrefix(Element elt) throws XMLProcessingException {
        String s = elt.getTagName();
        int c = s.indexOf(58);
        if (c < 0) {
            throw new XMLProcessingException("unexpected element: " + s);
        }
        return s.substring(c);
    }

    public static String dumpNodeAsString(Node node) throws XMLProcessingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtil.dumpNode(node, baos);
            return baos.toString();
        }
        catch (IOException e) {
            throw new XMLProcessingException(e.toString());
        }
    }

    public static void dumpNode(Node node, OutputStream outputStream) throws XMLProcessingException, IOException {
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        XMLUtil.unparse(node, outWriter, 0);
        outWriter.write("\n");
        outWriter.flush();
    }

    public static void dumpNode(Node node, String filename) throws XMLProcessingException, IOException {
        FileOutputStream stream = new FileOutputStream(filename);
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8"));
        XMLUtil.unparse(node, outWriter, 0);
        outWriter.flush();
        stream.flush();
        stream.close();
    }

    public static void dumpChildrenOfNode(Node node, OutputStream outputStream) throws XMLProcessingException, IOException {
        BufferedWriter outWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            XMLUtil.unparse(child, outWriter, 0);
            outWriter.write("\n");
            outWriter.flush();
        }
    }

    public static void dumpChildrenOfNode(Node node, String filename) throws XMLProcessingException, IOException {
        FileOutputStream stream = new FileOutputStream(filename);
        XMLUtil.dumpChildrenOfNode(node, stream);
        stream.flush();
        stream.close();
    }

    private static void unparse(Node node, Writer outWriter, int indent) throws XMLProcessingException {
        short type = node.getNodeType();
        try {
            switch (type) {
                case 2: {
                    String attribValue = node.getNodeValue();
                    if (attribValue == null) {
                        outWriter.write(basicIndent + node.getNodeName() + "=\"!!!null!!!\"");
                        break;
                    }
                    outWriter.write(basicIndent + node.getNodeName() + "=\"" + XMLUtil.escape(attribValue, true) + "\"");
                    break;
                }
                case 4: {
                    throw new XMLProcessingException("Tag exception : CDATA");
                }
                case 8: {
                    throw new XMLProcessingException("Tag exception : COMMENT");
                }
                case 11: {
                    throw new XMLProcessingException("Tag exception : DOC_FRAG");
                }
                case 9: {
                    outWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>");
                    if (node.hasChildNodes()) {
                        for (Node curChild = node.getFirstChild(); curChild != null; curChild = curChild.getNextSibling()) {
                            outWriter.write("\n");
                            XMLUtil.unparse(curChild, outWriter, indent);
                        }
                    }
                    break;
                }
                case 10: {
                    outWriter.write("<!DOCTYPE " + node.getNodeName() + ">\n");
                    break;
                }
                case 1: {
                    outWriter.write("<" + node.getNodeName());
                    NamedNodeMap attribsnode = node.getAttributes();
                    for (int i = 0; i < attribsnode.getLength(); ++i) {
                        Node attrNode = attribsnode.item(i);
                        String attrValue = attrNode.getNodeValue();
                        if (attrValue == null) {
                            outWriter.write(basicIndent + attrNode.getNodeName() + "=\"!!!null!!!\"");
                            continue;
                        }
                        outWriter.write(basicIndent + attrNode.getNodeName() + "=\"" + XMLUtil.escape(attrValue, true) + "\"");
                    }
                    if (node.hasChildNodes()) {
                        outWriter.write(">");
                        Node firstChild = node.getFirstChild();
                        Node lastChild = node.getLastChild();
                        for (Node curChild = node.getFirstChild(); curChild != null; curChild = curChild.getNextSibling()) {
                            if (curChild.getNodeType() != 3) {
                                if (curChild == firstChild) {
                                    outWriter.write("\n");
                                    XMLUtil.outputIndentation(outWriter, indent + 1);
                                } else if (curChild.getPreviousSibling() != null && curChild.getPreviousSibling().getNodeType() != 3) {
                                    outWriter.write("\n");
                                    XMLUtil.outputIndentation(outWriter, indent + 1);
                                }
                            }
                            XMLUtil.unparse(curChild, outWriter, indent + 1);
                        }
                        if (firstChild.getNodeType() != 3 && lastChild.getNodeType() != 3) {
                            outWriter.write("\n");
                            XMLUtil.outputIndentation(outWriter, indent);
                        }
                        outWriter.write("</" + node.getNodeName() + ">");
                        break;
                    }
                    outWriter.write(" />");
                    break;
                }
                case 6: {
                    throw new XMLProcessingException("Tag exception : ENTITY");
                }
                case 5: {
                    throw new XMLProcessingException("Tag exception : ENTTIY_REF");
                }
                case 12: {
                    throw new XMLProcessingException("Tag exception : NOTATION");
                }
                case 7: {
                    XMLUtil.outputIndentation(outWriter, indent);
                    outWriter.write("<?" + node.getNodeName() + basicIndent + node.getNodeValue());
                    if (node.hasChildNodes()) {
                        outWriter.write(">");
                        XMLUtil.unparse(node.getFirstChild(), outWriter, indent + 1);
                        outWriter.write("\n");
                        XMLUtil.outputIndentation(outWriter, indent);
                        outWriter.write("</" + node.getNodeName() + ">");
                        break;
                    }
                    outWriter.write(" ?>\n");
                    break;
                }
                case 3: {
                    String nodeValue = node.getNodeValue();
                    outWriter.write(XMLUtil.escape(nodeValue));
                    break;
                }
                default: {
                    throw new XMLProcessingException("Tag exception : UNSUPPORTED NODE : " + type);
                }
            }
        }
        catch (Exception e) {
            throw new XMLProcessingException("An error occured while dumping : " + e.toString());
        }
    }

    private static void outputIndentation(Writer outWriter, int indent) throws XMLProcessingException, IOException {
        for (int i = 0; i < indent; ++i) {
            outWriter.write(basicIndent);
        }
    }

    private static Node stripWhiteSpaceNodes(Node node) {
        boolean lastNodeRemoved = false;
        Node curNode = node.getFirstChild();
        while (curNode != null) {
            if (curNode.hasChildNodes()) {
                XMLUtil.stripWhiteSpaceNodes(curNode);
            }
            if (curNode.getNodeType() == 3 && curNode.getNodeValue() != null && (curNode.getNodeValue().trim().length() == 0 || curNode.getNodeValue().trim().endsWith("\n") || curNode.getNodeValue().trim().startsWith("\n")) && (curNode.getPreviousSibling() != null || curNode.getNextSibling() != null)) {
                node.removeChild(curNode);
                lastNodeRemoved = true;
            }
            curNode = lastNodeRemoved ? node.getFirstChild() : curNode.getNextSibling();
            lastNodeRemoved = false;
        }
        return node;
    }

    private static String escape(String original, boolean escapeQuotes) {
        String str2Return = StringUtility.substitute(original, "&", "&amp;");
        str2Return = StringUtility.substitute(str2Return, "<", "&lt;");
        str2Return = StringUtility.substitute(str2Return, ">", "&gt;");
        if (escapeQuotes) {
            str2Return = StringUtility.substitute(str2Return, "\"", "&quot;");
        }
        return str2Return;
    }

    private static String escape(String original) {
        return XMLUtil.escape(original, false);
    }

    public static void insertNodeFromString(Document doc, Node node, String str) throws XMLProcessingException, IOException {
        Node parentNode;
        Document dummyDoc = XMLUtil.createDocFromString(str);
        if (dummyDoc != null && (parentNode = dummyDoc.getFirstChild()) != null) {
            for (Node curNode = parentNode.getFirstChild(); curNode != null; curNode = curNode.getNextSibling()) {
                node.appendChild(doc.importNode(curNode, true));
            }
        }
    }

    public static Document createDocFromString(String str) throws XMLProcessingException {
        Object dummyDoc = null;
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("<?xml version=\"1.0\"?>");
        strBuff.append("<dummyDocument>");
        strBuff.append(str);
        strBuff.append("</dummyDocument>");
        return XMLUtil.parse(strBuff.toString());
    }

    public static String getPrefixFromXMLString(String sElement) throws XMLProcessingException {
        int ix1 = sElement.indexOf(60);
        if (ix1 >= 0) {
            int ix2 = sElement.indexOf(58);
            if (ix2 > ix1 + 1) {
                return sElement.substring(ix1 + 1, ix2);
            }
            throw new XMLProcessingException("invalid XML: " + sElement);
        }
        throw new XMLProcessingException("invalid XML: " + sElement);
    }

    public static boolean isNamespaceAttribute(Node n) {
        String prefix = n.getPrefix();
        if (prefix != null) {
            return prefix.equals("xmlns");
        }
        return n.getNodeName().startsWith("xmlns:");
    }

    public static String replacePrefix(String in, String oldPrefix, String newPrefix) {
        String out = in;
        out = StringUtility.substitute(out, "<" + oldPrefix + ":", "<" + newPrefix + ":");
        out = StringUtility.substitute(out, "</" + oldPrefix + ":", "</" + newPrefix + ":");
        return out;
    }

    static {
        _fac.setValidating(false);
        _fac.setNamespaceAware(false);
        _fac.setIgnoringElementContentWhitespace(true);
        _fac.setIgnoringComments(true);
        _fac.setCoalescing(true);
    }
}

