/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import java.text.Collator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class StringUtility {
    public static final String lineSeparator = System.getProperty("line.separator");
    private static final Collator collator = Collator.getInstance();

    public static final String getBooleanString(boolean b) {
        if (b) {
            return "true";
        }
        return "false";
    }

    public static final boolean getBoolean(String str) throws IllegalArgumentException {
        if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("n") || str.equalsIgnoreCase("no") || str.equalsIgnoreCase("deny") || str.equalsIgnoreCase("off")) {
            return false;
        }
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("y") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("allow") || str.equalsIgnoreCase("on")) {
            return true;
        }
        throw new IllegalArgumentException("Not a boolean: " + str);
    }

    public static final boolean getBoolean(String str, boolean defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("n") || str.equalsIgnoreCase("no") || str.equalsIgnoreCase("deny") || str.equalsIgnoreCase("off")) {
            return false;
        }
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("y") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("allow") || str.equalsIgnoreCase("on")) {
            return true;
        }
        return defaultValue;
    }

    public static final String replaceString(String replace, String with, String in) {
        int start = 0;
        int foundAt = in.indexOf(replace, start);
        if (foundAt < 0) {
            return in;
        }
        StringBuffer ret = new StringBuffer();
        int len = replace.length();
        do {
            ret.append(in.substring(start, foundAt));
            ret.append(with);
        } while ((foundAt = in.indexOf(replace, start = foundAt + len)) >= 0);
        ret.append(in.substring(start));
        return ret.toString();
    }

    public static final Object[] sort(Object[] a) {
        if (a == null || a.length <= 1) {
            return a;
        }
        return StringUtility._sort(a, 0, a.length - 1);
    }

    public static final Vector sort(Vector v) {
        if (v == null || v.size() <= 1) {
            return v;
        }
        return StringUtility._sort(v, 0, v.size() - 1);
    }

    private static final Object[] _sort(Object[] a, int lo0, int hi0) {
        if (a == null || a.length <= 1) {
            return a;
        }
        if (lo0 < hi0) {
            int q = StringUtility.partition(a, lo0, hi0);
            if (q == hi0) {
                --q;
            }
            StringUtility._sort(a, lo0, q);
            StringUtility._sort(a, q + 1, hi0);
        }
        return a;
    }

    private static final Vector _sort(Vector v, int lo0, int hi0) {
        if (v == null || v.size() <= 1) {
            return v;
        }
        if (lo0 < hi0) {
            int q = StringUtility.partition(v, lo0, hi0);
            if (q == hi0) {
                --q;
            }
            StringUtility._sort(v, lo0, q);
            StringUtility._sort(v, q + 1, hi0);
        }
        return v;
    }

    private static final String getString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    private static final int partition(Vector v, int p, int r) {
        String pivot = StringUtility.getString(v.elementAt(p));
        int lo = p;
        int hi = r;
        while (true) {
            String strhi = StringUtility.getString(v.elementAt(hi));
            while (collator.compare(strhi, pivot) >= 0 && lo < hi) {
                strhi = StringUtility.getString(v.elementAt(--hi));
            }
            String strlo = StringUtility.getString(v.elementAt(lo));
            while (collator.compare(strlo, pivot) < 0 && lo < hi) {
                strlo = StringUtility.getString(v.elementAt(++lo));
            }
            if (lo >= hi) break;
            Object temp = v.elementAt(lo);
            v.setElementAt(v.elementAt(hi), lo);
            v.setElementAt(temp, hi);
        }
        return hi;
    }

    private static final int partition(Object[] a, int p, int r) {
        String pivot = StringUtility.getString(a[p]);
        int lo = p;
        int hi = r;
        while (true) {
            String strhi = StringUtility.getString(a[hi]);
            while (collator.compare(strhi, pivot) >= 0 && lo < hi) {
                strhi = StringUtility.getString(a[--hi]);
            }
            String strlo = StringUtility.getString(a[lo]);
            while (collator.compare(strlo, pivot) < 0 && lo < hi) {
                strlo = StringUtility.getString(a[++lo]);
            }
            if (lo >= hi) break;
            Object temp = a[lo];
            a[lo] = a[hi];
            a[hi] = temp;
        }
        return hi;
    }

    public static String substitute(String in, String swapOut, String swapIn) {
        if (in == null || in.length() <= 0) {
            return in;
        }
        if (swapOut == null || swapOut.length() <= 0) {
            return in;
        }
        if (swapIn == null) {
            return in;
        }
        if (swapOut.equals(swapIn)) {
            return in;
        }
        String cur = in;
        StringBuffer out = new StringBuffer();
        int swapOutLen = swapOut.length();
        int offset = -1;
        while ((offset = cur.indexOf(swapOut)) >= 0) {
            out.append(cur.substring(0, offset));
            out.append(swapIn);
            cur = cur.substring(offset + swapOutLen);
        }
        if (out != null) {
            out.append(cur);
            return out.toString();
        }
        return in;
    }

    public static String substitute(String in, char c, String swapIn) {
        return StringUtility.substitute(in, String.valueOf(c), swapIn);
    }

    public static String substitute(String in, String swapOut, char c) {
        return StringUtility.substitute(in, swapOut, String.valueOf(c));
    }

    public static String substituteMacros(String in, Map attributes, String header, String trailer) {
        String out = in;
        Iterator i = attributes.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            out = StringUtility.substitute(out, header + key + trailer, attributes.get(key).toString());
        }
        return out;
    }

    public static String substituteMacros(String in, String header, String trailer, String substitution) {
        int offset;
        String cur = in;
        StringBuffer buf = null;
        int headerLen = header.length();
        int trailerLen = trailer.length();
        while ((offset = cur.indexOf(header)) >= 0) {
            if (buf == null) {
                buf = new StringBuffer(cur.substring(0, offset));
            } else {
                buf.append(cur.substring(0, offset));
            }
            buf.append(substitution);
            if ((offset = (cur = cur.substring(offset + headerLen)).indexOf(trailer)) <= 0) continue;
            cur = cur.substring(offset + trailerLen);
        }
        if (buf != null) {
            buf.append(cur);
            return buf.toString();
        }
        return in;
    }

    public static String quoteSpecialCharacters(String in) {
        int inlen = in.length();
        char[] inchars = new char[inlen];
        StringBuffer out = new StringBuffer(inlen);
        in.getChars(0, inlen, inchars, 0);
        for (int i = 0; i < inchars.length; ++i) {
            if (inchars[i] == '@' || inchars[i] == '\\') {
                out.append('\\');
            }
            out.append(inchars[i]);
        }
        return out.toString();
    }

    public static String unquoteSpecialCharacters(String in) {
        int inlen = in.length();
        char[] inchars = new char[inlen];
        StringBuffer out = new StringBuffer(inlen);
        in.getChars(0, inlen, inchars, 0);
        for (int i = 0; i < inchars.length; ++i) {
            if (inchars[i] == '\\') {
                if (i >= inchars.length - 1) continue;
                out.append(inchars[++i]);
                continue;
            }
            out.append(inchars[i]);
        }
        return out.toString();
    }

    public static String getDomainFromAddress(String in, String defaultDomain) {
        if (in == null) {
            return null;
        }
        int i = in.lastIndexOf(64);
        if (i > 0 && in.charAt(i - 1) != '\\') {
            return in.substring(i + 1);
        }
        return defaultDomain;
    }

    public static String getLocalPartFromAddress(String in) {
        int i = in.lastIndexOf(64);
        if (i > 0 && in.charAt(i - 1) != '\\') {
            return in.substring(0, i);
        }
        return in;
    }

    public static String appendDomainToAddress(String in, String defaultDomain) {
        int i = in.lastIndexOf(64);
        if (i > 0 && in.charAt(i - 1) != '\\') {
            return in;
        }
        return in + "@" + defaultDomain;
    }

    public static String appendResourceToAddress(String in, String resource) {
        int i = in.lastIndexOf(47);
        if (i > 0) {
            return in;
        }
        return in + "/" + resource;
    }

    public static String removeResource(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(47);
        if (index != -1) {
            return str.substring(0, index);
        }
        return str;
    }

    public static String getResource(String str) {
        if (str == null) {
            return null;
        }
        int index = str.indexOf(47);
        if (index != -1) {
            return str.substring(index + 1);
        }
        return null;
    }

    public static boolean isValidEmailAddress(String s) {
        int len = s.length();
        int i = s.lastIndexOf(64);
        return len > 3 && i > 0 && i < len - 1 && s.charAt(i - 1) != '\\';
    }

    public static boolean isValidPhoneNumber(String s) {
        char[] c = s.toCharArray();
        for (int i = 0; i < c.length; ++i) {
            if (Character.isDigit(c[i]) || c[i] == '+' || c[i] == '-' || Character.isWhitespace(c[i])) continue;
            return false;
        }
        return s.length() >= 3;
    }

    public static LinkedList getFirstCharAndIndexOf(String s, LinkedList charToSearch) {
        LinkedList<Object> toReturn = new LinkedList<Object>();
        toReturn.add(0, new Integer(-1));
        toReturn.add(1, new String(""));
        for (int i = 0; i < charToSearch.size(); ++i) {
            int tmpPos = s.indexOf((String)charToSearch.get(i));
            if (tmpPos < 0 || (Integer)toReturn.get(0) <= tmpPos && (Integer)toReturn.get(0) != -1) continue;
            toReturn.set(0, new Integer(tmpPos));
            toReturn.set(1, new String((String)charToSearch.get(i)));
        }
        return toReturn;
    }

    public static final String getFirstAttr(Object o) {
        Set e = null;
        try {
            e = (Set)o;
            if (e == null || e.isEmpty()) {
                return null;
            }
            return (String)e.iterator().next();
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public static final String getStringAttr(Object o, String def) {
        String val = StringUtility.getFirstAttr(o);
        return val == null ? def : val;
    }

    public static final boolean contains(String[] strArray, String str) {
        for (int i = 0; i < strArray.length; ++i) {
            if (!strArray[i].equals(str)) continue;
            return true;
        }
        return false;
    }
}

