/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import com.sun.im.service.util.HostPort;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Http
extends Thread {
    Socket s;
    static final String index = "index.html";
    private File rootFile;
    private static Hashtable _servers = new Hashtable();

    public Http(File file, Socket s) {
        this.s = s;
        this.rootFile = file;
    }

    public static void main(String[] args) {
        String port = "9980";
        String root = ".";
        for (int x = 0; x < args.length; ++x) {
            if (args[x].equals("-port")) {
                port = args[x++];
            }
            if (!args[x].equals("-root")) continue;
            root = args[x++];
        }
        HostPort hp = new HostPort(port, 9980);
        try {
            Http.startServ(root, hp);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void startServ(String filepath, HostPort hp) throws IOException {
        HTTPAcceptor acceptor = (HTTPAcceptor)_servers.get(hp);
        if (acceptor != null) {
            return;
        }
        File file = new File(filepath);
        if (!file.exists()) {
            return;
        }
        acceptor = new HTTPAcceptor(file, hp);
        acceptor.startServ();
        Thread t = new Thread(acceptor);
        _servers.put(hp, acceptor);
        t.setDaemon(true);
        t.start();
    }

    public static void stopServ(HostPort hp) {
        HTTPAcceptor acceptor = (HTTPAcceptor)_servers.get(hp);
        if (acceptor != null) {
            acceptor.stopServ();
        }
    }

    public void run() {
        block25: {
            String version = "";
            try {
                PrintStream os = new PrintStream(new BufferedOutputStream(this.s.getOutputStream()));
                BufferedReader is = new BufferedReader(new InputStreamReader(this.s.getInputStream()));
                String line = is.readLine();
                if (line == null) {
                    return;
                }
                StringTokenizer st = new StringTokenizer(line);
                String method = st.nextToken();
                String fileName = st.nextToken();
                if (st.hasMoreTokens()) {
                    version = st.nextToken();
                }
                while ((line = is.readLine()) != null && !line.trim().equals("")) {
                }
                if (method.equals("GET") || method.equals("HEAD")) {
                    File file;
                    FileInputStream fs = null;
                    boolean headOnly = false;
                    if (method.equals("HEAD")) {
                        headOnly = true;
                    }
                    try {
                        if (fileName.endsWith("/")) {
                            fileName = fileName + index;
                        }
                        fileName = fileName.substring(1, fileName.length());
                        if (this.rootFile.isFile()) {
                            if (this.rootFile.getName().equals(fileName)) {
                                file = this.rootFile;
                                fs = new FileInputStream(file);
                            } else {
                                file = null;
                            }
                        } else if (this.rootFile.isDirectory()) {
                            file = new File(this.rootFile, fileName);
                            if (file.isDirectory()) {
                                file = new File(file, index);
                            }
                            fs = new FileInputStream(file);
                        } else {
                            file = null;
                        }
                    }
                    catch (IOException e) {
                        file = null;
                        if (version.startsWith("HTTP/")) {
                            String header = "HTTP/1.0 404 File Not Found\r\n";
                            header = header + this.standardHeaders();
                            header = header + "Content-type: text/html\r\n\r\n";
                            os.print(header);
                        }
                        os.println("<HTML><HEAD><TITLE>File Not Found</TITLE><HEAD>");
                        os.println("<BODY><H1>HTTP Error 404: File Not Found</H1></BODY></HTML>");
                        os.close();
                    }
                    if (file != null) {
                        if (version.startsWith("HTTP/")) {
                            String header = "HTTP/1.0 200 OK\r\n";
                            header = header + this.standardHeaders();
                            header = header + "Content-length: " + file.length() + "\r\n";
                            header = header + "Content-type: " + this.contentType(fileName) + "\r\n\r\n";
                            os.print(header);
                        }
                        if (!headOnly) {
                            int r;
                            byte[] data = new byte[1024];
                            while ((r = fs.read(data)) > 0) {
                                os.write(data, 0, r);
                            }
                        }
                        os.flush();
                        os.close();
                        fs.close();
                        this.s.close();
                    }
                    break block25;
                }
                if (version.startsWith("HTTP/")) {
                    String header = "HTTP/1.0 501 Not Implemented\r\n";
                    header = header + this.standardHeaders();
                    header = header + "Content-type: text/html\r\n\r\n";
                    os.print(header);
                }
                os.println("<HTML><HEAD><TITLE>Not Implemented</TITLE><HEAD>");
                os.println("<BODY><H1>HTTP Error 501: Not Implemented</H1></BODY></HTML>");
                os.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            this.s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String standardHeaders() {
        Date now = new Date();
        return "Date: " + now + "\r\nServer: iim http 1.0\r\n";
    }

    private String contentType(String filename) {
        String[] a = new String[]{".html", "text/html", ".htm", "text/html", ".txt", "text/plain", ".jar", "application/octet-stream", ".class", "application/octet-stream", ".gif", "image/gif", ".jpg", "image/jpeg", ".jpeg", "image/jpeg", ".jnlp", "application/x-java-jnlp-file", ".nlc", "application/x-x509-ca-cert"};
        for (int x = 0; x < a.length - 1; x += 2) {
            if (!filename.endsWith(a[x])) continue;
            return a[x + 1];
        }
        return "application/octet-stream";
    }

    static class HTTPAcceptor
    implements Runnable {
        private HostPort _hp;
        private boolean running;
        private ServerSocket serv;
        private File file;

        HTTPAcceptor(File f, HostPort hp) {
            this._hp = hp;
            this.file = f;
        }

        public void startServ() throws IOException {
            int port = this._hp.getPort();
            InetAddress i = this._hp.getHost();
            this.serv = new ServerSocket(port, 10, i);
            this.running = true;
            if (port == 0) {
                this._hp.setPort(this.serv.getLocalPort());
            }
        }

        public void run() {
            try {
                while (this.running) {
                    Http n = new Http(this.file, this.serv.accept());
                    n.setDaemon(true);
                    n.start();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.stopServ();
        }

        boolean isRunning() {
            return this.running;
        }

        void stopServ() {
            if (!this.running) {
                return;
            }
            this.running = false;
            if (this.serv != null) {
                try {
                    this.serv.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.serv = null;
        }
    }
}

