/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import com.sun.im.service.util.StringUtility;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;

public class HtmlUtility {
    public static final String HTML_BEGIN = "<html><body>";
    public static final String HTML_END = "</body></html>";
    private static final String ID_HTTP = "http://";
    private static final String ID_WWW = "www.";
    private static final char ID_TAGSTART = '<';
    private static final char ID_TAGEND = '>';
    public static final String BODY_BEGIN = "<body";
    public static final String ID_COLOR_BLACK = "color=\"#000000\"";
    public static final String ID_COLOR_BLUE = "color=\"#0000ff\"";
    public static final String ID_COLOR_GREEN = "color=\"#00ff00\"";
    public static final String ID_COLOR_RED = "color=\"#ff0000\"";
    public static final String ID_COLOR_WHITE = "color=\"#ffffff\"";
    public static final String ID_COLOR_PINK = "color=\"#ff00ff\"";
    public static final int FONT_COLOR_BLACK = 0;
    public static final int FONT_COLOR_BLUE = 1;
    public static final int FONT_COLOR_RED = 2;
    public static final int FONT_COLOR_WHITE = 3;
    public static final int FONT_COLOR_GREEN = 4;
    public static final int FONT_COLOR_PINK = 5;
    private static final Pattern PATTERN_MIDDLE_SPACE = Pattern.compile("([^ ])[ ][ ]+([^ ])");
    private static final Pattern PATTERN_START_SPACE = Pattern.compile("\\A[ ]+");
    private static final Pattern PATTERN_END_SPACE = Pattern.compile("[ ]+\\z");
    private static final char[] unescapedChars = new char[]{'<', '>', '\"', '&'};
    private static final String[] escapedStrings = new String[]{"&lt;", "&gt;", "&quot;", "&amp;"};

    public static final String getFontColor(int color, String size) {
        StringBuffer buf = new StringBuffer("<font ");
        switch (color) {
            case 0: {
                buf.append(ID_COLOR_BLACK);
                break;
            }
            case 1: {
                buf.append(ID_COLOR_BLUE);
                break;
            }
            case 2: {
                buf.append(ID_COLOR_RED);
                break;
            }
            case 3: {
                buf.append(ID_COLOR_WHITE);
                break;
            }
            case 4: {
                buf.append(ID_COLOR_GREEN);
                break;
            }
            case 5: {
                buf.append(ID_COLOR_PINK);
                break;
            }
            default: {
                buf.append(ID_COLOR_BLACK);
            }
        }
        if (size != null) {
            buf.append(" size=");
            buf.append(size);
        }
        buf.append(">");
        return buf.toString();
    }

    public static final String createImageTag(String src, String alt) {
        String s = "<IMG SRC=\"" + src + "\"" + " ALT=\"" + alt + "\">";
        return s;
    }

    public static final String getTagContent(String s, HTML.Tag tag) {
        String tmpStr = s.toLowerCase();
        int startOpeningTag = tmpStr.indexOf("<" + tag);
        if (startOpeningTag < 0) {
            return s;
        }
        int endOpeningTag = startOpeningTag + tmpStr.substring(startOpeningTag).indexOf(">");
        int startClosingTag = endOpeningTag + tmpStr.substring(endOpeningTag + 1).lastIndexOf("</" + tag);
        if (startClosingTag < 0) {
            return s;
        }
        return s.substring(endOpeningTag + 1, startClosingTag).trim();
    }

    private static final String removeTagAndContent(String s, HTML.Tag tag) {
        String tmpStr = s.toLowerCase();
        StringBuffer buf = new StringBuffer();
        int startOpeningTag = tmpStr.indexOf("<" + tag);
        if (startOpeningTag < 0) {
            return s;
        }
        buf.append(s.substring(0, startOpeningTag + 1));
        int endOpeningTag = startOpeningTag + tmpStr.substring(startOpeningTag).indexOf(">");
        int startClosingTag = endOpeningTag + tmpStr.substring(endOpeningTag + 1).lastIndexOf("</" + tag);
        int endClosingTag = startClosingTag + tmpStr.substring(startClosingTag).indexOf(">");
        if (endClosingTag < 0) {
            return s;
        }
        buf.append(s.substring(endClosingTag + 1));
        return buf.toString().trim();
    }

    private static final String removeFirstTagOnly(String s, HTML.Tag tag) {
        String tmpStr = s.toLowerCase();
        StringBuffer buf = new StringBuffer();
        int startOpeningTag = tmpStr.indexOf("<" + tag);
        if (startOpeningTag < 0) {
            return s;
        }
        buf.append(s.substring(0, startOpeningTag));
        int endOpeningTag = startOpeningTag + tmpStr.substring(startOpeningTag).indexOf(">");
        int startClosingTag = endOpeningTag + tmpStr.substring(endOpeningTag + 1).indexOf("</" + tag);
        if (startClosingTag < 0) {
            return s;
        }
        buf.append(s.substring(endOpeningTag + 1, startClosingTag - 1));
        int endClosingTag = startClosingTag + tmpStr.substring(startClosingTag).indexOf(">");
        if (endClosingTag < 0) {
            return s;
        }
        buf.append(s.substring(endClosingTag + 1));
        return buf.toString().trim();
    }

    private static final String stripUnsupportedTags(String s) {
        HTML.Tag[] unsupportedTags = new HTML.Tag[]{HTML.Tag.SCRIPT};
        String tmpStr = s;
        for (int i = 0; i < unsupportedTags.length; ++i) {
            while (tmpStr.toLowerCase().indexOf(unsupportedTags[i].toString()) > -1) {
                tmpStr = HtmlUtility.removeTagAndContent(tmpStr, unsupportedTags[i]);
            }
        }
        return tmpStr;
    }

    public static final String getContent(String s) {
        String content = HtmlUtility.getTagContent(s, HTML.Tag.BODY);
        return HtmlUtility.stripUnsupportedTags(content);
    }

    public static final String[] splitFirstParagraph(String s, HTML.Tag tag) {
        if (s != null) {
            int tagLen = tag.toString().length();
            if (s.length() > tagLen && s.substring(0, tagLen + 1).equalsIgnoreCase("<" + tag)) {
                String[] parts = new String[]{HtmlUtility.getTagContent(s, tag), HtmlUtility.removeTagAndContent(s, tag)};
                return parts;
            }
        }
        return null;
    }

    public static final String getPBody(String s) {
        return HtmlUtility.getTagContent(s, HTML.Tag.P);
    }

    public static final String getBody(String s) {
        String body = HtmlUtility.getTagContent(s, HTML.Tag.BODY);
        return HtmlUtility.removeFirstTagOnly(body, HTML.Tag.P);
    }

    public static final String convertLinks(String body) {
        String originalBody = body;
        StringBuffer buf = new StringBuffer();
        String tmpStr = null;
        int a = 0;
        int b = 0;
        while (a < body.length()) {
            tmpStr = body.substring(a);
            if (tmpStr.charAt(0) == '<') {
                b = a + tmpStr.indexOf(62);
                if (b == -1) {
                    return originalBody;
                }
                buf.append(body.substring(a, ++b));
            } else if (tmpStr.startsWith(ID_HTTP)) {
                b = a + HtmlUtility.getEndOfURL(tmpStr);
                if (b == -1) {
                    return originalBody;
                }
                buf.append(HtmlUtility.createLink(body.substring(a, b), body.substring(a, b)));
            } else if (tmpStr.startsWith(ID_WWW)) {
                b = a + HtmlUtility.getEndOfURL(tmpStr);
                if (b == -1) {
                    return originalBody;
                }
                buf.append(HtmlUtility.createLink(ID_HTTP + body.substring(a, b), body.substring(a, b)));
            } else {
                buf.append(body.substring(a, ++b));
            }
            a = b;
        }
        return buf.toString();
    }

    private static int getEndOfURL(String str) {
        int i = str.indexOf(60);
        int j = str.indexOf(32);
        if (i == -1 && j > -1) {
            return j;
        }
        if (i > -1 && j == -1) {
            return i;
        }
        if (i > -1 && j > -1) {
            return Math.min(i, j);
        }
        return -1;
    }

    public static final String convertLinks2(String body) {
        int tmp = 0;
        while ((tmp = body.indexOf(ID_HTTP, tmp)) >= 0) {
            int tmp2 = body.indexOf(" ", tmp);
            String link = body.substring(tmp, tmp2);
            if ((tmp2 = link.indexOf("<")) >= 0) {
                link = link.substring(0, tmp2);
            }
            body = StringUtility.replaceString(link, HtmlUtility.createLink(link, link), body);
            tmp += 2 * link.length() + 8;
        }
        return body;
    }

    public static final String convertFont(String s) {
        if (s.equals("12")) {
            return "2\"";
        }
        if (s.equals("14")) {
            return "3\"";
        }
        if (s.equals("18")) {
            return "4\"";
        }
        if (s.equals("24")) {
            return "5\"";
        }
        if (s.equals("32")) {
            return "6\"";
        }
        return "3\"";
    }

    public static final String convertFontSize(boolean[] list, String s) {
        if (list[0]) {
            s = StringUtility.replaceString("size=\"12\"", "size=\"2\"", s);
        }
        if (list[1]) {
            s = StringUtility.replaceString("size=\"14\"", "size=\"3\"", s);
        }
        if (list[2]) {
            s = StringUtility.replaceString("size=\"18\"", "size=\"4\"", s);
        }
        if (list[3]) {
            s = StringUtility.replaceString("size=\"24\"", "size=\"5\"", s);
        }
        if (list[4]) {
            s = StringUtility.replaceString("size=\"32\"", "size=\"6\"", s);
        }
        return s;
    }

    public static final void insertImage(Document d, int pos, String src, String alt, int width, int height, int vspace, int border) {
        SimpleAttributeSet a = new SimpleAttributeSet();
        a.addAttribute(StyleConstants.NameAttribute, HTML.Tag.IMG);
        a.addAttribute(HTML.Attribute.SRC, src);
        a.addAttribute(HTML.Attribute.ALT, alt);
        try {
            d.insertString(pos, "image", a);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static final void insertImage(Document d, int pos, String src, String alt) {
        HtmlUtility.insertImage(d, pos, src, alt, 0, 0, 0, 0);
    }

    public static final String createLink(String link, String name) {
        StringBuffer buf = new StringBuffer("<a href=");
        buf.append("\"");
        buf.append(link);
        buf.append("\"");
        buf.append(">");
        buf.append(name.trim());
        buf.append("</a>");
        return buf.toString();
    }

    public static final String createFakeLink(String lnk) {
        return "<u><font color=\"" + HtmlUtility.getFontColor(1, null) + "\">" + lnk + "</font></u>";
    }

    public static final String formatUrl(String url) {
        if (url.equals("")) {
            return "";
        }
        if (url.startsWith(ID_HTTP)) {
            return url;
        }
        if (url.startsWith("file:///")) {
            return url;
        }
        return ID_HTTP + url;
    }

    public static final int getPosAfterBody(String s) {
        int startPos = s.indexOf(BODY_BEGIN);
        if (startPos == -1) {
            return -1;
        }
        int endPos = s.substring(startPos).indexOf(">");
        if (endPos == -1) {
            return -1;
        }
        return startPos + endPos + 1;
    }

    public static String escape(String s) {
        for (int i = 0; i < unescapedChars.length - 1; ++i) {
            s = StringUtility.substitute(s, unescapedChars[i], escapedStrings[i]);
        }
        return s;
    }

    public static String unescape(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        for (int i = 0; i < escapedStrings.length - 1; ++i) {
            s = StringUtility.substitute(s, escapedStrings[i], unescapedChars[i]);
        }
        return s;
    }

    public static final String substitute(String s, String from, String to) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        if (from == null || from.length() <= 0) {
            return s;
        }
        if (to == null) {
            return s;
        }
        if (from == to) {
            return s;
        }
        int a = 0;
        int b = 0;
        int c = 0;
        int maxA = s.length() - 1;
        StringBuffer buf = new StringBuffer();
        String strToProcess = s.trim();
        String unescapedStr = null;
        while (strToProcess.length() > 0) {
            b = strToProcess.indexOf(60);
            if (b >= 0) {
                unescapedStr = HtmlUtility.unescape(strToProcess.substring(0, b));
                while ((c = unescapedStr.indexOf(from)) >= 0) {
                    buf.append(HtmlUtility.escape(unescapedStr.substring(0, c)));
                    buf.append(to);
                    unescapedStr = unescapedStr.substring(c + from.length());
                }
                buf.append(HtmlUtility.escape(unescapedStr));
                a = b;
                b = strToProcess.indexOf(62, a);
                if (b < 0) {
                    return s;
                }
                buf.append(strToProcess.substring(a, b + 1));
            } else {
                unescapedStr = HtmlUtility.unescape(strToProcess);
                while ((c = unescapedStr.indexOf(from)) >= 0) {
                    buf.append(HtmlUtility.escape(unescapedStr.substring(0, c)));
                    buf.append(to);
                    unescapedStr = unescapedStr.substring(c + from.length());
                }
                buf.append(HtmlUtility.escape(unescapedStr));
                b = strToProcess.length() - 1;
            }
            strToProcess = strToProcess.substring(b + 1);
            b = 0;
            a = 0;
        }
        return buf.toString();
    }

    private static String replaceSpace(String s) {
        int i;
        StringBuffer temp;
        int len;
        Pattern p = PATTERN_MIDDLE_SPACE;
        Matcher m = p.matcher(s);
        StringBuffer out = new StringBuffer();
        int prev = 0;
        while (m.find(prev)) {
            out.append(s.substring(prev, m.start()));
            len = m.end() - m.start();
            temp = new StringBuffer();
            for (i = 1; i < len - 2; ++i) {
                temp.append("&nbsp;");
            }
            temp.append(" ");
            out.append(m.group(1));
            out.append(temp);
            prev = m.end() - 1;
        }
        out.append(s.substring(prev));
        p = PATTERN_START_SPACE;
        m = p.matcher(out.toString());
        if (m.find()) {
            len = m.end() - m.start();
            temp = new StringBuffer();
            for (i = 0; i < len; ++i) {
                temp.append("&nbsp;");
            }
            out.replace(m.start(), m.end(), temp.toString());
        }
        if ((m = (p = PATTERN_END_SPACE).matcher(out.toString())).find()) {
            len = m.end() - m.start();
            temp = new StringBuffer();
            for (i = 0; i < len; ++i) {
                temp.append("&nbsp;");
            }
            out.replace(m.start(), m.end(), temp.toString());
        }
        return out.toString();
    }

    public static final String substituteSpace(String s) {
        if (s == null || s.length() <= 0) {
            return s;
        }
        int a = 0;
        int b = 0;
        boolean c = false;
        int maxA = s.length() - 1;
        StringBuffer buf = new StringBuffer();
        String strToProcess = s.trim();
        String unescapedStr = null;
        while (strToProcess.length() > 0) {
            b = strToProcess.indexOf(60);
            if (b >= 0) {
                unescapedStr = HtmlUtility.unescape(strToProcess.substring(0, b));
                buf.append(HtmlUtility.escape(HtmlUtility.replaceSpace(unescapedStr)));
                a = b;
                b = strToProcess.indexOf(62, a);
                if (b < 0) {
                    return s;
                }
                buf.append(strToProcess.substring(a, b + 1));
            } else {
                unescapedStr = HtmlUtility.unescape(strToProcess);
                buf.append(HtmlUtility.escape(HtmlUtility.replaceSpace(unescapedStr)));
                b = strToProcess.length() - 1;
            }
            strToProcess = strToProcess.substring(b + 1);
            b = 0;
            a = 0;
        }
        return buf.toString();
    }
}

