/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class HostPort {
    private int _port;
    private String _hostName = null;

    public HostPort(String s, int defaultPort) {
        int n = 0;
        this._port = defaultPort;
        if (s != null) {
            s = s.trim();
            n = s.indexOf(58);
        }
        if (n > 0) {
            String sPort = s.substring(n + 1);
            this._port = Integer.parseInt(sPort);
            this._hostName = s.substring(0, n);
        } else if (s != null && Character.isDigit(s.charAt(0)) && s.indexOf(".") < 0) {
            this._port = Integer.parseInt(s);
        } else {
            this._hostName = s;
        }
    }

    public String getHostName() {
        return this._hostName != null ? this._hostName : "localhost";
    }

    public int getPort() {
        return this._port;
    }

    public void setPort(int port) {
        if (this._port != 0) {
            throw new IllegalStateException();
        }
        this._port = port;
    }

    public InetAddress getHost() throws UnknownHostException {
        return this._hostName != null ? InetAddress.getByName(this._hostName) : null;
    }

    public String toString() {
        return this.getHostName() + ":" + this._port;
    }

    public boolean equals(Object o) {
        if (o instanceof HostPort) {
            HostPort hp = (HostPort)o;
            try {
                return this._port == hp.getPort() && (this.getHost() == null && hp.getHost() == null || this.getHost() != null && this.getHost().equals(hp.getHost()));
            }
            catch (Exception e) {
                return false;
            }
        }
        return this.equals(new HostPort(o.toString(), 0));
    }
}

