/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.sample;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.NotificationSession;
import com.sun.im.service.NotificationSessionListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Alerter
extends Thread
implements NotificationSessionListener {
    private NotificationSession _session;
    private Hashtable _subscriptions = new Hashtable();
    private boolean _shutdown = false;
    private String _user;
    private static BufferedReader _reader;

    public Alerter(CollaborationSessionFactory fac, String server, String user, String password) throws Exception {
        this._user = user;
        CollaborationSession s = fac.getSession(server, user, password, this);
        this._session = (NotificationSession)s.accessService("notification");
    }

    public void onError(CollaborationException e) {
        e.printStackTrace();
    }

    public void run() {
        while (!this._shutdown) {
            System.out.println("Listening for notifications");
            try {
                String s = _reader.readLine();
                if (s == null) break;
                if ((s = s.trim()).equals("")) continue;
                StringTokenizer st = new StringTokenizer(s);
                String cmd = st.nextToken();
                String[] args = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    args[i++] = st.nextToken();
                }
                if (!cmd.equalsIgnoreCase("quit") && !cmd.equalsIgnoreCase("exit") && !cmd.equalsIgnoreCase(".")) continue;
                this._shutdown = true;
            }
            catch (Exception e) {
                System.out.println("Error " + e.toString());
                e.printStackTrace();
            }
        }
    }

    public synchronized void onMessage(Message m) {
        try {
            Alerter.printMessage(m);
            String s = Alerter.prompt("Hit Enter when you have read the message... ", false);
            m.sendStatus(7);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String user;
        _reader = new BufferedReader(new InputStreamReader(System.in));
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("login host username password");
            return;
        }
        String server = args.length >= 1 ? args[0] : Alerter.prompt("Hostname [localhost:9909]\t: ", false, "localhost:9909");
        if (args.length >= 2) {
            user = args[1];
        } else {
            String username = System.getProperty("user.name");
            user = Alerter.prompt("User name [" + username + "]\t: ", false, username);
        }
        String password = args.length >= 3 ? args[2] : Alerter.prompt("Password [iplanet]\t: ", false, "iplanet");
        try {
            CollaborationSessionFactory fac = new CollaborationSessionFactory();
            Alerter thr = new Alerter(fac, server, user, password);
            thr.start();
            thr.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printMessage(Message message) throws Exception {
        System.out.println("    Subject: " + message.getHeader("subject"));
        System.out.println("    Content-type: " + message.getContentType());
        String from = message.getOriginator();
        System.out.println("    From: " + from);
        String[] rcpts = message.getRecipients();
        for (int i = 0; i < rcpts.length; ++i) {
            System.out.println("    To: " + rcpts[i]);
        }
        MessagePart[] parts = message.getParts();
        for (int i = 0; i < parts.length; ++i) {
            try {
                String str;
                BufferedReader br = new BufferedReader(new InputStreamReader(parts[i].getInputStream()));
                while ((str = br.readLine()) != null) {
                    System.out.println(str);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String prompt(String ask, boolean newline) {
        return Alerter.prompt(ask, newline, "");
    }

    private static String prompt(String ask, boolean newline, String defaultValue) {
        String ret = defaultValue;
        if (newline) {
            System.out.println(ask);
        } else {
            System.out.print(ask);
        }
        try {
            String s = _reader.readLine();
            if (s.length() > 0) {
                ret = s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

