/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.jso.io;

import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.event.StreamStatusEvent;
import org.jabberstudio.jso.event.StreamStatusListener;
import org.jabberstudio.jso.io.StreamSource;

public class NIOSSLSocketStreamSource
implements StreamSource {
    private SSLSocket _socket;
    private StatusWatcher _watcher;
    private boolean _EOF = false;

    public NIOSSLSocketStreamSource(SSLSocket soc) {
        if (soc == null) {
            throw new IllegalArgumentException("Socket cannot be null");
        }
        this._socket = soc;
    }

    public String getHostname() {
        return this._socket.getInetAddress().getHostName();
    }

    public void connect(Stream s) throws IOException, Exception {
        this._watcher = new StatusWatcher();
        s.addStreamStatusListener((StreamStatusListener)this._watcher);
        this._socket.setKeepAlive(true);
        NIOSSLSocketStreamSource.configureSocket(this._socket, s.getCurrentStatus());
    }

    public void disconnect(Stream s) throws IOException, Exception {
        s.removeStreamStatusListener((StreamStatusListener)this._watcher);
        this._socket.close();
    }

    public boolean ready() throws IOException {
        return this._socket.isConnected() && !this._socket.isInputShutdown() && !this.isEOF();
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        SSLSession session = this._socket.getSession();
        session.putValue("BUG_4836493_READ", Boolean.TRUE);
        try {
            int read = this._socket.getInputStream().read(buffer, offset, length);
            this.setEOF(read == -1);
            return read;
        }
        catch (SocketTimeoutException e) {
            return 0;
        }
    }

    public int write(byte[] buffer, int offset, int length) throws IOException {
        this._socket.getOutputStream().write(buffer, offset, length);
        return length;
    }

    private boolean isEOF() {
        return this._EOF;
    }

    private void setEOF(boolean eof) {
        this._EOF = eof;
    }

    private static void configureSocket(SSLSocket sock, Stream.Status stat) throws SocketException {
        if (stat == null) {
            stat = Stream.DISCONNECTED;
        }
        if (!stat.isOpened()) {
            sock.setSoTimeout(0);
        } else {
            sock.setSoTimeout(100);
        }
    }

    private class StatusWatcher
    implements StreamStatusListener {
        private StatusWatcher() {
        }

        public void statusChanged(StreamStatusEvent evt) {
            try {
                NIOSSLSocketStreamSource.configureSocket(NIOSSLSocketStreamSource.this._socket, evt.getStream().getCurrentStatus());
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }
}

