/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.SenderStreamingProfile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.DigestInputStream;
import java.security.MessageDigest;

public class SenderFileStreamingProfile
extends SenderStreamingProfile {
    private File _file;
    private byte[] _hash;
    private String _desc;

    public SenderFileStreamingProfile(File file, boolean computeHash, String description) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        this._file = file;
        this._desc = description;
        if (computeHash) {
            this._hash = this.getHash(this._file);
        }
    }

    public File getFile() {
        return this._file;
    }

    public byte[] getHash() {
        return this._hash;
    }

    public void setHash(byte[] hash) {
        this._hash = hash;
    }

    public String getDescription() {
        return this._desc;
    }

    private byte[] getHash(File f) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            byte[] b = new byte[1024];
            DigestInputStream dis = new DigestInputStream(new BufferedInputStream(new FileInputStream(f)), md5);
            int len = 0;
            while ((len = dis.read(b)) != -1) {
            }
            dis.close();
            return md5.digest();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

