/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service;

import com.sun.im.service.Presence;
import com.sun.im.service.util.XMLProcessingException;
import com.sun.im.service.util.XMLUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PresenceTuple {
    protected HashMap _notes;
    protected String id;
    protected String presentityID;
    protected float priority;
    protected String contact;
    protected String status;
    protected String basicStatus;
    protected Presence presentity;
    protected HashMap _namespaces;
    private String _lastUpdated;
    private HashMap customTupleElements;
    private StringBuffer serializedCustomTupleElements;
    private HashMap customStatusElements;
    private StringBuffer serializedCustomStatusElements;

    public PresenceTuple(String id) {
        this.id = id;
    }

    public PresenceTuple() {
    }

    public PresenceTuple(String id, String contact, String status) throws IllegalArgumentException {
        this.id = id;
        this.setContact(contact, 0.0f);
        this.setStatus(status);
    }

    public PresenceTuple(String id, String contact, String status, float priority) throws IllegalArgumentException {
        this.id = id;
        this.setContact(contact, priority);
        this.setStatus(status);
    }

    public String getNote(String lang) {
        if (this._notes != null) {
            return (String)this._notes.get(lang);
        }
        return null;
    }

    public String getNote() {
        if (this._notes == null) {
            return null;
        }
        String text = this.getNote(System.getProperty("user.language"));
        if (text == null && this._notes.size() == 1) {
            text = (String)this._notes.values().iterator().next();
        }
        return text;
    }

    public Map getNotes() {
        return this._notes;
    }

    public void addNote(String lang, String text) {
        if (this._notes == null) {
            this._notes = new HashMap(3);
        }
        this._notes.put(lang, text);
    }

    public void addNote(String text) {
        this.addNote(System.getProperty("user.language"), text);
    }

    public String getLastUpdateTimeStamp() {
        return this._lastUpdated;
    }

    public void setLastUpdateTimeStamp(String ts) {
        this._lastUpdated = ts;
    }

    public String getId() {
        return this.id;
    }

    public String getPresenceURL() {
        return this.presentityID;
    }

    public float getPriority() {
        return this.priority;
    }

    public String getContact() {
        return this.contact;
    }

    public String getStatus() {
        return this.status;
    }

    public String getBasicStatus() {
        return this.basicStatus;
    }

    public void setPriority(float priority) throws IllegalArgumentException {
        if (priority > 1.0f || priority < 0.0f) {
            throw new IllegalArgumentException("tuple priority must range from 0 to 1");
        }
        this.priority = priority;
    }

    public void setContact(String contact, float priority) throws IllegalArgumentException {
        this.contact = contact;
        this.setPriority(priority);
    }

    public void setContact(String contact) throws IllegalArgumentException {
        this.contact = contact;
    }

    public void setStatus(String status) throws IllegalArgumentException {
        this.status = status;
        if (this.id == null) {
            return;
        }
        if (status.equals("CLOSED") || status.equals("FORWARDED")) {
            this.basicStatus = "CLOSED";
        } else if (status.equals("OPEN") || status.equals("IDLE") || status.equals("BUSY") || status.equals("AWAY") || status.equals("CHAT")) {
            this.basicStatus = "OPEN";
        } else {
            throw new IllegalArgumentException("unknown status value: " + status);
        }
    }

    public String toString() {
        if (this.id == null) {
            return "Not Implemented";
        }
        StringBuffer buf = new StringBuffer();
        try {
            this.copyTo(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    protected void copyTo(StringBuffer buf) throws Exception {
        String s;
        XMLUtil.appendElementTag(buf, "", "tuple", false, false);
        buf.append(" id='" + this.id + "'>");
        XMLUtil.appendElementTag(buf, "", "contact", false, false);
        if ((double)this.priority != 0.0) {
            buf.append(" priority='" + this.priority + "'>");
        } else {
            buf.append(">");
        }
        buf.append(this.contact);
        XMLUtil.appendElementTag(buf, "", "contact", true, true);
        XMLUtil.appendElementTag(buf, "", "status", false, true);
        if (this.basicStatus != null) {
            XMLUtil.appendElementTag(buf, "", "basic", false, true);
            buf.append(this.basicStatus);
            XMLUtil.appendElementTag(buf, "", "basic", true, true);
        }
        XMLUtil.appendElementTag(buf, "icp:", "xstatus", false, true);
        buf.append(this.status);
        XMLUtil.appendElementTag(buf, "icp:", "xstatus", true, true);
        XMLUtil.appendElementTag(buf, "", "status", true, true);
        if (this._notes != null && this._notes.size() > 0) {
            Iterator i = this._notes.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                String lang = (String)entry.getKey();
                String note = (String)entry.getValue();
                XMLUtil.appendElementTag(buf, "", "note", false, false);
                buf.append(" lang='" + lang + "'>" + note);
                XMLUtil.appendElementTag(buf, "", "note", true, true);
            }
        }
        if ((s = this.getSerializedCustomTupleElements()) != null) {
            buf.append(s);
        }
        XMLUtil.appendElementTag(buf, "", "tuple", true, true);
    }

    public boolean equals(Object o) {
        if (this.id == null) {
            return false;
        }
        PresenceTuple other = (PresenceTuple)o;
        return other.getId().equals(this.getId());
    }

    private String addNamespace(String prefix, String nsURI) {
        String origURI;
        String uniquePrefix = prefix;
        String res = null;
        if (this._namespaces == null) {
            this._namespaces = new HashMap();
        }
        int i = 0;
        while ((origURI = this.presentity == null ? (String)this._namespaces.get(uniquePrefix) : this.presentity.getNamespaceURI(uniquePrefix)) != null && !origURI.equalsIgnoreCase(nsURI)) {
            res = uniquePrefix = Integer.toString(nsURI.hashCode() + i);
            ++i;
        }
        this._namespaces.put(uniquePrefix, nsURI);
        if (this.presentity != null) {
            this.presentity.addNamespace(uniquePrefix, nsURI);
        }
        return res;
    }

    private String getNamespaceURI(String s) {
        if (s.indexOf(58) > 0) {
            return s;
        }
        String nsURI = null;
        if (this._namespaces != null && (nsURI = (String)this._namespaces.get(s)) != null) {
            return nsURI;
        }
        if (nsURI == null && this.presentity != null) {
            nsURI = this.presentity.getNamespaceURI(s);
        }
        return nsURI;
    }

    protected void addCustomTupleElement(Element element) throws XMLProcessingException {
        LinkedList<Element> list;
        if (this.customTupleElements == null) {
            this.customTupleElements = new HashMap();
        }
        if ((list = (LinkedList<Element>)this.customTupleElements.get(element.getNamespaceURI())) == null) {
            list = new LinkedList<Element>();
            list.add(element);
            this.customTupleElements.put(element.getNamespaceURI(), list);
        } else {
            list.add(element);
        }
    }

    public void addSerializedCustomTupleElement(String sElement, String namespaceURI, boolean validateXML) throws XMLProcessingException {
        String prefix = null;
        Document dummyDoc = null;
        String s = sElement;
        if (validateXML) {
            dummyDoc = XMLUtil.createDocFromString(sElement);
        }
        if (namespaceURI != null) {
            String newPrefix;
            if (validateXML) {
                Node parentNode;
                if (dummyDoc != null && (parentNode = dummyDoc.getFirstChild()) != null) {
                    Node curNode = parentNode.getFirstChild();
                    prefix = XMLUtil.getNamespacePrefix((Element)curNode);
                }
            } else {
                prefix = XMLUtil.getPrefixFromXMLString(sElement);
            }
            if ((newPrefix = this.addNamespace(namespaceURI, prefix)) != null) {
                s = XMLUtil.replacePrefix(sElement, prefix, newPrefix);
            }
        }
        if (this.serializedCustomTupleElements == null) {
            this.serializedCustomTupleElements = new StringBuffer(s);
        } else {
            this.serializedCustomTupleElements.append(s);
        }
    }

    public String getSerializedCustomTupleElements() throws XMLProcessingException {
        if (this.customTupleElements == null) {
            return null;
        }
        StringBuffer buf = this.serializedCustomTupleElements;
        Iterator i = this.customTupleElements.values().iterator();
        while (i.hasNext()) {
            List list = (List)i.next();
            if (list == null) continue;
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Element elt = (Element)j.next();
                String s = XMLUtil.dumpNodeAsString(elt);
                if (buf == null) {
                    buf = new StringBuffer(s);
                    continue;
                }
                buf.append(s);
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    public List getCustomTupleElements(String namespace) {
        if (this.customTupleElements == null) {
            return null;
        }
        String nsURI = this.getNamespaceURI(namespace);
        if (nsURI == null) {
            return null;
        }
        return (List)this.customTupleElements.get(nsURI);
    }

    public String getSerializedCustomTupleElements(String namespace) throws XMLProcessingException {
        if (this.customTupleElements == null) {
            return null;
        }
        String nsURI = this.getNamespaceURI(namespace);
        if (nsURI == null) {
            return null;
        }
        List list = this.getCustomTupleElements(nsURI);
        StringBuffer buf = null;
        if (list != null) {
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Element elt = (Element)j.next();
                String s = XMLUtil.dumpNodeAsString(elt);
                if (buf == null) {
                    buf = new StringBuffer(s);
                    continue;
                }
                buf.append(s);
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    protected void addCustomStatusElement(Element element) throws XMLProcessingException {
        LinkedList<Element> list;
        if (this.customStatusElements == null) {
            this.customStatusElements = new HashMap();
        }
        if ((list = (LinkedList<Element>)this.customStatusElements.get(element.getNamespaceURI())) == null) {
            list = new LinkedList<Element>();
            list.add(element);
            this.customStatusElements.put(element.getNamespaceURI(), list);
        } else {
            list.add(element);
        }
    }

    public void addSerializedCustomStatusElement(String sElement, String namespaceURI, boolean validateXML) throws XMLProcessingException {
        String prefix = null;
        Document dummyDoc = null;
        String s = sElement;
        if (validateXML) {
            dummyDoc = XMLUtil.createDocFromString(sElement);
        }
        if (namespaceURI != null) {
            String newPrefix;
            if (validateXML) {
                Node parentNode;
                if (dummyDoc != null && (parentNode = dummyDoc.getFirstChild()) != null) {
                    Node curNode = parentNode.getFirstChild();
                    prefix = XMLUtil.getNamespacePrefix((Element)curNode);
                }
            } else {
                prefix = XMLUtil.getPrefixFromXMLString(sElement);
            }
            if ((newPrefix = this.addNamespace(namespaceURI, prefix)) != null) {
                s = XMLUtil.replacePrefix(sElement, prefix, newPrefix);
            }
        }
        if (this.serializedCustomStatusElements == null) {
            this.serializedCustomStatusElements = new StringBuffer(s);
        } else {
            this.serializedCustomStatusElements.append(s);
        }
    }

    public String getSerializedCustomStatusElements() throws XMLProcessingException {
        if (this.customStatusElements == null) {
            return null;
        }
        StringBuffer buf = this.serializedCustomStatusElements;
        Iterator i = this.customStatusElements.values().iterator();
        while (i.hasNext()) {
            List list = (List)i.next();
            if (list == null) continue;
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Element elt = (Element)j.next();
                String s = XMLUtil.dumpNodeAsString(elt);
                if (buf == null) {
                    buf = new StringBuffer(s);
                    continue;
                }
                buf.append(s);
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }

    public List getCustomStatusElements(String namespace) {
        if (this.customTupleElements == null) {
            return null;
        }
        String nsURI = this.getNamespaceURI(namespace);
        if (nsURI == null) {
            return null;
        }
        return (List)this.customStatusElements.get(nsURI);
    }

    public String getSerializedCustomStatusElements(String namespace) throws XMLProcessingException {
        if (this.customStatusElements == null) {
            return null;
        }
        String nsURI = this.getNamespaceURI(namespace);
        if (nsURI == null) {
            return null;
        }
        List list = this.getCustomStatusElements(nsURI);
        StringBuffer buf = null;
        if (list != null) {
            Iterator j = list.iterator();
            while (j.hasNext()) {
                Element elt = (Element)j.next();
                String s = XMLUtil.dumpNodeAsString(elt);
                if (buf == null) {
                    buf = new StringBuffer(s);
                    continue;
                }
                buf.append(s);
            }
        }
        if (buf != null) {
            return buf.toString();
        }
        return null;
    }
}

