/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.Config;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.MultiplexSocket;
import com.sun.im.service.AuthenticationException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.TimeoutException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Properties;

public class MultiplexConnectionFactory
extends ConnectionFactory {
    private MultiplexSocket _socket;
    private int _channel;
    private CommandData _reply;

    public MultiplexConnectionFactory(int n, MultiplexSocket multiplexSocket, Properties properties) {
        super(properties);
        this._socket = multiplexSocket;
        this._channel = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() throws UnknownHostException, IOException, CollaborationException {
        this.connected = true;
        Object object = this.receivedHello;
        synchronized (object) {
            while (!this.bReceivedHello && this.connected) {
                try {
                    this.receivedHello.wait();
                }
                catch (Exception exception) {}
            }
        }
        this.sayHello();
    }

    void sayHello() throws IOException, CollaborationException {
        CommandData commandData = Command.create(106, "3.0", VERSION, ConnectionFactory.VERSION, "");
        try {
            CommandData commandData2 = this.sendCommand(commandData);
        }
        catch (CollaborationException collaborationException) {
            this._close("protocol error at hello phase", false, 0);
        }
    }

    public Config login() throws CollaborationException, AuthenticationException {
        return this._login();
    }

    public void close() {
        this.connected = false;
        try {
            this._socket.close(this._channel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected synchronized void closed(String string) {
        this.connected = false;
        this.notify();
        this.fireConnectionLost(string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandData sendCommand(CommandData commandData) throws CollaborationException {
        int n = 0;
        CommandData commandData2 = null;
        Object object = this.replyLock;
        synchronized (object) {
            this.writeCommand(commandData);
            while (this._reply == null && this.connected) {
                if (++n > 4) {
                    this._reply = null;
                    this._pendingCommand = null;
                    throw new TimeoutException("Timeout while waiting for server response to " + Command.toString(commandData));
                }
                MultiplexConnectionFactory multiplexConnectionFactory = this;
                synchronized (multiplexConnectionFactory) {
                    try {
                        this.wait(5000L);
                    }
                    catch (Exception exception) {
                        System.err.println("WAIT interrupted " + exception);
                    }
                }
                if (this.connected) continue;
                throw new CollaborationException("Channel closed by server");
            }
            commandData2 = this._reply;
            this._reply = null;
        }
        if (commandData2 == null) {
            throw new CollaborationException("Command interrupted");
        }
        if (Command.getReplyCode(commandData2) != 0) {
            throw new CollaborationException(Command.getReplyString(commandData2));
        }
        return commandData2;
    }

    void writeCommand(CommandData commandData) throws CollaborationException {
        try {
            this._socket.writeCommand(this._channel, commandData);
        }
        catch (IOException iOException) {
            throw new CollaborationException(iOException.toString());
        }
    }

    synchronized void onReply(CommandData commandData) {
        if (this._reply != null) {
            System.err.println("ERROR: <" + this._channel + "> writing over last reply: " + Command.toString((Integer)this._reply.args[0]));
        }
        this._reply = commandData;
        this.notify();
    }
}

