/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.BaseMessageImpl;
import com.iplanet.im.net.Message;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.MessagePart;
import com.sun.im.service.ReadOnlyMessagePart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class MessagePartImpl
implements MessagePart {
    public Message _message;
    private byte[] _bytes = null;
    private String _filename = "1";
    private String _contentType = "application/octet-stream";
    private boolean _isTextPart = true;
    String _sContent = null;
    String _encoding = null;
    BaseMessageImpl _parent = null;

    public MessagePartImpl(Message message) {
        this._message = message;
        this._contentType = BaseMessageImpl.getContentType(this._message);
        this._sContent = Message.toString(this._message);
    }

    public MessagePartImpl() {
        this._isTextPart = true;
    }

    public MessagePartImpl(boolean bl) {
        this._isTextPart = bl;
    }

    public MessagePartImpl(BaseMessageImpl baseMessageImpl, Message message, String string, byte[] byArray) {
        this._filename = string;
        this._message = message;
        this._bytes = byArray;
        this._isTextPart = false;
        this._parent = baseMessageImpl;
    }

    public MessagePartImpl(Message message, String string) {
        this._sContent = string;
        this._message = message;
    }

    public int getSize() {
        if (this._isTextPart) {
            return this._sContent.length();
        }
        return this._bytes.length;
    }

    public String getContent() throws CollaborationException {
        if (this._isTextPart) {
            return this._sContent;
        }
        return null;
    }

    public String getContent(String string) throws CollaborationException {
        return null;
    }

    public byte[] getBytes(String string) throws CollaborationException {
        return null;
    }

    public synchronized InputStream getInputStream() throws CollaborationException {
        if (!this._isTextPart) {
            if (this._bytes != null) {
                return new ByteArrayInputStream(this._bytes, 0, this._bytes.length);
            }
        } else if (this._sContent != null) {
            byte[] byArray = this._sContent.getBytes();
            return new ByteArrayInputStream(byArray, 0, byArray.length);
        }
        return null;
    }

    public String getContentType() {
        return this._contentType;
    }

    public String getContentName() {
        return this._filename;
    }

    public String getContentID() {
        return this._filename;
    }

    public String getContentEncoding() {
        return this._encoding;
    }

    public void setContent(byte[] byArray, String string) throws CollaborationException {
        if (this._isTextPart) {
            if (string != null) {
                this._encoding = string;
            }
            try {
                this._sContent = new String(byArray, this._encoding);
                this._message.setBody(this._sContent);
            }
            catch (Exception exception) {
                throw new CollaborationException(exception.toString());
            }
        } else {
            this._bytes = byArray;
            this.resetAttachment(false);
        }
    }

    public void setContent(InputStream inputStream, String string) throws CollaborationException {
        try {
            if (this._isTextPart) {
                if (string != null) {
                    this._encoding = string;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this._encoding);
                StringBuffer stringBuffer = new StringBuffer();
                char[] cArray = new char[1024];
                while (inputStreamReader.ready()) {
                    int n = inputStreamReader.read(cArray, 0, cArray.length);
                    stringBuffer.append(cArray, 0, n);
                }
                this._sContent = stringBuffer.toString();
                this._message.setBody(this._sContent);
                inputStreamReader.close();
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while (inputStream.available() > 0) {
                    int n = inputStream.read(byArray);
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                this._bytes = byteArrayOutputStream.toByteArray();
                this.resetAttachment(false);
                byteArrayOutputStream.close();
            }
        }
        catch (Exception exception) {
            throw new CollaborationException(exception.toString());
        }
    }

    public void clearContent() throws CollaborationException {
        if (this._isTextPart) {
            this._message.setBody("");
        } else {
            this._bytes = null;
            this.resetAttachment(true);
        }
    }

    private void resetAttachment(boolean bl) {
        if (!this._isTextPart) {
            if (bl) {
                this._message.removeAttachment(this._filename);
            }
            if (this._bytes != null) {
                this._message.addAttachment(this._filename, this._bytes);
            }
        }
    }

    public void setContent(String string) throws CollaborationException {
        this._message.setText(string);
        this._sContent = string;
        this._bytes = string.getBytes();
        if (!this._isTextPart) {
            this.resetAttachment(false);
        }
    }

    public void setContent(String string, String string2) throws CollaborationException {
    }

    public void setContentName(String string) throws CollaborationException {
        if (!this._isTextPart) {
            this._message.renameAttachment(this._filename, string);
        }
        this._filename = string;
    }

    public void setContentType(String string) throws CollaborationException {
        if (string.equals("text/plain")) {
            this._message.setContentType("net/text");
        } else if (string.equals("text/html")) {
            this._message.setContentType("net/html");
        } else if (string.equals("text/x-iim-url")) {
            this._message.setContentType("net/url");
        } else if (string.equals("application/x-iim-poll")) {
            this._message.setContentType("net/poll");
        } else if (string.equals("application/x-iim-poll-reply")) {
            this._message.setContentType("net/pollreply");
        } else if (string.equals("application/x-iim-extended")) {
            this._message.setContentType("net/extended");
        } else if (!string.equals("text/xml")) {
            throw new CollaborationException("unsupported content type : " + string);
        }
    }

    public String getHeader(String string) {
        return null;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public void setHeader(String string, String string2) throws CollaborationException {
    }

    public void addPart(MessagePart messagePart) throws CollaborationException {
    }

    public void removePart(MessagePart messagePart) throws CollaborationException {
    }

    public ReadOnlyMessagePart getParent() {
        return this._parent;
    }
}

