/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.BooleanAccessControlList;
import com.iplanet.im.net.Command;
import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.CommandToNet;
import com.iplanet.im.net.Config;
import com.iplanet.im.net.Connection;
import com.iplanet.im.net.ConnectionEvent;
import com.iplanet.im.net.ConnectionStatusListener;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.DestinationAccessControlList;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessageListener;
import com.iplanet.im.net.MessageStatusEvent;
import com.iplanet.im.net.MsgStatusListener;
import com.iplanet.im.net.NetIOException;
import com.iplanet.im.net.QueueConnection;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.RoomConnection;
import com.iplanet.im.net.RoomMsg;
import com.iplanet.im.net.Topic;
import com.iplanet.im.net.TopicConnection;
import com.iplanet.im.net.UserEvent;
import com.iplanet.im.net.UserSearchReply;
import com.iplanet.im.net.UserStatus;
import com.iplanet.im.net.UserStatusListener;
import com.iplanet.im.net.iIMGroup;
import com.iplanet.im.net.iIMPrincipal;
import com.iplanet.im.net.iIMQueue;
import com.iplanet.im.net.iIMUser;
import com.sun.im.service.AuthenticationException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.TimeoutException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OptionalDataException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ConnectionFactory {
    public static String VERSION = "6.1";
    private float _serverVersion = 6.0f;
    public static final String NMS = "net.nms";
    public static final String USER = "net.user";
    public static final String PASS = "net.password";
    public static final String SERV = "net.server";
    public static final String LOGINTYPE = "net.login";
    public static final int LOGINTYPE_PRIMARY = 1;
    public static final int LOGINTYPE_SECONDARY = 2;
    public static final String PING_INTERVAL = "net.pinginterval";
    public static final String USER_ENV_VAR = "net.user.property";
    public static final String USER_CACHE = "net.user.cache";
    public static final String SERVER_ARCHIVE_ENABLED = "net.archive.enabled";
    public static final String USE_SSL = "net.use.ssl";
    public static final String FORWARD_EMAIL = "forward.email";
    public static final String FORWARD_EMAIL_ADDR = "forward.email.addr";
    public static final String FORWARD_PAGER = "forward.pager";
    public static final String FORWARD_PAGER_ADDR = "forward.pager.addr";
    public static final String FORWARD_SMS = "forward.sms";
    public static final String FORWARD_SMS_ADDR = "forward.sms.addr";
    public static final String DELIVER_OFFLINE_ALERTS = "alerts.offline.deliver";
    public static final String ID_MSGTYPE_URL = "net/url";
    public static final String ID_MSGTYPE_URLEX = "net/urlex";
    public static final String ID_MSGTYPE_HTML = "net/html";
    public static final String ID_MSGTYPE_HTMLEX = "net/htmlex";
    public static final String ID_MSGTYPE_TEXT = "net/text";
    public static final String ID_MSGTYPE_REPLY = "net/reply";
    public static final String ID_MSGTYPE_POLL = "net/poll";
    public static final String ID_MSGTYPE_POLL_REPLY = "net/pollreply";
    public static final String ID_MSGTYPE_STATUSALERT = "net/status";
    public static final String ID_MSGTYPE_EXTENDED = "net/extended";
    public static final String ID_MSGTYPE_CHAT = "net/chat";
    public static final String ID_MSGTYPE_CHATEX = "net/chatex";
    public static final String ID_MSGTYPE_TYPING = "net/typing";
    public static final String ID_MSGTYPE_TYPING_OFF = "net/typing_off";
    public static final String ID_MSGTYPE_MODCHAT = "net/moderated";
    public static final String ID_MSGTYPE_WHITEBOARD = "net/wb";
    public static final String ID_MSGTYPE_INVITE = "net/invite";
    public static final String ID_MSGTYPE_SEND_FILE = "net/sendfile";
    public static final String ID_MSGTYPE_RECEIVE_FILE = "net/recfile";
    public static final String ID_MSGTYPE_PLUGIN = "net/plugin";
    public static final String ID_NEW_WB = "net/wb";
    public static final String ID_MSGTYPE_RELOAD = "net/reload";
    public static final String ID_MSGTYPE_UPDATE = "net/update";
    public static final String ID_MSGTYPE_MEDIA = "net/media";
    public static final String ID_MSGTYPE_REQUEST = "net/request";
    public static final String ID_MSGTYPE_ADVERTIZE = "net/advertize";
    public static final String ID_MSGTYPE_MESSAGE = "net/msg";
    public static final String ID_MSGFIELD_BODY = "BODY";
    public static final String ID_MSGFIELD_FILES = "FILES";
    public static final String ID_MSGFIELD_IMAGES = "IMAGES";
    public static final String SSO_PREFIX = "~~~";
    public static final String SSO_PORTALID_PREFIX = "^^^";
    private Hashtable connHT = new Hashtable(10);
    private String currentServer;
    private String netVer;
    private String nmsVer;
    protected Properties props;
    protected Socket socket;
    private DataOutputStream os;
    private DataInputStream is;
    private CommandToNet c2n = new CommandToNet();
    private CommandData _reply;
    Object replyLock = new Object();
    boolean connected = false;
    boolean bReceivedHello = false;
    iIMUser nlu;
    protected Vector userStatusListeners = new Vector(20);
    protected Vector msgStatusListeners = new Vector(5);
    protected Vector cfStatusListeners = new Vector(5);
    CommandData _pendingCommand;
    Object receivedHello = new Object();
    Thread pinger = null;
    int pingInterval = 30000;
    public static final String JVMID_PROP = "com.iplanet.im.jvmid";
    protected static String processId;

    public static InetAddress[] findServers(int n) {
        Object[] objectArray;
        if (n == 0) {
            n = 9909;
        }
        Vector<InetAddress> vector = new Vector<InetAddress>();
        try {
            objectArray = new DatagramSocket();
            objectArray.setSoTimeout(2000);
            String string = "WhereIsiIMMessageServer";
            byte[] byArray = string.getBytes();
            InetAddress inetAddress = InetAddress.getByName("255.255.255.255");
            DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n);
            objectArray.send(datagramPacket);
            try {
                while (true) {
                    byte[] byArray2 = new byte[255];
                    DatagramPacket datagramPacket2 = new DatagramPacket(byArray2, byArray2.length);
                    objectArray.receive(datagramPacket2);
                    String string2 = new String(datagramPacket2.getData(), 0, datagramPacket2.getLength());
                    if (!string2.equals("HereIsiIMMessageServer")) continue;
                    vector.addElement(datagramPacket2.getAddress());
                }
            }
            catch (InterruptedIOException interruptedIOException) {
            }
        }
        catch (Exception exception) {
            System.err.println("Error trying to find server");
        }
        objectArray = new InetAddress[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public ConnectionFactory(Properties properties) {
        this.props = properties;
    }

    public String getServerName() {
        return this.currentServer;
    }

    public String getServerVersionDisplayString() {
        return "Sun ONE IM Server " + this.nmsVer + " - protocol version " + this.netVer;
    }

    public String getiIMProtocolVersion() {
        return this.netVer;
    }

    public String getNMSVersion() {
        return this.nmsVer;
    }

    public String getNetVersion() {
        return this.netVer;
    }

    public void connect() throws UnknownHostException, IOException, CollaborationException {
        String string = this.props.getProperty(NMS, "localhost");
        int n = 9909;
        int n2 = string.indexOf(58);
        if (n2 != -1) {
            String string2 = string.substring(n2 + 1);
            n = Integer.parseInt(string2);
            string = string.substring(0, n2);
        }
        this.socket = new Socket(string, n);
        this._connect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _connect() throws UnknownHostException, IOException, CollaborationException {
        try {
            this.os = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.is = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.os = null;
            this.is = null;
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
            throw new CollaborationException(iOException.toString());
        }
        this.connected = true;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ConnectionFactory.this.readThread();
            }
        });
        thread.setName("cf - reader");
        thread.start();
        Object object = this.receivedHello;
        synchronized (object) {
            while (!this.bReceivedHello && this.connected) {
                try {
                    this.receivedHello.wait(30000L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                if (this.bReceivedHello) continue;
                this._close("Timeout waiting for server greeting", false, 0);
                throw new TimeoutException("Timeout waiting for server greeting");
            }
        }
        if (!this.connected) {
            throw new NetIOException("Error occured before receiving hello");
        }
        this.sayHello();
    }

    void sayHello() throws IOException, CollaborationException {
        CommandData commandData = Command.create(106, VERSION, VERSION, VERSION, "");
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null || commandData2.command != 100) {
            System.err.println("Invalid protocol ");
            this._close("error at hello phase", false, 0);
        }
    }

    Config _login() throws CollaborationException, AuthenticationException {
        Config config = this.auth();
        this.currentServer = config.server;
        this.nlu = config.me;
        return config;
    }

    public Config login() throws CollaborationException, AuthenticationException {
        String string;
        Config config = this._login();
        if (config.me != null && (string = config.me.getAttribute(PING_INTERVAL)) != null) {
            this.pingInterval = Integer.parseInt(string);
        }
        if (this.pingInterval > 0) {
            this.pinger = new Thread(new Runnable(){

                public void run() {
                    while (ConnectionFactory.this.isConnected()) {
                        try {
                            Thread.sleep(ConnectionFactory.this.pingInterval);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!ConnectionFactory.this.isConnected()) continue;
                        try {
                            CommandData commandData = Command.create(10);
                            ConnectionFactory.this.writeCommand(commandData);
                        }
                        catch (Exception exception) {}
                    }
                }
            });
            this.pinger.setName("cf - ping");
            this.pinger.start();
        }
        return config;
    }

    protected void finalize() throws Throwable {
        this._close("finalize: Cleaning up ConnectionFactory", false, ConnectionEvent.NETWORK_ERROR);
    }

    public boolean isConnected() {
        return this.connected;
    }

    private CommandData readCommand() throws CollaborationException {
        if (!this.connected) {
            throw new CollaborationException("not connected");
        }
        try {
            return this.c2n.readCommand(this.is);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this._close(classNotFoundException.toString(), true, ConnectionEvent.NETWORK_ERROR);
            throw new CollaborationException("invalid class type");
        }
        catch (OptionalDataException optionalDataException) {
            this._close(optionalDataException.toString(), true, ConnectionEvent.NETWORK_ERROR);
            throw new CollaborationException("invalid class format");
        }
        catch (IOException iOException) {
            this._close(iOException.toString(), true, ConnectionEvent.NETWORK_ERROR);
            throw new CollaborationException(iOException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCommand(CommandData commandData) throws CollaborationException {
        this.threadCheck(commandData);
        if (!this.connected) {
            throw new NetIOException("not connected");
        }
        try {
            DataOutputStream dataOutputStream = this.os;
            synchronized (dataOutputStream) {
                this.c2n.sendCommand(this.os, commandData);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this._close(iOException.toString(), true, ConnectionEvent.NETWORK_ERROR);
            throw new NetIOException(iOException.toString());
        }
    }

    public void close() {
        this._close("User request", false, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _close(String string, boolean bl, int n) {
        if (string == null) {
            string = "unknown";
        }
        if (string.equals("")) {
            string = "unknown";
        }
        if (!this.connected) {
            return;
        }
        this.connected = false;
        Object object = this.receivedHello;
        synchronized (object) {
            if (!this.bReceivedHello) {
                this.receivedHello.notify();
            }
        }
        try {
            if (this.pinger != null) {
                this.pinger.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.os = null;
        }
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.socket = null;
        }
        if (bl) {
            this.fireConnectionLost(string, n);
        }
    }

    public Properties getAuthProperties() {
        return this.props;
    }

    private Config auth() throws CollaborationException, AuthenticationException {
        String string = this.props.getProperty(USER, "anonymous");
        String string2 = this.props.getProperty(PASS, "");
        String string3 = this.props.getProperty(SERV, "");
        Boolean bl = string3.equals("true") ? new Boolean(true) : new Boolean(false);
        String string4 = this.props.getProperty(LOGINTYPE, "1");
        Integer n = new Integer(string4);
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)(cArray[i] ^ 0xBA);
        }
        char[] cArray2 = new char[string2.length()];
        string2.getChars(0, string2.length(), cArray2, 0);
        for (int i = 0; i < cArray2.length; ++i) {
            cArray2[i] = (char)(cArray2[i] ^ 0xBE);
        }
        String string5 = new String(cArray);
        String string6 = new String(cArray2);
        Config config = null;
        CommandData commandData = n != 1 ? Command.create(200, string5, string6, bl, n) : Command.create(200, string5, string6, bl);
        try {
            CommandData commandData2 = this.sendCommand(commandData);
            config = (Config)commandData2.args[3];
        }
        catch (CollaborationException collaborationException) {
            if (collaborationException.getMessage().startsWith("Authentication Failed")) {
                throw new AuthenticationException(collaborationException.getMessage());
            }
            throw collaborationException;
        }
        return config;
    }

    private void threadCheck(CommandData commandData) {
        Thread thread = Thread.currentThread();
        if (thread.getName().equals("cf - reader") && commandData.command != 10) {
            System.err.println("ConnectionFactory calling network send in reader class : " + Command.toString(commandData));
            RuntimeException runtimeException = new RuntimeException("programmer threading error");
            throw runtimeException;
        }
        if (thread.getName().startsWith("AWT")) {
            System.out.println("WARNING: sending data in the UI Thread : " + Command.toString(commandData));
        }
    }

    private void readThread() {
        Thread thread = Thread.currentThread();
        thread.setName("cf - reader");
        try {
            while (true) {
                CommandData commandData = this.readCommand();
                this.handleCommand(commandData);
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    synchronized void onReply(CommandData commandData) {
        String string = "";
        if (this.nlu != null) {
            string = this.nlu.getUID();
        }
        if (this._pendingCommand == null) {
            System.err.println("ERROR: <" + string + "> no pending request - ignoring reply to " + Command.toString((Integer)commandData.args[0]));
            return;
        }
        if ((Integer)commandData.args[0] != this._pendingCommand.command) {
            System.err.println("ERROR: <" + string + "> request/reply mismatch - ignoring reply to " + Command.toString((Integer)commandData.args[0]));
            return;
        }
        if (this._reply != null) {
            System.err.println("ERROR: <" + string + "> writing over last reply: " + Command.toString((Integer)this._reply.args[0]));
        }
        this._reply = commandData;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void handleCommand(CommandData commandData) {
        switch (commandData.command) {
            case 10: {
                return;
            }
            case 101: {
                Destination destination = (Destination)commandData.args[0];
                if (destination == null) {
                    System.err.println("ConnectionFactory.handleCommand(): invalid destination in MSGADDED command");
                    return;
                }
                Message message = (Message)commandData.args[1];
                Connection connection = this.findConnection(destination);
                if (connection == null) {
                    if (this.nlu != null) {
                        System.err.println("ConnectionFactory.handleCommand(): " + this.nlu.getUID() + ": MSGADDED: no connection for " + destination.getUID());
                        return;
                    } else {
                        System.err.println("ConnectionFactory.handleCommand(): MSGADDED: no connection for " + destination.getName());
                    }
                    return;
                }
                connection.addMessage(message, commandData);
                return;
            }
            case 102: {
                Destination destination = (Destination)commandData.args[0];
                if (destination == null) {
                    System.err.println("ConnectionFactory.handleCommand(): invalid destination in MSGDELED command");
                    return;
                }
                String string = (String)commandData.args[1];
                Connection connection = this.findConnection(destination);
                if (connection == null) {
                    System.err.println("ConnectionFactory.handleCommand(): " + this.nlu.getUID() + ": MSGDELED: no connection for " + destination.getName());
                    return;
                }
                connection.delMessage(string, commandData);
                return;
            }
            case 100: {
                this.onReply(commandData);
                return;
            }
            case 103: {
                String string = (String)commandData.args[0];
                Integer n = (Integer)commandData.args[1];
                String string2 = (String)commandData.args[2];
                Integer n2 = (Integer)commandData.args[3];
                this.fireUserStatus(string, n, string2, n2, commandData);
                return;
            }
            case 104: {
                iIMQueue iIMQueue2 = (iIMQueue)commandData.args[0];
                Integer n = (Integer)commandData.args[1];
                String string = (String)commandData.args[2];
                String string3 = (String)commandData.args[3];
                Destination destination = (Destination)commandData.args[4];
                this.fireMsgStatus(destination, n, string, string3, commandData);
                return;
            }
            case 105: {
                RoomConnection roomConnection;
                Room room = (Room)commandData.args[0];
                String string = (String)commandData.args[1];
                String string4 = (String)commandData.args[2];
                String string5 = null;
                if (commandData.args.length > 3) {
                    string5 = (String)commandData.args[3];
                }
                if ((roomConnection = (RoomConnection)this.findConnection(room)) == null) return;
                roomConnection.setUserStatus(string, string4, string5, commandData);
                return;
            }
            case 106: {
                try {
                    this.nmsVer = (String)commandData.args[1];
                    String string = (String)commandData.args[2];
                    this.netVer = string.charAt(0) + "." + string.charAt(string.length() - 1);
                    this._serverVersion = Float.parseFloat(this.netVer);
                    Object object = this.receivedHello;
                    synchronized (object) {
                        this.bReceivedHello = true;
                        this.receivedHello.notify();
                        return;
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this._close("error at hello phase: " + exception.toString(), false, 0);
                }
                return;
            }
            case 108: {
                this._close("Server Close", true, ConnectionEvent.SERVER_CLOSED);
                return;
            }
            default: {
                System.err.println("ConnectionFactory.handleCommand(): Unknown command " + commandData.command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandData readReply() throws CollaborationException {
        Object object;
        int n = 0;
        while (this.connected && this._reply == null) {
            if (n > 5) {
                this._reply = null;
                object = this._pendingCommand != null ? Command.toString(this._pendingCommand) : "null";
                this._pendingCommand = null;
                throw new TimeoutException("Timeout while waiting for server response to " + (String)object);
            }
            object = this;
            synchronized (object) {
                try {
                    this.wait(5000L);
                    ++n;
                }
                catch (Exception exception) {
                    System.err.println("WAIT interrupted " + exception);
                }
            }
        }
        object = this._reply;
        this._reply = null;
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandData sendCommand(CommandData commandData) throws CollaborationException {
        CommandData commandData2;
        Object object = this.replyLock;
        synchronized (object) {
            this._pendingCommand = commandData;
            this.writeCommand(commandData);
            commandData2 = this.readReply();
            this._pendingCommand = null;
        }
        if (commandData2 == null) {
            return null;
        }
        if (!Command.checkReplyCommand(commandData.command, commandData2)) {
            if (commandData2.command == 100) {
                System.out.println("ERROR : Expected reply to : " + Command.toString(commandData) + " and got reply to " + Command.toString((Integer)commandData2.args[0]));
            } else {
                System.out.println("ERROR : Expected reply to : " + Command.toString(commandData) + " and got " + Command.toString(commandData2));
            }
            throw new CollaborationException("protocol error");
        }
        if (Command.getReplyCode(commandData2) != 0) {
            throw new CollaborationException(Command.getReplyString(commandData2));
        }
        return commandData2;
    }

    public Connection createConnection(Destination destination) {
        Connection connection = this.findConnection(destination);
        if (connection != null) {
            return connection;
        }
        if (destination instanceof Topic) {
            connection = new TopicConnection(this, (Topic)destination);
        } else if (destination instanceof Room) {
            connection = new RoomConnection(this, (Room)destination);
        } else if (destination instanceof iIMQueue) {
            connection = new QueueConnection(this, (iIMQueue)destination);
        } else {
            System.err.println("Unknown Destination type");
            return null;
        }
        this.connHT.put(connection.getDestination().getUID(), connection);
        return connection;
    }

    public Connection findConnection(Destination destination) {
        return (Connection)this.connHT.get(destination.getUID());
    }

    public void removeConnection(Destination destination) {
        this.connHT.remove(destination.getUID());
    }

    public Topic[] getTopics(String string) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string == null || string.length() < 1) {
            string = "*";
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(218, string, "*"))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Topic[])Command.getReplyArg1(commandData2);
    }

    public Room[] getRooms(String string) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string == null || string.length() < 1) {
            string = "*";
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(217, string))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Room[])Command.getReplyArg1(commandData2);
    }

    public Room[] getManagedRooms(String string) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string == null || string.length() < 1) {
            string = "*";
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(217, this.getServerName(), string, new Integer(14)))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Room[])Command.getReplyArg1(commandData2);
    }

    public iIMQueue[] getQueues(String string) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string == null || string.equals("")) {
            string = this.currentServer;
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(219, string))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMQueue[])Command.getReplyArg1(commandData2);
    }

    void start(Connection connection, String string) throws CollaborationException {
        CommandData commandData = Command.create(201, connection.getDestination(), string, new Boolean(connection.isArchiveEnabled()));
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        if (commandData2.args.length > 2) {
            int n;
            connection.getDestination()._access = n = ((Integer)Command.getReplyArg1(commandData2)).intValue();
        }
    }

    void stop(Connection connection) throws CollaborationException {
        CommandData commandData = Command.create(202, connection.getDestination(), new Boolean(connection.isArchiveEnabled()));
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void setArchive(Destination destination, boolean bl) throws CollaborationException {
        CommandData commandData = Command.create(228, destination, new Boolean(bl));
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void addMsg(Message message) throws CollaborationException {
        Object object;
        if (message.getFrom() == null) {
            message.setFrom(new iIMQueue(this.nlu));
        }
        CommandData commandData = Command.create(203, message);
        if (message instanceof RoomMsg && ((Destination[])(object = message.getTo())).length > 0) {
            for (int i = 0; i < ((Destination[])object).length; ++i) {
                Destination destination = object[i];
                if (!(destination instanceof Room)) continue;
                Connection connection = this.findConnection(destination);
                if (connection == null) {
                    System.err.println("addMsg: no connection for " + destination.getName());
                    continue;
                }
                connection.addMessage(message, commandData);
            }
        }
        if ((object = this.sendCommand(commandData)) == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void addServerMsg(Message message, MessageListener messageListener) throws CollaborationException {
        if (this.nlu != null) {
            System.err.println("addServerMsg: called by real user " + this.nlu.getUID());
            return;
        }
        Destination[] destinationArray = message.getTo();
        if (destinationArray.length > 0) {
            for (int i = 0; i < destinationArray.length; ++i) {
                Destination destination = destinationArray[i];
                if (!(destination instanceof Room) && !(destination instanceof Topic)) continue;
                Connection connection = this.findConnection(destination);
                if (connection == null) {
                    System.err.println("addServerMsg: no connection for " + destination.getUID());
                    continue;
                }
                CommandData commandData = Command.create(101, destination, message);
                connection.removeChangeListener(messageListener);
                connection.addMessage(message, commandData);
                connection.addChangeListener(messageListener);
            }
        }
    }

    public void delMsg(Destination destination, Message message) throws CollaborationException {
        CommandData commandData = Command.create(204, destination, message.getMsgid());
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void markRead(Message message) throws CollaborationException {
        CommandData commandData = Command.create(211, message.getMsgid(), message.getFrom());
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void addTopic(Topic topic) throws CollaborationException {
        CommandData commandData = Command.create(206, topic);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void addRoom(Room room, boolean bl) throws CollaborationException {
        CommandData commandData = Command.create(212, room, new Boolean(bl));
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void setUserStatus(int n, String string) throws CollaborationException {
        CommandData commandData = Command.create(224, new Integer(n), string);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void delRoom(Room room) throws CollaborationException {
        CommandData commandData = Command.create(213, room);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void delTopic(Topic topic) throws CollaborationException {
        CommandData commandData = Command.create(207, topic);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public Properties getUserSettings(iIMUser iIMUser2) throws CollaborationException {
        CommandData commandData = Command.create(221, iIMUser2);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Properties)Command.getReplyArg1(commandData2);
    }

    public void saveUserSettings(iIMUser iIMUser2, Properties properties, boolean bl) throws CollaborationException {
        CommandData commandData = Command.create(205, iIMUser2, properties, new Boolean(bl));
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public iIMGroup[] getGroups(String string) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string == null || string.equals("")) {
            string = this.currentServer;
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(209, string))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMGroup[])Command.getReplyArg1(commandData2);
    }

    public boolean isMemberOf(iIMUser iIMUser2, iIMGroup iIMGroup2) throws CollaborationException {
        CommandData commandData = Command.create(222, iIMUser2, iIMGroup2);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        Boolean bl = (Boolean)Command.getReplyArg1(commandData2);
        return bl;
    }

    public iIMUser getCurrentUser() {
        return this.nlu;
    }

    public String[] getServers() throws CollaborationException {
        String[] stringArray = new String[]{this.currentServer};
        return stringArray;
    }

    public iIMGroup[] getiIMGroupsFromUIDs(String[] stringArray) throws CollaborationException {
        CommandData commandData = Command.create(225, new Boolean(true), stringArray);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMGroup[])Command.getReplyArg1(commandData2);
    }

    public iIMPrincipal[] getPrincipalsFromUIDs(String[] stringArray) throws CollaborationException {
        if (this._serverVersion > 0.0f) {
            CommandData commandData = Command.create(229, new Boolean(true), stringArray);
            CommandData commandData2 = this.sendCommand(commandData);
            if (commandData2 == null) {
                throw new CollaborationException("No reply from server");
            }
            return (iIMPrincipal[])Command.getReplyArg1(commandData2);
        }
        return this.getiIMUsersFromUIDs(stringArray);
    }

    public iIMGroup getiIMGroupFromUID(String string) throws CollaborationException {
        String[] stringArray = new String[]{string};
        CommandData commandData = Command.create(225, new Boolean(true), stringArray);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        iIMGroup[] iIMGroupArray = (iIMGroup[])Command.getReplyArg1(commandData2);
        return iIMGroupArray[0];
    }

    public iIMUser[] getiIMUsersFromUIDs(String[] stringArray) throws CollaborationException {
        CommandData commandData = Command.create(208, new Boolean(true), stringArray);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMUser[])Command.getReplyArg1(commandData2);
    }

    public UserSearchReply searchForiIMUsers(String string, String string2, boolean bl) throws CollaborationException {
        CommandData commandData = Command.create(226, "*", string2, new Boolean(bl));
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        return (UserSearchReply)Command.getReplyArg1(commandData2);
    }

    public Room[] searchRooms(String string, String string2) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string == null || string.length() < 1) {
            string = "*";
        }
        if (string2 == null || string2.length() < 1) {
            string2 = "*";
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(217, string, string2))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Room[])Command.getReplyArg1(commandData2);
    }

    public Topic[] searchTopics(String string, String string2) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string == null || string.length() < 1) {
            string = "*";
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(218, string, string2))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Topic[])Command.getReplyArg1(commandData2);
    }

    public Topic[] getManagedTopics(String string) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string == null || string.length() < 1) {
            string = "*";
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(218, this.getServerName(), string, new Integer(14)))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (Topic[])Command.getReplyArg1(commandData2);
    }

    public iIMUser getiIMUserFromUID(String string) throws CollaborationException {
        String[] stringArray = new String[]{string};
        CommandData commandData = Command.create(208, new Boolean(true), stringArray);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        iIMUser[] iIMUserArray = (iIMUser[])Command.getReplyArg1(commandData2);
        return iIMUserArray[0];
    }

    public iIMUser[] getiIMUsersInGroup(String string) throws CollaborationException {
        CommandData commandData = Command.create(208, new Boolean(false), string);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        return (iIMUser[])Command.getReplyArg1(commandData2);
    }

    public UserStatus[] getUserStatus(iIMQueue[] iIMQueueArray, boolean bl) throws CollaborationException {
        CommandData commandData = Command.create(210, iIMQueueArray, new Boolean(bl));
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
        Integer[] integerArray = (Integer[])Command.getReplyArg1(commandData2);
        String[] stringArray = (String[])Command.getReplyArg2(commandData2);
        Integer[] integerArray2 = (Integer[])Command.getReplyArg3(commandData2);
        UserStatus[] userStatusArray = new UserStatus[iIMQueueArray.length];
        for (int i = 0; i < iIMQueueArray.length; ++i) {
            userStatusArray[i] = new UserStatus(integerArray[i], stringArray[i], integerArray2[i]);
        }
        return userStatusArray;
    }

    public UserStatus getUserStatus(iIMQueue iIMQueue2, boolean bl) throws CollaborationException {
        iIMQueue[] iIMQueueArray = new iIMQueue[]{iIMQueue2};
        UserStatus[] userStatusArray = this.getUserStatus(iIMQueueArray, bl);
        return userStatusArray[0];
    }

    public BooleanAccessControlList getAdminACL(String string) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("admin", string, null);
    }

    public BooleanAccessControlList getTopicsAddDelACL(String string) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("topicsAddDel", string, null);
    }

    public BooleanAccessControlList getSendAlertsACL(String string) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("sendAlerts", string, null);
    }

    public BooleanAccessControlList getRoomsAddDelACL(String string) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("roomsAddDel", string, null);
    }

    public BooleanAccessControlList getSaveUserSettingsACL(String string) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("saveUserSettings", string, null);
    }

    public BooleanAccessControlList getWatchACL(String string) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("watch", string, null);
    }

    public DestinationAccessControlList getDestinationACL(Destination destination) throws CollaborationException {
        return (DestinationAccessControlList)this.getACL("destination", destination.getLocation(), destination);
    }

    public BooleanAccessControlList getUserACL(String string, iIMUser iIMUser2) throws CollaborationException {
        return (BooleanAccessControlList)this.getACL("user", string, iIMUser2);
    }

    public void setAdminACL(String string, BooleanAccessControlList booleanAccessControlList) throws CollaborationException {
        this.setACL(booleanAccessControlList, "admin", string, null);
    }

    public void setTopicsAddDelACL(String string, BooleanAccessControlList booleanAccessControlList) throws CollaborationException {
        this.setACL(booleanAccessControlList, "topicsAddDel", string, null);
    }

    public void setSendAlertsACL(String string, BooleanAccessControlList booleanAccessControlList) throws CollaborationException {
        this.setACL(booleanAccessControlList, "sendAlerts", string, null);
    }

    public void setRoomsAddDelACL(String string, BooleanAccessControlList booleanAccessControlList) throws CollaborationException {
        this.setACL(booleanAccessControlList, "roomsAddDel", string, null);
    }

    public void setSaveUserSettingsACL(String string, BooleanAccessControlList booleanAccessControlList) throws CollaborationException {
        this.setACL(booleanAccessControlList, "saveUserSettings", string, null);
    }

    public void setWatchACL(String string, BooleanAccessControlList booleanAccessControlList) throws CollaborationException {
        this.setACL(booleanAccessControlList, "watch", string, null);
    }

    public void setDestinationACL(DestinationAccessControlList destinationAccessControlList, Destination destination) throws CollaborationException {
        this.setACL(destinationAccessControlList, "destination", destination.getLocation(), destination);
    }

    public void saveDestinationProperties(Destination destination) throws CollaborationException {
        if (this._serverVersion > 3.0f) {
            CommandData commandData;
            CommandData commandData2;
            String string = destination.getLocation();
            if (string == null || string.equals("")) {
                string = this.currentServer;
            }
            if ((commandData2 = this.sendCommand(commandData = Command.create(227, destination))) == null) {
                throw new CollaborationException("No reply from server");
            }
        }
    }

    public void setUserACL(String string, iIMUser iIMUser2, BooleanAccessControlList booleanAccessControlList) throws CollaborationException {
        this.setACL(booleanAccessControlList, "user", string, iIMUser2);
    }

    public boolean checkAdminACL(String string) throws CollaborationException {
        boolean[] blArray = this.checkACL("admin", string, null, 0);
        return blArray[0];
    }

    public boolean checkTopicsAddDelACL(String string) throws CollaborationException {
        boolean[] blArray = this.checkACL("topicsAddDel", string, null, 0);
        return blArray[0];
    }

    public boolean checkSendAlertsACL(String string) throws CollaborationException {
        boolean[] blArray = this.checkACL("sendAlerts", string, null, 0);
        return blArray[0];
    }

    public boolean checkRoomsAddDelACL(String string) throws CollaborationException {
        boolean[] blArray = this.checkACL("roomsAddDel", string, null, 0);
        return blArray[0];
    }

    public boolean checkSaveUserSettingsACL(String string) throws CollaborationException {
        boolean[] blArray = this.checkACL("saveUserSettings", string, null, 0);
        return blArray[0];
    }

    public boolean checkWatchACL(String string) throws CollaborationException {
        boolean[] blArray = this.checkACL("watch", string, null, 0);
        return blArray[0];
    }

    public boolean[] checkDestinationACL(String string, Destination[] destinationArray, int n) throws CollaborationException {
        return this.checkACL("destination", string, destinationArray, n);
    }

    public boolean[] checkUserACL(String string, iIMUser[] iIMUserArray) throws CollaborationException {
        return this.checkACL("user", string, iIMUserArray, 0);
    }

    private void setACL(Object object, String string, String string2, Object object2) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string2 == null || string2.equals("")) {
            string2 = this.currentServer;
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(215, string, string2, object2, object))) == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    private Object getACL(String string, String string2, Object object) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string2 == null || string2.equals("")) {
            string2 = this.currentServer;
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(214, string, string2, object))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return Command.getReplyArg1(commandData2);
    }

    private boolean[] checkACL(String string, String string2, Object[] objectArray, int n) throws CollaborationException {
        CommandData commandData;
        CommandData commandData2;
        if (string2 == null || string2.equals("")) {
            string2 = this.currentServer;
        }
        if ((commandData2 = this.sendCommand(commandData = Command.create(216, string, string2, objectArray, new Integer(n)))) == null) {
            throw new CollaborationException("No reply from server");
        }
        return (boolean[])Command.getReplyArg1(commandData2);
    }

    public void subscribe(Destination destination, iIMPrincipal iIMPrincipal2) throws CollaborationException {
        CommandData commandData = Command.create(231, destination, iIMPrincipal2);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public void unsubscribe(Destination destination, iIMPrincipal iIMPrincipal2) throws CollaborationException {
        CommandData commandData = Command.create(232, destination, iIMPrincipal2);
        CommandData commandData2 = this.sendCommand(commandData);
        if (commandData2 == null) {
            throw new CollaborationException("No reply from server");
        }
    }

    public synchronized void addUserStatusListener(UserStatusListener userStatusListener) {
        if (this.userStatusListeners.contains(userStatusListener)) {
            return;
        }
        Vector vector = (Vector)this.userStatusListeners.clone();
        vector.addElement(userStatusListener);
        this.userStatusListeners = vector;
    }

    public synchronized void removeUserStatusListener(UserStatusListener userStatusListener) {
        if (!this.userStatusListeners.contains(userStatusListener)) {
            return;
        }
        Vector vector = (Vector)this.userStatusListeners.clone();
        vector.removeElement(userStatusListener);
        this.userStatusListeners = vector;
    }

    protected void fireUserStatus(String string, int n, String string2, int n2, CommandData commandData) {
        Vector vector = this.userStatusListeners;
        int n3 = vector.size();
        if (n3 == 0) {
            return;
        }
        UserStatus userStatus = new UserStatus(n, string2, n2);
        UserEvent userEvent = new UserEvent(string, userStatus, commandData);
        for (int i = 0; i < n3; ++i) {
            UserStatusListener userStatusListener = (UserStatusListener)vector.elementAt(i);
            userStatusListener.userStatusChange(userEvent);
        }
    }

    public synchronized void addMsgStatusListener(MsgStatusListener msgStatusListener) {
        if (this.msgStatusListeners.contains(msgStatusListener)) {
            return;
        }
        Vector vector = (Vector)this.msgStatusListeners.clone();
        vector.addElement(msgStatusListener);
        this.msgStatusListeners = vector;
    }

    public synchronized void removeMsgStatusListener(MsgStatusListener msgStatusListener) {
        if (!this.msgStatusListeners.contains(msgStatusListener)) {
            return;
        }
        Vector vector = (Vector)this.msgStatusListeners.clone();
        vector.removeElement(msgStatusListener);
        this.msgStatusListeners = vector;
    }

    protected void fireMsgStatus(Destination destination, Integer n, String string, String string2, CommandData commandData) {
        Vector vector = this.msgStatusListeners;
        int n2 = vector.size();
        if (n2 == 0) {
            return;
        }
        MessageStatusEvent messageStatusEvent = new MessageStatusEvent(destination, n, string, string2, commandData);
        for (int i = 0; i < n2; ++i) {
            MsgStatusListener msgStatusListener = (MsgStatusListener)vector.elementAt(i);
            msgStatusListener.msgStatusChange(messageStatusEvent);
        }
    }

    public synchronized void addConnectionStatusListener(ConnectionStatusListener connectionStatusListener) {
        if (this.cfStatusListeners.contains(connectionStatusListener)) {
            return;
        }
        this.cfStatusListeners.addElement(connectionStatusListener);
    }

    public synchronized void removeConnectionStatusListener(ConnectionStatusListener connectionStatusListener) {
        this.cfStatusListeners.removeElement(connectionStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireConnectionLost(String string, int n) {
        Vector vector;
        ConnectionFactory connectionFactory = this;
        synchronized (connectionFactory) {
            vector = (Vector)this.cfStatusListeners.clone();
        }
        int n2 = vector.size();
        if (n2 == 0) {
            return;
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(string, n, null);
        for (int i = 0; i < n2; ++i) {
            ConnectionStatusListener connectionStatusListener = (ConnectionStatusListener)vector.elementAt(i);
            connectionStatusListener.connectionLost(connectionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireUpdateAvailable(String string, CommandData commandData) {
        Vector vector;
        ConnectionFactory connectionFactory = this;
        synchronized (connectionFactory) {
            vector = (Vector)this.cfStatusListeners.clone();
        }
        int n = vector.size();
        if (n == 0) {
            return;
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(string, 0, commandData);
        for (int i = 0; i < n; ++i) {
            ConnectionStatusListener connectionStatusListener = (ConnectionStatusListener)vector.elementAt(i);
            connectionStatusListener.updateAvailable(connectionEvent);
        }
    }

    static {
        try {
            processId = InetAddress.getLocalHost().getHostAddress() + "." + System.getProperty(JVMID_PROP, "jvm");
        }
        catch (Exception exception) {
            processId = "ip." + System.getProperty(JVMID_PROP, "pid");
        }
    }
}

