/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.CommandData;
import com.iplanet.im.net.ConnectionFactory;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.Message;
import com.iplanet.im.net.MessageEvent;
import com.iplanet.im.net.MessageListener;
import com.sun.im.service.CollaborationException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Connection {
    protected Vector changeListeners = new Vector(2);
    protected Destination destination;
    protected ConnectionFactory cf;
    private int startCnt;
    private boolean isStarted = false;
    protected boolean archive = false;

    void addMessage(Message message, CommandData commandData) {
        this.fireMessageAdded(message, commandData);
    }

    void delMessage(String string, CommandData commandData) {
        this.fireMessageDeleted(string, commandData);
    }

    public String getName() {
        return this.destination.getName();
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void start() throws CollaborationException {
        this.start(null);
    }

    public void start(String string) throws CollaborationException {
        ++this.startCnt;
        this.cf.start(this, string);
        this.isStarted = true;
    }

    public void stop() throws CollaborationException {
        if (this.isStarted) {
            this.cf.stop(this);
            this.isStarted = false;
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public synchronized void addChangeListener(MessageListener messageListener) {
        if (!this.changeListeners.contains(messageListener)) {
            this.changeListeners.addElement(messageListener);
        }
    }

    public boolean hasChangeListener() {
        return !this.changeListeners.isEmpty();
    }

    public synchronized void removeChangeListener(MessageListener messageListener) {
        this.changeListeners.removeElement(messageListener);
    }

    public synchronized Enumeration getChangeListeners() {
        Vector vector = (Vector)this.changeListeners.clone();
        return vector.elements();
    }

    protected void fireMessageAdded(Message message, CommandData commandData) {
        if (this.changeListeners.isEmpty()) {
            return;
        }
        MessageEvent messageEvent = new MessageEvent(this, message, commandData);
        Enumeration enumeration = this.changeListeners.elements();
        while (enumeration.hasMoreElements()) {
            MessageListener messageListener = (MessageListener)enumeration.nextElement();
            messageListener.messageAdded(messageEvent);
        }
    }

    protected void fireMessageDeleted(String string, CommandData commandData) {
        if (this.changeListeners.isEmpty()) {
            return;
        }
        MessageEvent messageEvent = new MessageEvent(this, string, commandData);
        Enumeration enumeration = this.changeListeners.elements();
        while (enumeration.hasMoreElements()) {
            MessageListener messageListener = (MessageListener)enumeration.nextElement();
            messageListener.messageDeleted(messageEvent);
        }
    }

    public void setArchive(boolean bl) {
        this.archive = bl;
    }

    public boolean isArchiveEnabled() {
        return this.archive;
    }
}

