/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.net;

import com.iplanet.im.net.CommandData;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class CommandToNet {
    private byte[] databuff = new byte[4096];
    private ByteArrayInputStream bais = new ByteArrayInputStream(this.databuff);
    private ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private boolean useMux = false;

    public CommandToNet() {
    }

    public CommandToNet(boolean bl) {
        this.useMux = bl;
    }

    public CommandData readCommand(DataInputStream dataInputStream) throws IOException, ClassNotFoundException {
        int n;
        int n2;
        if (this.useMux) {
            n2 = dataInputStream.readInt();
        }
        if ((n2 = dataInputStream.readInt()) > this.databuff.length) {
            this.databuff = new byte[n2];
            this.bais = new ByteArrayInputStream(this.databuff);
        }
        for (int i = 0; i < n2; i += n) {
            n = dataInputStream.read(this.databuff, i, n2 - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(this.bais);
        Object object = objectInputStream.readObject();
        objectInputStream.close();
        this.bais.reset();
        objectInputStream = null;
        if (object instanceof CommandData) {
            return (CommandData)object;
        }
        System.err.println("Plainsocket unknown object type: " + object);
        return null;
    }

    public void sendCommand(DataOutputStream dataOutputStream, CommandData commandData) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.baos);
        objectOutputStream.writeObject(commandData);
        objectOutputStream.close();
        objectOutputStream = null;
        int n = this.baos.size();
        if (this.useMux) {
            dataOutputStream.writeInt(n + 4);
        }
        dataOutputStream.writeInt(n);
        this.baos.writeTo(dataOutputStream);
        this.baos.reset();
        dataOutputStream.flush();
    }
}

