/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api.test;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.im.client.api.test.ArchiveTest;
import com.iplanet.im.client.api.test.NoSuchConferenceException;
import com.iplanet.im.client.api.test.YesOrNoListener;
import com.iplanet.im.client.api.test.iIMCLIConference;
import com.iplanet.im.client.api.test.iIMCLINewsChannel;
import com.iplanet.sso.SSOToken;
import com.sun.im.identity.util.Auth;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.CollaborationSession;
import com.sun.im.service.CollaborationSessionFactory;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceSession;
import com.sun.im.service.ConferenceSessionListener;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.InviteMessageStatusListener;
import com.sun.im.service.Message;
import com.sun.im.service.MessagePart;
import com.sun.im.service.MessageStatusListener;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.NewsSession;
import com.sun.im.service.NotificationSession;
import com.sun.im.service.NotificationSessionListener;
import com.sun.im.service.PersonalConference;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGroup;
import com.sun.im.service.PersonalProfile;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreFolder;
import com.sun.im.service.PersonalStoreSession;
import com.sun.im.service.Poll;
import com.sun.im.service.PollHelper;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceAccessRule;
import com.sun.im.service.PresenceHelper;
import com.sun.im.service.PresenceInfoListener;
import com.sun.im.service.PresenceSession;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.util.StringUtility;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;

public class iimtalk
implements NotificationSessionListener,
ConferenceSessionListener,
PresenceInfoListener,
MessageStatusListener,
InviteMessageStatusListener,
SecureSessionListener {
    CollaborationSession _session;
    PresenceSession _presenceSession;
    NewsSession _newsSession;
    ConferenceSession _conferenceSession;
    NotificationSession _messageSession;
    PersonalStoreSession _personalStoreSession;
    private static boolean _usesso = false;
    private static String _defaultDomain;
    private static AMStoreConnection _adminConnection;
    Vector _receivedMessages;
    CollaborationSessionFactory _factory;
    BufferedReader _reader;
    boolean interactive;
    Hashtable _conferences = new Hashtable();
    Hashtable _confnames = new Hashtable();
    Hashtable _polls = new Hashtable();
    CollaborationPrincipal _principal;
    private boolean bYesOrNo;
    boolean waiting;
    boolean running;
    boolean inTestingMode = false;
    final int testModeWaitMsec = 500;
    String sessionId;
    private static String imServer;
    String server = null;
    String user = System.getProperty("user.name");
    String password = "iplanet";
    static String _inputFileName;

    public iimtalk() throws Exception {
        this.init(true, null);
    }

    public iimtalk(BufferedReader br, boolean doingMultiimtalkTesting) throws Exception {
        this.inTestingMode = doingMultiimtalkTesting;
        this.init(false, br);
    }

    private void init(boolean interactive, BufferedReader br) throws Exception {
        this.interactive = interactive;
        this._reader = br != null ? br : new BufferedReader(new InputStreamReader(System.in));
        this._factory = new CollaborationSessionFactory();
        this._receivedMessages = new Vector();
    }

    protected String getCanonicalConferenceName(Conference conf) {
        return conf.getDestination();
    }

    protected void assignLocalName(String name, String confDest) {
        this._confnames.put(name, confDest);
    }

    protected void assignLocalNameIfSameDomain(String confDest) {
        if (confDest.endsWith("@" + this._principal.getDomainName())) {
            this._confnames.put(StringUtility.getLocalPartFromAddress(confDest), confDest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        block8: while (true) {
            try {
                while (true) {
                    String s;
                    if (this.interactive) {
                        System.out.print("\niimtalk> ");
                    }
                    if ((s = this._reader.readLine()) == null) break block8;
                    if ((s = s.trim()).equals("")) continue;
                    this.running = true;
                    StringTokenizer st = new StringTokenizer(s);
                    String cmd = st.nextToken();
                    String[] args = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        args[i++] = st.nextToken();
                    }
                    if (cmd.equals("amc") || cmd.equalsIgnoreCase("AddMessageConference")) {
                        this.addConferenceMessage(args);
                    } else if (cmd.equals("amnc") || cmd.equalsIgnoreCase("AddMessageNewsChannel")) {
                        this.addNewsMessage(args);
                    } else if (cmd.equals("send")) {
                        this.sendMessage(args);
                    } else if (!cmd.equals("search")) {
                        if (cmd.equals("pause")) {
                            Thread.sleep(1000L);
                        } else if (cmd.equals("cnc")) {
                            this.addNewsChannel(args);
                        } else if (cmd.equals("snc")) {
                            this.subscribeNewsChannel(args);
                        } else if (cmd.equals("unc")) {
                            this.unSubscribeNewsChannel(args);
                        } else if (cmd.equals("rnc")) {
                            this.delNewsChannel(args);
                        } else if (cmd.equals("ac")) {
                            this.addConference(args);
                        } else if (cmd.equals("apc")) {
                            this.addPublicConference(args);
                        } else if (cmd.equals("jpc")) {
                            this.joinPublicConference(args);
                        } else if (cmd.equals("rc")) {
                            this.delRoom(args);
                        } else if (cmd.equals("login")) {
                            this.login(args);
                        } else if (cmd.equals("dmnc")) {
                            this.delNewsMessage(args);
                        } else if (cmd.equals("lmnc")) {
                            this.listMessages(args);
                        } else if (cmd.equals("lsnc")) {
                            this.listNewsChannels(args);
                        } else if (!cmd.equals("lq")) {
                            if (cmd.equals("lsc")) {
                                this.listPublicConferences(args);
                            } else if (!cmd.equals("lu") && !cmd.equals("lg")) {
                                if (cmd.equals("lc")) {
                                    this.quitRoom(args);
                                } else if (cmd.equals("cacl")) {
                                    this.editConferenceAcl(args);
                                } else if (cmd.equals("status")) {
                                    this.sendMessageStatus(args);
                                } else if (cmd.equals("reply")) {
                                    this.sendMessageReply(args);
                                } else if (cmd.equals("getdp")) {
                                    this.getDestinationProperty(args);
                                } else if (cmd.equals("setdp")) {
                                    this.setDestinationProperty(args);
                                } else if (cmd.equals("rmdp")) {
                                    this.removeDestinationProperty(args);
                                } else if (!cmd.equals("s")) {
                                    if (cmd.equals("h") || cmd.equals("help")) {
                                        this.help();
                                    } else {
                                        if (cmd.equals("e") || cmd.equals("logout") || cmd.equals("exit") || cmd.equals("quit")) {
                                            this.logout();
                                            this.running = false;
                                            break block8;
                                        }
                                        if (cmd.equals("iuc")) {
                                            this.invite(args);
                                        } else if (!(cmd.equals("checkacl") || cmd.equals("ls") || cmd.equals("ss"))) {
                                            iimtalk iimtalk2;
                                            if (cmd.equals("ppi")) {
                                                this.publishPresenceInfo(args);
                                            } else if (cmd.equals("fpi")) {
                                                this.fetchPresenceInfo(args);
                                            } else if (cmd.equals("spi")) {
                                                this.subscribePresenceInfo(args);
                                            } else if (cmd.equals("uspi")) {
                                                this.unsubscribePresenceInfo(args);
                                            } else if (cmd.equals("pacl")) {
                                                this.editPresenceAcl(args);
                                            } else if (cmd.equals("sacl")) {
                                                this.showPresenceAcl(args);
                                            } else if (cmd.equals("poll")) {
                                                this.sendPollMessage(args);
                                            } else if (cmd.equals("pollr")) {
                                                this.sendPollResponse(args);
                                            } else if (cmd.equals("acon")) {
                                                this.addContact(args);
                                            } else if (cmd.equals("rcon")) {
                                                this.removeContact(args);
                                            } else if (cmd.equals("agrp")) {
                                                this.addContactGroup(args);
                                            } else if (cmd.equals("rgrp")) {
                                                this.removeContactGroup(args);
                                            } else if (cmd.equals("afol")) {
                                                this.addContactFolder(args);
                                            } else if (cmd.equals("rfol")) {
                                                this.removeContactFolder(args);
                                            } else if (cmd.equals("lcon")) {
                                                this.listContacts(args);
                                            } else if (cmd.equals("lpro")) {
                                                this.listProfile(args);
                                            } else if (cmd.equals("gpro")) {
                                                this.getProfile(args);
                                            } else if (cmd.equals("cpro")) {
                                                this.changeProfile(args);
                                            } else if (cmd.equals("rpro")) {
                                                this.removeProfile(args);
                                            } else if (cmd.equals("asub")) {
                                                this.addSubscription(args);
                                            } else if (cmd.equals("rsub")) {
                                                this.removeSubscription(args);
                                            } else if (cmd.equals("lsub")) {
                                                this.listSubscriptions(args);
                                            } else if (cmd.equals("rat")) {
                                                this.runArchiveTest(args);
                                            } else if (cmd.equals("?")) {
                                                this.help();
                                            } else if (cmd.equalsIgnoreCase("y") || cmd.equalsIgnoreCase("yes")) {
                                                iimtalk2 = this;
                                                synchronized (iimtalk2) {
                                                    this.bYesOrNo = true;
                                                    this.notify();
                                                }
                                            } else if (cmd.equalsIgnoreCase("n") || cmd.equalsIgnoreCase("no")) {
                                                iimtalk2 = this;
                                                synchronized (iimtalk2) {
                                                    this.bYesOrNo = false;
                                                    this.notify();
                                                }
                                            } else {
                                                System.out.println("error: unknown command : " + cmd);
                                                if (this.interactive) {
                                                    this.help();
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    this.running = false;
                }
            }
            catch (Exception e) {
                this.running = false;
                System.out.println("Error " + e.toString());
                e.printStackTrace();
                continue;
            }
            break;
        }
        this._factory.close();
    }

    void help() {
        System.out.println("");
        System.out.println("login = start a session with presence, conference,");
        System.out.println("        message, and news channel services");
        System.out.println("");
        System.out.println(" --- PRESENCE --- ");
        System.out.println("ppi  = publish availability      fpi  = fetch availability");
        System.out.println("spi  = subcribe to availability  uspi = unsubcribe to availability");
        System.out.println("sacl = show presence rule acl    pacl = edit presence rule acl");
        System.out.println("");
        System.out.println(" --- CONFERENCE ---");
        System.out.println("amc  = add or send a message     iuc = invite user");
        System.out.println("ac   = setup conference          rc  = remove conference");
        System.out.println("jpc  = join public conference    lc  = leave conference");
        System.out.println("lsc  = list public conferences   apc = add public conference");
        System.out.println("cacl = edit access rules");
        System.out.println("");
        System.out.println(" --- NEWS --- ");
        System.out.println("cnc  = create news channel       rnc = remove news channel");
        System.out.println("snc  = subscribe news channel    unc = unsubscribe news channel");
        System.out.println("lsnc = list news channels        amnc = post a message");
        System.out.println("lmnc = list messages             dmnc = delete message");
        System.out.println("");
        System.out.println(" --- NOTIFICATION --- ");
        System.out.println("send = send a message to users");
        System.out.println("status = send message status     reply reply last message");
        System.out.println("poll = send poll message         pollr send poll response");
        System.out.println("");
        System.out.println(" --- PERSONAL STORE --- ");
        System.out.println("lcon = list contacts\t\t");
        System.out.println("rcon = remove contact            acon = add contact");
        System.out.println("rgrp = remove contact group      agrp = add contact group");
        System.out.println("rfol = remove contact folder     afol = add contact folder");
        System.out.println("lpro = list profile info         rpro = remove profile info");
        System.out.println("gpro = get profile info          cpro = change profile info");
        System.out.println("asub = subscribe to destination  rsub = unsubscribe");
        System.out.println("lsub = list subscriptions");
        System.out.println();
        System.out.println(" --- ARCHIVE TEST --- ");
        System.out.println("rat = run archive tests\t\t");
        System.out.println();
        System.out.println("e = exit");
        System.out.println("h = print this help");
        System.out.println("for help on a command type \"command ?\"");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getYesOrNo(String ask, boolean synchronous) throws Exception {
        if (synchronous) {
            YesOrNoListener listener = new YesOrNoListener(this._reader);
            Thread yesOrNoThread = new Thread(listener);
            yesOrNoThread.start();
            System.out.println(ask);
            YesOrNoListener yesOrNoListener = listener;
            synchronized (yesOrNoListener) {
                listener.wait();
            }
            yesOrNoThread.join();
            return listener.booleanValue();
        }
        System.out.println(ask);
        iimtalk iimtalk2 = this;
        synchronized (iimtalk2) {
            this.wait();
        }
        return this.bYesOrNo;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public boolean isRunning() {
        return this.running;
    }

    protected String prompt(String ask, boolean newline) {
        return this.prompt(ask, newline, "");
    }

    protected String prompt(String ask, boolean newline, String defaultValue) {
        String ret = defaultValue;
        this.waiting = true;
        if (newline) {
            System.out.println(ask);
        } else {
            System.out.print(ask);
        }
        try {
            String s = this._reader.readLine();
            if (s.length() > 0) {
                ret = s;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.waiting = false;
        return ret;
    }

    protected String[] promptValues(String ask, boolean newline, String defaultValue) {
        String s = this.prompt(ask, false, defaultValue);
        if (s != null && s.length() > 0) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(s);
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            String[] array = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                array[i] = (String)list.get(i);
            }
            return array;
        }
        return null;
    }

    private void logout() throws Exception {
        if (this._presenceSession != null) {
            this._presenceSession.logout();
        }
        if (this._conferenceSession != null) {
            this._conferenceSession.logout();
        }
        if (this._newsSession != null) {
            this._newsSession.logout();
        }
        if (this._messageSession != null) {
            this._messageSession.logout();
        }
        if (this._personalStoreSession != null) {
            this._personalStoreSession.logout();
        }
    }

    private String loginDSAME(String user, String password) throws Exception {
        if (this.interactive) {
            System.out.println("login through Identity Server");
            System.out.println("default domain " + _defaultDomain);
        }
        SSOToken token = null;
        try {
            String domain = StringUtility.getDomainFromAddress(user, _defaultDomain);
            String ssoOrg = _adminConnection.getOrganizationDN(domain, null);
            user = StringUtility.getLocalPartFromAddress(user);
            token = Auth.getSSOToken((String)ssoOrg, (String)user, (String)password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (token != null) {
            if (this.interactive) {
                System.out.println("Authentication Success!");
            }
            return token.getTokenID().toString();
        }
        if (this.interactive) {
            System.out.println("Authentication Failed!");
        }
        return null;
    }

    public void login(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("login host username password");
            return;
        }
        this.server = args.length >= 1 ? args[0] : this.prompt("IM Service [" + imServer + "]: ", false, imServer);
        this.user = args.length >= 2 ? args[1] : this.prompt("User Name [" + this.user + "]: ", false, this.user);
        this.password = args.length >= 3 ? args[2] : this.prompt("Password [" + this.password + "]: ", false, this.password);
        if (_usesso) {
            String sid = this.loginDSAME(this.user, this.password);
            this.user = StringUtility.getLocalPartFromAddress(this.user);
            this._session = this._factory.getSession(this.server, this.user, sid, this);
        } else {
            this._session = this._factory.getSession(this.server, this.user, this.password, this);
        }
        this._presenceSession = (PresenceSession)this._session.accessService("presence");
        this._newsSession = (NewsSession)this._session.accessService("news");
        this._conferenceSession = (ConferenceSession)this._session.accessService("conference");
        this._messageSession = (NotificationSession)this._session.accessService("notification");
        this._personalStoreSession = (PersonalStoreSession)this._session.accessService("pstore");
        this._principal = this._session.getPrincipal();
    }

    public void onPresenceInfo(String presenceInfo) {
        PresenceHelper ph = null;
        try {
            ph = new PresenceHelper(presenceInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList tuples = (ArrayList)ph.getTuples();
        for (int i = 0; i < tuples.size(); ++i) {
            PresenceTuple t = (PresenceTuple)tuples.get(i);
            if (t.getNote() != null && t.getNote().length() > 0) {
                System.out.println("[Presence Info Received] Recipient=<" + this._principal.getUID() + "> Destination=<" + t.getPresenceURL() + "> Status=<" + t.getStatus() + "> Note=<" + t.getNote() + ">");
                continue;
            }
            System.out.println("[Presence Info Received] Recipient=<" + this._principal.getUID() + "> Destination=<" + t.getPresenceURL() + "> Status=<" + t.getStatus() + ">");
        }
    }

    private void publishPresenceInfo(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("ppi status  - publish presence status");
            return;
        }
        String status = args.length >= 1 ? args[0] : this.prompt("New presence status (OPEN, CLOSED, AWAY, IDLE, FORWARDED): ", false);
        String address = args.length >= 2 ? args[1] : this.prompt("Entity :", false);
        String note = this.prompt("Optional note: ", false);
        PresenceTuple pt = new PresenceTuple("im", address, status);
        if (note != null && note.length() > 0) {
            pt.addNote(note);
        }
        Presence p = new Presence(address);
        p.addTuple(pt);
        this._presenceSession.publish(p.toString());
    }

    public void fetchPresenceInfo(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("fpi [ entity ]");
            return;
        }
        String[] entities = args.length >= 1 ? args : this.promptValues("Entities (space-sparated): ", false, null);
        try {
            if (entities.length > 1) {
                this._presenceSession.fetch(entities, (PresenceInfoListener)this);
            } else {
                this._presenceSession.fetch(entities[0], (PresenceInfoListener)this);
            }
        }
        catch (Exception e) {
            System.out.println("Cannot fetch presence information");
        }
    }

    public void subscribePresenceInfo(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("spi [ entity ]");
            return;
        }
        String[] entities = args.length >= 1 ? args : this.promptValues("Entities (space-sparated): ", false, null);
        try {
            if (entities.length > 1) {
                this._presenceSession.subscribe(entities, (PresenceInfoListener)this);
            } else {
                this._presenceSession.subscribe(entities[0], (PresenceInfoListener)this);
            }
        }
        catch (Exception e) {
            System.out.println("Cannot subscribe to presence information");
        }
    }

    public void unsubscribePresenceInfo(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("uspi [ entity ]");
            return;
        }
        String[] entities = args.length >= 1 ? args : this.promptValues("Entities (space-sparated): ", false, null);
        if (entities.length > 1) {
            this._presenceSession.unsubscribe(entities);
        } else {
            this._presenceSession.unsubscribe(entities[0]);
        }
    }

    public void onCompletion() {
    }

    private PresenceAccessRule displayPresenceAcl() throws Exception {
        PresenceAccessRule par = (PresenceAccessRule)this._presenceSession.getAccessRules(this._principal.getUID()).iterator().next();
        if (par.grant()) {
            System.out.println("This is a grant rule");
        } else {
            System.out.println("This is a deny rule");
        }
        System.out.println("Exceptions: ");
        Collection exceptPrincipals = par.getExceptPrincipals();
        Iterator i = exceptPrincipals.iterator();
        while (i.hasNext()) {
            System.out.println("    " + ((CollaborationPrincipal)i.next()).getUID());
        }
        System.out.println();
        return par;
    }

    public void showPresenceAcl(String[] args) throws Exception {
        this.displayPresenceAcl();
    }

    private void editPresenceAcl(String[] args) throws Exception {
        String uid;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("pacl [ grant/deny ]");
            return;
        }
        System.out.println("Current presence access rule:");
        PresenceAccessRule par = this.displayPresenceAcl();
        boolean defaultAccess = par.grant();
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("deny")) {
                defaultAccess = false;
            } else if (args[0].equalsIgnoreCase("grant")) {
                defaultAccess = true;
            }
        }
        par.setGrant(defaultAccess);
        while ((uid = this.prompt("Remove exception for user (newline to skip): ", false)).length() > 1) {
            par.removeExceptPrincipal(uid);
        }
        while ((uid = this.prompt("Add exception for user (newline to skip): ", false)).length() > 1) {
            par.addExceptPrincipal(uid);
        }
        this._presenceSession.saveAccessRules();
    }

    public void setConfName(Hashtable h) {
        this._confnames = h;
    }

    private iIMCLIConference findConference(String name) throws Exception {
        String confname = (String)this._confnames.get(name);
        if (confname != null) {
            return (iIMCLIConference)this._conferences.get(confname);
        }
        return (iIMCLIConference)this._conferences.get(name);
    }

    private iIMCLINewsChannel findNewsChannel(String theName, boolean subscribe) throws Exception {
        iIMCLINewsChannel nc = null;
        String fqName = StringUtility.appendDomainToAddress(theName, this._principal.getDomainName());
        String channelName = (String)this._confnames.get(fqName);
        nc = channelName != null ? (iIMCLINewsChannel)this._conferences.get(channelName) : (iIMCLINewsChannel)this._conferences.get(fqName);
        if (nc == null) {
            try {
                nc = new iIMCLINewsChannel(this._principal.getUID(), this._newsSession, fqName, subscribe);
                this.assignLocalName(fqName, nc.getConference().getDestination());
            }
            catch (NoSuchConferenceException e) {
                // empty catch block
            }
            if (nc != null) {
                this._conferences.put(nc.getConference().getDestination(), nc);
            }
        }
        return nc;
    }

    private void invite(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("iuc [ conf [ users ] ]");
            System.out.println("invite message");
            return;
        }
        String roomname = args.length > 0 ? args[0] : this.prompt("Conference: ", false);
        String names = "";
        names = args.length >= 2 ? args[1] : this.prompt("User(s) to invite (space-separated): ", false);
        String ret = this.prompt("Invite message: ", true);
        if (ret.equals("")) {
            ret = "<empty>";
        }
        ret = "     " + ret;
        iIMCLIConference c = this.findConference(roomname = StringUtility.appendDomainToAddress(roomname, this._principal.getDomainName()));
        if (c == null) {
            System.out.println("Conference " + roomname + " not found");
            return;
        }
        Conference conf = c.getConference();
        this._conferences.put(conf.getDestination(), c);
        InviteMessage newMsg = conf.createInviteMessage();
        MessagePart part = newMsg.newPart();
        part.setContent(ret);
        newMsg.addPart(part);
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            newMsg.addRecipient(st.nextToken());
        }
        conf.invite(30, newMsg, this);
    }

    private void addConferenceMessage(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("amc [ conference ]");
            System.out.println("msg line");
            return;
        }
        Message newMsg = null;
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        iIMCLIConference c = this.findConference(name = StringUtility.appendDomainToAddress(name, this._principal.getDomainName()));
        if (c == null) {
            System.out.println("Conference " + name + " not found");
            return;
        }
        String ret = this.prompt("enter the message", true);
        Conference conf = c.getConference();
        newMsg = conf.createMessage();
        MessagePart part = newMsg.newPart();
        part.setContent(ret);
        newMsg.addPart(part);
        conf.addMessage(newMsg);
    }

    private void addPublicConference(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("apc [ conf ] ");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        try {
            iIMCLIConference c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession, name, true, true);
            this._conferences.put(c.getConference().getDestination(), c);
            name = StringUtility.appendDomainToAddress(name, this._principal.getDomainName());
            this.assignLocalName(name, c.getConference().getDestination());
            System.out.println("Created Conference " + c.getConference().getDestination());
        }
        catch (Exception e) {
            System.out.println("Cannot create conference: " + e.getMessage());
        }
    }

    private void joinPublicConference(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("jpc [ conf ] ");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        name = StringUtility.appendDomainToAddress(name, this._principal.getDomainName());
        iIMCLIConference c = this.findConference(name);
        try {
            if (c == null) {
                c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession, name, false, true);
                this._conferences.put(name, c);
            }
            if (c != null) {
                System.out.println("Joined Conference " + c.getConference().getDestination());
            } else {
                System.out.println("Failed to join conference " + name);
            }
        }
        catch (Exception e) {
            System.out.println("\nException: Unable to join conference: " + name);
        }
    }

    private void addConference(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("ac");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        name = StringUtility.appendDomainToAddress(name, this._principal.getDomainName());
        iIMCLIConference c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession);
        this._conferences.put(c.getConference().getDestination(), c);
        this.assignLocalName(name, c.getConference().getDestination());
        System.out.println("Created Conference " + name);
    }

    private void delRoom(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rc [ conf ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        name = StringUtility.appendDomainToAddress(name, this._principal.getDomainName());
        iIMCLIConference c = this.findConference(name);
        if (c == null && (c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession, name, false, false)).getConference() == null) {
            System.out.println("Room " + name + " not found.");
            return;
        }
        this._conferences.remove(c.getConference().getDestination());
        c.getConference().close();
    }

    public void quitRoom(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("lc [ conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        iIMCLIConference conf = this.findConference(name = StringUtility.appendDomainToAddress(name, this._principal.getDomainName()));
        if (conf != null) {
            conf.getConference().leave();
            this._conferences.remove(conf.getConference().getDestination());
        } else {
            System.out.println("Conference not found");
        }
    }

    public void onInvite(Conference conference, InviteMessage message) {
        System.out.println("\nYou have been invited to conference: " + this.getCanonicalConferenceName(conference) + " by: " + message.getOriginator());
        try {
            if (this.getYesOrNo("Do you want to join?", false)) {
                iIMCLIConference c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession, conference);
                this._conferences.put(conference.getDestination(), c);
                this.assignLocalNameIfSameDomain(conference.getDestination());
            } else {
                System.out.println("\nDeclining invitation");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("\n Exception thrown: Failed to join a Conference");
        }
    }

    public void onRsvp(String destination, Message message, boolean accepted) {
        this.onRsvp(destination, accepted);
        iimtalk.printMessage(message);
    }

    public void onRsvp(String destination, boolean accepted) {
        if (accepted) {
            System.out.println(destination + " accepted your invitation.");
        } else {
            System.out.println(destination + " declined your invitation.");
        }
    }

    private String accessToString(int access) {
        switch (access) {
            case 1: {
                return "NONE";
            }
            case 2: {
                return "LISTEN";
            }
            case 4: {
                return "PUBLISH";
            }
            case 30: {
                return "MANAGE";
            }
        }
        System.out.println("Invalid access level: " + access);
        return "UNKNOWN";
    }

    private int accessToVal(String access) throws Exception {
        if (access.equalsIgnoreCase("NONE")) {
            return 1;
        }
        if (access.equalsIgnoreCase("LISTEN")) {
            return 2;
        }
        if (access.equalsIgnoreCase("PUBLISH")) {
            return 4;
        }
        if (access.equalsIgnoreCase("MANAGE")) {
            return 30;
        }
        throw new Exception("invalid access level: " + access);
    }

    private void displayConferenceAcl(Conference conf) throws Exception {
        System.out.println();
    }

    private void editConferenceAcl(String[] args) throws Exception {
        String member;
        String sNewDefaultAccess;
        Conference conf;
        String sDefaultAccess;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("cacl [ public-conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        iIMCLIConference c = this.findConference(name);
        if (c == null) {
            c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession, name, false, false);
            this._conferences.put(name, c);
        }
        if (!(sDefaultAccess = this.accessToString((conf = c.getConference()).getDefaultPrivilege())).equals(sNewDefaultAccess = this.prompt("Default access [" + sDefaultAccess + "] : ", false, sDefaultAccess))) {
            conf.setDefaultPrivilege(this.accessToVal(sNewDefaultAccess));
        }
        while (!(member = this.prompt("Modify Access for: ", false)).equals("")) {
            String sAccess = this.accessToString(conf.getPrivilege(member));
            String sNewAccess = this.prompt("New access level [" + sAccess + "]: ", false, sAccess);
            try {
                conf.setPrivilege(member, this.accessToVal(sNewAccess));
            }
            catch (Exception e) {
                System.out.println("Cannot set privilege for: " + name);
            }
        }
    }

    private void getDestinationProperty(String[] args) throws Exception {
        String att;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rmdp [ conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        iIMCLIConference c = this.findConference(name);
        if (c == null) {
            c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession, name, false, false);
            this._conferences.put(name, c);
        }
        Conference conf = c.getConference();
        while (!(att = this.prompt("Property : ", false)).equals("")) {
            System.out.println("    " + att + " = " + conf.getProperty(att));
        }
    }

    private void removeDestinationProperty(String[] args) throws Exception {
        String att;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rmcp [ conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        iIMCLIConference c = this.findConference(name);
        if (c == null) {
            c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession, name, false, false);
            this._conferences.put(name, c);
        }
        Conference conf = c.getConference();
        while (!(att = this.prompt("Property : ", false)).equals("")) {
            conf.setProperty(att, null);
        }
    }

    private void setDestinationProperty(String[] args) throws Exception {
        String att;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("cacl [ conference ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("Conference: ", false);
        iIMCLIConference c = this.findConference(name);
        if (c == null) {
            c = new iIMCLIConference(this._principal.getUID(), this._conferenceSession, name, false, false);
            this._conferences.put(name, c);
        }
        Conference conf = c.getConference();
        while (!(att = this.prompt("Property : ", false)).equals("")) {
            String val = this.prompt("Value    : ", false);
            conf.setProperty(att, val);
        }
    }

    public void listPublicConferences(String[] args) throws Exception {
        Collection pcList = this._conferenceSession.listPublicConferences("*");
        System.out.println("Listing public conferences - START");
        if (pcList != null) {
            Iterator i = pcList.iterator();
            while (i.hasNext()) {
                Conference c = (Conference)i.next();
                System.out.println("    " + c.getDestination());
            }
        }
        System.out.println("Listing public conferences - END");
    }

    private void addNewsMessage(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("amnc [ channel ]");
            System.out.println("subj line");
            System.out.println("msg line");
            return;
        }
        Message newMsg = null;
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        iIMCLINewsChannel bb = this.findNewsChannel(name, true);
        if (bb == null) {
            System.out.println("News Channel " + name + " not found");
            return;
        }
        String topicSub = this.prompt("Subject: ", false);
        String ret = this.prompt("Message: ", true);
        if (ret.equals("")) {
            ret = "<empty>";
        }
        newMsg = bb.getConference().createMessage();
        MessagePart part = newMsg.newPart();
        newMsg.setHeader("subject", topicSub);
        part.setContent(ret);
        newMsg.addPart(part);
        try {
            bb.getConference().addMessage(newMsg);
        }
        catch (Exception e) {
            System.out.println("Exception thrown in addMessage");
        }
        bb._messageIdToNumber.put(newMsg.getMessageId(), Integer.toString(bb._messageIdCount));
        bb._numberToMessageId.put(Integer.toString(bb._messageIdCount), newMsg.getMessageId());
        ++bb._messageIdCount;
    }

    public void delNewsMessage(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("dmnc [ channel ]");
            System.out.println("[id]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        iIMCLINewsChannel bb = this.findNewsChannel(name, true);
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        String simpleId = "<unknown>";
        if (args.length >= 2) {
            simpleId = args[1];
        } else {
            bb.listMessages();
            simpleId = this.prompt("Id of the message delete: ", false);
        }
        String origId = (String)bb._numberToMessageId.get(simpleId);
        if (origId != null) {
            ((NewsChannel)bb.getConference()).removeMessage(origId);
            bb._messages.remove(origId);
            bb._numberToMessageId.remove(simpleId);
            bb._messageIdToNumber.remove(origId);
        } else {
            System.out.println("No message with this id: " + simpleId);
        }
    }

    public void addNewsChannel(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("cnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        iIMCLINewsChannel nc = this.findNewsChannel(name, true);
        if (nc != null) {
            System.out.println("News channel " + name + " already present.");
            return;
        }
        try {
            iIMCLINewsChannel bb = new iIMCLINewsChannel(this._principal.getUID(), this._newsSession, name, 30);
            this._conferences.put(bb.getConference().getDestination(), bb);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void subscribeNewsChannel(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("snc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        iIMCLINewsChannel bb = this.findNewsChannel(name, true);
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        System.out.println("subscribed to " + name);
    }

    public void unSubscribeNewsChannel(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("unc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        iIMCLINewsChannel bb = this.findNewsChannel(name, false);
        String fqName = StringUtility.appendDomainToAddress(name, this._principal.getDomainName());
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        bb.getConference().leave();
        this._conferences.remove(fqName);
        bb._messages.clear();
        bb._messageIdToNumber.clear();
        bb._numberToMessageId.clear();
        System.out.println("unsubscribed from " + fqName);
    }

    public void listNewsChannels(String[] args) throws Exception {
        Collection bbList = this._newsSession.listNewsChannels("*");
        System.out.println("Listing news channels - START");
        if (bbList != null) {
            Iterator bbIter = bbList.iterator();
            while (bbIter.hasNext()) {
                NewsChannel bb = (NewsChannel)bbIter.next();
                System.out.println("    " + bb.getDestination());
            }
        }
        System.out.println("Listing news channels - END");
    }

    public void delNewsChannel(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        iIMCLINewsChannel bb = this.findNewsChannel(name, false);
        if (bb == null) {
            System.out.println("news channel " + name + " not found");
            return;
        }
        bb.getConference().close();
        bb._messages.clear();
        bb._messageIdToNumber.clear();
        bb._numberToMessageId.clear();
        String fqName = StringUtility.appendDomainToAddress(name, this._principal.getDomainName());
        this._conferences.remove(fqName);
        System.out.println("News Channel " + fqName + " deleted");
    }

    private void listMessages(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("lmnc [ channel ]");
            return;
        }
        String name = args.length >= 1 ? args[0] : this.prompt("News channel: ", false);
        iIMCLINewsChannel bb = this.findNewsChannel(name, true);
        if (bb == null) {
            System.out.println("News channel " + name + " not found.");
            return;
        }
        bb.listMessages();
    }

    private void sendMessage(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("send [ users ]");
            System.out.println("subj line");
            System.out.println("msg line");
            return;
        }
        Message newMsg = null;
        String names = "";
        if (args.length >= 1) {
            names = names + args[0];
            for (int i = 1; i < args.length; ++i) {
                names = names + " " + args[i];
            }
        } else {
            names = this.prompt("recipient list (space-separated): ", false);
        }
        String sub = this.prompt("Subject: ", false);
        String ret = this.prompt("Message: ", true);
        newMsg = this._messageSession.createMessage();
        newMsg.setHeader("subject", sub);
        MessagePart part = newMsg.newPart();
        part.setContent(ret);
        newMsg.addPart(part);
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            newMsg.addRecipient(name);
        }
        this._messageSession.sendMessage(newMsg, this);
    }

    public void onMessage(Message message) {
        System.out.println("[Message Received] Recipient=<" + this._principal.getUID() + "> From=<" + message.getOriginator() + ">");
        try {
            if (message.getContentType().equalsIgnoreCase("application/x-iim-poll")) {
                MessagePart[] parts = message.getParts();
                PollHelper ph = new PollHelper(parts[0].getInputStream());
                int noOfAnswers = ph.countAnswers();
                System.out.println("Poll Question: " + ph.getQuestion());
                System.out.println("Answers: ");
                for (int i = 0; i < noOfAnswers; ++i) {
                    System.out.println(i + " " + ph.getAnswer(i));
                }
            } else {
                iimtalk.printMessage(message);
            }
            this._receivedMessages.addElement(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMessageReply(String[] args) throws Exception {
        if (this._receivedMessages.isEmpty()) {
            return;
        }
        Message message = (Message)this._receivedMessages.firstElement();
        System.out.println("Replying to " + message.getOriginator());
        Message newMsg = this._messageSession.createMessage(message.getOriginator());
        String sub = this.prompt("Subject: ", true);
        String ret = this.prompt("Message: ", true);
        newMsg.setHeader("subject", sub);
        MessagePart part = newMsg.newPart();
        part.setContent(ret);
        newMsg.addPart(part);
        message.sendReply(newMsg);
        this._receivedMessages.remove(message);
    }

    private void sendMessageStatus(String[] args) throws Exception {
        if (this._receivedMessages.isEmpty()) {
            return;
        }
        Message message = (Message)this._receivedMessages.firstElement();
        this._receivedMessages.remove(message);
        try {
            message.sendStatus(7);
        }
        catch (Exception e) {
            System.out.println("Exception thrown in sendMessageStatus");
        }
    }

    public boolean onX509Certificate(X509Certificate[] chain) {
        return true;
    }

    public boolean Ask_onX509Certificate(X509Certificate[] chain) {
        StringBuffer chainS = new StringBuffer();
        chainS.append("Untrusted certificate received from server:\n");
        chainS.append("---------------------\n");
        for (int i = 0; i < chain.length; ++i) {
            chainS.append("\nIssuer DN: " + chain[i].getIssuerDN());
            chainS.append("\nSubject DN: " + chain[i].getSubjectDN());
            chainS.append("\nValidity: from " + chain[i].getNotBefore() + " to " + chain[i].getNotAfter());
            chainS.append("\n---------------------\n");
        }
        System.out.println(chainS.toString());
        try {
            return this.getYesOrNo("Do you trust this certificate? ", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void onError(String pURL, String errorText) {
        System.out.println("[Presence Service Error] Destination=" + pURL + " cause=" + errorText);
    }

    public void onError(CollaborationException e) {
        e.printStackTrace();
        this._session = null;
        this._presenceSession = null;
        this._newsSession = null;
        this._conferenceSession = null;
        this._messageSession = null;
        this._personalStoreSession = null;
        this._principal = null;
    }

    public boolean onReceipt(String destination, int deliveryStatus) {
        System.out.println("[Message Status Received] Recipient=<" + this._principal.getUID() + "> From=<" + destination + "> Status=<" + deliveryStatus + ">");
        return true;
    }

    public void onReply(Message message) {
        try {
            if (message.getContentType().equalsIgnoreCase("application/x-iim-poll-reply")) {
                Poll ph = (Poll)this._polls.get(message.getHeader("related-message-id"));
                MessagePart[] parts = message.getParts();
                System.out.println("[Poll Reply Received] Recipient=<" + this._principal.getUID() + "> Question=<" + message.getHeader("subject") + "> Answer=<" + ph.parseAnswer(parts[0].getInputStream()) + ">");
            } else {
                iimtalk.printMessage(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void sendPollMessage(String[] args) throws Exception {
        String answer;
        String names;
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("poll [ users ]");
            return;
        }
        if (args.length >= 2) {
            names = args[1];
            for (int i = 2; i < args.length; ++i) {
                names = names + " " + args[i];
            }
        } else {
            names = this.prompt("To: ", false);
        }
        String question = this.prompt("Question: ", false);
        ArrayList<String> answers = new ArrayList<String>();
        while (!(answer = this.prompt("Answer (return if no more):", false)).equals("")) {
            answers.add(answer);
        }
        boolean allowCustom = false;
        String sCustom = this.prompt("Allow custom answers? (y/n): ", false);
        if (sCustom.equalsIgnoreCase("y")) {
            allowCustom = true;
        }
        Poll helper = new Poll(question, answers, allowCustom);
        Message message = this._messageSession.createMessage();
        MessagePart part = message.newPart();
        message.setContentType("application/x-iim-poll");
        part.setContent(helper.toString());
        message.addPart(part);
        StringTokenizer st = new StringTokenizer(names);
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            message.addRecipient(name);
        }
        this._polls.put(message.getMessageId(), helper);
        this._messageSession.sendMessage(message, this);
    }

    private void sendPollResponse(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("pollr");
            return;
        }
        if (this._receivedMessages.isEmpty()) {
            return;
        }
        Message message = (Message)this._receivedMessages.firstElement();
        MessagePart[] parts = message.getParts();
        PollHelper helper = new PollHelper(parts[0].getInputStream());
        System.out.println("Poll Question: " + helper.getQuestion());
        int noOfAnswers = helper.countAnswers();
        System.out.println("Answers: ");
        for (int i = 0; i < noOfAnswers; ++i) {
            System.out.println(i + " " + helper.getAnswer(i));
        }
        int iAnswer = -1;
        String answer = this.prompt("Index of the answer of your choice: ", false);
        try {
            iAnswer = new Integer(answer);
        }
        catch (Exception e) {
            answer = this.prompt("Custom answer: ", false);
        }
        Message reply = this._messageSession.createMessage(message.getOriginator());
        reply.setContentType("application/x-iim-poll-reply");
        MessagePart part = reply.newPart();
        if (iAnswer >= 0) {
            part.setContent(helper.createResponse(iAnswer));
        } else {
            part.setContent(helper.createResponse(answer));
        }
        reply.addPart(part);
        message.sendReply(reply);
        this._receivedMessages.remove(message);
    }

    private Collection getFolders(String[] args) throws Exception {
        Collection folders;
        if (args.length > 0) {
            CollaborationPrincipal p = this._personalStoreSession.createPrincipal(args[0]);
            folders = this._personalStoreSession.getFolders(p, "abook");
        } else {
            folders = this._personalStoreSession.getFolders("abook");
        }
        return folders;
    }

    private PersonalStoreFolder findFolder(Collection folders, String name) {
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            PersonalStoreFolder f = (PersonalStoreFolder)i.next();
            if (!f.getDisplayName().equals(name)) continue;
            return f;
        }
        return null;
    }

    private void listContacts(String[] args) throws Exception {
        Collection folders = this.getFolders(args);
        Iterator i = folders.iterator();
        while (i.hasNext()) {
            PersonalStoreFolder f = (PersonalStoreFolder)i.next();
            Collection entries = f.getEntries();
            System.out.println(" - " + f.getDisplayName());
            Iterator j = entries.iterator();
            while (j.hasNext()) {
                PersonalStoreEntry c;
                PersonalStoreEntry e = (PersonalStoreEntry)j.next();
                if (e.getType() == "contact") {
                    c = (PersonalContact)e;
                    System.out.println("     - " + c.getDisplayName() + " <" + c.getAddress("im") + ">");
                    continue;
                }
                c = (PersonalGroup)e;
                System.out.println("     - " + c.getDisplayName() + " <" + c.getEntryId() + ">");
            }
        }
    }

    private void addContact(String[] args) throws Exception {
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name: ", false);
        String name = this.prompt("Contact id: ", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            System.out.println("No such Folder: " + folder);
        }
        String localUID = StringUtility.getLocalPartFromAddress(name);
        CollaborationPrincipal[] searchResults = this._personalStoreSession.searchPrincipals(0, localUID);
        boolean found = false;
        for (int i = 0; i < searchResults.length; ++i) {
            CollaborationPrincipal cp = searchResults[i];
            if (!cp.getUID().equalsIgnoreCase(name)) continue;
            found = true;
        }
        if (found) {
            PersonalContact entry = (PersonalContact)this._personalStoreSession.createEntry("contact", name);
            entry.addToFolder(f);
            entry.addAddress("im", name, 0);
            entry.save();
        } else {
            System.out.println("No entry found in the directory with the name " + name);
        }
    }

    private void removeContact(String[] args) throws Exception {
        PersonalContact e;
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name: ", false);
        String id = this.prompt("Contact id: ", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            System.out.println("No Such Folder: " + folder);
            return;
        }
        if (args.length > 0) {
            CollaborationPrincipal p = this._personalStoreSession.createPrincipal(args[0]);
            e = (PersonalContact)this._personalStoreSession.getEntry(p, "contact", id);
        } else {
            e = (PersonalContact)this._personalStoreSession.getEntry("contact", id);
        }
        if (e == null) {
            System.out.println("No Such Entry: " + id);
            return;
        }
        e.removeFromFolder(f);
        f.save();
    }

    private void addContactGroup(String[] args) throws Exception {
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name  :", false);
        String name = this.prompt("Group id     :", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            throw new Exception("No such Folder: " + folder);
        }
        PersonalGroup entry = (PersonalGroup)this._personalStoreSession.createEntry("group", name);
        entry.addToFolder(f);
        entry.save();
    }

    private void removeContactGroup(String[] args) throws Exception {
        PersonalGroup e;
        Collection folders = this.getFolders(args);
        String folder = this.prompt("Folder name          :", false);
        String id = this.prompt("Group id             :", false);
        PersonalStoreFolder f = this.findFolder(folders, folder);
        if (f == null) {
            System.out.println("No Such Folder: " + folder);
            return;
        }
        if (args.length > 0) {
            CollaborationPrincipal p = this._personalStoreSession.createPrincipal(args[0]);
            e = (PersonalGroup)this._personalStoreSession.getEntry(p, "group", id);
        } else {
            e = (PersonalGroup)this._personalStoreSession.getEntry("group", id);
        }
        if (e == null) {
            System.out.println("No Such Entry: " + id);
            return;
        }
        e.removeFromFolder(f);
        f.save();
    }

    private void removeContactFolder(String[] args) throws Exception {
        String folder;
        Collection folders = this.getFolders(args);
        PersonalStoreFolder f = this.findFolder(folders, folder = this.prompt("Folder name:", false));
        if (f == null) {
            throw new Exception("No such Folder: " + folder);
        }
        f.remove();
    }

    private void addContactFolder(String[] args) throws Exception {
        PersonalStoreFolder f;
        String folder = this.prompt("Folder name: ", false);
        if (args.length > 0) {
            CollaborationPrincipal p = this._personalStoreSession.createPrincipal(args[0]);
            f = (PersonalStoreFolder)this._personalStoreSession.createEntry(p, "abook", folder);
        } else {
            f = (PersonalStoreFolder)this._personalStoreSession.createEntry("abook", folder);
        }
        f.save();
    }

    private void listProfile(String[] args) throws Exception {
        PersonalProfile profile = this._personalStoreSession.getProfile();
        Map m = profile.getProperties();
        Object[] keys = m.keySet().toArray();
        Arrays.sort(keys, 0, keys.length, new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((String)o1).compareTo(o2);
            }
        });
        for (int i = 0; i < keys.length; ++i) {
            String p = (String)keys[i];
            Object propValue = m.get(p);
            if (propValue instanceof Set) {
                Object[] propValuesArray = ((Set)propValue).toArray();
                propValuesArray = StringUtility.sort(propValuesArray);
                System.out.print(p + " = [ ");
                for (int j = 0; j < propValuesArray.length; ++j) {
                    System.out.print(propValuesArray[j] + "  ");
                }
                System.out.println(" ]");
                continue;
            }
            System.out.println(p + " = " + propValue);
        }
    }

    private void getProfile(String[] args) throws Exception {
        String propName = this.prompt("Property Name :", false);
        PersonalProfile profile = this._personalStoreSession.getProfile();
        String v = profile.getProperty(propName, "");
        System.out.println(propName + " = " + v);
    }

    private void changeProfile(String[] args) throws Exception {
        String propName = this.prompt("Property Name  :", false);
        String propVal = this.prompt("Property Value :", false);
        PersonalProfile p = this._personalStoreSession.getProfile();
        p.setProperty(propName, propVal);
        p.save();
    }

    private void removeProfile(String[] args) throws Exception {
        PersonalProfile profile = this._personalStoreSession.getProfile();
        profile.remove();
    }

    private void removeSubscription(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rsub [ conference|news id ]");
            return;
        }
        boolean isNews = false;
        String type = "conference";
        type = args.length > 0 ? args[0] : this.prompt("Subscription type:", false);
        String id = null;
        id = args.length > 1 ? args[1] : this.prompt("Subscription target:", false);
        PersonalStoreEntry entry = this._personalStoreSession.getEntry(type, id);
        if (entry != null) {
            entry.remove();
        } else {
            System.out.println("No such Subscription: " + type + " " + id);
        }
    }

    private void addSubscription(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("asub [ conference|news id ]");
            return;
        }
        boolean isNews = false;
        String type = "conference";
        type = args.length > 0 ? args[0] : this.prompt("Subscription type:", false);
        String id = null;
        id = args.length > 1 ? args[1] : this.prompt("Subscription target:", false);
        PersonalStoreEntry[] entry = this._personalStoreSession.search(0, id, type);
        if (entry != null) {
            entry[0].save();
        } else {
            System.out.println("No such Subscription target: " + type + " " + id);
        }
    }

    private void listSubscriptions(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("asub [ conference|news ]");
            return;
        }
        boolean isNews = false;
        String type = "conference";
        type = args.length > 0 ? args[0] : this.prompt("Subscription type:", false);
        Collection c = this._personalStoreSession.getEntries(type);
        Iterator i = c.iterator();
        while (i.hasNext()) {
            PersonalConference dest = (PersonalConference)i.next();
            System.out.println(dest.getAddress());
        }
    }

    private void runArchiveTest(String[] args) {
        if (args.length > 0 && args[0].equals("?")) {
            System.out.println("rat [ host [ soifFile [ Keyword [ User ] ] ] ]");
            System.out.println("run archive test");
            return;
        }
        String portal_host = args.length > 0 ? args[0] : this.prompt("Portal Server Host Name: ", false);
        String soifFile = "";
        soifFile = args.length >= 2 ? args[1] : this.prompt("File name of SOIF data: ", false);
        String keyword = "";
        keyword = args.length >= 3 ? args[2] : this.prompt("Keyword of SOIF data: ", false);
        String userDN = "";
        userDN = args.length >= 4 ? args[3] : this.prompt("User DN whose acl is to be removed: ", false);
        ArchiveTest at = this.sessionId == null ? new ArchiveTest(portal_host, soifFile, keyword, userDN) : new ArchiveTest(portal_host, soifFile, keyword, userDN, this.sessionId);
        at.runTests();
    }

    protected static void printMessage(Message message) {
        System.out.println("");
        System.out.println("    Subject: " + message.getHeader("subject"));
        System.out.println("    Content-type: " + message.getContentType());
        MessagePart[] parts = message.getParts();
        for (int i = 0; i < parts.length; ++i) {
            System.out.println("    Part " + i);
            System.out.println("        Content-type: " + parts[i].getContentType());
            try {
                String str;
                BufferedReader br = new BufferedReader(new InputStreamReader(parts[i].getInputStream()));
                while ((str = br.readLine()) != null) {
                    System.out.println(str);
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void exitUsage(String errorText) {
        System.out.println("usage error: " + errorText);
        System.out.println("usage: \n\tcom.iplanet.im.client.test.iimtalk [-i <input-file> -factory <session-factory-class-name>] [-debug] [-sso] [-org <orgname>]");
        System.exit(0);
    }

    public static void readArgs(String[] argv) {
        for (int i = 0; i < argv.length; ++i) {
            if (argv[i].equals("-i")) {
                if (i + 1 < argv.length) {
                    _inputFileName = argv[++i];
                    continue;
                }
                iimtalk.exitUsage("Missing input file");
                continue;
            }
            if (argv[i].equals("-factory")) {
                if (i + 1 < argv.length) {
                    System.setProperty("com.sun.im.service.CollaborationSessionFactory", argv[++i]);
                    continue;
                }
                iimtalk.exitUsage("Missing factory");
                continue;
            }
            if (argv[i].equals("-debug")) {
                System.setProperty("com.iplanet.im.client.api.debug", "true");
                continue;
            }
            if (argv[i].equals("-sso")) {
                _usesso = true;
                try {
                    String adminDN = Auth.getAdminDN();
                    String adminPassword = Auth.getAdminPassword();
                    _adminConnection = Auth.getAdminStoreConnection((String)adminDN, (String)adminPassword);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (argv[i].equals("-org") || argv[i].equals("-orgname")) {
                if (i + 1 < argv.length) {
                    _defaultDomain = argv[++i];
                    continue;
                }
                iimtalk.exitUsage("Missing sso org");
                continue;
            }
            if (argv[i].equals("-service") || argv[i].equals("-host")) {
                if (i + 1 < argv.length) {
                    imServer = argv[++i];
                    continue;
                }
                iimtalk.exitUsage("Missing host name");
                continue;
            }
            iimtalk.exitUsage("Illegal option: " + argv[i]);
        }
    }

    public static void main(String[] argv) {
        try {
            BufferedReader br = null;
            iimtalk.readArgs(argv);
            if (_usesso) {
                String adminDN = Auth.getAdminDN();
                String adminPassword = Auth.getAdminPassword();
                System.out.println("doing sso .......");
                _adminConnection = Auth.getAdminStoreConnection((String)adminDN, (String)adminPassword);
            }
            if (_inputFileName != null) {
                br = new BufferedReader(new FileReader(_inputFileName));
            }
            iimtalk interp = br != null ? new iimtalk(br, false) : new iimtalk();
            interp.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        imServer = "localhost:49909";
        _inputFileName = null;
    }
}

