/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.iIMContact;
import com.iplanet.im.client.api.iIMContactGroup;
import com.iplanet.im.client.api.iIMSession;
import com.iplanet.im.net.iIMUser;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreFolder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;

public class iIMContactList
implements PersonalStoreFolder {
    String _name;
    Vector _contactEntries;
    Vector _groupEntries;
    iIMSession _session;
    iIMUser _owner;

    public iIMContactList(iIMSession s, String name, iIMUser owner) {
        this._name = name;
        this._session = s;
        this._contactEntries = new Vector();
        this._groupEntries = new Vector();
        this._owner = owner;
    }

    public int size() {
        return this._contactEntries.size() + this._groupEntries.size();
    }

    public Collection getEntries() throws CollaborationException {
        Vector _entries = new Vector();
        _entries.addAll(this._contactEntries);
        _entries.addAll(this._groupEntries);
        return _entries;
    }

    public Collection getEntries(String entryType) throws CollaborationException {
        if (entryType.equals("contact")) {
            return this._contactEntries;
        }
        if (entryType.equals("group")) {
            return this._groupEntries;
        }
        return null;
    }

    public PersonalStoreEntry getEntry(String entryId) throws CollaborationException {
        Vector _entries = (Vector)this.getEntries();
        Enumeration enumeration = _entries.elements();
        while (enumeration.hasMoreElements()) {
            PersonalStoreEntry c;
            PersonalStoreEntry e = (PersonalStoreEntry)enumeration.nextElement();
            if (!(e.getType() == "contact" ? ((iIMContact)(c = (iIMContact)e)).getAddress("im").equals(entryId) : ((iIMContactGroup)(c = (iIMContactGroup)e)).getEntryId().equals(entryId))) continue;
            return c;
        }
        return null;
    }

    public String getEntryId() {
        return this._name;
    }

    public String getDisplayName() {
        return this._name;
    }

    public String getType() {
        return "abook";
    }

    public void addToFolder(PersonalStoreFolder folder) throws CollaborationException {
        throw new CollaborationException("Subfolders not supported");
    }

    public void removeFromFolder(PersonalStoreFolder folder) throws CollaborationException {
        throw new CollaborationException("Subfolders not supported");
    }

    public void save() throws CollaborationException {
        this._session.save(this._owner);
    }

    public void remove() throws CollaborationException {
        this._session.removeContactList(this, this._owner);
    }

    protected void addEntry(iIMContact entry) {
        if (!this._contactEntries.contains(entry)) {
            this._contactEntries.addElement(entry);
        }
    }

    protected void addEntry(iIMContactGroup entry) {
        if (!this._groupEntries.contains(entry)) {
            this._groupEntries.addElement(entry);
        }
    }

    public boolean hasEntry(String entryId) {
        PersonalStoreEntry entry = null;
        try {
            entry = this.getEntry(entryId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return entry != null;
    }

    protected void removeEntry(iIMContact entry) {
        this._contactEntries.remove(entry);
    }

    protected void removeEntry(iIMContactGroup entry) {
        this._groupEntries.remove(entry);
    }

    public boolean equals(Object o) {
        iIMContactList cl;
        return o instanceof iIMContactList && (cl = (iIMContactList)o).getDisplayName().equals(this._name);
    }

    public void rename(String displayName) {
        this._name = displayName;
    }

    public CollaborationPrincipal getPrincipal() {
        return null;
    }

    public void setDisplayName(String name) {
        this._name = name;
    }

    public Collection getFolders() throws CollaborationException {
        return null;
    }
}

