/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.im.client.api;

import com.iplanet.im.client.api.iIMMessage;
import com.iplanet.im.client.api.iIMSession;
import com.iplanet.im.client.api.iIMSessionFactory;
import com.iplanet.im.net.Connection;
import com.iplanet.im.net.Destination;
import com.iplanet.im.net.DestinationAccessControlList;
import com.iplanet.im.net.MessageEvent;
import com.iplanet.im.net.QueueMsg;
import com.iplanet.im.net.Room;
import com.iplanet.im.net.RoomListener;
import com.iplanet.im.net.RoomUserEvent;
import com.iplanet.im.net.iIMPrincipal;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Conference;
import com.sun.im.service.ConferenceEventHelper;
import com.sun.im.service.ConferenceEventListener;
import com.sun.im.service.ConferenceEventTuple;
import com.sun.im.service.ConferenceListener;
import com.sun.im.service.InviteMessage;
import com.sun.im.service.InviteMessageStatusListener;
import com.sun.im.service.Message;
import com.sun.im.service.PersonalConference;
import com.sun.im.service.PersonalStoreFolder;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;

public class iIMConference
implements Conference,
RoomListener,
PersonalConference {
    Destination _destination;
    ConferenceListener _listener;
    Connection _connection;
    iIMSession _session;
    int _defaultAccess = 30;
    boolean _joined = false;
    DestinationAccessControlList _dacl;
    int _privilege;
    Hashtable _messages = new Hashtable();

    public boolean isPersistent() {
        return !this.getDestination().startsWith(".");
    }

    public boolean isPublic() {
        return !this.getDestination().startsWith(".");
    }

    private String makeConferenceName() {
        return "." + Long.toString(new Date().getTime()) + Long.toString(Math.round(Math.random() * 10000.0));
    }

    public iIMConference(iIMSession session) {
        this._session = session;
    }

    void _getAccess() throws CollaborationException {
        this._dacl = this._session.connectionFactory.getDestinationACL(this._destination);
        this._privilege = this.Net2CollAccessLevel(this._dacl.getAccess(this._session.connectionFactory.getCurrentUser()));
    }

    public iIMConference(iIMSession session, Destination destination) throws CollaborationException {
        this._destination = destination;
        this._session = session;
    }

    public iIMConference(iIMSession session, Destination destination, ConferenceListener listener, String note) throws CollaborationException {
        this._destination = destination;
        this._listener = listener;
        this._session = session;
        this._join(note);
    }

    private void createNewRoom(String destination, boolean temp, int accessLevel) throws CollaborationException {
        this._destination = new Room(destination, this._session.connectionFactory.getServerName());
        this._session.connectionFactory.addRoom((Room)this._destination, temp);
        this._setAccess(30);
        this._dacl.add(this._session.connectionFactory.getCurrentUser(), 14);
        this._dacl.setDefault(accessLevel);
        this._saveAccess();
    }

    void _setAccess(int accessLevel) throws CollaborationException {
        this._dacl = new DestinationAccessControlList();
        this._dacl.setDefault(this.Coll2NetAccessLevel(accessLevel));
        this._session.connectionFactory.setDestinationACL(this._dacl, this._destination);
        this._privilege = this.Net2CollAccessLevel(this._dacl.getAccess(this._session.connectionFactory.getCurrentUser()));
    }

    public iIMConference(iIMSession session, int accessLevel) throws CollaborationException {
        this._session = session;
        String destination = this.makeConferenceName();
        this.createNewRoom(destination, true, accessLevel);
    }

    public iIMConference(iIMSession session, ConferenceListener listener, int accessLevel) throws CollaborationException {
        this._listener = listener;
        this._session = session;
        String destination = this.makeConferenceName();
        this.createNewRoom(destination, true, accessLevel);
        this._join();
    }

    public iIMConference(iIMSession session, String destination, int accessLevel) throws CollaborationException {
        this._session = session;
        this.createNewRoom(destination, false, accessLevel);
    }

    public iIMConference(iIMSession session, String destination, ConferenceListener listener, int accessLevel) throws CollaborationException {
        this._listener = listener;
        this._session = session;
        this.createNewRoom(destination, false, accessLevel);
        this._join();
    }

    int Coll2NetAccessLevel(int access) throws CollaborationException {
        switch (access) {
            case 1: {
                return 1;
            }
            case 2: 
            case 14: {
                return 2;
            }
            case 4: {
                return 6;
            }
            case 30: {
                return 14;
            }
        }
        throw new CollaborationException("invalid access level: " + access);
    }

    int Net2CollAccessLevel(int access) throws CollaborationException {
        switch (access) {
            case 0: {
                return this.Net2CollAccessLevel(this._dacl.getDefault());
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 6: {
                return 4;
            }
            case 14: {
                return 30;
            }
        }
        throw new CollaborationException("invalid Net access level: " + access);
    }

    protected void _join() throws CollaborationException {
        this._join(null);
    }

    protected synchronized void _join(String note) throws CollaborationException {
        if (!this._joined) {
            this._connection = this._session.connectionFactory.createConnection(this._destination);
            this._connection.addChangeListener(this);
            if (note == null) {
                this._connection.start();
            } else {
                this._connection.start(note);
            }
            this._joined = true;
        }
    }

    public String getDestination() {
        return this._destination.getUID().substring(5);
    }

    public void addMessage(Message message) throws CollaborationException {
        try {
            this._join();
            com.iplanet.im.net.Message m = ((iIMMessage)message).getNetMessage();
            if (m.getContentType().equals("net/html") || m.getContentType().equals("net/htmlex") || m.getContentType().equals("net/text")) {
                m.setContentType("net/chat");
            } else if (m.getContentType().equals("net/url")) {
                URL url = new URL((String)m.getBody());
                m.setBody(url);
            } else if (m.getContentType().equals("net/urlex")) {
                Hashtable<String, URL> ht = new Hashtable<String, URL>();
                ht.put("BODY", new URL((String)m.getBody()));
                m.setBody(ht);
            }
            this._session.connectionFactory.addMsg(m);
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    public void roomStarted() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave() {
        try {
            iIMConference iIMConference2 = this;
            synchronized (iIMConference2) {
                if (this._joined) {
                    this._connection.removeChangeListener(this);
                    this._connection.stop();
                    this._joined = false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void join(ConferenceListener listener) throws CollaborationException {
        this._listener = listener;
        this._join();
    }

    public Message createMessage() throws CollaborationException {
        return new iIMMessage(this._session, this._destination, this._session.myDestination);
    }

    public InviteMessage createInviteMessage() throws CollaborationException {
        return new iIMMessage(this._session, this._session.myDestination);
    }

    public void invite(int accessLevel, Message message, InviteMessageStatusListener listener) throws CollaborationException {
        Object[] a = new Object[2];
        QueueMsg m = new QueueMsg();
        a[0] = message == null ? "     <empty>" : (String)((iIMMessage)message).getNetMessage().getBody();
        a[1] = this._destination;
        m.setBody(a);
        m.setContentType("net/invite");
        m.setTo(((iIMMessage)message).getNetMessage().getTo());
        this._session.connectionFactory.addMsg(m);
    }

    public int getPrivilege() throws CollaborationException {
        if (this._dacl == null) {
            this._getAccess();
        }
        return this._privilege;
    }

    public int getPrivilege(String uid) throws CollaborationException {
        if (this._dacl == null) {
            this._getAccess();
        }
        return this.Net2CollAccessLevel(this._dacl.getAccess(this._session.getNetPrincipal(uid)));
    }

    public void setPrivilege(String destination, int accessLevel) throws CollaborationException {
        if (this._dacl == null) {
            this._getAccess();
        }
        if (this._privilege != 30) {
            throw new CollaborationException("Insufficient privilege: " + this._privilege);
        }
        iIMPrincipal p = this._session.getNetPrincipal(destination);
        this._dacl.remove(p);
        this._dacl.add(p, this.Coll2NetAccessLevel(accessLevel));
        this._saveAccess();
    }

    public boolean hasPrivilege(int accessLevel) throws CollaborationException {
        Destination[] d = new Destination[]{this._destination};
        boolean[] b = this._session.connectionFactory.checkDestinationACL("", d, accessLevel);
        return b[0];
    }

    public void roomUserStatusChange(RoomUserEvent e) {
        iIMSessionFactory.debug("User status change: " + e.getUID() + " / " + e.getStatus());
        if (this._listener == null) {
            return;
        }
        ConferenceEventTuple cet = new ConferenceEventTuple(e.getUID());
        cet.status = e.getStatus();
        if (this._listener instanceof ConferenceEventListener) {
            ((ConferenceEventListener)((Object)this._listener)).onEvent(cet);
        } else {
            ConferenceEventHelper ceh = new ConferenceEventHelper();
            ceh.addTuple(cet);
            this._listener.onEvent(ceh.toString());
        }
    }

    public void messageAdded(MessageEvent e) {
        iIMSessionFactory.debug("message received in Conference " + this._destination.getUID());
        com.iplanet.im.net.Message m = e.getMsg();
        String ct = m.getContentType();
        if (!(ct.equals("net/typing") || ct.equals("net/typing_off") || ct.equals("net/sendfile") || ct.equals("net/recfile") || this._listener == null)) {
            this._listener.onMessageAdded(new iIMMessage(this._session, e.getMsg()));
        } else {
            iIMSessionFactory.debug("Received conference message of unsupported type " + ct);
        }
    }

    public void messageDeleted(MessageEvent e) {
    }

    public int getDefaultPrivilege() throws CollaborationException {
        if (this._dacl == null) {
            this._getAccess();
        }
        return this.Net2CollAccessLevel(this._dacl.getDefault());
    }

    public void setDefaultPrivilege(int accessLevel) throws CollaborationException {
        if (this._dacl == null) {
            this._getAccess();
        }
        this._dacl.setDefault(this.Coll2NetAccessLevel(accessLevel));
        this._saveAccess();
    }

    protected void _saveAccess() throws CollaborationException {
        this._session.connectionFactory.setDestinationACL(this._dacl, this._destination);
    }

    public void close() throws CollaborationException {
        this._session.connectionFactory.delRoom((Room)this._destination);
    }

    public synchronized String getProperty(String attribute) {
        return this._destination.getProperty(attribute);
    }

    public synchronized void setProperty(String attribute, String value) throws CollaborationException {
        this._destination.setProperty(attribute, value);
        this._session.connectionFactory.saveDestinationProperties(this._destination);
    }

    public String getAddress() {
        return this._destination.getFQName();
    }

    public String getEntryId() {
        return this._destination.getFQName();
    }

    public String getDisplayName() {
        return this._destination.getName();
    }

    public String getType() {
        return "conference";
    }

    public void addToFolder(PersonalStoreFolder folder) throws CollaborationException {
    }

    public void removeFromFolder(PersonalStoreFolder folder) throws CollaborationException {
    }

    public void save() throws CollaborationException {
        this._session.addRoomSubscription(this._destination);
    }

    public void remove() throws CollaborationException {
        this._session.removeRoomSubscription(this._destination);
    }

    public void moderate(boolean start) throws CollaborationException {
    }

    public Map listPrivileges() throws CollaborationException {
        return null;
    }

    public void setPrivileges(Map m) throws CollaborationException {
    }

    public CollaborationPrincipal getPrincipal() {
        return null;
    }

    public void setAddress(String s) {
    }

    public void setEntryId(String s) {
    }

    public void setDisplayName(String name) {
    }

    public void addModeratedMessage(Message message, int status, String reason) throws CollaborationException {
    }

    public Collection getParticipants() throws CollaborationException {
        return null;
    }

    public Collection getFolders() throws CollaborationException {
        return null;
    }
}

