/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CertificateRejectedException;
import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.util.CertificateVerify;
import com.sun.im.service.util.JavaxX509TrustManager;
import com.sun.im.service.util.StreamChannelSocketAdaptor;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.io.src.SocketStreamSource;

public class XMPPSecureSession
extends XMPPSession {
    private Socket _baseSocket;
    private boolean _certAcceptedByClient;
    private boolean _certProvidedToClient;

    public XMPPSecureSession(XMPPSessionProvider fac, String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener listener) throws CollaborationException {
        super(fac, serviceUrl, loginName, password, loginType, listener, null);
    }

    protected StreamSource createStreamSource(String hostName, int port) throws Exception {
        JavaxX509TrustManager trustManager = new JavaxX509TrustManager(new CertificateVerify(){

            public boolean doYouTrustCertificate(X509Certificate[] chain) {
                if (XMPPSecureSession.this.getSessionListener() instanceof SecureSessionListener) {
                    XMPPSecureSession.this._certProvidedToClient = true;
                    XMPPSecureSession.this._certAcceptedByClient = ((SecureSessionListener)XMPPSecureSession.this.getSessionListener()).onX509Certificate(chain);
                    return XMPPSecureSession.this._certAcceptedByClient;
                }
                return false;
            }
        });
        this._baseSocket = SocketChannel.open(new InetSocketAddress(hostName, port)).socket();
        StreamChannelSocketAdaptor adapter = new StreamChannelSocketAdaptor(this._baseSocket);
        SSLSocketFactory factory = trustManager.getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)factory.createSocket(adapter, hostName, port, true);
        try {
            sslSocket.startHandshake();
        }
        catch (IOException e) {
            if (this._certProvidedToClient && !this._certAcceptedByClient) {
                throw new CertificateRejectedException();
            }
            throw e;
        }
        SocketStreamSource streamSource = new SocketStreamSource((Socket)sslSocket);
        this._baseSocket.getChannel().configureBlocking(false);
        return streamSource;
    }

    protected SocketChannel getSocketChannel() throws IOException {
        return this._baseSocket.getChannel();
    }
}

