/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.ContentStream;
import com.sun.im.service.ReceiverFileStreamingProfile;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.x.info.OutOfBandExtension;
import org.jabberstudio.jso.x.si.SIProfile;
import org.jabberstudio.jso.x.si.SIQuery;
import org.jabberstudio.jso.x.sift.FileTransferProfile;

public class XMPPReceiverFileStreamingProfile
implements ReceiverFileStreamingProfile {
    List _outputstreams = new ArrayList();
    String _name;
    byte[] _senderHash;
    String _desc;
    String _mimeType;
    long _lastModified;
    long _size = -1L;
    long _offset = 0L;
    long _length = -1L;
    MessageDigest md5;
    byte[] _receiverHash;

    public XMPPReceiverFileStreamingProfile(ContentStream cs, InfoQuery iq) throws CollaborationException {
        List elements = iq.listElements(SIQuery.NAME);
        if (elements.size() > 0) {
            SIQuery si = (SIQuery)elements.get(0);
            this._mimeType = si.getMimeType();
            SIProfile profile = si.getProfile();
            if (!(profile instanceof FileTransferProfile)) {
                XMPPSessionProvider.info("Unknown profile for stream initiation");
                cs.reject("no-valid-streams");
                throw new CollaborationException("Unknown profile for stream initiation");
            }
            this._name = ((FileTransferProfile)profile).getName();
            this._desc = ((FileTransferProfile)profile).getDescription();
            this._size = ((FileTransferProfile)profile).getSize();
            this._senderHash = ((FileTransferProfile)profile).getHash();
            if (this._senderHash != null && this._senderHash.length > 0) {
                try {
                    this.md5 = MessageDigest.getInstance("MD5");
                    this.md5.reset();
                }
                catch (NoSuchAlgorithmException nsae) {
                    nsae.printStackTrace();
                }
            }
        } else {
            elements = iq.listElements(OutOfBandExtension.IQ_NAME);
            if (elements.size() > 0) {
                OutOfBandExtension oob = (OutOfBandExtension)elements.get(0);
                URL url = oob.getURL();
                this._name = url.getPath();
                int i = this._name.lastIndexOf(47);
                if (i != -1) {
                    this._name = this._name.substring(i);
                }
                this._desc = oob.getDescription();
            }
        }
    }

    public void addOutput(OutputStream os) {
        if (os != null) {
            this._outputstreams.add(os);
        }
    }

    public void addOutput(File f) {
        if (f.isDirectory()) {
            f = new File(f, this._name);
        }
        try {
            f.createNewFile();
            this.addOutput(new FileOutputStream(f, true));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int checkIntegrity() {
        if (this._senderHash == null || this._senderHash.length == 0) {
            return 2;
        }
        if (this._receiverHash == null || this._receiverHash.length == 0) {
            throw new IllegalStateException();
        }
        if (MessageDigest.isEqual(this._senderHash, this._receiverHash)) {
            return 0;
        }
        return 1;
    }

    public String getDescription() {
        return this._desc;
    }

    public byte[] getHash() {
        return this._senderHash;
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public long getLength() {
        if (this._length != -1L) {
            return this._length;
        }
        return this.size();
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public String getName() {
        return this._name;
    }

    public long getOffset() {
        return this._offset;
    }

    public void setLength(long length) {
        this._length = length;
    }

    public void setOffset(long offset) {
        this._offset = offset;
    }

    public long size() {
        return this._size;
    }

    public void write(byte[] b, int len) {
        try {
            Iterator itr = this._outputstreams.iterator();
            while (itr.hasNext()) {
                ((OutputStream)itr.next()).write(b, 0, len);
            }
            if (this._senderHash != null && this._senderHash.length > 0) {
                this.md5.update(b, 0, len);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void close() {
        Iterator itr = this._outputstreams.iterator();
        while (itr.hasNext()) {
            try {
                ((OutputStream)itr.next()).close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (this._senderHash != null && this._senderHash.length > 0) {
            this._receiverHash = this.md5.digest();
        }
    }
}

