/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.Presence;
import com.sun.im.service.PresenceAccessRule;
import com.sun.im.service.PresenceService;
import com.sun.im.service.PresenceServiceListener;
import com.sun.im.service.PresenceTuple;
import com.sun.im.service.PrivacyItem;
import com.sun.im.service.PrivacyList;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.XMPPPresenceAccessRule;
import com.sun.im.service.xmpp.XMPPPrincipal;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.JIDFormatException;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Presence;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.util.PacketMonitor;
import org.jabberstudio.jso.x.core.PrivacyQuery;

public class XMPPPresenceService
implements PresenceService {
    private List _presenceServiceListeners = Collections.synchronizedList(new ArrayList());
    XMPPSession __session;
    private Hashtable _subscriptions = new Hashtable();
    private Hashtable _cache = new Hashtable();
    private ArrayList _acl;
    private String _aclListName = "AccessRule";
    final int MAX_PRIORITY = 256;
    final String AWAY = "away";
    final String DND = "dnd";
    final String XA = "xa";
    final String CHAT = "chat";

    public XMPPPresenceService(XMPPSession session) {
        this.__session = session;
    }

    public void subscribe(String presentity) throws CollaborationException {
        this.sendPresence(org.jabberstudio.jso.Presence.SUBSCRIBE, this.__session.getDataFactory().createJID((Object)presentity));
    }

    public void subscribe(String[] presentity) throws CollaborationException {
        for (int i = 0; i < presentity.length; ++i) {
            this.subscribe(presentity[i]);
        }
    }

    public void unsubscribe(String str) throws CollaborationException {
        this.sendPresence(org.jabberstudio.jso.Presence.UNSUBSCRIBE, this.__session.getDataFactory().createJID((Object)str));
    }

    public void unsubscribe(String[] str) throws CollaborationException {
        for (int i = 0; i < str.length; ++i) {
            this.unsubscribe(str[i]);
        }
    }

    public void publish(Presence presence, String rcpt) throws CollaborationException {
        try {
            this.__session.getConnection().send((Packet)this.setPresence(presence, rcpt));
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    public void publish(Presence presence) throws CollaborationException {
        this.publish(presence, null);
    }

    public Presence fetchPresence(String uid) throws CollaborationException {
        uid = StringUtility.appendDomainToAddress(uid, this.__session.getPrincipal().getDomainName());
        StreamDataFactory sdf = this.__session.getDataFactory();
        JID jid = sdf.createJID((Object)uid);
        Presence p = (Presence)this._cache.get(jid);
        XMPPSessionProvider.debug("getting presence(" + jid + ") = " + p);
        if (p == null) {
            Enumeration e = this._subscriptions.keys();
            while (e.hasMoreElements()) {
                JID j = (JID)e.nextElement();
                if (!j.toBareJID().equals(jid)) continue;
                p = (Presence)this._subscriptions.get(j);
            }
        }
        if (p == null || p.getTuples().size() == 0 || ((PresenceTuple)p.getTuples().iterator().next()).getStatus() == null) {
            try {
                org.jabberstudio.jso.Presence pp = (org.jabberstudio.jso.Presence)sdf.createPacketNode(XMPPSession.PRESENCE_NAME, org.jabberstudio.jso.Presence.class);
                pp.setType((Packet.Type)org.jabberstudio.jso.Presence.PROBE);
                pp.setTo(sdf.createJID((Object)uid));
                String id = this.__session.nextID("presence");
                pp.setID(id);
                this.__session.addSendAndWatchID(id);
                pp = (org.jabberstudio.jso.Presence)PacketMonitor.sendAndWatch((Stream)this.__session.getConnection(), (Packet)pp, (long)XMPPSession.SHORT_REQUEST_TIMEOUT);
                if (pp == null || org.jabberstudio.jso.Presence.ERROR.equals((Object)pp.getType())) {
                    throw new CollaborationException("Failed to get presence for " + uid + " error=" + pp);
                }
                return this.getPresence(pp);
            }
            catch (StreamException se) {
                throw new CollaborationException(se);
            }
        }
        return p;
    }

    public Presence[] fetchPresence(String[] uids) throws CollaborationException {
        Presence[] ret = new Presence[uids.length];
        for (int i = 0; i < uids.length; ++i) {
            ret[i] = this.fetchPresence(uids[i]);
        }
        return ret;
    }

    public void cancel(String presentity) throws CollaborationException {
        JID jid;
        try {
            jid = new JID(presentity);
        }
        catch (JIDFormatException e) {
            throw new CollaborationException(e);
        }
        this.sendPresence(org.jabberstudio.jso.Presence.UNSUBSCRIBED, jid);
    }

    public void authorize(String presentity) throws CollaborationException {
        JID jid;
        try {
            jid = new JID(presentity);
        }
        catch (JIDFormatException e) {
            throw new CollaborationException(e);
        }
        this.sendPresence(org.jabberstudio.jso.Presence.SUBSCRIBED, jid);
    }

    public void addAccessRule(PresenceAccessRule rule) throws CollaborationException {
        throw new CollaborationException("Only one rule is supported");
    }

    public Collection getAccessRules(String presentity) throws CollaborationException {
        if (this._acl == null) {
            this._acl = new ArrayList();
            PrivacyQuery pq = this.__session.getPrivacyQueryResult(null);
            this.__session._activePrivacyList = pq.getActive();
            this.__session._defaultPrivacyList = pq.getDefault();
            if (this.__session._activePrivacyList != null && !this.__session._activePrivacyList.equals("")) {
                this._aclListName = this.__session._activePrivacyList;
            } else if (this.__session._defaultPrivacyList != null && !this.__session._defaultPrivacyList.equals("")) {
                this._aclListName = this.__session._defaultPrivacyList;
            } else {
                PrivacyList pl = null;
                try {
                    pl = this.__session.getPrivacyList(this._aclListName);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (pl == null) {
                    XMPPPresenceAccessRule par = new XMPPPresenceAccessRule(this.__session);
                    par.setGrant(true);
                    this._acl.add(par);
                    return this._acl;
                }
                Collection c = pl.getPrivacyItems();
                Iterator itr = c.iterator();
                while (itr.hasNext()) {
                    PrivacyItem item = (PrivacyItem)itr.next();
                    if (item.getResource() != 2) continue;
                    XMPPPresenceAccessRule par = new XMPPPresenceAccessRule(this.__session);
                    if (item.getAccess() == 1) {
                        par.setGrant(false);
                    } else {
                        par.setGrant(true);
                    }
                    par.addExceptPrincipal(item.getSubject());
                    this._acl.add(par);
                    return this._acl;
                }
            }
        }
        return this._acl;
    }

    public void saveAccessRules() throws CollaborationException {
        XMPPPresenceAccessRule par = (XMPPPresenceAccessRule)this._acl.get(0);
        PrivacyList pl = this.__session.createPrivacyList(this._aclListName);
        int action = 1;
        if (par.grant()) {
            action = 2;
        }
        Collection exceptPrincipals = par.getExceptPrincipals();
        Iterator i = exceptPrincipals.iterator();
        while (i.hasNext()) {
            PrivacyItem item = pl.createPrivacyItem("jid", action);
            String jid = ((CollaborationPrincipal)i.next()).getUID();
            item.setSubject(jid);
            item.setResource(2);
            pl.addPrivacyItem(item);
        }
        this.__session.addPrivacyList(pl);
    }

    public void initialize(PresenceServiceListener listener) throws CollaborationException {
        this.addPresenceServiceListener(listener);
    }

    void addSubscriptions(JID jid, Presence p) {
        this._subscriptions.put(jid, p);
        this._firePresenceServiceListener(p, null);
    }

    void removeSubscriptions(JID jid) {
        this._subscriptions.remove(jid);
        this._subscriptions.remove(jid.toBareJID());
    }

    Presence getSubscriptions(JID jid) {
        return (Presence)this._subscriptions.get(jid);
    }

    Presence processPresence(org.jabberstudio.jso.Presence p) throws CollaborationException {
        Presence imPresence = this.getPresence(p);
        JID from = this.getFromJID(p);
        this._cache.put(from, imPresence);
        this._firePresenceServiceListener(imPresence, p);
        return imPresence;
    }

    private boolean isPending(Presence p) {
        Iterator tuples = p.getTuples().iterator();
        if (tuples.hasNext()) {
            PresenceTuple t = (PresenceTuple)tuples.next();
            return "PENDING".equals(t.getStatus());
        }
        return false;
    }

    Presence createPresence(String uid, String status, String note, float priority) {
        PresenceTuple pt = new PresenceTuple();
        pt.setStatus(status);
        pt.setPriority(priority);
        pt.addNote(note);
        pt.setContact(uid);
        return new Presence(pt);
    }

    private void sendPresence(Presence.Type type, JID to) throws CollaborationException {
        try {
            org.jabberstudio.jso.Presence p = (org.jabberstudio.jso.Presence)this.__session.getDataFactory().createPacketNode(XMPPSession.PRESENCE_NAME, org.jabberstudio.jso.Presence.class);
            p.setType((Packet.Type)type);
            p.setTo(to);
            XMPPSessionProvider.debug("Sending the subscribed presence to " + to);
            this.__session.getConnection().send((Packet)p);
        }
        catch (Exception e) {
            throw new CollaborationException(e.toString());
        }
    }

    private Presence getPresence(org.jabberstudio.jso.Presence p) {
        String status = null;
        float priority = p.hasPriority() ? (float)(p.getPriority() + 128) / 256.0f : 0.5f;
        String note = p.getStatus();
        if (p.getType() == null) {
            String show = p.getShow();
            status = show.equalsIgnoreCase("chat") ? "CHAT" : (show.equalsIgnoreCase("away") ? "IDLE" : (show.equalsIgnoreCase("xa") ? "AWAY" : (show.equalsIgnoreCase("dnd") ? "BUSY" : "OPEN")));
        } else if (p.getType().equals((Object)org.jabberstudio.jso.Presence.UNAVAILABLE)) {
            status = note.equalsIgnoreCase("FORWARDED") ? "FORWARDED" : "CLOSED";
        }
        String uid = this.getFromJID(p).toString();
        return this.createPresence(uid, status, note, priority);
    }

    private org.jabberstudio.jso.Presence setPresence(Presence presence) {
        return this.setPresence(presence, null);
    }

    private org.jabberstudio.jso.Presence setPresence(Presence presence, String rcpt) {
        org.jabberstudio.jso.Presence p = (org.jabberstudio.jso.Presence)this.__session.getDataFactory().createPacketNode(XMPPSession.PRESENCE_NAME, org.jabberstudio.jso.Presence.class);
        Object[] o = presence.getTuples().toArray();
        PresenceTuple pt = (PresenceTuple)o[0];
        float priority = pt.getPriority();
        if (priority != 0.0f) {
            p.setPriority((int)(priority * 256.0f - 128.0f));
        }
        p.setStatus(pt.getNote());
        String status = pt.getStatus();
        if (status.equalsIgnoreCase("CLOSED") || status.equalsIgnoreCase("FORWARDED")) {
            p.setType((Packet.Type)org.jabberstudio.jso.Presence.UNAVAILABLE);
        } else if (status.equalsIgnoreCase("CHAT")) {
            p.setShow("chat");
        } else if (status.equalsIgnoreCase("IDLE")) {
            p.setShow("away");
        } else if (status.equalsIgnoreCase("AWAY")) {
            p.setShow("xa");
        } else if (status.equalsIgnoreCase("BUSY")) {
            p.setShow("dnd");
        }
        if (rcpt != null) {
            p.setTo(new JID(rcpt));
        }
        return p;
    }

    private JID getFromJID(org.jabberstudio.jso.Presence p) {
        JID from = p.getFrom();
        if (from == null) {
            try {
                from = ((XMPPPrincipal)this.__session.getPrincipal()).getJID();
            }
            catch (CollaborationException e) {
                XMPPSessionProvider.error("Error occured on getPrincipal() " + e);
            }
        }
        return from;
    }

    private void _firePresenceServiceListener(Presence imPresence, org.jabberstudio.jso.Presence jsoPresence) {
        this.__session.addWorkerRunnable(new PresenceNotifier(imPresence, jsoPresence));
    }

    public void addPresenceServiceListener(PresenceServiceListener listener) {
        if (!this._presenceServiceListeners.contains(listener)) {
            this._presenceServiceListeners.add(listener);
        }
    }

    public void removePresenceServiceListener(PresenceServiceListener listener) {
        this._presenceServiceListeners.remove(listener);
    }

    private class PresenceNotifier
    implements Runnable {
        Presence presence;
        org.jabberstudio.jso.Presence xmppPresence;

        PresenceNotifier(Presence p, org.jabberstudio.jso.Presence x) {
            this.presence = p;
            this.xmppPresence = x;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            List list = XMPPPresenceService.this._presenceServiceListeners;
            synchronized (list) {
                Iterator itr = XMPPPresenceService.this._presenceServiceListeners.iterator();
                while (itr.hasNext()) {
                    PresenceServiceListener serviceListener = (PresenceServiceListener)itr.next();
                    if (serviceListener == null) continue;
                    try {
                        if (this.xmppPresence == null || this.xmppPresence.getType() == null) {
                            serviceListener.onPresence(this.presence);
                            if (this.xmppPresence == null) continue;
                            XMPPPresenceService.this.removeSubscriptions(XMPPPresenceService.this.getFromJID(this.xmppPresence));
                            continue;
                        }
                        JID from = XMPPPresenceService.this.getFromJID(this.xmppPresence);
                        if (org.jabberstudio.jso.Presence.SUBSCRIBE == this.xmppPresence.getType()) {
                            if (XMPPPresenceService.this.__session.isGatewayEntry(from)) {
                                XMPPPresenceService.this.sendPresence(org.jabberstudio.jso.Presence.SUBSCRIBED, from);
                                continue;
                            }
                            serviceListener.onSubscribeRequest(this.presence);
                            continue;
                        }
                        if (this.xmppPresence.getType() == org.jabberstudio.jso.Presence.UNSUBSCRIBE) {
                            serviceListener.onUnsubscribe(this.presence);
                            continue;
                        }
                        if (this.xmppPresence.getType() == org.jabberstudio.jso.Presence.SUBSCRIBED) {
                            serviceListener.onSubscribed(this.presence);
                            continue;
                        }
                        if (this.xmppPresence.getType() == org.jabberstudio.jso.Presence.UNSUBSCRIBED) {
                            serviceListener.onUnsubscribed(this.presence);
                            XMPPPresenceService.this.removeSubscriptions(from);
                            XMPPPresenceService.this._cache.remove(from);
                            continue;
                        }
                        if (this.xmppPresence.getType() == org.jabberstudio.jso.Presence.UNAVAILABLE) {
                            serviceListener.onPresence(this.presence);
                            XMPPPresenceService.this.removeSubscriptions(from);
                            XMPPPresenceService.this._cache.remove(from);
                            continue;
                        }
                        XMPPSessionProvider.debug("Unknown packet type " + this.xmppPresence.getType());
                    }
                    catch (Exception e) {
                        XMPPSessionProvider.error(e.toString(), e);
                    }
                }
            }
        }
    }
}

