/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationPrincipal;
import com.sun.im.service.PersonalStoreEntry;
import com.sun.im.service.PersonalStoreFolder;
import com.sun.im.service.xmpp.XMPPPersonalContact;
import com.sun.im.service.xmpp.XMPPPersonalFolder;
import com.sun.im.service.xmpp.XMPPPersonalGateway;
import com.sun.im.service.xmpp.XMPPPersonalGroup;
import com.sun.im.service.xmpp.XMPPPersonalStoreService;
import com.sun.im.service.xmpp.XMPPPersonalStoreSession;
import com.sun.im.service.xmpp.XMPPPrincipal;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPWatcher;
import java.util.ArrayList;
import java.util.Collection;
import org.jabberstudio.jso.JID;

public class XMPPPersonalStoreEntry
implements PersonalStoreEntry {
    XMPPSession _session;
    XMPPPersonalStoreService _personalStoreService;
    String _displayName;
    String _type;
    String _jid;
    ArrayList _folders;

    public XMPPPersonalStoreEntry(XMPPSession s, String name, String type, String jid) {
        this._session = s;
        try {
            this._personalStoreService = (XMPPPersonalStoreService)this._session.getPersonalStoreService();
        }
        catch (CollaborationException e) {
            e.printStackTrace();
        }
        this._displayName = name;
        this._type = type;
        this._jid = jid;
        this._folders = new ArrayList();
    }

    public void addToFolder(PersonalStoreFolder folder) throws CollaborationException {
        if ("contact".equals(this._type)) {
            if (!this._folders.contains(folder)) {
                this._folders.add(folder);
            }
            ((XMPPPersonalFolder)folder).addEntry((XMPPPersonalContact)this);
        } else if ("group".equals(this._type)) {
            if (!this._folders.contains(folder)) {
                this._folders.add(folder);
            }
            ((XMPPPersonalFolder)folder).addEntry((XMPPPersonalGroup)this);
        } else if ("gateway".equals(this._type)) {
            if (!this._folders.contains(folder)) {
                this._folders.add(folder);
            }
            ((XMPPPersonalFolder)folder).addEntry((XMPPPersonalGateway)this);
        } else if ("watcher".equals(this._type)) {
            if (!this._folders.contains(folder)) {
                this._folders.add(folder);
            }
            ((XMPPPersonalFolder)folder).addEntry((XMPPWatcher)this);
        } else if ("profile".equals(this._type)) {
            throw new CollaborationException("profile cannot be added to the folder");
        }
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getType() {
        return this._type;
    }

    public String getEntryId() {
        return this._jid;
    }

    public Collection getFolders() {
        return this._folders;
    }

    public void setDisplayName(String name) {
        this._displayName = name;
    }

    public void setEntryId(String id) {
        this._jid = id;
    }

    public void remove() throws CollaborationException {
        if ("contact".equals(this._type) || "gateway".equals(this._type)) {
            for (int i = 0; i < this._folders.size(); ++i) {
                this.removeFromFolder((PersonalStoreFolder)this._folders.get(i));
            }
            this._personalStoreService.removeEntry(this);
        } else if ("abook".equals(this._type)) {
            this._personalStoreService.removeFolder((PersonalStoreFolder)((Object)this));
        } else if ("group".equals(this._type)) {
            for (int i = 0; i < this._folders.size(); ++i) {
                this.removeFromFolder((PersonalStoreFolder)this._folders.get(i));
            }
            this._personalStoreService.removePrivateStorage(this);
        } else if ("profile".equals(this._type)) {
            this._personalStoreService.removeProfile();
        } else if ("conference".equals(this._type)) {
            this._personalStoreService.removePrivateStorage(this);
        } else if ("watcher".equals(this._type)) {
            this._session.cancelSubscription(this._jid);
        }
    }

    public void removeFromFolder(PersonalStoreFolder folder) throws CollaborationException {
        if (this._type.equals("contact")) {
            ((XMPPPersonalFolder)folder).removeEntry((XMPPPersonalContact)this);
            this._folders.remove(folder);
        } else if (this._type.equals("group")) {
            ((XMPPPersonalFolder)folder).removeEntry((XMPPPersonalGroup)this);
            this._folders.remove(folder);
        } else if (this._type.equals("gateway")) {
            ((XMPPPersonalFolder)folder).removeEntry((XMPPPersonalGateway)this);
            this._folders.remove(folder);
        } else if (this._type.equals("watcher")) {
            ((XMPPPersonalFolder)folder).removeEntry((XMPPWatcher)this);
            this._folders.remove(folder);
        }
    }

    public void save() throws CollaborationException {
        if (this._type.equals("contact") || this._type.equals("watcher") || this._type.equals("gateway")) {
            if (this._folders.size() > 0) {
                this._personalStoreService.saveEntry(this);
            } else {
                this._personalStoreService.removeEntry(this);
            }
        } else if (this._type.equals("abook")) {
            if (((XMPPPersonalFolder)this).size() > 0) {
                XMPPPersonalStoreSession.saveFolder((PersonalStoreFolder)((Object)this));
            }
        } else if (this._type.equals("group")) {
            if (this._folders.size() > 0) {
                this._personalStoreService.setPrivateStorage(this);
            } else {
                this._personalStoreService.removePrivateStorage(this);
            }
        } else if (this._type.equals("conference")) {
            this._personalStoreService.setPrivateStorage(this);
        }
    }

    public CollaborationPrincipal getPrincipal() {
        return new XMPPPrincipal(new JID(this._jid), this._displayName);
    }

    public boolean equals(Object o) {
        XMPPPersonalStoreEntry e;
        String entryId;
        XMPPPersonalFolder f;
        String displayName;
        return o instanceof XMPPPersonalFolder ? (displayName = (f = (XMPPPersonalFolder)o).getDisplayName()) != null && displayName.equalsIgnoreCase(this._displayName) : o instanceof XMPPPersonalStoreEntry && (entryId = (e = (XMPPPersonalStoreEntry)o).getEntryId()) != null && entryId.equalsIgnoreCase(this._jid);
    }

    public void clearFolders() {
        this._folders.clear();
    }

    public String toString() {
        return "JID: " + this._jid + " DisplayName: " + this._displayName + " type: " + this._type + " folders " + this._folders;
    }
}

