/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.PersonalContact;
import com.sun.im.service.PersonalGateway;
import com.sun.im.service.PersonalStoreService;
import com.sun.im.service.RegistrationListener;
import com.sun.im.service.xmpp.XMPPPersonalStoreEntry;
import com.sun.im.service.xmpp.XMPPPersonalStoreService;
import com.sun.im.service.xmpp.XMPPRegistrationListenerWrapper;
import com.sun.im.service.xmpp.XMPPSession;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.jabberstudio.jso.JID;

public class XMPPPersonalGateway
extends XMPPPersonalStoreEntry
implements PersonalGateway {
    private String _service;
    private boolean _registered;
    private Set _features = new TreeSet();
    public static final String GATEWAY_FOLDER = "";

    public XMPPPersonalGateway(XMPPSession s, String name, String jid) {
        super(s, name, "gateway", jid);
    }

    public XMPPPersonalGateway(XMPPSession s, String name, String jid, String service) {
        super(s, name, "gateway", jid);
        this._service = service;
    }

    public String getHostName() throws CollaborationException {
        return this.getEntryId();
    }

    public String getName() throws CollaborationException {
        return this.getDisplayName();
    }

    public String getService() throws CollaborationException {
        return this._service;
    }

    public void setService(String service) throws CollaborationException {
        this._service = service;
    }

    public void register(RegistrationListener listener) throws CollaborationException {
        XMPPRegistrationListenerWrapper regisListenerWrapper = new XMPPRegistrationListenerWrapper(listener);
        regisListenerWrapper.setRequestType(XMPPRegistrationListenerWrapper.GATEWAY_REGISTRATION);
        this._session.register(this.getHostName(), regisListenerWrapper);
    }

    public void unregister(RegistrationListener regisListener) throws CollaborationException {
        XMPPRegistrationListenerWrapper regisListenerWrapper = new XMPPRegistrationListenerWrapper(regisListener);
        regisListenerWrapper.setRequestType(XMPPRegistrationListenerWrapper.GATEWAY_UNREGISTRATION);
        this._session.unregister(new JID(this.getHostName()), regisListenerWrapper);
        XMPPPersonalStoreService pss = (XMPPPersonalStoreService)this._session.getPersonalStoreService();
        Iterator i = pss.getEntries("contact").iterator();
        while (i.hasNext()) {
            PersonalContact pc = (PersonalContact)i.next();
            String domain = pc.getPrincipal().getDomainName();
            if (domain == null || !domain.equalsIgnoreCase(this._jid)) continue;
            pc.remove();
        }
        this._registered = false;
    }

    public void addSupportedFeature(String feature) throws CollaborationException {
        this._features.add(feature);
    }

    public Set getSupportedFeatures() throws CollaborationException {
        return this._features;
    }

    public boolean isSupportedFeature(String feature) throws CollaborationException {
        return this._features.contains(feature);
    }

    public void removeSupportedFeature(String feature) throws CollaborationException {
        this._features.remove(feature);
    }

    public boolean isRegistered() throws CollaborationException {
        PersonalStoreService pss = this._session.getPersonalStoreService();
        return pss.getEntry("gateway", this.getHostName()) != null;
    }
}

