/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.NewsChannel;
import com.sun.im.service.NewsChannelListener;
import com.sun.im.service.NewsService;
import com.sun.im.service.ServiceUnavailableException;
import com.sun.im.service.TimeoutException;
import com.sun.im.service.util.StringUtility;
import com.sun.im.service.xmpp.JIDUtil;
import com.sun.im.service.xmpp.XMPPNewsChannel;
import com.sun.im.service.xmpp.XMPPNewsMessage;
import com.sun.im.service.xmpp.XMPPPrincipal;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.NSI;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamDataFactory;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamException;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.util.PacketMonitor;
import org.jabberstudio.jso.x.disco.DiscoItem;
import org.jabberstudio.jso.x.disco.DiscoItemsQuery;
import org.jabberstudio.jso.x.pubsub.EntityContainer;
import org.jabberstudio.jso.x.pubsub.PubSubEntityElement;
import org.jabberstudio.jso.x.pubsub.PubSubEvent;
import org.jabberstudio.jso.x.pubsub.PubSubItems;
import org.jabberstudio.jso.x.pubsub.PubSubQuery;

public class XMPPNewsService
implements NewsService {
    public static final String NEWS_SERVICEPREFIX = "pubsub.";
    private Map _newsChannels = new HashMap();
    XMPPSession __session;
    private JID _newsService;
    private HashSet _remoteServices = new HashSet();
    public static final NSI NEWS_EXTENSION = new NSI("sunnews", "sun:xmpp:news");
    public static final String DEFAULT_ACCESS_ELEMENT = "defaultaccess";
    static /* synthetic */ Class class$org$jabberstudio$jso$Message;
    static /* synthetic */ Class class$org$jabberstudio$jso$x$pubsub$PubSubEvent;

    public XMPPNewsService(XMPPSession session) {
        this.__session = session;
    }

    protected void processNewsMessage(Message in) throws CollaborationException {
        String domain = in.getFrom().toString();
        String newsService = this.getService().toString();
        PubSubEvent event = (PubSubEvent)in.getExtension("http://jabber.org/protocol/pubsub#event");
        if (event != null) {
            if (event.hasPubSubItemsElement()) {
                PubSubItems items = event.getPubSubItemsElement();
                if (items.hasPubSubRetractItem()) {
                    String node = items.getNodeIdentifier();
                    String decodedNode = JIDUtil.decodedJID(XMPPNewsService.decode(node, newsService));
                    XMPPNewsChannel nc = (XMPPNewsChannel)this._newsChannels.get(decodedNode);
                    if (nc != null) {
                        nc.messageRemoved(new XMPPNewsMessage(this.__session, (Packet)in));
                    }
                } else {
                    String node = items.getNodeIdentifier();
                    String decodedNode = XMPPNewsService.decode(node, newsService);
                    String fullyDecodedNode = JIDUtil.decodedJID(decodedNode);
                    XMPPNewsChannel nc = (XMPPNewsChannel)this._newsChannels.get(fullyDecodedNode);
                    if (nc != null) {
                        PubSubItems itemsElement = event.getPubSubItemsElement();
                        Iterator iter = itemsElement.listPubSubItems().iterator();
                        while (iter.hasNext()) {
                            Packet message = this.__session.getDataFactory().createPacketNode(new NSI("message", null), class$org$jabberstudio$jso$Message == null ? XMPPNewsService.class$("org.jabberstudio.jso.Message") : class$org$jabberstudio$jso$Message);
                            PubSubEvent pubsubEvent = (PubSubEvent)this.__session.getDataFactory().createExtensionNode(PubSubEvent.NAME, class$org$jabberstudio$jso$x$pubsub$PubSubEvent == null ? XMPPNewsService.class$("org.jabberstudio.jso.x.pubsub.PubSubEvent") : class$org$jabberstudio$jso$x$pubsub$PubSubEvent);
                            PubSubItems pubSubItems = pubsubEvent.createPubSubItemsElement(itemsElement.getNodeIdentifier());
                            pubsubEvent.add((StreamNode)pubSubItems);
                            message.add((StreamNode)pubsubEvent);
                            StreamElement item = (StreamElement)iter.next();
                            pubSubItems.add((StreamNode)item);
                            message.setFrom(new JID(decodedNode));
                            message.setTo(in.getTo());
                            nc.messageAdded(new XMPPNewsMessage(this.__session, message));
                        }
                    } else {
                        XMPPSessionProvider.info("No NewsChannel " + XMPPNewsService.decode(node, newsService));
                    }
                }
            } else if (event.hasDeleteElement()) {
                XMPPSessionProvider.info("Node deletion Event: " + in.toString());
            }
        } else {
            XMPPSessionProvider.info("[XMPPSession#processNewsMessage]: no message event extension");
        }
    }

    protected Map getNewsAffiliations() throws CollaborationException {
        HashMap<String, Integer> news2Priv = new HashMap<String, Integer>();
        EntityContainer affiliationsElem = this.getAffiliationsElementResponse();
        Iterator i = affiliationsElem.listPubSubEntities().iterator();
        while (i.hasNext()) {
            PubSubEntityElement entityElem = (PubSubEntityElement)i.next();
            int access = -1;
            String affiliation = entityElem.getAffiliation().toString();
            access = XMPPSession.affiliation2Access(affiliation);
            String nodeId = XMPPNewsService.decode(entityElem.getNodeIdentifier(), this.getService().toString());
            news2Priv.put(nodeId, new Integer(access));
        }
        return news2Priv;
    }

    protected void addNewsChannel(XMPPNewsChannel nc) {
        this._newsChannels.put(nc.getDestination(), nc);
    }

    protected void removeNewsChannel(XMPPNewsChannel nc) {
        this._newsChannels.remove(nc.getDestination());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setService(JID jid) {
        this._newsService = jid;
        XMPPNewsService xMPPNewsService = this;
        synchronized (xMPPNewsService) {
            this.notifyAll();
        }
    }

    JID getService() throws CollaborationException {
        if (this._newsService == null) {
            this.__session.waitForServiceInitialization(this);
        }
        if (this._newsService == null) {
            throw new ServiceUnavailableException("News Service was initialized successfully");
        }
        return this._newsService;
    }

    public boolean isServiceInitialized() {
        return this._newsService != null;
    }

    void addRemoteService(JID jid) {
        this._remoteServices.add(jid);
    }

    Set getRemoteServices() {
        return this._remoteServices;
    }

    public static String encode(String jid, String defaultDomain) {
        JID newsJID = new JID(jid);
        JID encodedNewsChannel = null;
        encodedNewsChannel = newsJID.getDomain() != null && newsJID.getNode() != null ? new JID(null, newsJID.getDomain(), newsJID.getNode()) : new JID(null, defaultDomain, jid);
        return encodedNewsChannel.toString();
    }

    public static String decode(String jid, String defaultDomain) {
        JID newsJID = new JID(jid);
        JID decodedNewsChannel = null;
        decodedNewsChannel = newsJID.getDomain() != null && newsJID.getResource() != null ? new JID(newsJID.getResource(), newsJID.getDomain(), null) : new JID(jid, defaultDomain, null);
        return decodedNewsChannel.toString();
    }

    public NewsChannel getNewsChannel(String destination, NewsChannelListener newsChannelListener) throws CollaborationException {
        destination = StringUtility.appendDomainToAddress(destination, this.getService().toString());
        NewsChannel newsChannelFound = null;
        newsChannelFound = (NewsChannel)this._newsChannels.get(destination);
        if (newsChannelFound != null) {
            if (newsChannelListener != null) {
                newsChannelFound.subscribe(newsChannelListener);
            }
            return newsChannelFound;
        }
        try {
            Collection l = this.listNewsChannels();
            if (l == null) {
                return null;
            }
            destination = StringUtility.appendDomainToAddress(destination, this.getService().toString());
            Iterator i = l.iterator();
            while (i.hasNext()) {
                NewsChannel nc = (NewsChannel)i.next();
                String fqName = nc.getDestination();
                if (!fqName.equals(destination)) continue;
                newsChannelFound = nc;
                this._newsChannels.put(nc.getDestination(), nc);
                break;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (newsChannelFound != null && newsChannelListener != null) {
            newsChannelFound.subscribe(newsChannelListener);
        }
        return newsChannelFound;
    }

    public Collection listNewsChannels() throws CollaborationException {
        ArrayList<XMPPNewsChannel> newsChannelsList = new ArrayList<XMPPNewsChannel>();
        DiscoItemsQuery discoQuery = this.__session.sendItemsQuery(this.getService(), null);
        if (discoQuery != null) {
            Iterator i = discoQuery.listItems().iterator();
            while (i.hasNext()) {
                DiscoItem item = (DiscoItem)i.next();
                XMPPSessionProvider.debug("NewsChannel: " + item.getNode());
                String node = JIDUtil.decodedJID(XMPPNewsService.decode(item.getNode(), this.getService().toString()));
                XMPPNewsChannel nc = new XMPPNewsChannel(this.__session, node);
                newsChannelsList.add(nc);
            }
        }
        return newsChannelsList;
    }

    public Collection listNewsChannels(int access) throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        EntityContainer affiliationsElem = this.getAffiliationsElementResponse();
        ArrayList<XMPPNewsChannel> newsChannelList = new ArrayList<XMPPNewsChannel>();
        String affiliation = XMPPSession.access2Affiliation(access);
        Iterator i = affiliationsElem.listPubSubEntities().iterator();
        while (i.hasNext()) {
            PubSubEntityElement entityElem = (PubSubEntityElement)i.next();
            if (!entityElem.getAffiliation().toString().equals(affiliation)) continue;
            XMPPNewsChannel nc = new XMPPNewsChannel(this.__session, JIDUtil.decodedString(XMPPNewsService.decode(entityElem.getNodeIdentifier(), this.getService().toString())));
            newsChannelList.add(nc);
        }
        return newsChannelList;
    }

    public Collection getSubscribedNewsChannels() throws CollaborationException {
        EntityContainer affiliationsElem = this.getAffiliationsElementResponse();
        ArrayList<XMPPNewsChannel> newsChannelList = new ArrayList<XMPPNewsChannel>();
        Iterator i = affiliationsElem.listPubSubEntities().iterator();
        while (i.hasNext()) {
            PubSubEntityElement entityElem = (PubSubEntityElement)i.next();
            if (!entityElem.hasSubscriptionStatus(PubSubEntityElement.SUBSCRIBED)) continue;
            XMPPNewsChannel nc = new XMPPNewsChannel(this.__session, JIDUtil.decodedString(XMPPNewsService.decode(entityElem.getNodeIdentifier(), this.getService().toString())));
            newsChannelList.add(nc);
            if (this._newsChannels.get(nc.getDestination()) != null) continue;
            this._newsChannels.put(nc.getDestination(), nc);
        }
        return newsChannelList;
    }

    public NewsChannel newNewsChannel(String destination, NewsChannelListener newsChannelListener, int accesslevel) throws CollaborationException {
        XMPPNewsChannel nc = new XMPPNewsChannel(this.__session, destination, newsChannelListener, accesslevel);
        this._newsChannels.put(nc.getDestination(), nc);
        return nc;
    }

    public boolean isIncludedInACL(StreamElement affiliation) {
        StreamDataFactory sdf = this.__session.getDataFactory();
        if (affiliation == null) {
            return false;
        }
        StreamElement newsExt = affiliation.getFirstElement(NEWS_EXTENSION);
        if (newsExt != null) {
            StreamElement defaultAccessElem = newsExt.getFirstElement(DEFAULT_ACCESS_ELEMENT);
            return defaultAccessElem == null;
        }
        return true;
    }

    public void addDefaultElementExtension(StreamElement affiliation) {
        StreamDataFactory sdf = this.__session.getDataFactory();
        Packet newsExt = sdf.createPacketNode(NEWS_EXTENSION);
        StreamElement defaultElement = sdf.createElementNode(new NSI(DEFAULT_ACCESS_ELEMENT, null));
        if (newsExt != null) {
            newsExt.add((StreamNode)defaultElement);
        }
        affiliation.add((StreamNode)newsExt);
    }

    EntityContainer getAffiliationsElementResponse() throws CollaborationException {
        StreamDataFactory sdf = this.__session.getDataFactory();
        InfoQuery iq = (InfoQuery)sdf.createPacketNode(XMPPSession.IQ_NAME, InfoQuery.class);
        PubSubQuery pubsubquery = (PubSubQuery)sdf.createExtensionNode(PubSubQuery.NAME, PubSubQuery.class);
        EntityContainer affiliationsElem = pubsubquery.createAffiliationsElement();
        pubsubquery.add((StreamNode)affiliationsElem);
        iq.addExtension((Extension)pubsubquery);
        iq.setTo(new JID((Object)this.getService()));
        iq.setFrom(((XMPPPrincipal)this.__session.getPrincipal()).getJID());
        iq.setID(this.__session.nextID("pubsub"));
        iq.setType((Packet.Type)InfoQuery.GET);
        try {
            iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this.__session.getConnection(), (Packet)iq, (long)XMPPSession.REQUEST_TIMEOUT);
        }
        catch (StreamException se) {
            XMPPSessionProvider.error(se.toString(), se);
        }
        if (iq == null) {
            throw new TimeoutException("Request timed out");
        }
        if (iq.getType() != InfoQuery.RESULT) {
            throw new CollaborationException("Could not get newschannels from the server");
        }
        pubsubquery = (PubSubQuery)iq.getExtension("http://jabber.org/protocol/pubsub");
        affiliationsElem = (EntityContainer)pubsubquery.getFirstElement("affiliations");
        return affiliationsElem;
    }
}

