/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.xmpp.StreamingMethod;
import com.sun.im.service.xmpp.XMPPContentStream;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.List;
import org.jabberstudio.jso.Extension;
import org.jabberstudio.jso.InfoQuery;
import org.jabberstudio.jso.JID;
import org.jabberstudio.jso.Message;
import org.jabberstudio.jso.Packet;
import org.jabberstudio.jso.Stream;
import org.jabberstudio.jso.StreamElement;
import org.jabberstudio.jso.StreamNode;
import org.jabberstudio.jso.util.PacketMonitor;

public class XMPPIBBStream
implements StreamingMethod {
    XMPPSession _session;
    XMPPContentStream _cs;
    int expectedSeqId = 0;
    Hashtable _outOfOrderData = new Hashtable();
    boolean abort = false;

    public XMPPIBBStream(XMPPSession session, XMPPContentStream cs) {
        this._session = session;
        this._cs = cs;
    }

    public void start(JID to, String sid, InputStream is) {
        XMPPSessionProvider.debug("starting IBB data transfer" + sid);
        InfoQuery iq = this._session.createIBBInfoQuery(to, sid, true);
        try {
            if (this.abort) {
                return;
            }
            iq = (InfoQuery)PacketMonitor.sendAndWatch((Stream)this._session.getConnection(), (Packet)iq, (long)XMPPSession.REQUEST_TIMEOUT);
            if (iq == null) {
                this._cs.notifyClosed(3, "Timeout while waiting for reply to IBB open request");
                return;
            }
            if (iq.getType() == Packet.ERROR) {
                this._cs.notifyClosed(3, "Failed to open IBB Stream");
                return;
            }
            this._cs.notifyStarted();
            Extension data = this._session.getDataFactory().createExtensionNode(XMPPSession.IBB_DATA);
            data.setAttributeValue("sid", sid);
            boolean seqId = false;
            Message newMsg = (Message)this._session.getDataFactory().createPacketNode(XMPPSession.MESSAGE_NAME, Message.class);
            newMsg.setFrom(this._session.getCurrentUserJID());
            newMsg.setTo(to);
            newMsg.setID(this._session.nextID("message"));
            newMsg.add((StreamNode)data);
            StringBuffer buf = new StringBuffer();
            byte[] b = new byte[1023];
            int i = 0;
            int len = 0;
            while (len != -1) {
                len = is.read(b);
                int maxsize = XMPPSession.IBB_MESSAGE_SIZE;
                if (len == -1) {
                    maxsize = buf.length();
                    if (maxsize == 0) {
                        break;
                    }
                } else {
                    buf.append(XMPPSession.BASE64.encode(b, 0, len));
                }
                if (buf.length() >= maxsize) {
                    data.setAttributeValue("seq", Integer.toString(i++));
                    data.clearText();
                    data.addText(buf.substring(0, maxsize));
                    buf.replace(0, maxsize, "");
                    if (this.abort) {
                        return;
                    }
                    this._session.getConnection().send((Packet)newMsg);
                }
                this._cs.incrementTransferredBytes(len);
            }
            iq = this._session.createIBBInfoQuery(to, sid, false);
            if (this.abort) {
                return;
            }
            this._session.getConnection().send((Packet)iq);
            this._cs.notifyClosed(0, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this._cs.notifyClosed(2, e.toString());
        }
    }

    public void process(Packet packet) {
        if (packet instanceof InfoQuery) {
            List elements = packet.listElements("open", "http://jabber.org/protocol/ibb");
            if (elements.size() > 0) {
                this.processIBBInfoQuery(packet, true);
            } else {
                elements = packet.listElements("close", "http://jabber.org/protocol/ibb");
                if (elements.size() > 0) {
                    this.processIBBInfoQuery(packet, false);
                }
            }
        } else if (packet instanceof Message) {
            this.processMessage(packet);
        }
    }

    public void processIBBInfoQuery(Packet packet, boolean open) {
        try {
            Packet p = this._session.getDataFactory().createPacketNode(packet.getNSI());
            p.setID(packet.getID());
            p.setType((Packet.Type)InfoQuery.RESULT);
            p.setFrom(this._session.getCurrentUserJID());
            p.setTo(packet.getFrom());
            if (this.abort) {
                return;
            }
            this._session.getConnection().send(p);
            if (open) {
                this._cs.notifyStarted();
            } else {
                this._cs.notifyClosed(0, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this._cs.notifyClosed(2, e.toString());
        }
    }

    public void processMessage(Packet packet) {
        block8: {
            try {
                List elements = packet.listElements("data", "http://jabber.org/protocol/ibb");
                if (elements.size() <= 0) break block8;
                StreamElement ibb = (StreamElement)elements.get(0);
                String content = ibb.normalizeText();
                byte[] b = XMPPSession.BASE64.decode(content);
                String seq = ibb.getAttributeValue("seq");
                try {
                    int seqId = Integer.parseInt(seq);
                    if (seqId != this.expectedSeqId) {
                        this._outOfOrderData.put(seq, b);
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (this.abort) {
                    return;
                }
                this._cs.write(b, b.length);
                ++this.expectedSeqId;
                while (this._outOfOrderData.containsKey(Integer.toString(this.expectedSeqId))) {
                    if (this.abort) {
                        return;
                    }
                    b = (byte[])this._outOfOrderData.remove(Integer.toString(this.expectedSeqId));
                    this._cs.write(b, b.length);
                    ++this.expectedSeqId;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void abort() {
        this.abort = true;
    }
}

