/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CertificateRejectedException;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.util.CertificateVerify;
import com.sun.im.service.util.JavaxX509TrustManager;
import com.sun.im.service.util.StreamChannelSocketAdaptor;
import com.sun.im.service.xmpp.StreamSourceCreator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.ByteChannel;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.io.src.SocketStreamSource;

public class SecureStreamSourceCreator
extends StreamSourceCreator {
    private Socket _baseSocket;
    SSLSocket _sslSocket;
    private boolean _certAcceptedByClient;
    private boolean _certProvidedToClient;

    public SecureStreamSourceCreator(CollaborationSessionListener sListener) {
        super(sListener);
    }

    protected StreamSource createStreamSource(String hostName, int port) throws Exception {
        JavaxX509TrustManager trustManager = new JavaxX509TrustManager(new CertificateVerify(){

            public boolean doYouTrustCertificate(X509Certificate[] chain) {
                CollaborationSessionListener sListener = SecureStreamSourceCreator.this.getSessionListener();
                if (sListener instanceof SecureSessionListener) {
                    SecureStreamSourceCreator.this._certProvidedToClient = true;
                    SecureStreamSourceCreator.this._certAcceptedByClient = ((SecureSessionListener)sListener).onX509Certificate(chain);
                    return SecureStreamSourceCreator.this._certAcceptedByClient;
                }
                return false;
            }
        });
        this._baseSocket = SocketChannel.open(new InetSocketAddress(hostName, port)).socket();
        StreamChannelSocketAdaptor adapter = new StreamChannelSocketAdaptor(this._baseSocket);
        SSLSocketFactory factory = trustManager.getSocketFactory();
        this._sslSocket = (SSLSocket)factory.createSocket(adapter, hostName, port, true);
        try {
            this._sslSocket.startHandshake();
        }
        catch (IOException e) {
            if (this._certProvidedToClient && !this._certAcceptedByClient) {
                throw new CertificateRejectedException();
            }
            throw e;
        }
        SocketStreamSource streamSource = new SocketStreamSource((Socket)this._sslSocket);
        this._baseSocket.getChannel().configureBlocking(false);
        return streamSource;
    }

    protected SocketChannel getSocketChannel() throws IOException {
        return this._baseSocket.getChannel();
    }

    protected ByteChannel getBufferedChannel() throws IOException {
        return null;
    }

    protected Socket getSocket() {
        return this._sslSocket;
    }
}

