/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CollaborationException;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.RegistrationListener;
import com.sun.im.service.SecureRegistrationListener;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.xmpp.HTTPStreamSourceCreator;
import com.sun.im.service.xmpp.Socks5StreamSourceCreator;
import com.sun.im.service.xmpp.StreamSourceCreator;
import com.sun.im.service.xmpp.XMPPSession;
import com.sun.im.service.xmpp.XMPPSessionProvider;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.StringTokenizer;

public class ProxySessionProvider
extends XMPPSessionProvider {
    public static final String KEEPALIVE_ATTR = "keepalive";
    public static final String AUTHNAME_ATTR = "authname";
    public static final String PASSWORD_ATTR = "password";
    public static final String SERVICE_ATTR = "service";

    protected XMPPSession createSession(String serviceUrl, String loginName, String password, int loginType, CollaborationSessionListener csl) throws CollaborationException {
        URI uri = null;
        try {
            uri = new URI(serviceUrl);
        }
        catch (URISyntaxException use) {
            throw new CollaborationException(use);
        }
        String query = uri.getQuery();
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String avp = st.nextToken();
                int eqi = avp.indexOf("=");
                if (eqi <= 0 || eqi >= avp.length()) continue;
                try {
                    String val = URLDecoder.decode(avp.substring(eqi + 1), "UTF-8");
                    attributes.put(avp.substring(0, eqi), val);
                }
                catch (UnsupportedEncodingException uee) {}
            }
        }
        if (attributes.containsKey(KEEPALIVE_ATTR)) {
            this.startKeepAlive(Long.parseLong((String)attributes.get(KEEPALIVE_ATTR)) * 1000L);
        }
        StreamSourceCreator ssc = null;
        if (uri.getScheme().equalsIgnoreCase("socks")) {
            ssc = new Socks5StreamSourceCreator(csl, uri, attributes);
        } else if (uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https")) {
            ssc = new HTTPStreamSourceCreator(csl, uri, attributes);
        }
        if (ssc != null) {
            return new XMPPSession(this, (String)attributes.get(SERVICE_ATTR), loginName, password, loginType, csl, ssc);
        }
        throw new CollaborationException("Unsupported protocol: " + uri.getScheme());
    }

    protected CollaborationSessionListener getCollaborationSessionListerForRegistration(final RegistrationListener listener) {
        if (listener instanceof SecureRegistrationListener) {
            return new SecureSessionListener(){

                public boolean onX509Certificate(X509Certificate[] chain) {
                    return ((SecureRegistrationListener)listener).onX509Certificate(chain);
                }

                public void onError(CollaborationException e) {
                }
            };
        }
        return null;
    }
}

