/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.util.StringUtility;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.jabberstudio.jso.JID;

public class JIDUtil {
    public static JID encodedJID(Object o) {
        try {
            String s = (String)o;
            String resource = StringUtility.getResource(s);
            String bare = StringUtility.removeResource(s);
            String domain = StringUtility.getDomainFromAddress(bare, bare);
            String node = null;
            if (!domain.equals(bare)) {
                node = StringUtility.getLocalPartFromAddress(bare);
            }
            return JIDUtil.encodedJID(node, domain, resource);
        }
        catch (Exception e) {
            return new JID(o);
        }
    }

    public static JID encodedJID(String s) {
        try {
            String resource = StringUtility.getResource(s);
            String bare = StringUtility.removeResource(s);
            String domain = StringUtility.getDomainFromAddress(bare, bare);
            String node = null;
            if (!domain.equals(bare)) {
                node = StringUtility.getLocalPartFromAddress(bare);
            }
            return JIDUtil.encodedJID(node, domain, resource);
        }
        catch (Exception e) {
            return new JID(s);
        }
    }

    public static JID encodedJID(String node, String domain, String resource) {
        try {
            String encodedNode = node == null ? null : URLEncoder.encode(node, "UTF-8");
            String encodedDomain = domain == null ? null : URLEncoder.encode(domain, "UTF-8");
            String encodedResource = resource == null ? null : URLEncoder.encode(resource, "UTF-8");
            return new JID(encodedNode, encodedDomain, encodedResource);
        }
        catch (Exception e) {
            return new JID(node, domain, resource);
        }
    }

    public static String encodedString(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }

    public static String decodedJID(JID jid) {
        try {
            String node = JIDUtil.decodedNode(jid);
            String domain = JIDUtil.decodedDomain(jid);
            String resource = JIDUtil.decodedResource(jid);
            String jidString = domain;
            if (node != null && !node.equals("")) {
                jidString = node + "@" + jidString;
            }
            if (resource != null && !resource.equals("")) {
                jidString = jidString + "/" + resource;
            }
            return jidString;
        }
        catch (Exception e) {
            return jid.toString();
        }
    }

    public static String decodedJID(String s) {
        try {
            String resource = StringUtility.getResource(s);
            String bare = StringUtility.removeResource(s);
            String domain = StringUtility.getDomainFromAddress(bare, bare);
            String node = null;
            if (!domain.equals(bare)) {
                node = StringUtility.getLocalPartFromAddress(bare);
            }
            String jidString = URLDecoder.decode(domain, "UTF-8");
            if (node != null && !node.equals("")) {
                jidString = URLDecoder.decode(node, "UTF-8") + "@" + jidString;
            }
            if (resource != null && !resource.equals("")) {
                jidString = jidString + "/" + URLDecoder.decode(resource, "UTF-8");
            }
            return jidString;
        }
        catch (Exception e) {
            return s;
        }
    }

    public static String decodedNode(JID jid) {
        try {
            return URLDecoder.decode(jid.getNode(), "UTF-8");
        }
        catch (Exception e) {
            return jid.getNode();
        }
    }

    public static String decodedDomain(JID jid) {
        try {
            return URLDecoder.decode(jid.getDomain(), "UTF-8");
        }
        catch (Exception e) {
            return jid.getDomain();
        }
    }

    public static String decodedResource(JID jid) {
        try {
            return URLDecoder.decode(jid.getResource(), "UTF-8");
        }
        catch (Exception e) {
            return jid.getResource();
        }
    }

    public static String decodedString(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (Exception e) {
            return s;
        }
    }
}

