/*
 * Decompiled with CFR 0.152.
 */
package com.sun.im.service.xmpp;

import com.sun.im.service.CertificateRejectedException;
import com.sun.im.service.CollaborationSessionListener;
import com.sun.im.service.SecureSessionListener;
import com.sun.im.service.util.CertificateVerify;
import com.sun.im.service.util.JavaxX509TrustManager;
import com.sun.im.service.util.StreamChannelSocketAdaptor;
import com.sun.im.service.xmpp.StreamSourceCreator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.jabberstudio.jso.io.StreamSource;
import org.jabberstudio.jso.io.src.ChannelStreamSource;
import org.jabberstudio.jso.io.src.SocketStreamSource;
import org.jabberstudio.jso.util.ByteCodec;

public class HTTPStreamSourceCreator
extends StreamSourceCreator {
    private String proxyHost;
    private String username;
    private String password;
    private int proxyPort;
    private boolean usessl = false;
    private Socket _socket;
    private boolean _certAcceptedByClient;
    private boolean _certProvidedToClient;
    ByteCodec.Base64Codec base64 = new ByteCodec.Base64Codec();

    public HTTPStreamSourceCreator(CollaborationSessionListener sListener, URI uri, Map attributes) {
        this(sListener, uri);
        this.username = (String)attributes.get("authname");
        this.password = (String)attributes.get("password");
    }

    public HTTPStreamSourceCreator(CollaborationSessionListener sListener, URI uri) {
        super(sListener);
        this.proxyHost = uri.getHost();
        this.proxyPort = uri.getPort();
        this.usessl = uri.getScheme().equalsIgnoreCase("https");
        if (this.proxyPort < 0) {
            this.proxyPort = this.usessl ? 443 : 80;
        }
    }

    protected StreamSource createStreamSource(String host, int port) throws Exception {
        ChannelStreamSource streamSource;
        if (!this.usessl) {
            streamSource = ChannelStreamSource.createSocket((String)this.proxyHost, (int)this.proxyPort);
            this._sockCh = (SocketChannel)streamSource.getChannel();
            this._socket = this._sockCh.socket();
        } else {
            JavaxX509TrustManager trustManager = new JavaxX509TrustManager(new CertificateVerify(){

                public boolean doYouTrustCertificate(X509Certificate[] chain) {
                    CollaborationSessionListener sListener = HTTPStreamSourceCreator.this.getSessionListener();
                    if (sListener instanceof SecureSessionListener) {
                        HTTPStreamSourceCreator.this._certProvidedToClient = true;
                        HTTPStreamSourceCreator.this._certAcceptedByClient = ((SecureSessionListener)sListener).onX509Certificate(chain);
                        return HTTPStreamSourceCreator.this._certAcceptedByClient;
                    }
                    return false;
                }
            });
            this._sockCh = SocketChannel.open(new InetSocketAddress(host, port));
            StreamChannelSocketAdaptor adapter = new StreamChannelSocketAdaptor(this._sockCh.socket());
            SSLSocketFactory factory = trustManager.getSocketFactory();
            this._socket = (SSLSocket)factory.createSocket(adapter, host, port, true);
            try {
                ((SSLSocket)this._socket).startHandshake();
            }
            catch (IOException e) {
                if (this._certProvidedToClient && !this._certAcceptedByClient) {
                    throw new CertificateRejectedException();
                }
                throw e;
            }
            streamSource = new SocketStreamSource(this._socket);
        }
        this._sockCh.configureBlocking(true);
        StringBuffer request = new StringBuffer("CONNECT ");
        request.append(host);
        request.append(":");
        request.append(port);
        request.append(" HTTP/1.1\r\n");
        if (this.username != null) {
            String sCreds = this.username + ":" + this.password;
            request.append("Proxy-Authorization: Basic ");
            request.append(this.base64.encode(sCreds.getBytes("US-ASCII")));
            request.append("\r\n");
        }
        request.append("\r\n");
        InputStream is = this._socket.getInputStream();
        OutputStream os = this._socket.getOutputStream();
        os.write(request.toString().getBytes("US-ASCII"));
        os.flush();
        HTTPStreamSourceCreator.readHTTPHeader(is);
        this._sockCh.configureBlocking(false);
        return streamSource;
    }

    private static void readHTTPHeader(InputStream is) throws Exception {
        int index;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "US-ASCII"));
        String header = reader.readLine();
        if (!header.startsWith("2", (index = header.indexOf(" ")) + 1)) {
            throw new IOException("Response from server: " + header);
        }
        while (header != null && header.length() != 0) {
            header = reader.readLine();
        }
    }

    private static void readContent(InputStream is) throws Exception {
        int i = is.read();
        while (i != -1) {
            char c = (char)i;
            i = is.read();
        }
    }

    protected Socket getSocket() {
        return this._socket;
    }
}

